/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11;

import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Info;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.pkcs11.PKCS11Slot;

public abstract class PKCS11 {
    protected PKCS11() {
    }

    public abstract String getBridgeVersion();

    public abstract PKCS11Object[] getRSAcredential(String var1, int var2, String var3) throws PKCS11Exception;

    public abstract PKCS11Info getInfo() throws PKCS11Exception;

    public abstract PKCS11Slot[] getSlotList(boolean var1) throws PKCS11Exception;

    public PKCS11Slot getFirstTokenSlot() throws PKCS11Exception {
        return this.getFirstTokenSlot(true);
    }

    public PKCS11Slot getFirstTokenSlot(boolean flag) throws PKCS11Exception {
        PKCS11Slot[] apkcs11slot = this.getSlotList(flag);
        if (apkcs11slot.length > 0) {
            return apkcs11slot[0];
        }
        return null;
    }

    public abstract PKCS11Slot waitForSlotEvent(boolean var1) throws PKCS11Exception;

    public String toString() {
        try {
            return this.getInfo().toString();
        }
        catch (PKCS11Exception pkcs11exception) {
            throw new RuntimeException(pkcs11exception.toString() + " code: " + pkcs11exception.getCode());
        }
    }

    static String flagsToString(int i, int[] ai, String[] as, String s) {
        StringBuffer stringbuffer = new StringBuffer(64);
        String s1 = "";
        for (int j = 0; j < ai.length; ++j) {
            if ((ai[j] & i) == 0) continue;
            stringbuffer.append(s1);
            stringbuffer.append(as[j]);
            i &= ~ai[j];
            s1 = s;
        }
        if (i != 0) {
            stringbuffer.append(s1);
            stringbuffer.append("0x");
            stringbuffer.append(Integer.toString(i, 16));
        }
        return stringbuffer.toString();
    }

    static String versionString(int i) {
        StringBuffer stringbuffer = new StringBuffer();
        int j = i >> 8;
        int k = i & 0xFF;
        stringbuffer.append(j);
        stringbuffer.append(".");
        stringbuffer.append(k / 10);
        if (k % 10 != 0) {
            stringbuffer.append(k % 10);
        }
        return stringbuffer.toString();
    }
}

