/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11;

import it.actalis.ellips.capi.core.CapiException;

public class PKCS11Exception
extends RuntimeException {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int HOST_MEMORY = 2;
    public static final int SLOT_ID_INVALID = 3;
    public static final int GENERAL_ERROR = 5;
    public static final int FUNCTION_FAILED = 6;
    public static final int ARGUMENTS_BAD = 7;
    public static final int NO_EVENT = 8;
    public static final int NEED_TO_CREATE_THREADS = 9;
    public static final int CANT_LOCK = 10;
    public static final int ATTRIBUTE_READ_ONLY = 16;
    public static final int ATTRIBUTE_SENSITIVE = 17;
    public static final int ATTRIBUTE_TYPE_INVALID = 18;
    public static final int ATTRIBUTE_VALUE_INVALID = 19;
    public static final int DATA_INVALID = 32;
    public static final int DATA_LEN_RANGE = 33;
    public static final int DEVICE_ERROR = 48;
    public static final int DEVICE_MEMORY = 49;
    public static final int DEVICE_REMOVED = 50;
    public static final int ENCRYPTED_DATA_INVALID = 64;
    public static final int ENCRYPTED_DATA_LEN_RANGE = 65;
    public static final int FUNCTION_CANCELED = 80;
    public static final int FUNCTION_NOT_PARALLEL = 81;
    public static final int FUNCTION_PARALLEL = 82;
    public static final int FUNCTION_NOT_SUPPORTED = 84;
    public static final int KEY_HANDLE_INVALID = 96;
    public static final int KEY_SIZE_RANGE = 98;
    public static final int KEY_TYPE_INCONSISTENT = 99;
    public static final int KEY_NOT_NEEDED = 100;
    public static final int KEY_CHANGED = 101;
    public static final int KEY_NEEDED = 102;
    public static final int KEY_INDIGESTIBLE = 103;
    public static final int KEY_FUNCTION_NOT_PERMITTED = 104;
    public static final int KEY_NOT_WRAPPABLE = 105;
    public static final int KEY_UNEXTRACTABLE = 106;
    public static final int MECHANISM_INVALID = 112;
    public static final int MECHANISM_PARAM_INVALID = 113;
    public static final int OBJECT_HANDLE_INVALID = 130;
    public static final int OPERATION_ACTIVE = 144;
    public static final int OPERATION_NOT_INITIALIZED = 145;
    public static final int PIN_INCORRECT = 160;
    public static final int PIN_INVALID = 161;
    public static final int PIN_LEN_RANGE = 162;
    public static final int PIN_EXPIRED = 163;
    public static final int PIN_LOCKED = 164;
    public static final int SESSION_CLOSED = 176;
    public static final int SESSION_COUNT = 177;
    public static final int SESSION_EXCLUSIVE_EXISTS = 178;
    public static final int SESSION_HANDLE_INVALID = 179;
    public static final int SESSION_PARALLEL_NOT_SUPPORTED = 180;
    public static final int SESSION_READ_ONLY = 181;
    public static final int SESSION_EXISTS = 182;
    public static final int SESSION_READ_ONLY_EXISTS = 183;
    public static final int SESSION_READ_WRITE_SO_EXISTS = 184;
    public static final int SIGNATURE_INVALID = 192;
    public static final int SIGNATURE_LEN_RANGE = 193;
    public static final int TEMPLATE_INCOMPLETE = 208;
    public static final int TEMPLATE_INCONSISTENT = 209;
    public static final int TOKEN_NOT_PRESENT = 224;
    public static final int TOKEN_NOT_RECOGNIZED = 225;
    public static final int TOKEN_WRITE_PROTECTED = 226;
    public static final int UNWRAPPING_KEY_HANDLE_INVALID = 240;
    public static final int UNWRAPPING_KEY_SIZE_RANGE = 241;
    public static final int UNWRAPPING_KEY_TYPE_INCONSISTENT = 242;
    public static final int USER_ALREADY_LOGGED_IN = 256;
    public static final int USER_NOT_LOGGED_IN = 257;
    public static final int USER_PIN_NOT_INITIALIZED = 258;
    public static final int USER_TYPE_INVALID = 259;
    public static final int USER_ANOTHER_ALREADY_LOGGED_IN = 260;
    public static final int USER_TOO_MANY_TYPES = 261;
    public static final int WRAPPED_KEY_INVALID = 272;
    public static final int WRAPPED_KEY_LEN_RANGE = 274;
    public static final int WRAPPING_KEY_HANDLE_INVALID = 275;
    public static final int WRAPPING_KEY_SIZE_RANGE = 276;
    public static final int WRAPPING_KEY_TYPE_INCONSISTENT = 277;
    public static final int RANDOM_SEED_NOT_SUPPORTED = 288;
    public static final int RANDOM_NO_RNG = 289;
    public static final int INSERTION_CALLBACK_SET = 320;
    public static final int INSERTION_CALLBACK_NOT_SUPPORTED = 321;
    public static final int BUFFER_TOO_SMALL = 336;
    public static final int SAVED_STATE_INVALID = 352;
    public static final int INFORMATION_SENSITIVE = 368;
    public static final int STATE_UNSAVEABLE = 384;
    public static final int CRYPTOKI_NOT_INITIALIZED = 400;
    public static final int CRYPTOKI_ALREADY_INITIALIZED = 401;
    public static final int MUTEX_BAD = 416;
    public static final int MUTEX_NOT_LOCKED = 417;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    static final int[] codes = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 16, 17, 18, 19, 32, 33, 48, 49, 50, 64, 65, 80, 81, 82, 84, 96, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 130, 144, 145, 160, 161, 162, 163, 164, 176, 177, 178, 179, 180, 181, 182, 183, 184, 192, 193, 208, 209, 224, 225, 226, 240, 241, 242, 256, 257, 258, 259, 260, 261, 272, 274, 275, 276, 277, 288, 289, 320, 321, 336, 352, 368, 384, 400, 401, 416, 417, Integer.MIN_VALUE};
    static final String[] messages = new String[]{"Function has completed successfully", "Function should be canceled", "Not enough memory on host", "Slot ID is invalid", "Unrecoverable error", "The requested function could not be performed", "Supplied arguments not appropriate", "No new events available", "Native thread support required", "Locking not available", "Attribute is read-only", "Attribute is sensitive and cannot be revealed", "Attribute type is invalid", "Attribute value is invalid", "Data is invalid", "Invalid data length", "Device error", "Not enough memory on device", "Device has been removed", "Encrypted data is invalid", "Encrypted data length is out of range", "Function has been canceled", "No function is executing in parallel", "Function is executing in parallel", "The requested function is not supported", "Key handle is invalid", "Key size is out of range", "Key type is inconsistent with mechanism", "Key not needed, extraneous key supplied", "Key has been changed", "Key needed, no key supplied", "The value of the specified key cannot be digested", "Function not permitted for this key", "Key cannot be wrapped", "Key is unextractable", "Mechanism invalid", "Mechanism parameter is invalid", "Object handle is invalid", "Another operation is already active", "Operation has not been initialized", "Pin is incorrect", "New PIN cotains invalid characters", "New PIN length is out of range", "Pin has expired", "Pin is locked", "Session has been closed", "Session limits have been reached", "An exclusive session already exists", "Session handle is invalid", "Parallel execution is not supported", "Session is read-only", "A session with the token is already open", "A read-only session already exists and the SO cannot be logged in", "A read/write SO session already exists and the SO cannot be logged in", "Signature is invalid", "Signature length is out of range", "Template is incomplete", "Template is inconsistent", "Slot does not contain a token", "The token was not recognized", "Token is write-protected", "Unwrapping key handle is invalid", "Unwrapping key size is out of range", "Unwrapping key is inconsistent with mechanism", "A user is already logged in", "A user is not logged in", "The user's PIN has not been initialized", "User type is invalid", "Another user is already logged in", "Too many users logged in", "Wrapped key is invalid", "Wrapped key length is out of range", "Wrapping key handle is invalid", "Wrapping key size is invalid", "Wrapping key type is inconsistent with mechanism", "Random number generator does not accept seeding", "The token does not have a random number generator", "Insertion_CALLBACK_SET", "The slot does not support token insertion callbacks", "Buffer too small", "The saved operations state is invalid and cannot be restored", "The requested information is sensitive and cannot be revealed", "The operations state cannot be saved", "Cryptoki is not yet initialized", "Cryptoki is already initialized", "Mutex object is bad", "Mutex is not locked"};
    int code;

    public PKCS11Exception(int i, boolean flag) {
        super(PKCS11Exception.errorMessage(i, flag));
        this.code = i;
    }

    public PKCS11Exception(int i) {
        this(i, false);
    }

    public PKCS11Exception(String s) {
        super(s);
        this.code = Integer.MIN_VALUE;
    }

    public int getCode() {
        return this.code;
    }

    static String errorMessage(int i, boolean flag) {
        if (flag && i >= Integer.MIN_VALUE) {
            return "Vendor defined error (0x" + Integer.toHexString(i) + ")";
        }
        if ((i & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return "Vendor defined error";
        }
        for (int j = 0; j < messages.length; ++j) {
            if (codes[j] != i) continue;
            return messages[j];
        }
        return "Unknown error (0x" + Integer.toHexString(i) + ")";
    }

    public CapiException toCapiException() {
        return this.toCapiException(false, false);
    }

    public CapiException toCapiException(boolean isPUK) {
        return this.toCapiException(isPUK, false);
    }

    public CapiException toCapiException(boolean isPUK, boolean isAS) {
        String msg = null;
        int code = -1;
        switch (this.getCode()) {
            case 176: 
            case 179: 
            case 257: {
                msg = "User not logged in";
                code = 10013;
                break;
            }
            case 50: {
                msg = "Token removed";
                code = 10012;
                break;
            }
            case 224: {
                msg = "Token not inserted";
                code = 10011;
                break;
            }
            case 49: {
                msg = "No space on device";
                code = 10030;
                break;
            }
            case 48: {
                msg = "Problem on device";
                code = 11001;
                break;
            }
            case 16: {
                msg = "Cannot modify label";
                code = 11010;
                break;
            }
            case 17: 
            case 368: {
                msg = "Cannot read private data";
                code = 11011;
                break;
            }
            case 400: {
                msg = "Library not initialized";
                code = 10003;
                break;
            }
            case 182: 
            case 401: {
                msg = "Library already init";
                code = 10002;
                break;
            }
            case 84: {
                msg = "Function not supported";
                code = 11002;
                break;
            }
            case 98: {
                msg = "Unsupported key size";
                code = 10031;
                break;
            }
            case 105: 
            case 106: {
                msg = "Cannot extract key";
                code = 11012;
                break;
            }
            case 112: 
            case 113: {
                msg = "Unsupported mechanism";
                code = 11013;
                break;
            }
            case 163: {
                msg = isPUK ? "Expired PUK" : "Expired PIN";
                code = isPUK ? 2010 : 2007;
                break;
            }
            case 160: {
                msg = isPUK ? "Wrong PUK" : "Wrong PIN";
                code = isPUK ? 2005 : 2001;
                break;
            }
            case 161: 
            case 162: {
                msg = isPUK ? "Invalid PUK" : "Invalid PIN";
                code = isPUK ? 2009 : 2006;
                break;
            }
            case 164: {
                msg = isPUK ? "Locked PUK" : "Locked PIN";
                code = isPUK ? 2008 : 2003;
                break;
            }
            case 177: 
            case 256: 
            case 259: 
            case 260: 
            case 261: {
                msg = "cannot login";
                code = 11014;
                break;
            }
            case 3: {
                msg = "Invalid slot";
                code = 11003;
                break;
            }
            case 225: 
            case 226: {
                msg = "Token is not valid";
                code = 11004;
                break;
            }
            case 258: {
                msg = "Token is not initialized";
                code = 10010;
                break;
            }
            case 104: {
                msg = "Function not permitted for this type of key";
                code = 10038;
                break;
            }
            case 32: {
                msg = "Data is Invalid";
                code = 10038;
                break;
            }
            case -2147483136: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_ERR";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483135: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_UNK";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483134: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_CONN";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483133: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_RCV";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483132: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_SND";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483131: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_NOSOCK";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483130: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_ARGS";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483129: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_LIB";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483128: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_MEM";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483127: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_MSGS";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483126: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_TIMEOUT";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483125: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_WND";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483124: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_AGAIN";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483123: {
                if (isAS) {
                    msg = "AS_VENDOR_NET_QUIT";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483122: {
                if (isAS) {
                    msg = "AS_VENDOR_NO_SERVER";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483121: {
                if (isAS) {
                    msg = "AS_VENDOR_NO_CARD_FOUND";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483120: {
                if (isAS) {
                    msg = "AS_VENDOR_REMOTE_CALL_ERROR";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483117: {
                if (isAS) {
                    msg = "AS_VENDOR_INVALID_MAC";
                    code = this.getCode();
                    break;
                }
            }
            case -2147483116: {
                if (isAS) {
                    msg = "AS_VENDOR_NO_MAC_KEY";
                    code = this.getCode();
                    break;
                }
            }
            default: {
                msg = "General error on Token";
                code = 10040;
            }
        }
        return new CapiException(msg, code);
    }
}

