/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11.nat;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.pkcs11.PKCS11;
import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Info;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.pkcs11.nat.Platform;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class NativePKCS11
extends PKCS11 {
    private static final String JNA_TMPLIB_PREFIX = "pkcs11";
    protected long libraryHandler;
    protected long functionList;
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final Map<Long, NativePKCS11> NATIVE_INSTANCES = new HashMap<Long, NativePKCS11>();
    private int libReferenceCount;
    private boolean loadFromCapi;

    private static File extractFromResourcePath(String name, ClassLoader loader) throws IOException {
        URL url;
        String resourcePath;
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = NativePKCS11.class.getClassLoader();
        }
        String libname = name.startsWith("/") ? name : NativePKCS11.mapSharedLibraryName(name);
        String string = resourcePath = name.startsWith("/") ? name : Platform.RESOURCE_PREFIX + "/" + libname;
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((url = loader.getResource(resourcePath)) == null && resourcePath.startsWith(Platform.RESOURCE_PREFIX)) {
            url = loader.getResource(libname);
        }
        if (url == null) {
            String path = System.getProperty("java.class.path");
            if (loader instanceof URLClassLoader) {
                path = Arrays.asList(((URLClassLoader)loader).getURLs()).toString();
            }
            throw new IOException("Native library (" + resourcePath + ") not found in resource path (" + path + ")");
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                lib = new File(url.getPath());
            }
            if (!lib.exists()) {
                throw new IOException("File URL " + url + " could not be properly decoded");
            }
        } else if (!Boolean.getBoolean("jna.nounpack")) {
            InputStream is = loader.getResourceAsStream(resourcePath);
            if (is == null) {
                throw new IOException("Can't obtain InputStream for " + resourcePath);
            }
            FileOutputStream fos = null;
            try {
                int count;
                File dir = NativePKCS11.getTempDir();
                lib = TmpFileUtils.createTempFile((String)JNA_TMPLIB_PREFIX, (String)(Platform.isWindows() ? ".dll" : null), (File)dir);
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[4096];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to create temporary file for " + name + " library: " + e.getMessage());
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return lib;
    }

    private static File extractFromResourcePath(String resourcePath, String file_name, ClassLoader loader, File temp_dir) throws IOException {
        URL url;
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = NativePKCS11.class.getClassLoader();
        }
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((url = loader.getResource(resourcePath)) == null) {
            String path = System.getProperty("java.class.path");
            if (loader instanceof URLClassLoader) {
                path = Arrays.asList(((URLClassLoader)loader).getURLs()).toString();
            }
            throw new IOException("Native library (" + resourcePath + ") not found in resource path (" + path + ")");
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                lib = new File(url.getPath());
            }
            if (!lib.exists()) {
                throw new IOException("File URL " + url + " could not be properly decoded");
            }
        } else {
            InputStream is = loader.getResourceAsStream(resourcePath);
            if (is == null) {
                throw new IOException("Can't obtain InputStream for " + resourcePath);
            }
            FileOutputStream fos = null;
            try {
                int count;
                lib = new File(temp_dir.getAbsolutePath() + File.separator + file_name);
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[4096];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to create temporary file for " + resourcePath + " library: " + e.getMessage());
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return lib;
    }

    private static String mapSharedLibraryName(String libName) {
        if (Platform.isMac()) {
            if (libName.startsWith("lib") && (libName.endsWith(".dylib") || libName.endsWith(".jnilib"))) {
                return libName;
            }
            String name = System.mapLibraryName(libName);
            if (name.endsWith(".jnilib")) {
                return name.substring(0, name.lastIndexOf(".jnilib")) + ".dylib";
            }
            return name;
        }
        if (Platform.isLinux() || Platform.isFreeBSD() ? NativePKCS11.isVersionedName(libName) || libName.endsWith(".so") : (Platform.isAIX() ? libName.startsWith("lib") : Platform.isWindows() && (libName.endsWith(".drv") || libName.endsWith(".dll")))) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    private static boolean isVersionedName(String name) {
        int so;
        if (name.startsWith("lib") && (so = name.lastIndexOf(".so.")) != -1 && so + 4 < name.length()) {
            for (int i = so + 4; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Character.isDigit(ch) || ch == '.') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected NativePKCS11(long l) {
        this.libReferenceCount = 0;
        this.loadFromCapi = false;
        this.functionList = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativePKCS11 getInstance(String libName, boolean doInitialization) {
        long handler;
        block11: {
            System.runFinalization();
            handler = 0L;
            try {
                handler = NativePKCS11.loadPKCS11Library(libName);
            }
            catch (Throwable tr) {
                File embedded;
                logger.debug("Unable to load " + libName);
                String driverFolder = System.getProperty("driver.folder", "");
                if (driverFolder.isEmpty()) {
                    logger.debug("driver.folder is empty, try with embedded");
                    embedded = new File(new File(libName).getAbsolutePath());
                } else {
                    logger.debug("Found driver.folder " + driverFolder + " , try with embedded");
                    embedded = new File(driverFolder + File.separator + libName);
                }
                if (!embedded.exists()) break block11;
                logger.debug("Embedded lib " + embedded.getAbsolutePath());
                handler = NativePKCS11.loadPKCS11Library(embedded.getAbsolutePath());
            }
        }
        if (handler == 0L) {
            throw new UnsatisfiedLinkError(libName);
        }
        if (!NATIVE_INSTANCES.containsKey(handler)) {
            Map<Long, NativePKCS11> tr = NATIVE_INSTANCES;
            synchronized (tr) {
                if (!NATIVE_INSTANCES.containsKey(handler)) {
                    NATIVE_INSTANCES.put(handler, new NativePKCS11(handler, doInitialization));
                    return NATIVE_INSTANCES.get(handler);
                }
            }
        }
        NativePKCS11 ret = NATIVE_INSTANCES.get(handler);
        if (doInitialization) {
            ret.libInitializePublic();
        }
        return ret;
    }

    private NativePKCS11(long handler, boolean doInitialization) {
        block3: {
            this.libReferenceCount = 0;
            this.loadFromCapi = false;
            this.libraryHandler = handler;
            this.functionList = NativePKCS11.functionListHandler(handler);
            if (doInitialization) {
                try {
                    this.libInitializePublic();
                }
                catch (PKCS11Exception pkcs11exception) {
                    if (pkcs11exception.getCode() == 401) break block3;
                    throw pkcs11exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void libInitializePublic() {
        NativePKCS11 nativePKCS11 = this;
        synchronized (nativePKCS11) {
            long start = System.currentTimeMillis();
            if (this.libReferenceCount == 0) {
                if (!this.isInitialized()) {
                    logger.debug("Call native libInitialize [START]");
                    this.libInitialize(this.functionList);
                    logger.debug("Call native libInitialize [END in {} ms]", (Object)(System.currentTimeMillis() - start));
                    this.loadFromCapi = true;
                } else {
                    logger.debug("Pkcs11 Already Intialized by Other Modules", (Object)(System.currentTimeMillis() - start));
                }
            } else {
                logger.debug("Library already initialized");
            }
            ++this.libReferenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void libFinalizePublic() {
        NativePKCS11 nativePKCS11 = this;
        synchronized (nativePKCS11) {
            long start = System.currentTimeMillis();
            if (this.libReferenceCount > 0) {
                if (this.libReferenceCount == 1) {
                    logger.debug("Call native libFinalize [START]");
                    if (this.loadFromCapi) {
                        this.libFinalize(this.libraryHandler, this.functionList);
                        this.loadFromCapi = false;
                    }
                    logger.debug("Call native libFinalize [END in {} ms]", (Object)(System.currentTimeMillis() - start));
                } else {
                    logger.debug("Library used by other reference");
                }
                --this.libReferenceCount;
            }
        }
    }

    public void unloadLibrary() {
        try {
            this.libFinalizePublic();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getReferenceCount() {
        return this.libReferenceCount;
    }

    public static int nativeInstancesCount() {
        return NATIVE_INSTANCES.size();
    }

    @Override
    public native String getBridgeVersion();

    private native Object[] getRSAcredential(long var1, String var3, int var4, String var5) throws PKCS11Exception;

    protected static native long loadPKCS11Library(String var0);

    protected static native long functionListHandler(long var0);

    private native PKCS11Info getInfo(long var1) throws PKCS11Exception;

    private native PKCS11Slot[] getSlotList(long var1, boolean var3) throws PKCS11Exception;

    private native PKCS11Slot waitForSlotEvent(long var1, boolean var3) throws PKCS11Exception;

    private native void libInitialize(long var1);

    private native void libFinalize(long var1, long var3);

    public boolean isInitialized() {
        boolean blnReturn = false;
        try {
            this.getSlotList(false);
            blnReturn = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blnReturn;
    }

    @Override
    public PKCS11Info getInfo() throws PKCS11Exception {
        return this.getInfo(this.functionList);
    }

    @Override
    public PKCS11Slot[] getSlotList(boolean flag) throws PKCS11Exception {
        return this.getSlotList(this.functionList, flag);
    }

    @Override
    public PKCS11Slot waitForSlotEvent(boolean flag) throws PKCS11Exception {
        return this.waitForSlotEvent(this.functionList, flag);
    }

    long getFunctionList() {
        return this.functionList;
    }

    @Override
    public PKCS11Object[] getRSAcredential(String s, int i, String s1) throws PKCS11Exception {
        Object[] objs = this.getRSAcredential(this.functionList, s, i, s1);
        PKCS11Object[] objRet = new PKCS11Object[objs.length];
        for (int j = 0; j < objs.length; ++j) {
            Object object = objs[j];
            if (!(object instanceof PKCS11Object)) continue;
            objRet[j] = (PKCS11Object)object;
        }
        return objRet;
    }

    private static File getTempDir() throws IOException {
        File jnatmp;
        String prop = System.getProperty("jna.tmpdir");
        if (prop != null) {
            jnatmp = new File(prop);
            jnatmp.mkdirs();
        } else {
            File tmp = new File(System.getProperty("java.io.tmpdir"));
            jnatmp = new File(tmp, "jna-" + System.getProperty("user.name").hashCode());
            jnatmp.mkdirs();
            if (!jnatmp.exists() || !jnatmp.canWrite()) {
                jnatmp = tmp;
            }
        }
        if (!jnatmp.exists()) {
            throw new IOException("JNA temporary directory '" + jnatmp + "' does not exist");
        }
        if (!jnatmp.canWrite()) {
            throw new IOException("JNA temporary directory '" + jnatmp + "' is not writable");
        }
        return jnatmp;
    }

    long getLibraryHandler() {
        return this.libraryHandler;
    }

    static {
        try {
            logger.info("Start Initializing actalisjpkcs11 Library");
            String libName = "/it/actalis/ca/pkcs11/" + Platform.RESOURCE_PREFIX + "/" + System.mapLibraryName("actalisjpkcs11").replace(".dylib", ".jnilib");
            File lib = NativePKCS11.extractFromResourcePath(libName, NativePKCS11.class.getClassLoader());
            System.load(lib.getAbsolutePath());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

