/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.CardUtilsConfig;
import it.arubapec.ca.pkcs11.card.PData;
import it.arubapec.ca.utils.ConfigParameter;
import org.slf4j.Logger;

public class Card
implements TokenParameters {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int KEY_DS = 0;
    public static final int KEY_AUTH = 1;
    public static final int KEY_CNS = 2;
    public static final int KEY_P11 = 3;
    private PKCS11Slot slot;
    private String strSerial;
    private CardFamily cardFamily;
    private ConfigParameter conf;
    private CardUtilsConfig setup;
    private PData pData = null;

    public CardFamily getCardFamily() {
        return this.cardFamily;
    }

    public void setCardFamily(CardFamily cardFamily) {
        this.cardFamily = cardFamily;
    }

    public PKCS11Slot getSlot() {
        return this.slot;
    }

    public void setSlot(PKCS11Slot slot) {
        this.slot = slot;
    }

    public String getSerial() {
        return this.strSerial;
    }

    public void setSerial(String strSerial) {
        this.strSerial = strSerial;
    }

    public String toString() {
        return this.cardFamily.getName() + "_" + this.strSerial;
    }

    @Deprecated
    public ConfigParameter getConf() {
        return this.conf;
    }

    @Deprecated
    public void setConf(ConfigParameter conf) {
        this.conf = conf;
    }

    public TokenSpi getToken() throws CapiException {
        logger.info("Inizializzazione Token PKCS11");
        return TokenHelper.initToken((String)"PKCS11Token", (TokenParameters)this);
    }

    @Deprecated
    public CardUtilsConfig getSetup() {
        return this.setup;
    }

    @Deprecated
    public void setSetup(CardUtilsConfig setup) {
        this.setup = setup;
    }

    public void setpData(PData pData) {
        this.pData = pData;
    }

    public PData getpData() {
        return this.pData;
    }
}

