/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.KeyHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.java6.PCSC6;
import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.pkcs11.PKCS11TokenInfo;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.pkcs11.nat.NativePKCS11Slot;
import it.actalis.pkcs11.nat.Platform;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pcsc.SCardUtils;
import it.arubapec.ca.pkcs11.card.Atr;
import it.arubapec.ca.pkcs11.card.AtrType;
import it.arubapec.ca.pkcs11.card.CNSStrategy;
import it.arubapec.ca.pkcs11.card.Card;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.CardFamilyMatch;
import it.arubapec.ca.pkcs11.card.CardLibrary;
import it.arubapec.ca.pkcs11.card.CardStore;
import it.arubapec.ca.pkcs11.card.DSStrategy;
import it.arubapec.ca.pkcs11.card.PData;
import it.arubapec.ca.pkcs11.card.ReaderEvent;
import it.arubapec.ca.pkcs11.card.ReaderListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.smartcardio.ATR;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;

public class CardService {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final CardFamily akFamily = new CardFamily("AK", "12345", "12345678", CNSStrategy.LABEL, DSStrategy.LABEL);
    private CardStore cardStore = null;
    private static List<CardTerminal> cardTerminals = new ArrayList<CardTerminal>();
    private static TerminalFactory TERMINAL_FACTORY = null;
    private static final List<KeyHandler> KEYS = new ArrayList<KeyHandler>();
    private static boolean stop = false;
    private static Thread cardMonitor = null;
    private static boolean running = false;
    private static final List<ReaderListener> LISTENERS = new ArrayList<ReaderListener>();
    private static CardService INSTANCE = null;

    public static CardService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CardService(null);
        }
        return INSTANCE;
    }

    public static CardService getInstance(File jsonStoreFile) {
        if (INSTANCE == null) {
            INSTANCE = new CardService(jsonStoreFile);
        }
        return INSTANCE;
    }

    private CardService(File jsonStoreFile) {
        try {
            this.cardStore = CardStore.getInstance(jsonStoreFile);
            akFamily.addLib(CardLibrary.bit4IdUniversalEmbedded);
            akFamily.addLib(CardLibrary.bit4IdUniversal);
        }
        catch (IOException ex) {
            logger.error("Impossibile inizializzare lo store delle carte {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public CardStore getCardStore() {
        return this.cardStore;
    }

    public CardFamilyMatch getFromAtr(it.actalis.ellips.util.ATR objAtr) {
        String atrToMatch = objAtr.getMessage().toLowerCase();
        String strTerminalName = objAtr.getTerminalName().toLowerCase();
        logger.debug("Search matching for ATR " + atrToMatch);
        for (Atr atr : this.cardStore.getCompleteAtr()) {
            if (atr.getType() != AtrType.COMPLETE || !atr.getValue().equalsIgnoreCase(atrToMatch)) continue;
            return new CardFamilyMatch(atr.getCardFamily(), strTerminalName);
        }
        for (Atr atr : this.cardStore.getRegexAtr()) {
            Pattern p = Pattern.compile(atr.getValue().toLowerCase());
            Matcher m = p.matcher(atrToMatch);
            if (!m.matches()) continue;
            return new CardFamilyMatch(atr.getCardFamily(), strTerminalName);
        }
        ATR objAtrSCIO = new ATR(PCSC6.hexStringToByteArray((String)objAtr.getMessage()));
        byte[] historicalBytes = objAtrSCIO.getHistoricalBytes();
        if (historicalBytes != null && historicalBytes.length >= 4) {
            byte historicalByte = historicalBytes[3];
            for (Atr atr : this.cardStore.getHistoricalAtr()) {
                byte storedHistoricalByte = new Byte(atr.getValue());
                if (storedHistoricalByte != historicalByte) continue;
                return new CardFamilyMatch(atr.getCardFamily(), strTerminalName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Card> retrieveCardList() throws IOException, CapiException {
        ArrayList<Card> lstCards = new ArrayList<Card>();
        if (this.cardStore == null) {
            throw new IOException("No Card Database Found");
        }
        List<it.actalis.ellips.util.ATR> lstATR = SCardUtils.retrieveATR();
        int cardsPresent = lstATR.size();
        logger.debug("Individuati ATRs " + cardsPresent);
        for (it.actalis.ellips.util.ATR atr : lstATR) {
            List<Card> matchCards;
            CardFamilyMatch matchFamily = this.getFromAtr(atr);
            if (matchFamily == null || (matchCards = CardService.fromCardFamilyMatch(matchFamily, lstCards)) == null || matchCards.size() <= 0) continue;
            lstCards.add(matchCards.get(0));
        }
        NativePKCS11 pkcs11Ak = CardService.initModule(akFamily);
        if (pkcs11Ak != null) {
            try {
                PKCS11Slot[] slots = pkcs11Ak.getSlotList(true);
                if (slots != null) {
                    for (PKCS11Slot slot : slots) {
                        if (!slot.getInfo().description().startsWith("HID")) continue;
                        Card card = new Card();
                        card.setCardFamily(akFamily);
                        card.setSerial(slot.getTokenInfo().serialNumber());
                        card.setSlot(slot);
                        card.setpData(PData.getInstance(card));
                        lstCards.add(card);
                    }
                }
            }
            finally {
                pkcs11Ak.libFinalizePublic();
            }
        }
        return lstCards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Card> fromCardFamilyMatch(CardFamilyMatch familyMatch, List<Card> lstCard) {
        logger.debug("start listing all card supported by family");
        logger.info("Module " + familyMatch.getFamily().getName());
        if (logger.isDebugEnabled()) {
            logger.debug("Referenced libraries: ");
            for (CardLibrary lib : familyMatch.getFamily().getLib()) {
                logger.debug(String.format("%s\n windows:%s\n osx:%s\n linux:%s", lib.getDriveName(), lib.getWindowsDrive(), lib.getOsxDrive(), lib.getLinuxDrive()));
            }
        }
        logger.info("Terminal name: " + familyMatch.getTerminalName());
        ArrayList<Card> objReturn = new ArrayList<Card>();
        NativePKCS11 nativePKCS11 = null;
        try {
            nativePKCS11 = familyMatch.getFamily().getPKCS11(true);
            if (nativePKCS11 == null) {
                throw new CapiException("pkcs11 null", 11000);
            }
            String pkcs11ManId = nativePKCS11.getInfo().manufacturerID();
            logger.info("Drive manufacturer: " + pkcs11ManId);
            PKCS11Slot[] arrSlot = null;
            try {
                arrSlot = nativePKCS11.getSlotList(true);
                if (arrSlot == null || arrSlot.length == 0) {
                    throw new PKCS11Exception("No card found");
                }
            }
            catch (PKCS11Exception ex) {
                logger.error(ex.getMessage() + " code: " + ex.getCode());
                logger.debug("no card associated to this module was found into the slots");
                List<Card> list = null;
                logger.debug("end listing all card supported by family");
                if (nativePKCS11 != null) {
                    nativePKCS11.libFinalizePublic();
                }
                return list;
            }
            logger.info("Number of cards found into the pkcs11 module slots: " + arrSlot.length);
            for (int iSlot = 0; iSlot < arrSlot.length; ++iSlot) {
                PKCS11Slot curPKCS11Slot = arrSlot[iSlot];
                PKCS11TokenInfo pkcs11TokenInfo = null;
                String cardManID = "";
                String cardSerial = "";
                String cardSlotName = "";
                if (curPKCS11Slot instanceof NativePKCS11Slot) {
                    logger.info("Slot native ID......: " + ((NativePKCS11Slot)curPKCS11Slot).getNativeID());
                }
                try {
                    try {
                        pkcs11TokenInfo = curPKCS11Slot.getTokenInfo();
                        cardManID = pkcs11TokenInfo.manufacturer().trim();
                        cardSerial = pkcs11TokenInfo.serialNumber().trim();
                        cardSlotName = curPKCS11Slot.getInfo().description().trim();
                        logger.info("Card manufacturer...: [{}]", (Object)cardManID);
                        logger.info("Card serial.........: [{}]", (Object)cardSerial);
                        logger.info("Card slot name......: [{}]", (Object)cardSlotName);
                        if (cardManID.toUpperCase().contains("ATHENA") && !pkcs11ManId.toUpperCase().contains("ATHENA")) {
                            logger.info("Smartcard Athena on non-Athena driver!");
                            continue;
                        }
                        if (!familyMatch.getTerminalName().equals("CUSTOMOVERRIDE") && !familyMatch.getTerminalName().equalsIgnoreCase(cardSlotName)) {
                            logger.debug("Carta skippata in quanto il lettore non corrisponde a quello rilevato in fase di match atr");
                            continue;
                        }
                        for (Card card : lstCard) {
                            if (!card.getSerial().equals(cardSerial)) continue;
                            logger.debug("Carta skippata in quanto gi\u00e0 rilevata precedentemente");
                        }
                    }
                    catch (PKCS11Exception ex) {
                        if (ex.getCode() == 225) {
                            logger.info("skip: found a smartcard that matches with another manufacturer driver");
                            continue;
                        }
                        logger.debug(ex.getMessage() + " code: " + ex.getCode());
                        throw ex;
                    }
                    Card card = new Card();
                    card.setCardFamily(familyMatch.getFamily());
                    card.setSerial(cardSerial);
                    card.setSlot(arrSlot[iSlot]);
                    card.setpData(PData.getInstance(card));
                    objReturn.add(card);
                    logger.info("This card is added to the module card list");
                    if (!Platform.isMac()) continue;
                    logger.info("for Mac only: no more cards are considered for this module!");
                    break;
                }
                catch (Exception ex) {
                    logger.error("skip: " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            logger.debug("Generic exception! The card list may be incomplete!");
        }
        finally {
            logger.debug("end listing all card supported by family");
            if (nativePKCS11 != null) {
                nativePKCS11.libFinalizePublic();
            }
        }
        return objReturn;
    }

    public static NativePKCS11 initModule(CardFamily cardFamily) throws CapiException {
        logger.debug("initModule() start");
        NativePKCS11 nativePKCS11 = null;
        try {
            logger.debug("module need to be initialized");
            nativePKCS11 = cardFamily.getPKCS11(true);
            logger.debug("initialization done");
        }
        catch (PKCS11Exception ex) {
            if (ex.getCode() != 401) {
                logger.error(ex.getMessage() + " code: " + ex.getCode(), (Throwable)ex);
                throw ex.toCapiException();
            }
            logger.debug("module is already intialized and a 'double initialization' exception was generated, but the exception is ignored");
        }
        catch (UnsatisfiedLinkError ex) {
            cardFamily.setSelected_lib(null);
            logger.error(ex.getMessage());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException(ex.getMessage(), 11000);
        }
        finally {
            logger.debug("initModule() end");
        }
        return nativePKCS11;
    }

    public void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    private void start() {
        System.out.println("CardMonitor -> start()");
        running = true;
        Thread terminalReader = new Thread(new Runnable(){

            @Override
            public void run() {
                if (TERMINAL_FACTORY == null) {
                    TERMINAL_FACTORY = TerminalFactory.getDefault();
                }
                KEYS.clear();
                stop = false;
                cardMonitor = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HashMap exceptions = new HashMap();
                        while (!stop) {
                            try {
                                List<CardTerminal> cardList = null;
                                try {
                                    CardTerminals terminals = TERMINAL_FACTORY.terminals();
                                    cardList = terminals.list(CardTerminals.State.CARD_PRESENT);
                                }
                                catch (CardException ex) {
                                    CardService.this.clearTerminalsIfNeeded(ex);
                                }
                                if (!CardService.this.isTerminalsChanged(cardList)) continue;
                                CardService.this.notifyListeners();
                            }
                            catch (Throwable t) {
                                CardService.this.manageCardExceptionLog(exceptions, t);
                            }
                            finally {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException ex) {
                                    logger.error(ex.getMessage(), (Throwable)ex);
                                }
                            }
                        }
                    }
                }, "CardMonitor");
                cardMonitor.setDaemon(true);
                cardMonitor.start();
            }
        });
        terminalReader.setDaemon(true);
        terminalReader.start();
    }

    private boolean isTerminalsChanged(List<CardTerminal> readedCardTerminals) {
        if (readedCardTerminals == null) {
            if (!cardTerminals.isEmpty()) {
                cardTerminals = new ArrayList<CardTerminal>();
                return true;
            }
            return false;
        }
        if (this.isNewTerminalConnected(readedCardTerminals) || this.isOldTerminalDisconnected(readedCardTerminals)) {
            cardTerminals = readedCardTerminals;
            return true;
        }
        return false;
    }

    private boolean isNewTerminalConnected(List<CardTerminal> readedCardTerminals) {
        for (CardTerminal term : readedCardTerminals) {
            if (cardTerminals.contains(term)) continue;
            return true;
        }
        return false;
    }

    private boolean isOldTerminalDisconnected(List<CardTerminal> readedCardTerminals) {
        for (CardTerminal term : cardTerminals) {
            if (readedCardTerminals.contains(term)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        final ReaderEvent event = new ReaderEvent();
        event.setCardTerminals(cardTerminals);
        event.setType(ReaderEvent.ReaderEventType.onChange);
        List<ReaderListener> list = LISTENERS;
        synchronized (list) {
            for (final ReaderListener listener : LISTENERS) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        listener.readerEvent(event);
                    }
                }).start();
            }
        }
    }

    private void clearTerminalsIfNeeded(CardException ex) throws Exception {
        if (ex.getCause() == null) {
            throw ex;
        }
        if ("SCARD_E_NO_READERS_AVAILABLE".equals(ex.getCause().getMessage())) {
            return;
        }
        if (!"SCARD_E_SERVICE_STOPPED".equals(ex.getCause().getMessage())) {
            throw ex;
        }
        SCardUtils.clearTerminalsList();
        TERMINAL_FACTORY = TerminalFactory.getDefault();
    }

    private void manageCardExceptionLog(Map<String, Long> exceptions, Throwable t) {
        String key;
        String string = key = t.getMessage() == null ? t.getClass().getName() : t.getMessage();
        if (exceptions.containsKey(key)) {
            if (System.currentTimeMillis() - exceptions.get(key) > 30000L) {
                logger.error(t.getMessage(), t);
                exceptions.put(key, System.currentTimeMillis());
            }
        } else {
            logger.error(t.getMessage(), t);
            exceptions.put(key, System.currentTimeMillis());
        }
    }

    private void stop() {
        System.out.println("CardMonitor -> stop()");
        running = false;
        if (cardMonitor != null) {
            stop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ReaderListener listener) {
        if (listener == null) {
            return;
        }
        List<ReaderListener> list = LISTENERS;
        synchronized (list) {
            LISTENERS.add(listener);
        }
        if (!running) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ReaderListener listener) {
        if (listener == null) {
            return;
        }
        List<ReaderListener> list = LISTENERS;
        synchronized (list) {
            LISTENERS.remove(listener);
        }
    }
}

