/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms;

import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.cms.CadesSignedAttributeGenerator;
import it.actalis.ellips.capi.cms.CadesSignedDataGeneratorProxy;
import it.actalis.ellips.capi.cms.CadesSignedDataProxy;
import it.actalis.ellips.capi.cms.CadesUnSignedAttributeGenerator;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import it.actalis.ellips.capi.pkcs7.VerRsContentSignerBuilder;
import it.actalis.ellips.capi.pkcs7.VerRsSignerInfoGenerator;
import it.actalis.ellips.capi.signature.BaseSignatureOptions;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.util.SignUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cert.jcajce.JcaCRLStore;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.io.Streams;

public class CadesSignatureGenerator
extends SignatureGenerator<CadesSignatureOptions, BaseSignatureOptions> {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void innerSign(CadesSignatureOptions options) throws CapiException {
        OutputStream os = null;
        InputStream is = null;
        try {
            is = options.getDetachedContent() != null ? options.getDetachedContent().getInputAsNewStream() : options.getInput().getInputAsNewStream();
            os = options.getOutput().getAsOutputStream();
            CadesSignedDataGeneratorProxy pkcs7SignedDataGen = this.createGenerator(options, null, false, false);
            pkcs7SignedDataGen.saveToStream(is, os, false);
            logger.debug("Signer added");
        }
        catch (CapiError er) {
            try {
                logger.debug(er.getMessage(), (Throwable)er);
                throw er.getCapiException();
                catch (CapiException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (CMSAttributeTableGenerationException ex) {
                    if (ex.getCause() instanceof TSAException) {
                        throw (TSAException)ex.getCause();
                    }
                    logger.debug(ex.getMessage(), (Throwable)ex);
                    throw new CapiException("Cades Generation Exception:" + ex.getMessage(), 50040);
                }
                catch (Exception ex) {
                    logger.debug(ex.getMessage(), (Throwable)ex);
                    throw new CapiException("Cades Generation Exception:" + ex.getMessage(), 50040);
                }
                catch (Error er2) {
                    logger.debug(er2.getMessage(), (Throwable)er2);
                    throw new CapiException(er2.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(is);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)is);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void innerAddSign(CadesSignatureOptions options) throws CapiException {
        InputStream detachedInputStream = null;
        InputStream cmsContent = null;
        CacheOutputStream cache = null;
        try {
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            CMSSignedDataParser parser = new CMSSignedDataParser(dcp, options.getInput().getInputAsNewStream());
            CMSTypedStream cmsTypedS = parser.getSignedContent();
            if (cmsTypedS != null) {
                cache = new CacheOutputStream(64000);
                Streams.pipeAll((InputStream)cmsTypedS.getContentStream(), (OutputStream)cache);
                cmsContent = cache.getCache();
            } else {
                if (options.getDetachedContent() == null) {
                    logger.debug("no content found into envelope... is detached... but attached is required");
                    throw new CapiException("Envelope is detached", 50000);
                }
                cmsContent = options.getDetachedContent().getInputAsNewStream();
            }
            CadesSignedDataGeneratorProxy pkcs7SignedDataGen = null;
            if (!Util.isNullOrEmpty((String)options.getSignaturePath())) {
                LinkedList<OCSPResp> ocsps;
                LinkedList<BasicOCSPResp> basicOcsps;
                CadesSignedDataProxy counterSignatureDataParser = this.getCounterSignatureDataProxy(new CadesSignedDataProxy(parser), options.getSignaturePath());
                if (counterSignatureDataParser == null) {
                    throw new CapiException("Wrong signer path", 50010);
                }
                detachedInputStream = ((CMSProcessableByteArray)counterSignatureDataParser.getSignedData().getSignedContent()).getInputStream();
                pkcs7SignedDataGen = this.createGenerator(options, counterSignatureDataParser, true, false);
                CMSSignedData finalSignedData = pkcs7SignedDataGen.saveToStream(detachedInputStream, new ByteArrayOutputStream(), true);
                if (finalSignedData == null) {
                    throw new CapiException("Unable to apply counter signature", 50010);
                }
                CadesSignedDataProxy csDataProxy = new CadesSignedDataProxy(finalSignedData);
                pkcs7SignedDataGen = this.createGenerator(options, new CadesSignedDataProxy(parser), false, true);
                SignerInformationStore si = this.setCounterSignature(finalSignedData, parser.getSignerInfos(), options.getSignaturePath());
                pkcs7SignedDataGen.addSigners(si);
                X509Certificate[] certsArray = Certificate.getX509CertificatesFromStore((Store)parser.getCertificates());
                LinkedList<X509Certificate> certsVector = new LinkedList<X509Certificate>(Arrays.asList(certsArray));
                X509Certificate[] certsArray2 = Certificate.getX509CertificatesFromStore((Store)finalSignedData.getCertificates());
                for (int i = 0; i < certsArray2.length; ++i) {
                    if (certsVector.contains(certsArray2[i])) continue;
                    certsVector.add(certsArray2[i]);
                }
                pkcs7SignedDataGen.addCertificates(new JcaCertStore(certsVector));
                LinkedList<CRL> crls = csDataProxy.getCRLS();
                if (crls != null) {
                    for (CRL crl : crls) {
                        pkcs7SignedDataGen.addCRL(crl);
                    }
                }
                if ((basicOcsps = csDataProxy.getBasicOCSPResponses()) != null) {
                    for (BasicOCSPResp ocsp : basicOcsps) {
                        pkcs7SignedDataGen.addBasicOCSP(ocsp);
                    }
                }
                if ((ocsps = csDataProxy.getOCSPResponses()) != null) {
                    for (OCSPResp ocsp : ocsps) {
                        pkcs7SignedDataGen.addOCSP(ocsp);
                    }
                }
                pkcs7SignedDataGen.saveToStream(cmsContent, options.getOutput().getAsOutputStream(), false);
            } else {
                pkcs7SignedDataGen = this.createGenerator(options, new CadesSignedDataProxy(parser), false, false);
                pkcs7SignedDataGen.saveToStream(cmsContent, options.getOutput().getAsOutputStream(), false);
            }
            logger.debug("Signer added");
        }
        catch (CapiError er) {
            try {
                logger.debug(er.getMessage(), (Throwable)er);
                throw er.getCapiException();
                catch (CapiException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (CMSAttributeTableGenerationException ex) {
                    if (ex.getCause() instanceof TSAException) {
                        throw (TSAException)ex.getCause();
                    }
                    logger.debug(ex.getMessage(), (Throwable)ex);
                    throw new CapiException("Cades Generation Exception:" + ex.getMessage(), 50040);
                }
                catch (Exception x) {
                    logger.debug(x.getMessage(), (Throwable)x);
                    throw new CapiException("Cades generation Exception:" + x.getMessage(), 50040);
                }
                catch (Error er2) {
                    logger.debug(er2.getMessage(), (Throwable)er2);
                    throw new CapiException(er2.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(cache);
                Util.closeQuietly(detachedInputStream);
                Util.closeQuietly(cmsContent);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)cache);
        Util.closeQuietly((Closeable)detachedInputStream);
        Util.closeQuietly((Closeable)cmsContent);
    }

    protected void innerUpdateSign(BaseSignatureOptions option) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private SignerInformationStore setCounterSignature(CMSSignedData counterSign, SignerInformationStore parsedata, String path) throws CMSException, CapiException, OperatorCreationException, CertificateEncodingException {
        if (path != null && !path.equals("")) {
            String[] paths = path.split(":");
            Collection signerColl = parsedata.getSigners();
            LinkedList<SignerInformation> signerInformVector = new LinkedList<SignerInformation>(signerColl);
            int index_path = path.indexOf(58);
            if (index_path != -1) {
                SignerInformation curretSI = (SignerInformation)signerInformVector.get(Integer.parseInt(paths[0]));
                AttributeTable uattr = curretSI.getUnsignedAttributes();
                SignerInformationStore ret = this.setCounterSignature(counterSign, curretSI.getCounterSignatures(), path.substring(index_path + 1));
                if (uattr != null) {
                    SignerInformation tmpSI;
                    logger.debug("replacing CS attribute... ");
                    Hashtable ht = uattr.toHashtable();
                    ht.remove(CMSAttributes.counterSignature);
                    AttributeTable newUA = new AttributeTable(ht);
                    curretSI = tmpSI = SignerInformation.replaceUnsignedAttributes((SignerInformation)curretSI, (AttributeTable)newUA);
                }
                curretSI = SignerInformation.addCounterSigners((SignerInformation)curretSI, (SignerInformationStore)ret);
                signerInformVector.set(Integer.parseInt(paths[0]), curretSI);
                return new SignerInformationStore(signerInformVector);
            }
            SignerInformation curretSI = (SignerInformation)signerInformVector.get(Integer.parseInt(path));
            AttributeTable uattr = curretSI.getUnsignedAttributes();
            if (uattr != null) {
                SignerInformation tmpSI;
                logger.debug("replacing CS attribute... ");
                Hashtable ht = uattr.toHashtable();
                ht.remove(CMSAttributes.counterSignature);
                AttributeTable newUA = new AttributeTable(ht);
                curretSI = tmpSI = SignerInformation.replaceUnsignedAttributes((SignerInformation)curretSI, (AttributeTable)newUA);
            }
            curretSI = SignerInformation.addCounterSigners((SignerInformation)curretSI, (SignerInformationStore)counterSign.getSignerInfos());
            signerInformVector.set(Integer.parseInt(path), curretSI);
            return new SignerInformationStore(signerInformVector);
        }
        return null;
    }

    private CadesSignedDataGeneratorProxy createGenerator(CadesSignatureOptions options, CadesSignedDataProxy previousSignature, boolean forceDer, boolean noAddSigner) throws CapiException, OperatorCreationException, CertificateEncodingException, SignatureException {
        CadesSignedDataGeneratorProxy pkcs7SignedDataGen;
        try {
            pkcs7SignedDataGen = new CadesSignedDataGeneratorProxy(options, forceDer, previousSignature, noAddSigner);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Internal error: " + ex.getMessage(), 1003, (Throwable)ex);
        }
        if (noAddSigner) {
            return pkcs7SignedDataGen;
        }
        X509Certificate x509Cert = this.retrieveCert(options);
        PrivateKey privateKey = this.retrieveKey(options);
        Provider prov = this.retrieveProvider(options);
        try {
            pkcs7SignedDataGen.addCert(x509Cert);
            logger.debug("Adding signer OK");
        }
        catch (IOException | CertificateEncodingException | CMSException ex) {
            logger.error(ex.getMessage(), ex);
            throw new CapiException("Internal error: " + ex.getMessage(), 1003, ex);
        }
        logger.debug("Pkcs7addSigner ...");
        String sigAlg = SignUtils.algoByKeyAndDigest((PrivateKey)privateKey, (DigestAlgorithm)options.getDigestAlgorithm()).getJavaName();
        boolean isRsVerified = new Certificate(x509Cert.getEncoded()).isRsVerified();
        ContentSigner contentSigner = isRsVerified ? new VerRsContentSignerBuilder(sigAlg).setProvider(prov).build(privateKey) : new JcaContentSignerBuilder(sigAlg).setProvider(prov).build(privateKey);
        DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
        LTResourceResolver resolver = this.getLTResourceResolver(options, options.isResolveCertificateChainResources());
        JcaSignerInfoGeneratorBuilder jtemp = new JcaSignerInfoGeneratorBuilder(dcp);
        jtemp.setSignedAttributeGenerator((CMSAttributeTableGenerator)new CadesSignedAttributeGenerator(options, x509Cert));
        jtemp.setUnsignedAttributeGenerator((CMSAttributeTableGenerator)new CadesUnSignedAttributeGenerator(resolver, options, pkcs7SignedDataGen, x509Cert, isRsVerified));
        SignerInfoGenerator siGenerator = jtemp.build(contentSigner, x509Cert);
        if (isRsVerified) {
            pkcs7SignedDataGen.addSignerInfoGenerator(new VerRsSignerInfoGenerator(siGenerator));
        } else {
            pkcs7SignedDataGen.addSignerInfoGenerator(siGenerator);
        }
        logger.debug("Pkcs7 generating...");
        return pkcs7SignedDataGen;
    }

    private CadesSignedDataProxy getCounterSignatureDataProxy(CadesSignedDataProxy previousSignature, String path) throws CMSException, CertificateEncodingException, IOException, Exception {
        if (path != null && !path.equals("")) {
            Collection signerColl = previousSignature.getSignerInfos().getSigners();
            LinkedList signerInformVector = new LinkedList(signerColl);
            String[] paths = path.split(":");
            int index_path = path.indexOf(58);
            if (index_path != -1) {
                CadesSignedDataProxy nextPrevSignature = this.retrievePreviousSignedData(previousSignature, (SignerInformation)signerInformVector.get(Integer.parseInt(paths[0])));
                return this.getCounterSignatureDataProxy(nextPrevSignature, path.substring(index_path + 1));
            }
            return this.retrievePreviousSignedData(previousSignature, (SignerInformation)signerInformVector.get(Integer.parseInt(path)));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CadesSignedDataProxy retrievePreviousSignedData(CadesSignedDataProxy previousSignature, SignerInformation signer) throws CMSException, CertificateEncodingException, OperatorCreationException, IOException, Exception {
        CMSSignedDataGenerator pkcs7SignedDataGen = new CMSSignedDataGenerator();
        CMSProcessableByteArray content = new CMSProcessableByteArray(signer.getSignature());
        SignerInformationStore csStore = signer.getCounterSignatures();
        LinkedList<X509Certificate> certsList = previousSignature.getCertificates();
        LinkedList<CRL> crlsList = previousSignature.getCRLS();
        CMSSignedData pkcs7SignedData = null;
        if (csStore == null || csStore.size() == 0) {
            pkcs7SignedData = pkcs7SignedDataGen.generate((CMSTypedData)content, true);
        } else {
            JcaCertStore certStore = new JcaCertStore(certsList);
            JcaCRLStore crlStore = new JcaCRLStore(crlsList);
            pkcs7SignedDataGen.addCertificates((Store)certStore);
            pkcs7SignedDataGen.addCRLs((Store)crlStore);
            pkcs7SignedDataGen.addSigners(csStore);
            pkcs7SignedData = pkcs7SignedDataGen.generate((CMSTypedData)content, true);
        }
        CadesSignedDataProxy cadesSignedDataProxy = new CadesSignedDataProxy(pkcs7SignedData);
        return cadesSignedDataProxy;
    }
}

