/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.encrypt;

import it.actalis.ellips.capi.cms.encrypt.EncryptEnvelopeOptions;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;

public class EncryptEnvelopeGenerator {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public void encrypt(EncryptEnvelopeOptions options) throws CapiException {
        InputStream objIn = null;
        OutputStream objOut = null;
        OutputStream safeOut = null;
        try {
            objIn = options.getInput().getInputAsNewStream();
            objOut = options.getOutput().getAsOutputStream();
            byte[] buf = new byte[64000];
            CMSEnvelopedDataStreamGenerator generator = new CMSEnvelopedDataStreamGenerator();
            for (int i = 0; i < options.getRecipients().size(); ++i) {
                JceKeyTransRecipientInfoGenerator recipientGenerator = new JceKeyTransRecipientInfoGenerator(options.getRecipients().get(i));
                generator.addRecipientInfoGenerator((RecipientInfoGenerator)recipientGenerator);
            }
            int reads = objIn.read(buf);
            ASN1ObjectIdentifier algorithmId = new ASN1ObjectIdentifier(options.getAlgorithm().getOid());
            JceCMSContentEncryptorBuilder encryptorBuilder = new JceCMSContentEncryptorBuilder(algorithmId);
            encryptorBuilder.setProvider(ProvUtils.bcProvider);
            OutputEncryptor encryptor = encryptorBuilder.build();
            safeOut = generator.open(objOut, encryptor);
            while (reads != -1) {
                safeOut.write(buf, 0, reads);
                reads = objIn.read(buf);
            }
            safeOut.close();
            safeOut = null;
            objOut.close();
            objOut = null;
            objIn.close();
            objIn = null;
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Encrypt Envelope Generation Exception:" + ex.getMessage(), 50040);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Encrypt Envelope Generation Exception:" + ex.getMessage(), 50040);
        }
        finally {
            if (objOut != null) {
                try {
                    objOut.close();
                    objOut = null;
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (objIn != null) {
                try {
                    objIn.close();
                    objIn = null;
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (safeOut != null) {
                try {
                    safeOut.close();
                    safeOut = null;
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }
}

