/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.esf.CompleteRevocationRefs;
import org.bouncycastle.asn1.esf.CrlIdentifier;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OcspIdentifier;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.OtherHash;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;

public class CompleteRevocationReferenceBuilder {
    public CompleteRevocationReferenceBuilder(Certificate cert) {
    }

    public CompleteRevocationRefs build() throws NoSuchAlgorithmException, CRLException, OCSPException, IOException {
        CrlOcspRef[] crl_ocsp_ref = new CrlOcspRef[1];
        CrlValidatedID[] crlValidatedID = new CrlValidatedID[]{this.makeCrlValidatedID(null)};
        CrlListID crlListID = new CrlListID(crlValidatedID);
        OcspResponsesID[] ocspResponseID = new OcspResponsesID[]{this.makeOcspResponsesID(null)};
        OcspListID ocspListID = new OcspListID(ocspResponseID);
        crl_ocsp_ref[0] = new CrlOcspRef(crlListID, ocspListID, null);
        CompleteRevocationRefs comRevRef = new CompleteRevocationRefs(crl_ocsp_ref);
        return comRevRef;
    }

    private CrlValidatedID makeCrlValidatedID(X509CRL crl) throws NoSuchAlgorithmException, CRLException {
        CrlIdentifier crlid;
        MessageDigest sha1digest = MessageDigest.getInstance(X509ObjectIdentifiers.id_SHA1.getId(), ProvUtils.bcProvider);
        OtherHash hash = new OtherHash(sha1digest.digest(crl.getEncoded()));
        if (crl.getExtensionValue("2.5.29.20") != null) {
            BigInteger crlnumber = new DERInteger(crl.getExtensionValue("2.5.29.20")).getPositiveValue();
            crlid = new CrlIdentifier(new X500Name(crl.getIssuerX500Principal().getName()), new ASN1UTCTime(crl.getThisUpdate()), crlnumber);
        } else {
            crlid = new CrlIdentifier(new X500Name(crl.getIssuerX500Principal().getName()), new ASN1UTCTime(crl.getThisUpdate()));
        }
        CrlValidatedID crlvid = new CrlValidatedID(hash, crlid);
        return crlvid;
    }

    private OcspResponsesID makeOcspResponsesID(BasicOCSPResp ocspResp) throws NoSuchAlgorithmException, OCSPException, IOException {
        MessageDigest sha1digest = MessageDigest.getInstance(X509ObjectIdentifiers.id_SHA1.getId(), ProvUtils.bcProvider);
        byte[] digestValue = sha1digest.digest(ocspResp.getEncoded());
        OtherHash hash = new OtherHash(digestValue);
        OcspResponsesID ocsprespid = new OcspResponsesID(new OcspIdentifier(ocspResp.getResponderId().toASN1Primitive(), new ASN1GeneralizedTime(ocspResp.getProducedAt())), hash);
        return ocsprespid;
    }
}

