/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.Closeable;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.slf4j.Logger;

public class VerRsSignerInfoGenerator
extends SignerInfoGenerator {
    Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private SignerInfoGenerator original = null;

    public VerRsSignerInfoGenerator(SignerInfoGenerator original) {
        super(original, null, null);
        this.original = original;
    }

    public SignerInfo generate(ASN1ObjectIdentifier objectId) throws CMSException {
        SignerInfo signerInfo;
        ASN1InputStream asn = null;
        try {
            SignerInfo objReturn;
            SignerInfo si = this.original.generate(objectId);
            si.getEncryptedDigest();
            asn = new ASN1InputStream(si.getEncryptedDigest().getOctets());
            SignerInfo objReturnInt = SignerInfo.getInstance((Object)asn.readObject());
            signerInfo = objReturn = new SignerInfo(si.getSID(), si.getDigestAlgorithm(), objReturnInt.getAuthenticatedAttributes(), si.getDigestEncryptionAlgorithm(), objReturnInt.getEncryptedDigest(), si.getUnauthenticatedAttributes());
        }
        catch (IOException ex) {
            try {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                throw new CMSException(ex.getMessage(), (Exception)ex);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(asn);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)asn);
        return signerInfo;
    }
}

