/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util.m7m;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsa.TSDUtils;
import it.actalis.ellips.capi.util.m7m.SimpleMimeReader;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.InputStream;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import org.slf4j.Logger;

public class M7MUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static void M7MToTSD(InputHandler source, OutputHandler destination) throws CapiException {
        try {
            MimeBodyPart mbp = new MimeBodyPart(source.getInputAsNewStream());
            MimePartDataSource mpds = new MimePartDataSource((MimePart)mbp);
            MimeMultipart multipart = new MimeMultipart((DataSource)mpds);
            int pkcs7index = -1;
            int timestampIndex = -1;
            for (int i = 0; i < multipart.getCount(); ++i) {
                if (multipart.getBodyPart(i).getContentType().startsWith("application/pkcs7-mime")) {
                    pkcs7index = i;
                }
                if (!multipart.getBodyPart(i).getContentType().startsWith("application/timestamp")) continue;
                timestampIndex = i;
            }
            InputHandler timestamp = null;
            InputHandler associatedDocument = null;
            if (timestampIndex == -1 && pkcs7index != -1 || pkcs7index == -1 && timestampIndex != -1) {
                SimpleMimeReader smr = new SimpleMimeReader(source.getInputAsNewStream());
                while (smr.nextPart()) {
                    if (smr.getDescription() != null && smr.getDescription().toLowerCase().contains("time-stamp response")) {
                        timestamp = DataHandlerBuilder.get().setBytes(smr.getPartDataAsBytes()).buildInput();
                    } else if (smr.getPartType() != null && smr.getPartType().startsWith("application/timestamp")) {
                        timestamp = DataHandlerBuilder.get().setBytes(smr.getPartDataAsBytes()).buildInput();
                    } else {
                        associatedDocument = smr.getPartType() != null && smr.getPartType().startsWith("application/pkcs7-mime") ? DataHandlerBuilder.get().setBytes(smr.getPartDataAsBytes()).buildInput() : DataHandlerBuilder.get().setBytes(smr.getPartDataAsBytes()).buildInput();
                    }
                    if (timestamp == null || associatedDocument == null) continue;
                    break;
                }
            } else {
                timestamp = DataHandlerBuilder.get().setInputStream(multipart.getBodyPart(timestampIndex).getInputStream()).buildInput();
                associatedDocument = DataHandlerBuilder.get().setInputStream(multipart.getBodyPart(pkcs7index).getInputStream()).buildInput();
            }
            if (timestamp == null || associatedDocument == null) {
                throw new ParsingException("La busta M7M e' corrotta o illeggibile", (Throwable)new Exception("Possibile Boundary non corretto"));
            }
            TimeStampToken tkn = new TimeStampToken(Util.getBytesFromInputStream((InputStream)timestamp.getInputAsNewStream()));
            if (tkn == null || tkn.getInternalTst() == null) {
                throw new CapiException("Could not transform M7M to TSD", 50040);
            }
            TSDUtils.createTsd((InputHandler)associatedDocument, (OutputHandler)destination, (byte[])tkn.toByteArray(false, true), null, null, null, null, null, (boolean)false);
        }
        catch (CapiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CapiException("Could not transform M7M to TSD", 50040, (Throwable)e);
        }
    }
}

