/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util.m7m;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.slf4j.Logger;

public class SimpleMimeReader {
    private InputStream in = null;
    private String boundary = "";
    private String lastBoundary = "";
    private String lastHeader = "";
    private String docHeader = "";
    private byte[] preamble = new byte[0];
    private byte[] epilogue = new byte[0];
    private boolean justGotPart = false;
    private ByteArrayOutputStream readBuffer = new ByteArrayOutputStream(4096);
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("USAGE: java SimpleMimeReader MimeFileName");
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            SimpleMimeReader smr = new SimpleMimeReader(new FileInputStream(args[0]));
            System.out.println("BOUNDARY: " + smr.getBoundaryText());
            System.out.println("PREAMBLE: " + smr.getPreamble());
            System.out.println("CONTENT-TYPE: " + SimpleMimeReader.getHeaderValue(smr.getMessageHeader(), "content-type"));
            System.out.println("MESSAGE HEADER:\n" + smr.getMessageHeader());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int count = 0;
            while (smr.nextPart()) {
                System.out.println("----------\nPART " + ++count + "\n----------");
                System.out.println("TYPE: " + smr.getPartType());
                System.out.println("ENCODING: " + smr.getPartEncoding());
                System.out.println("CONTENT ID: " + smr.getPartID());
                System.out.println("CONTENT DISPOSITION: " + SimpleMimeReader.getHeaderValue(smr.getPartHeader(), "Content-Disposition"));
                System.out.println("HEADER:\n" + smr.getPartHeader());
                long size = smr.getPartData(baos);
                System.out.println("BODY LENGTH: " + size);
                baos.writeTo(new FileOutputStream(args[0] + ".file" + count));
                baos.reset();
            }
            System.out.println("----------");
            System.out.println("EPILOGUE: " + smr.getEpilogue());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        System.out.println(String.valueOf(endTime - startTime) + " ms");
    }

    public SimpleMimeReader(InputStream inStream) {
        this.in = new BufferedInputStream(inStream, 4096);
        this.getMimeBoundary();
    }

    public boolean nextPart() {
        if (this.lastBoundary.equals(this.boundary + "--")) {
            String tempBoundary = this.boundary;
            this.boundary = "";
            this.justGotPart = false;
            this.epilogue = this.getPartDataAsBytes();
            this.boundary = tempBoundary;
            this.lastBoundary = "";
            this.lastHeader = "";
            return false;
        }
        if (!this.justGotPart) {
            this.getPartData(null);
        }
        this.lastHeader = this.boundary.length() == 0 && this.lastHeader.length() == 0 ? this.docHeader : this.getHeader();
        this.justGotPart = false;
        return this.lastHeader.length() > 0;
    }

    public String getBoundaryText() {
        return this.boundary;
    }

    public String getMessageHeader() {
        return this.docHeader;
    }

    public String getPartHeader() {
        return this.lastHeader;
    }

    public String getPreamble() {
        return new String(this.preamble);
    }

    public byte[] getPreambleBytes() {
        byte[] p = new byte[this.preamble.length];
        System.arraycopy(this.preamble, 0, p, 0, this.preamble.length);
        return p;
    }

    public String getEpilogue() {
        return new String(this.epilogue);
    }

    public byte[] getEpilogueBytes() {
        byte[] p = new byte[this.epilogue.length];
        System.arraycopy(this.epilogue, 0, p, 0, this.epilogue.length);
        return p;
    }

    public byte[] getPartDataAsBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getPartData(baos);
        return baos.toByteArray();
    }

    public String getPartDataAsString() {
        return new String(this.getPartDataAsBytes());
    }

    public long getPartData(OutputStream outStream) {
        long count = 0L;
        if (this.justGotPart) {
            return 0L;
        }
        BufferedOutputStream out = null;
        if (outStream != null) {
            out = new BufferedOutputStream(outStream, 4096);
        }
        byte[] blineLast = new byte[]{};
        byte[] bline = this.readByteLine(this.in);
        while (bline.length > 0) {
            String line = new String(bline);
            if (this.boundary.length() > 0 && line.startsWith(this.boundary)) {
                if (blineLast.length > 1) {
                    int len = blineLast[blineLast.length - 2] == 13 ? blineLast.length - 2 : blineLast.length - 1;
                    count += (long)this.writeOut(out, blineLast, len);
                }
                this.lastBoundary = line.trim();
                break;
            }
            count += (long)this.writeOut(out, blineLast, blineLast.length);
            blineLast = bline;
            bline = this.readByteLine(this.in);
        }
        if (bline.length == 0 && blineLast.length > 0) {
            count += (long)this.writeOut(out, blineLast, blineLast.length);
        }
        if (out != null) {
            try {
                out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.justGotPart = true;
        return count;
    }

    private int writeOut(OutputStream out, byte[] data, int len) {
        if (out == null) {
            return 0;
        }
        try {
            out.write(data, 0, len);
            return len;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getPartType() {
        return SimpleMimeReader.getHeaderValue(this.lastHeader, "Content-Type");
    }

    public String getPartEncoding() {
        return SimpleMimeReader.getHeaderValue(this.lastHeader, "Content-Transfer-Encoding");
    }

    public String getDescription() {
        return SimpleMimeReader.getHeaderValue(this.lastHeader, "Content-Description");
    }

    public String getPartID() {
        return SimpleMimeReader.getHeaderValue(this.lastHeader, "Content-ID");
    }

    public static String getHeaderValue(String header, String entry) {
        String value = null;
        boolean gotit = false;
        if (!(entry = entry.toLowerCase()).endsWith(":")) {
            entry = entry + ":";
        }
        StringTokenizer st = new StringTokenizer(header, "\r\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.toLowerCase().startsWith(entry)) {
                value = line.substring(entry.length()).trim();
                gotit = true;
                continue;
            }
            if (!gotit || line.length() <= 0) continue;
            if (Character.isWhitespace(line.charAt(0))) {
                value = value + " " + line.trim();
                continue;
            }
            gotit = false;
        }
        return value;
    }

    private String getHeader() {
        String line;
        StringBuffer header = new StringBuffer("");
        byte[] bline = this.readByteLine(this.in);
        while (bline.length > 0 && (line = new String(bline)).trim().length() != 0) {
            header.append(line);
            bline = this.readByteLine(this.in);
        }
        return header.toString();
    }

    private void getMimeBoundary() {
        String value;
        while (this.docHeader.trim().length() == 0) {
            this.docHeader = this.docHeader + this.getHeader();
            try {
                if (this.in.available() != 0) continue;
                System.out.println("Reached the EOF");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((value = SimpleMimeReader.getHeaderValue(this.docHeader, "content-type")) != null) {
            int pos1 = value.toLowerCase().indexOf("boundary");
            int pos2 = value.indexOf(59, pos1);
            if (pos2 < 0) {
                pos2 = value.length();
            }
            if (pos1 > 0 && pos2 > pos1) {
                this.boundary = value.substring(pos1 + 9, pos2);
            }
        }
        if (this.boundary.startsWith("\"")) {
            this.boundary = this.boundary.substring(1);
        }
        if (this.boundary.endsWith("\"")) {
            this.boundary = this.boundary.substring(0, this.boundary.length() - 1);
        }
        this.boundary = this.boundary.trim();
        if (this.boundary.length() == 0) {
            this.justGotPart = true;
        } else {
            this.boundary = "--" + this.boundary;
            this.preamble = this.getPartDataAsBytes();
        }
    }

    private byte[] readByteLine(InputStream in) {
        this.readBuffer.reset();
        try {
            int c;
            while ((c = in.read()) != -1) {
                this.readBuffer.write(c);
                if (c != 10) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.readBuffer.toByteArray();
    }
}

