/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xades;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.signature.BaseSignatureOptions;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.xades.XadesDocument;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XadesSignatureGenerator
extends SignatureGenerator<XadesSignatureOptions, BaseSignatureOptions> {
    protected void innerSign(XadesSignatureOptions object) throws CapiException {
        X509Certificate x509Certificate = this.retrieveCert((SignatureOptions)object);
        PrivateKey privateKey = this.retrieveKey((SignatureOptions)object);
        Provider provider = this.retrieveProvider((SignatureOptions)object);
        try {
            Object object2 = new XadesDocument(object.getInput());
            object2 = ((XadesDocument)object2).b((XadesSignatureOptions)((Object)object), x509Certificate, privateKey, provider);
            object = object.getOutput().getAsOutputStream();
            XadesSignatureGenerator.a((Document)object2, (OutputStream)object);
            ((OutputStream)object).flush();
            return;
        }
        catch (IOException iOException) {
            throw new CapiException("Unable to sign XML document IOException", 1003, (Throwable)iOException);
        }
        catch (TransformerException transformerException) {
            throw new CapiException("Unable to sign XML document TransformerException", 1003, (Throwable)transformerException);
        }
    }

    protected void innerAddSign(XadesSignatureOptions xadesSignatureOptions) throws CapiException {
        this.innerSign(xadesSignatureOptions);
    }

    protected void innerUpdateSign(XadesSignatureOptions object) throws CapiException {
        try {
            Object object2 = new XadesDocument(object.getInput());
            object2 = ((XadesDocument)object2).a((XadesSignatureOptions)((Object)object));
            object = object.getOutput().getAsOutputStream();
            XadesSignatureGenerator.a((Document)object2, (OutputStream)object);
            ((OutputStream)object).flush();
            return;
        }
        catch (IOException iOException) {
            throw new CapiException("Unable to sign XML document IOException", 1003, (Throwable)iOException);
        }
        catch (TransformerException transformerException) {
            throw new CapiException("Unable to sign XML document TransformerException", 1003, (Throwable)transformerException);
        }
    }

    private static void a(Document document, OutputStream outputStream) throws TransformerException {
        Object object = TransformerFactory.newInstance();
        object = ((TransformerFactory)object).newTransformer();
        ((Transformer)object).transform(new DOMSource(document), new StreamResult(outputStream));
    }

    protected void parameterValidation(XadesSignatureOptions xadesSignatureOptions) throws CapiException {
        super.parameterValidation((SignatureOptions)xadesSignatureOptions);
        if (xadesSignatureOptions.getDigestAlgorithm() == DigestAlgorithm.SHA3_224 || xadesSignatureOptions.getDigestAlgorithm() == DigestAlgorithm.SHA3_256 || xadesSignatureOptions.getDigestAlgorithm() == DigestAlgorithm.SHA3_384 || xadesSignatureOptions.getDigestAlgorithm() == DigestAlgorithm.SHA3_512) {
            throw new CapiException("Unsupported Digest Algorithm", 3011);
        }
    }
}

