/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x509.Extension;

public class StepX509ExtensionsCheck
extends MultipleValidationSubStepImpl {
    public StepX509ExtensionsCheck() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        Object object;
        linkedList = new LinkedList();
        if (validationContextParameters != null && validationContextParameters.getSignerCertificate() != null && validationContextParameters.getSignature() == null || validationContextParameters.getSignature().getFormat() != null && !validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
            try {
                object = validationContextParameters.getSignerCertificate().getCert().keyUsageToString(validationContextParameters.getSignerCertificate().getCert().getKeyUsage());
            }
            catch (CapiException capiException) {
                object = "";
            }
            if (validationContextParameters.getSignature() != null && !validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST) && !object.contains("nonRepudiation")) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0011_NODIGITALSIGNATURE, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
            }
        }
        if (validationContextParameters != null && validationContextParameters.getSignerCertificate() != null && Constants.DPCM_AGID_189_2017_DEADLINE.before(validationContextParameters.getSignerCertificate().getCert().getInternalCert().getNotBefore())) {
            try {
                if (validationContextParameters.getSignerCertificate().getCert().getAuthorityKeyIdentifier() == null) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0008_AKI_NOT_PRESENT, new Object[0]));
                }
            }
            catch (CapiException capiException) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0008_AKI_NOT_PRESENT, new Object[0]));
            }
            try {
                if (validationContextParameters.getSignerCertificate().getCert().hasExtension(Extension.policyMappings.getId())) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0010_POLICY_MAPPINGS_NOT_ALLOWED, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
                }
            }
            catch (CapiException capiException) {}
            try {
                object = validationContextParameters.getSignerCertificate().getCert().getPolicies(',');
                if (object == null || ((String[])object).length <= 0) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0011_CERTIFICATE_POLICIES_NOT_PRESENT, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
                }
            }
            catch (CapiException capiException) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0011_CERTIFICATE_POLICIES_NOT_PRESENT, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
            }
            try {
                if (validationContextParameters.getSignerCertificate().getCert().hasExtension(Extension.nameConstraints.getId())) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0012_NAME_CONSTRAINTS_NOT_ALLOWED, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
                }
            }
            catch (CapiException capiException) {}
            try {
                if (validationContextParameters.getSignerCertificate().getCert().hasExtension(Extension.inhibitAnyPolicy.getId())) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0013_INHIBIT_ANY_POLICY_NOT_ALLOWED, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
                }
            }
            catch (CapiException capiException) {}
            object = null;
            String[] stringArray = null;
            try {
                object = validationContextParameters.getSignerCertificate().getCert().getOcspUrl();
            }
            catch (CapiException capiException) {}
            try {
                stringArray = validationContextParameters.getSignerCertificate().getCert().getCdpURLs();
            }
            catch (CapiException capiException) {}
            if (object == null && (stringArray == null || stringArray.length == 0 || stringArray[0] == null || stringArray[0].isEmpty())) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0021_OCSP_AND_CRL_INFORMATION_NOT_PRESENT, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]));
            }
        }
        return linkedList;
    }
}

