/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import java.util.List;

public class StepX509ValidateCertificateChain
extends MultipleValidationSubStepImpl {
    public StepX509ValidateCertificateChain() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        boolean bl;
        ValidatedCertificate validatedCertificate;
        boolean bl2;
        linkedList = new LinkedList();
        if (validationContextParameters == null || validationContextParameters.getSignerCertificate() == null) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
            return linkedList;
        }
        ValidatedCertificate validatedCertificate2 = validationContextParameters.getSignerCertificate();
        CertDBItem[] certDBItemArray = validatedCertificate2.getCert().getValidatedChain();
        if (certDBItemArray == null || certDBItemArray.length == 0) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0028_NO_CHAIN_FOUND, this.getClass().getName()));
            return linkedList;
        }
        boolean bl3 = certDBItemArray.length == 1;
        if (!bl3) {
            CertDBItem certDBItem = certDBItemArray[1];
            CertDBItem[] certDBItemArray2 = new CertDBItem[certDBItemArray.length - 1];
            System.arraycopy(certDBItemArray, 1, certDBItemArray2, 0, certDBItemArray.length - 1);
            try {
                Certificate certificate = certDBItem.getCertificate();
                certificate.setValidatedChain(certDBItemArray2);
                validatedCertificate2.setIssuer(validationContextParameters.getValidator().validate(certificate, validationContextParameters.getProfile(), validationContextParameters.getValidationDate()));
            }
            catch (CapiException capiException) {
                this.logger.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        boolean bl4 = validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getFormat() != null && validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST);
        boolean bl5 = CertDBItem.SOURCES_IN_CDB.contains(certDBItemArray[0].getSource());
        boolean bl6 = bl2 = certDBItemArray[0].getSource() == 6;
        if (!bl5 && bl3) {
            if (bl4) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0014_INVALID_CERT_TSA_AUTHORITY, this.getClass().getName()));
            } else {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0002_INVALID_CERT_AUTHORITY, this.getClass().getName()));
            }
        } else if (!bl5 && validatedCertificate2.getIssuer() != null) {
            ValidatedCertificate validatedCertificate3 = validatedCertificate2.getIssuer();
            if (validatedCertificate3.hasMessage(ValidatorMessageEnum.EC0014_INVALID_CERT_TSA_AUTHORITY)) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0014_INVALID_CERT_TSA_AUTHORITY, this.getClass().getName()));
            } else if (validatedCertificate3.hasMessage(ValidatorMessageEnum.EC0002_INVALID_CERT_AUTHORITY)) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0002_INVALID_CERT_AUTHORITY, this.getClass().getName()));
            }
        }
        bl3 = validationContextParameters.getCertDB().isValidChain(certDBItemArray, validationContextParameters.getProfile());
        if (!bl3) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0023_CERT_AUTHORITY_NOT_VALID_FOR_PROFILE, this.getClass().getName()));
        }
        if (bl2) {
            validatedCertificate = validatedCertificate2;
            bl = bl3;
        } else {
            validatedCertificate = validatedCertificate2;
            bl = bl5 && bl3;
        }
        validatedCertificate.setCertTrusted(bl);
        return linkedList;
    }
}

