/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.pdf.panels;

import esecurity.crypto.gui.pdf.bean.PdfDocument;
import esecurity.crypto.gui.pdf.guielements.CGAppearance;
import esecurity.crypto.gui.pdf.guielements.CGAppearanceBuilder;
import esecurity.crypto.gui.pdf.panels.oqjnkbuz;
import esecurity.crypto.gui.pdf.panels.qrbdtsxk;
import esecurity.crypto.gui.pdf.panels.rjvtsclo;
import esecurity.crypto.gui.pdf.panels.vhhpyrok;
import esecurity.crypto.gui.properties.UserProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.crypto.gui.utils.guielements.CGRadioButton;
import esecurity.desktop.FileDialog;
import esecurity.desktop.View;
import esecurity.desktop.dom.Button;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.dom.Image;
import esecurity.desktop.dom.Paragraph;
import esecurity.desktop.dom.SpanContainer;
import esecurity.desktop.dom.TextInput;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;

public class PdfViewerOptionsPanel {
    private static final EllipsLogger logger = PdfViewerOptionsPanel.Uk("m2pv0o", Constants.CAPI_LOGGER_NAME);
    private static final I18N i18n;
    private static final String ARROW_LEFT;
    private static final String ARROW_RIGHT;
    private final View view;
    private final CGAppearanceBuilder appearanceBuilder;
    private final List<PdfDocument> pdfDocuments;
    private CGRadioButton imageYesRB;
    private CGRadioButton imageNoRB;
    private Image appearanceImage;
    private Button modifyImageBtn;
    private CGRadioButton dateYesRB;
    private CGRadioButton dateNoRB;
    private CGRadioButton locationYesRB;
    private CGRadioButton locationNoRB;
    private TextInput locationTextBox;
    private CGRadioButton reasonYesRB;
    private CGRadioButton reasonNoRB;
    private TextInput reasonTextBox;
    private CGRadioButton preservePDFAYesRB;
    private CGRadioButton preservePDFANoRB;
    private boolean isOptionsVisible = false;
    private BufferedImage bufferedImage = null;

    public PdfViewerOptionsPanel(CGAppearanceBuilder appearanceBuilder, List<PdfDocument> pdfDocuments, DOMElement parent, View view) {
        this.appearanceBuilder = appearanceBuilder;
        this.pdfDocuments = pdfDocuments;
        this.view = view;
        this.draw(parent);
    }

    private void draw(DOMElement parent) {
        char[] cArray = "\ud820\ub016\u704c\u69c9\ufe7a\u14f8\u933e\ucfd4\ubcca\uc536\u052a\u0aaa\ubd05\u403a\uc06a\u0888\ua7c3\ub816\u2201\u319f\u6b8d\u7dcf\u9c1a\ud006\u3931\u0141\u4dc6\u0eb7\u6fce\u5679\u1d75\ub3b7\u09fe\u4c02\uce41\u7a3a\u630e\ufcd1\u87fa\ucfb2\u8ea8\uf178\ufd51\ue5e5\u20e4\u5f8d".toCharArray();
        cArray[21] = (char)(cArray[21] ^ 0x3D9A);
        DivContainer optionsContainer = new DivContainer(rjvtsclo.j(cArray, (short)31713, 0, 0), parent, this.view);
        char[] cArray2 = "\u365e\u06c3\ud9ef\u4b45\u9f8d\u0ac6\ub568\u40a9\u439a\u8739\u4a43\u2b53\u2de7\u0d1f\ud19b\ud71e\u174c\u0a9d\ue10a\u8f11\ub5aa\u5d3f\uac4c\uba8f\u5262~\ueba6\u465a\ud5e6\ua0db\ued04\u1fc4\uc483\ub927\u69f0\ud7ad\uddb9\u6cee\uf2d6\u5456\u7d1d\u5f2d\u6967\udee2\u34ca\u4e21".toCharArray();
        cArray2[26] = (char)(cArray2[26] ^ 0xB51);
        PdfViewerOptionsPanel.Uk("-51u0td", optionsContainer, rjvtsclo.j(cArray2, (short)7600, 0, 0));
        char[] cArray3 = "\ud1eb\u4e3f\u8d68\ue78d\u2ba1\ubaad\u2188\ub2a7\u5ef9\u98c9\u8f60\u16a9\u159e\u5e73\u4cc4\ud0f6\ucad9\uf461\u93c9\u2d5e\ud7b6\u3de3\u47ad\u3306\ub0bb\u0bff\u01d1\ub86c\u3d42\u9717\u32f5\u4cc9\u7c67\ub2ce\u1b6e\ua4db\u8e3a\ua322\uba5e\u81ef\uecfb\u7ce9\u057e\u434f\u6bd7\ua6bb\uf308\u705f\u389d".toCharArray();
        cArray3[2] = (char)(cArray3[2] ^ 0x79D3);
        DivContainer optionsArea = new DivContainer(rjvtsclo.j(cArray3, (short)18957, 2, 1), (DOMElement)optionsContainer, this.view);
        char[] cArray4 = "\u5c48\u5357\u5dac\u0e8e\ueca0\u01d6\u042b\ubc90\uecbb\u6489\u28a1\u0ab6\uc299\u3d74\u13d2\u3095\uec3f\u41c7\ub7cb\ua392\ubbe7\ud985\u109b\u9c1c\u8972\u55c5\ua6b1\u8bfb\ua008\u8fc9\ue48d\ue416\u636b\u5666\u780a\u98da\udb81\ub957\ube3e\u1bde\u4bdc\uf4f2\u8898\u79d3\u23e7\ua3b3\u35b3\u26f0\u6c10".toCharArray();
        cArray4[17] = (char)(cArray4[17] ^ 0x38DC);
        PdfViewerOptionsPanel.Uk("-51u0td", optionsArea, rjvtsclo.j(cArray4, (short)8958, 5, 2));
        PdfViewerOptionsPanel.Uk("1al5uvt", optionsArea, false);
        char[] cArray5 = "\uce6a\u267b\u510c\uff7e\u83d2\u5c23\udc83\ucb6f\u3e4a\u2fd1\u6f84\u3598\u3153\u9337\u5d21\uf8a6\u3b9c\uc387\u02d1\u6290\u2067\uf223\u3c9b\u93fc\u070e\u5e7c\ueec5\u4939\u41e9\ubddc\u01dd\uca68\uc1f0\u63c2\u615b\u7f89\u6d8b\u6a17\u7adc\u27b6\u5c38\u06fe\u1ea7\u7b58\u8e89\u954d\u16e5\u1ce3\uf434\uab56\u3853\u8dc7\u87fd\u5ca3\u13af\u345c".toCharArray();
        cArray5[17] = (char)(cArray5[17] ^ 0x1EA7);
        DivContainer optionsAreaContent = new DivContainer(rjvtsclo.j(cArray5, (short)20978, 0, 0), (DOMElement)optionsArea, this.view);
        char[] cArray6 = "\u69a3\u4664\u7001\u7b1b\ued25\ucd2f\ufbed\uda13\uf5a8\u909d\u04f3\uf9baw\u6717\uacc9\u3570\u918e\u4b17\u769d\u1097\u05d2\u86e3\ude02\uabf7\ua9e6\uc75f\ud6a9\u0080\u81e6\ue1c2\u5f61\u75f5\u3050\u5751\u1ecc\u484a\uf79b\uade4\u0ef7\uc8bb\uda7b\ub59b\u9d47\u44e3\u3c0a\ud728\u1fb9\u5d26\u8800\u556f\u5668\ub813\uaf26\u257f\u27f3\u52d2".toCharArray();
        cArray6[3] = (char)(cArray6[3] ^ 0x7268);
        PdfViewerOptionsPanel.Uk("-51u0td", optionsAreaContent, rjvtsclo.j(cArray6, (short)2321, 1, 2));
        char[] cArray7 = "\ua5a5\u98ca\u6798\u68fc\u347b\uacd1\u737d\u2c10\u660f\u4c48\u547f\ue04f\ue0cb\u68a4L\u59af\u0a0d\u1e4e\u2517\u96ff\udd4e\u589c\u75cb\u4ec5\ue377\u3224\u842d\ufba8\u2ed8\uafb3\u9b69\u7ae9\u4f57\u8de3\ude76\u3fbc\u1d07\udb1c\u96ef\u313b\u5285\u2d96\ube3b\u3328\uf5d3\u83fc\uf3c7\u5169\uef14\u7b4a\ua58c\ud59c\udcd9\u2c20".toCharArray();
        cArray7[30] = (char)(cArray7[30] ^ 0x69E9);
        Paragraph optionsInfo = new Paragraph(rjvtsclo.j(cArray7, (short)13774, 4, 1), (DOMElement)optionsArea, this.view, () -> {
            char[] cArray = "\u08c5\u3a1b\u8732\u223a\u2dfe\uea27\u6028\u17e7\ua5a0\u0434\u0739\ud8a7\u9127\u7fdf\u5350\u1404\uc2f1\u9251\u0146\uf819\u4bf8\u90f3\u0135\u5b91\u5f61\u716a\ud68b\u3107\u2116\ub8b7\u1c0e\u8bda\ued86\u6e70\u0e3b\u64f0\u1a37\ucc7a\u5b41".toCharArray();
            cArray[17] = (char)(cArray[17] ^ 0x1CE);
            return PdfViewerOptionsPanel.Uk("5hv35", i18n, vhhpyrok.N(cArray, (short)14763, 2, 4), (Object[])new Object[0]);
        });
        char[] cArray8 = "\u0d6a\ucbb0\u100e\ua8d4\u9940\u2e89\u0412\u8fc8\u7f71\u14f2\u3871\u59e2\u51b0\uaec6\u57ce\ub871\u6286\u9522\u618c\u7eca\u22a3\u00bc\u4ef1\u4e7c\u22ed\u2e24\ue8fc\u57b3\u43dc\u8361\ud2e5\ubfd4\ue55e\u9eac\u1abe\ue816\u4fcc\uecd1\ufc50\u8a15|\u50b3\u5d07\udb2d\ub9d1\ud2f4\ue6ca\u0e57\uabc8\ue0d1\u66b1\ub2c7\u09be\u72e7".toCharArray();
        cArray8[5] = (char)(cArray8[5] ^ 0x6DA8);
        PdfViewerOptionsPanel.Uk("1kqjuvo", optionsInfo, rjvtsclo.j(cArray8, (short)8734, 0, 2));
        this.drawImageArea((DOMElement)optionsAreaContent);
        this.drawDateArea((DOMElement)optionsAreaContent);
        this.drawLocationArea((DOMElement)optionsAreaContent);
        this.drawReasonArea((DOMElement)optionsAreaContent);
        this.drawPreservePdfAArea((DOMElement)optionsAreaContent);
        this.drawVerticalArea((DOMElement)optionsContainer, (DOMElement)optionsArea);
    }

    private void drawImageArea(DOMElement parent) {
        char[] cArray = "\ua1b2\u1b99\u36ef\u5d1a\u1b0f\u2669\uaf1b\ud106\u929f\u2177\u787c\u51d9\u32b0\u8db0\u87c9\uaa82\u48b7\ub98e\u99d5\u1d83\u4ff6\u8a9c\u859d\ue65d\u6479\u2a96\u9ea0\u0989\u3f0e\u82f7\u5da1\u20eb\ud608\u83fb\u37c4\u84c5\u39aa\u7327\u72ea\u2409\u0757\u203c\u425e\u6ce7\ub5c0\u2a3f\u78de\u9b64\u42d6\u6801\uc542\u134c\u1620\ub3f0\u75cc\u0cc7\ufc29\u781a\u1899\u0fc8".toCharArray();
        cArray[8] = (char)(cArray[8] ^ 0x967);
        Paragraph imageTitle = new Paragraph(vhhpyrok.N(cArray, (short)13456, 4, 5), parent, this.view, () -> {
            char[] cArray = "\u7d43\u5144\u03f7\u17c0\ub47f\ucb00\u5d07\ud648\u7edb\u7660\uc4d7\ue0de\uefe1\u608e\u57b8\u4d82\ubb87\ua50d\ufa0b\uba48\u62d0\uaf9a\u8cd3\ueb56\u0850\u4f64\u62ed\ue670\ua786\ud6e3\u0d2b\u4868\uf2a5\u3aaf".toCharArray();
            cArray[31] = (char)(cArray[31] ^ 0x51A1);
            return PdfViewerOptionsPanel.Uk("5hv35", i18n, qrbdtsxk.y(cArray, (short)7049, (byte)0, (byte)2), (Object[])new Object[0]);
        });
        char[] cArray2 = "\ud9de\u6558\u5e53\ub3cb\u1d3f\u4ee8\u34d6\u3fbc\ud411\u6c95\u1192\u0500\u271d\u6232\u3f60\ub06d\uf271\ua71e\ufc0f\u42d0\uf0b0\u0cf9\u191b\u1719\u3144\u3c11\u3ef8\u1cbc\uaf49\u0357\uf3d3\u4dbc\u39db\u3d93\u1eb1\ufc2d\u7979\u024e\u212e\u0577\u364b\u03e6\ua805\u66be\uc92a\u179f\u9994\u15d8\uf151\u134a\u5468\u33b7\u0494\u529b\u2fb6".toCharArray();
        cArray2[14] = (char)(cArray2[14] ^ 0x7650);
        PdfViewerOptionsPanel.Uk("1kqjuvo", imageTitle, vhhpyrok.N(cArray2, (short)14254, 0, 4));
        char[] cArray3 = "\u4388\uf3b0\u9c37\ue03c\u769b\u9b14\u86fc\u25da\udfc4\u4d9c\u3041\ua015\u26f5\ue62d\u73dd\ub777\u5df1\u9cb1\u6b8d\u7bc4\u111c\ucdd9\u2294\u7397\u6c06\uc505\ufe48\u1f8a\ua4a6\u07a6\ue7ef\uce5f\uc91b\ue3f7\uc30d\ud289\ufd97\u70d8\u0d4f\ucc86\u2b14\u3dbe\ue783\ud265\ubb68\uf45c\u52a9\ub552\u1f40\u269d\u09e0\ubed9\u802b\u1521\u6490\u2fa3\u929f\uc3d2\u92fc\u7cc8\u66fa\u22de".toCharArray();
        cArray3[37] = (char)(cArray3[37] ^ 0x40C1);
        DivContainer imageDivisor = new DivContainer(vhhpyrok.N(cArray3, (short)7000, 4, 5), parent, this.view);
        char[] cArray4 = "\u8f5e\u75cc\ubfd8\u3988\uce2e\ubf98\u66bb\ud562\u2496\ua46c\u4882\u6dce\uc697\u1410\ud7c9\u3a88\u4a15\u8b3d\u99ca\uacfd\u0fde\u5e6d\u92a0\u6f41\uaa1d\uc7e5\u57a6\u87ce\ud3fc\ub031\u5ee9\u3f9e\u01f0\u922b\u8e5a\u3f41\ue553\u3c75\ub46c\uf37b\u0511\u7253\u3cbc\u7721\u1307\u5623\u8b73\u0b14\u0f3c\ua66b\u8a6a\u123c\u2b56\ue395\u20cc\u94b2\u0fc2".toCharArray();
        cArray4[43] = (char)(cArray4[43] ^ 0x6FD0);
        PdfViewerOptionsPanel.Uk("-51u0td", imageDivisor, vhhpyrok.N(cArray4, (short)24813, 2, 0));
        char[] cArray5 = "\u1714\u1c62\uefe3\u6e53\u923c\u19c8\u2bf9\ueb1e\u0fd1\u98cb\u391b\u3168\u3d1d\u7b71\u785a\uf748\ue39f\u9cee\u5bc4\u46e4\u2e10\u7eda\u2530\u4251\u2a12\u2f58\u8bea\ubdd1\ud0c6\u990e\u1d44\u1926\ub249\u7591\u0d55\u08fb\uba23\u9970\ud18a\u3356\ue8ee\u40a1\ue8e1\u1b87\ufae1\u0f97\u02c8\uefc1\u3dfe\u637b\ua6f9\u309b\u4298\u8906\u01d4\u6a13\u8d89\u4d66".toCharArray();
        cArray5[42] = (char)(cArray5[42] ^ 0x138F);
        char[] cArray6 = "\uf0ac\u0b90\u7b1b\ubeed\u6128\u0c9b\u8ade\uba74\u5961\u1b79\u33ce\u9714\ufa84\u2466\ub3f4\u963c\u92cc\u2df4\u5f35\u09f4\udf64\u0a45\ufc3d\u386d\ua184\u0556\u17ff\u787f\ub7fa\u0b42\ube3f\u5a80".toCharArray();
        cArray6[8] = (char)(cArray6[8] ^ 0xAFC);
        char[] cArray7 = "\u8561\u2c63\u7bed\udbb6\ua933\ud78c\u3cca\ud980\u9814\ue853\u72dc\u57a7\u74d3".toCharArray();
        cArray7[0] = (char)(cArray7[0] ^ 0x826);
        this.imageYesRB = new CGRadioButton(vhhpyrok.N(cArray5, (short)9330, 0, 4), parent, this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, vhhpyrok.N(cArray6, (short)22063, 3, 4), (Object[])new Object[0]), vhhpyrok.N(cArray7, (short)29708, 4, 5));
        char[] cArray8 = "\u00f9\ua512\u49a5\u2f60\ubcb2\u8bed\u8f6d\u1f9c\ua601\u09f3\u5e52\u33e1\u5df3\u2fe5\u5664\ueae6\uefc8\u1c83\u641e\ub8aa\ud896\u1a29\u97c0\u97d7\udb5d\ub1dd\u4382\u4cc4\u6a74\u9ef1\ubadb\u0448\u0a81\ue964\uc901\uc7b5\u1337\u97cf\ud3a1\ucf03\ue7f0\ue4f8\uf979\u56a4\u1c30\u041e\ubf2f\uc4ee\uf541\u5915\u6ad9\ubc6d\u8a5b\u478a\u4800\u2f60\u241d".toCharArray();
        cArray8[18] = (char)(cArray8[18] ^ 0xB67);
        char[] cArray9 = "\u90a1\u54ff\uc3e6\uc22d\ubeb0\ud8d5\u1d47\ua427\u8ae1\u3b18\uea29\ucce8\u7a3a\u0a30\u802e\ud433\u85f1\u3aa9\ud174\u8a64\u8ac5\u68c6\ubc68\u2d8a\uc724\u4525\uf790\ua8a9\u5690\u9a24\u4331".toCharArray();
        cArray9[20] = (char)(cArray9[20] ^ 0x526F);
        char[] cArray10 = "\ua94c\ud90e\u80cf\u6f81\u54d4\u6d5e\ue934\u49dc\ud912\uc9a2\u8eae\u86e0\u75b4".toCharArray();
        cArray10[2] = (char)(cArray10[2] ^ 0xB0A);
        this.imageNoRB = new CGRadioButton(vhhpyrok.N(cArray8, (short)23436, 4, 0), parent, this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, vhhpyrok.N(cArray9, (short)26140, 4, 0), (Object[])new Object[0]), vhhpyrok.N(cArray10, (short)26927, 3, 0));
        char[] cArray11 = "\u2c51\u5c55\u1db7\ucb85\uad58\u0849\u6287\u8534\uc548\ucf30\u2a5b\u41eb\u7428\u1084\u2337\u8504\u3a12\ue08b\u4f40\u8d72\u656a\u9f42\u3aa0\u1571\u1f9e\ue37d\u1c45\ufc43\u43bc\ub87c\u1402\u69ff\u2927\uef87\ue3ec\uca44\ua473\ub5fe\u37e0\uf08c\u4ba3\u58e8\u5bb2\u6950\u37e0\u0789\u36f2\u64ec\uaf2c\ub97f\u4c1b\ubbf3\uad92\u2a6b\uc833\u95e2\uf282\ue8d5\u226e\u1537\u64c8".toCharArray();
        cArray11[20] = (char)(cArray11[20] ^ 0x75DE);
        PdfViewerOptionsPanel.Uk("1dg7v0i", this.imageYesRB, vhhpyrok.N(cArray11, (short)23735, 1, 0));
        char[] cArray12 = "\u1baa\uddd0\u0965\ud886\u5ced\ub4e5\u68f8\ub167\ufc4c\u478f\u111b\u05bb\uc062\uc3d9\u2459\uf51d\u57af\ubcbe\uaaf8\u757e\u3a99\ub17d\u8c9e\udc7c\uf2f0\ufcc9\u4d0b\u014d\u4c8c\u1990\u2614\u3743\uac66\ue2ff\ubdee\u5ed2\uede0\ue86e\u2a9e\ue888\ue4ea\u0d8b\u6a37\uc476\uf8c5\ud614\ucd90\u3ccd\ue6b8\u5c2d\u0ead\ub854\u65c6\uc818\ud7c5\u4bbf\u6a5b\u87f2\uef6a\u8607\u4ab1".toCharArray();
        cArray12[5] = (char)(cArray12[5] ^ 0x7B68);
        PdfViewerOptionsPanel.Uk("1dg7v0i", this.imageNoRB, vhhpyrok.N(cArray12, (short)1623, 1, 2));
        char[] cArray13 = "\u1471\uc542\ufbd3\ue997\u277e\u1ae4\u71c8\u3c6e\u4b1c\u67d7\u62b2\u3436\ubb2c\ud875\uc359\u02db\u0f6e\u3d39\u861b\u7c90\u8bae\u3bb4\u58d7\ubed7\ud9c8\u956c\u8f7d\u300d\u0d58\u883c\u2e3c\u7495\ueb10\uc108\ud7e1\uac59\u5fcd\ub77f\u30da\u8eab\u1774\u3e31\u41b9\u3316\u9e5a\u26a2\udd1c\u0249\u9f42\uf96a\u787d\uf41f\udb6a\u8c07\ubc1f\uc257\u6569\uf158\ub24e\ue793\u9d8a\u81c2\ua2db\u1fb0\u1800".toCharArray();
        cArray13[48] = (char)(cArray13[48] ^ 0x5299);
        this.appearanceImage = new Image(vhhpyrok.N(cArray13, (short)21874, 0, 2), parent, this.view);
        char[] cArray14 = "\u2780\u03ae\u4ca5\uf006\u8075\uaabf\u0240\u1657\uc13a\ud3bd\u1a40\uc988\ufd85\u1928\u899c\u5756\ua219\u14eb\ud716\u51c8\udd95\uc7fe\u2b2e\u3bcf\u1f29\u2d13\ub367\uf38a\ub548\u50e8\u0db1\u4d68\u3f2c\u8073\u6f64\uf5d1\u3cbb\uedac\u87b1\u7008\u20b0\ub3d4\u0701\u524f\u5bbe\u72eb\u2ee1\uf29f\u5715\u0c06\ubcf2\u7ba2\u76a5\u41e2\uac80\ua217\uacdb\u0638\u34ab\ub0b9\ud046\u7236\ubb1e\u19bb\u65f3".toCharArray();
        cArray14[11] = (char)(cArray14[11] ^ 0x2A65);
        PdfViewerOptionsPanel.Uk("-1oa4106", this.appearanceImage, vhhpyrok.N(cArray14, (short)22634, 0, 4));
        if (PdfViewerOptionsPanel.Uk("-11de0v7", PdfViewerOptionsPanel.Uk("-15fg0v4", PdfViewerOptionsPanel.Uk("1d6tv0n"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)"")) == false) {
            PdfViewerOptionsPanel.Uk("73lv34", this.appearanceImage, PdfViewerOptionsPanel.Uk("-15fg0v4", PdfViewerOptionsPanel.Uk("1d6tv0n"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)""));
        } else {
            char[] cArray15 = "\ua398\u8843\u6690\u9340\u5111\u1e6f\ucf5f\u7dcd\u3faf\u8dec\u9efe\u742f\u9747\u1e55\ud9e7\u3b85\u5194\u978a\u3a20\u6e39\u9a09\ud408\u926d\u3f64\u7f53\u50c8\uf9e1\u4038\u7896\u5c7b".toCharArray();
            cArray15[23] = (char)(cArray15[23] ^ 0xCB4);
            PdfViewerOptionsPanel.Uk("73lv34", this.appearanceImage, PdfViewerOptionsPanel.Uk("-de101", vhhpyrok.N(cArray15, (short)22626, 5, 1)));
        }
        char[] cArray16 = "\u757f\u0eb3\u39a2\uff44\ufc41\ud38b\ua2db\u6d4f\u6cf5\ub54b\u724b\uf768\uac4d\uaf20\ucbd0\u32f7\ud078\u2b76\u313b\u942a\u5bcd\uf9a3\u968b\uc7ca\u6554\u10e7\u545c\uec2f\ucf77\ub42a\uafdf\uf2f6\u0195\uf3bd\ub114\u220c\u0a40\udd52\ub830\u891f\u0b6f\u51e2\u7b32\u2864\u2261\u1124\u6bc9\ua4f5\ud82f\ufcd9\ua5af\u33fe\u82ce\u7cde\u1183\ue5d3\ud113\u4081\u1190\ud8b3\u731d\u6c26\uf474\u6b00".toCharArray();
        cArray16[62] = (char)(cArray16[62] ^ 0x8E);
        this.modifyImageBtn = new Button(vhhpyrok.N(cArray16, (short)24558, 5, 2), parent, this.view, () -> {
            char[] cArray = "\ud2f3\u3e51\u9e71\u5fb5\u2bbc\uc7c4\ueeec\u60e6\u5463\uc077\uf75c\u247e\uc748\u716a\ue600\ufe6bh\u1524\u61ec\u42d1\u62d5\ued81\u9583\ua025\u2bca\ue0ce\uf705\u7631\u2b82\ua109\ufb58\ube92\u6369\ub7c1\u3694".toCharArray();
            cArray[9] = (char)(cArray[9] ^ 0x1203);
            return PdfViewerOptionsPanel.Uk("5hv35", i18n, rjvtsclo.j(cArray, (short)3781, 5, 5), (Object[])new Object[0]);
        });
        char[] cArray17 = "\ucf33\u25e1\ufa2c\u7f44\u03d0\ue32b\uf9c0\ueb44\ud7f7\ucf66\u65a9\ua64e\u1f67\ud2f7\u63df\uefc5\uc9ac\u6b5b\u893d\u433d".toCharArray();
        cArray17[17] = (char)(cArray17[17] ^ 0x6F6E);
        PdfViewerOptionsPanel.Uk("-1dk60vh", this.modifyImageBtn, vhhpyrok.N(cArray17, (short)18630, 2, 1));
        char[] cArray18 = "\u767c\ue5c3\u2461\u1788\ua655\u3fae\ufc19\u2bb9\uf0e6\u3133\u38b9\ubd5b\uef97\u37ef\ub374\u68fc\ufa29\u6bf5\uc6ba\u5a7a\u62b6\u1068\u5e42\uc2ee\u62be\uc7f3\ub137\u40a5\u2dbe\uf72f\ud2d4\ub0e1\u7219\ubb2d\u8eb1\u0712\u5ee3\u0765\u2999\ufe1b\uccf6\u3b13\u274e\uf7d6\u3bd4\ue5b2\u6de1\u5655\u2a55\ua000\ub28c\uc65e\ue8fc\ufae3\u3178\u0c8a\ua7a4\u11e4\u6d0d\u1ba6\u590c\uabf7\u79e9\u0b03".toCharArray();
        cArray18[48] = (char)(cArray18[48] ^ 0x5355);
        PdfViewerOptionsPanel.Uk("-1dk60vh", this.modifyImageBtn, vhhpyrok.N(cArray18, (short)11886, 0, 3));
        PdfViewerOptionsPanel.Uk("6e9v0m", this.imageYesRB, () -> {
            if (PdfViewerOptionsPanel.Uk("5rnuug", this.imageYesRB) != false) {
                this.onImageYesSelected();
            }
        });
        PdfViewerOptionsPanel.Uk("6e9v0m", this.imageNoRB, () -> {
            if (PdfViewerOptionsPanel.Uk("5rnuug", this.imageNoRB) != false) {
                this.onImageNoSelected();
            }
        });
        char[] cArray19 = "\u5008\u1538\udef9\u1743\u7391".toCharArray();
        cArray19[1] = (char)(cArray19[1] ^ 0x727);
        char[] cArray20 = "\ub5f4\u53df\u8a91\u00ac\u54a9".toCharArray();
        cArray20[2] = (char)(cArray20[2] ^ 0x7EE);
        if (PdfViewerOptionsPanel.Uk("2q1v0r", vhhpyrok.N(cArray19, (short)6604, 1, 0), PdfViewerOptionsPanel.Uk("-15fg0v4", PdfViewerOptionsPanel.Uk("1d6tv0n"), UserProperties.GRAPHICSIGNATURE_IMAGE, (Object)vhhpyrok.N(cArray20, (short)15375, 4, 4))) == false) {
            PdfViewerOptionsPanel.Uk("-15j20ug", this.imageNoRB, false);
            this.onImageNoSelected();
        } else {
            PdfViewerOptionsPanel.Uk("-15j20ug", this.imageYesRB, false);
            this.onImageYesSelected();
        }
        PdfViewerOptionsPanel.Uk("-r6u10c", this.modifyImageBtn, evt -> this.onModifyImage());
    }

    private void onImageYesSelected() {
        if (this.bufferedImage == null) {
            Object src = null;
            File srcFile = null;
            if (PdfViewerOptionsPanel.Uk("-11de0v7", PdfViewerOptionsPanel.Uk("-15fg0v4", PdfViewerOptionsPanel.Uk("1d6tv0n"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)"")) == false) {
                srcFile = new File((String)PdfViewerOptionsPanel.Uk("-15fg0v4", PdfViewerOptionsPanel.Uk("1d6tv0n"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)""));
                src = PdfViewerOptionsPanel.Uk("-1rka0uj", srcFile);
            }
            if (src != null) {
                PdfViewerOptionsPanel.Uk("73lv34", this.appearanceImage, src);
                try {
                    this.bufferedImage = PdfViewerOptionsPanel.Uk("1p7dv1a", srcFile);
                }
                catch (IOException ex) {
                    PdfViewerOptionsPanel.Uk("-fo4105", logger, PdfViewerOptionsPanel.Uk("-27u10a", ex), (Object)ex);
                }
            } else {
                this.loadDefaultImage();
            }
        }
        char[] cArray = "\u52fd\uaa21\ud403\ua115\u7043\u62df\ucabc\u4037\u96ab\ue701\u6bf8\ud018\uff17\u68be\u0977".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x2088);
        PdfViewerOptionsPanel.Uk("18jjv1f", this.appearanceImage, rjvtsclo.j(cArray, (short)23622, 0, 0));
        PdfViewerOptionsPanel.Uk("1r9v0k", this.modifyImageBtn, false);
        PdfViewerOptionsPanel.Uk("-1qms0vf", this.appearanceBuilder, true);
        PdfViewerOptionsPanel.Uk("sfjv1e", this.appearanceBuilder, this.bufferedImage);
        this.updateAllImages(this.bufferedImage, true);
    }

    private void loadDefaultImage() {
        char[] cArray = "\u69fd\u1b92\u0324\ua356\ud3b4\u4a15\u383f\u32e4\uaba3\uaf47\u80f1\u2391\ue04c\ued58\ua2f6\ud1a3\uddf4\ub98d\u0ce0\u683d\u7d39\u48ed\uc029\uad95\u5047\u56cb\u18cf\u5282\u01c6\u4d8d".toCharArray();
        cArray[18] = (char)(cArray[18] ^ 0x55CD);
        PdfViewerOptionsPanel.Uk("73lv34", this.appearanceImage, PdfViewerOptionsPanel.Uk("-de101", qrbdtsxk.y(cArray, (short)11810, (byte)4, (byte)5)));
        try {
            char[] cArray2 = "\ua217\uaba8\u7160\u045a\u96a2\ub38d\u40e8\u60ad\uc340\udc86\uf234\uc90d\u351e\uc942\u9cab\u86a1\u010a\u65cc\ud063\u37b6\ue791\u4b9d\u4150\uc153\ub554\u5fe4\uc290\ufd7d\u12ac\uaba6\u6b74\ud5df\u2b0a\u65d8\u07f7\uf3ec\ube4e\u744b\ue70a\u4f62\u1766\uaa1d\u825a\u5324\ub031\u5405\u0bec\u6625\u167b\ua3b1\u7781\uee84\u2466\u16bc\u3d51\u3cec".toCharArray();
            cArray2[40] = (char)(cArray2[40] ^ 0x7E4D);
            this.bufferedImage = PdfViewerOptionsPanel.Uk("1077v18", PdfViewerOptionsPanel.Uk("m2rv0j", PdfViewerOptionsPanel.class, qrbdtsxk.y(cArray2, (short)23098, (byte)0, (byte)5)));
        }
        catch (IOException ex) {
            PdfViewerOptionsPanel.Uk("-fo4105", logger, PdfViewerOptionsPanel.Uk("-27u10a", ex), (Object)ex);
        }
    }

    private void onImageNoSelected() {
        char[] cArray = "\u54d7\u570d\u08e2\u52ab\u214c\u0d36\u23dc\u7695\u0120\u9795\u7c4c\u02db\ua578\u1464\u36df".toCharArray();
        cArray[8] = (char)(cArray[8] ^ 0x3E13);
        PdfViewerOptionsPanel.Uk("-1oa4106", this.appearanceImage, vhhpyrok.N(cArray, (short)20045, 4, 3));
        PdfViewerOptionsPanel.Uk("1r9v0k", this.modifyImageBtn, true);
        PdfViewerOptionsPanel.Uk("-1qms0vf", this.appearanceBuilder, false);
        PdfViewerOptionsPanel.Uk("sfjv1e", this.appearanceBuilder, null);
        this.updateAllImages(null, false);
    }

    private void onModifyImage() {
        char[] cArray = "\uaff8\u4406\u5988\ua3b0\ucbb6\u7824\uf8aa\ucdec\uacf2\ub746\ucdfa\uf7da\u122e\u9a5a\uab83\u0566\u53f5\u18c0\u9150\u2934\ub3d7\ue52e\uf0f1\u6554\ube57\ucdf6\u3df1\ud168\uf67b\uac2d\uf249\uf193\uf32e\u8b49\uc3aa\ud79f\u4fc5\u3f50\u0182\uae03\u05f1\u3f08".toCharArray();
        cArray[29] = (char)(cArray[29] ^ 0x5315);
        FileDialog dialog = new FileDialog(this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, vhhpyrok.N(cArray, (short)28603, 1, 1), (Object[])new Object[0]), esecurity.crypto.gui.utils.Constants.APPEARANCE_IMAGE_FORMATS);
        Object file = PdfViewerOptionsPanel.Uk("19o5v15", dialog, false);
        if (file != null && !file.isEmpty()) {
            try {
                File imageFile = new File((String)file.get(0));
                PdfViewerOptionsPanel.Uk("73lv34", this.appearanceImage, PdfViewerOptionsPanel.Uk("-1rka0uj", imageFile));
                PdfViewerOptionsPanel.Uk("-1qms0vf", this.appearanceBuilder, true);
                this.bufferedImage = PdfViewerOptionsPanel.Uk("1p7dv1a", imageFile);
                PdfViewerOptionsPanel.Uk("sfjv1e", this.appearanceBuilder, this.bufferedImage);
                this.updateAllImages(this.bufferedImage, true);
            }
            catch (IOException ex) {
                PdfViewerOptionsPanel.Uk("-fo4105", logger, PdfViewerOptionsPanel.Uk("-27u10a", ex), (Object)ex);
            }
        }
    }

    private void updateAllImages(BufferedImage image, boolean useImage) {
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Uk("-thg0up", PdfViewerOptionsPanel.Uk("h1fv12", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Uk("1mrrv1c", app, useImage);
                PdfViewerOptionsPanel.Uk("-5360un", app, image);
                PdfViewerOptionsPanel.Uk("-1u1q0uq", app);
            }
        }
    }

    private void drawDateArea(DOMElement parent) {
        char[] cArray = "\u5c11\u8bf8\u4a9a\uea8f\u74f6\uc0f6\ufb21\u4c57\uc754\u1b67\u13e7\uebb7\u98b4\u2177\u62de\u0730\ucb2b\ue605\u862d\ued22\uf1f7\ubdd4\u9f4d\ufba0\u1234\u660b\ua534\u716e\u2534\u6de6\uec06\u143d\u751f\u07d7\uea61\ue55b\u07ad\ua1b4\u809f\uf2ff\ud347\u7cab\uad5d1\u4fe5\u4b9d\ud3b6\u6e14\u580d\ua7ae\u1350\u2556\uf503\u203f\u5612\u71a1\ub57d\u034d\u5f0c".toCharArray();
        cArray[40] = (char)(cArray[40] ^ 0x39D1);
        Paragraph dateTitle = new Paragraph(qrbdtsxk.y(cArray, (short)2224, (byte)3, (byte)2), parent, this.view, () -> {
            char[] cArray = "\u18c3\uc7da\ubc1c\u309b\ub5d2\u6acd\uee4d\ud13f\ua15b\u903e\u9c5c\ufb96\ubb32\ud831\ub4ae\uaa82\u0789\uef7c\uc183\ud09b\ub271\u02ed\u93a7\u866b\u40f7\ubed0\ueb6a\uc54f\u6ea2\u4b1d\ua937\udbc2\u6a44".toCharArray();
            cArray[31] = (char)(cArray[31] ^ 0x7A95);
            return PdfViewerOptionsPanel.Uk("5hv35", i18n, rjvtsclo.j(cArray, (short)25831, 5, 4), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u2e46\u42ed\u453d\uf282\u6694\u118f\u80cb\ue1c5\u3734\u4132\u1932\u62c6\uffd1\uef8c\u9377\uc723\u1f43\udc9c\u7747\u3d7a\u6c2e\u9f6f\u16cd\uc2ae\u1830\uf26d\u1897\u75df\u7576\ub795\u0eee\u985a\u85ff\u0aeb\ubfe5\ud128\ub28d\u7ba0\ub5ed\u3af5\u503b\ufcab\u087a\udef4\u6ee3\uc074\u8d94\u6365\ufcbb\u1c5f\ua54d\u7eb6\u3ae5\u0b8b\u2743".toCharArray();
        cArray2[34] = (char)(cArray2[34] ^ 0x3D01);
        PdfViewerOptionsPanel.Uk("1kqjuvo", dateTitle, qrbdtsxk.y(cArray2, (short)16572, (byte)5, (byte)3));
        char[] cArray3 = "\uc6af\ua32d\ue15a\u9b75\u12d4\u3954\ub18b\ua098\u6f2f\u2502\u41a7\u4789\u24f8\ubc5a\u652f\udc0e\u0faf\uf8dd\u1e42\u15ee\u47d3\u8881\uea3c\u9f2b\ubd92\ua697\udb49\udd0a\u8c4b\ud1ad\u6409\u0a70\u44d1\uf9e4\u2a2d\ufd26\u4192\u4411\ub106\u5555\ud244\u8bf6\ufcb7\u6d68\u627f\u9ebf\u6c1b\ue3f4\u9b9c\ud38f\ua55b\u8646\u9ed8\uf56b\ua5cc\u7b99\u537e\uc2ad\u5c03\ue641\u377b".toCharArray();
        cArray3[57] = (char)(cArray3[57] ^ 0x3615);
        DivContainer dateDivisor = new DivContainer(qrbdtsxk.y(cArray3, (short)25732, (byte)0, (byte)2), parent, this.view);
        char[] cArray4 = "\u50c4\ufb94\u4a24\u9470\u7698\u8ff6\uebd5\u3a18\u0583\u09f9\ub4b0\ud910\ue52c\u09b6\ua8b2\ufdcc\uf45b\u4bcb\ubcb0\uda9d\u461b\u4257\u77ba\u07d5\u61b4\uf3a8\ua6df\u6c8e\uf2b2\ue2c0\ufb5f\ucc0f\ub339\u9209\u03e9\uf054\u0a60\u5b7b\u4041\uddf6\u3fa6\ud0d3\u6a39\u6944\ufe30\u4518\u39e1\u896f\ub257\uf60f\u5d26\ubee8\ue633\u85a4\uad2f\u2137\u6306".toCharArray();
        cArray4[24] = (char)(cArray4[24] ^ 0x2DE4);
        PdfViewerOptionsPanel.Uk("-51u0td", dateDivisor, qrbdtsxk.y(cArray4, (short)29598, (byte)2, (byte)5));
        char[] cArray5 = "\u3b5e\ud9a2\u4241\u68cc\ubdcd\u69f8\u3f70\ub6e2\u0f5d\ud1ef\udb78\u5d7c\ub051\u1a93\u23e2\uc395\ub15c\u99d2\u14e8\u70c5\u22cd\uc8c7\u9da8\u8690\ucd0c\u29a1\u7aca\u32fe\u3917\uaf02\u704e\uc0fd\u4f49\u281c\ua0af\uafaa\u475a\uea5e\u09c0\u4460\u0368\u9597\u0ac7\u72fc\u95ec\u3cc1\uf8f8\uf9e5\ua131\uadf7\ua4e5\ua7b7\u1e8d\u3535\ub9cf\uabf2\u73b0".toCharArray();
        cArray5[1] = (char)(cArray5[1] ^ 0x7EB5);
        char[] cArray6 = "\u693a\u2adf\uff6a\ubce5\u87ef\u2202\u6f8a\uec0f\u626d\udf62\ua85f\u234c\u4cae\u7dbd\uc709\u2415\u4ae1\u2bbb\u62a9\ub9b5\u4f57\u8d16\u23bb\u4b97\uf718\u2bf0\u6ce1\u4460\ude6d\ufd0b\u5d7f\u55e6".toCharArray();
        cArray6[8] = (char)(cArray6[8] ^ 0x1AA2);
        char[] cArray7 = "\ub2ea\uf1b1\u00c3\ucdc2\u0a08\u8d71\u7888\u1bb5\u85a0\uf14a\u796f\u5a80".toCharArray();
        cArray7[1] = (char)(cArray7[1] ^ 0x67DC);
        this.dateYesRB = new CGRadioButton(qrbdtsxk.y(cArray5, (short)9842, (byte)2, (byte)4), parent, this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, qrbdtsxk.y(cArray6, (short)5077, (byte)5, (byte)5), (Object[])new Object[0]), qrbdtsxk.y(cArray7, (short)28673, (byte)3, (byte)2));
        char[] cArray8 = "\u2603\u3a22\u783d\u38b6\u3c9f\u5b45\u0528\u9d43\u22d4\u8aa1\u65f0\ue4e5\uc327\ucab4\uc7bc\u6b5b\u3977\uf2f7\u00bb\u1d47\uae56\u457e\uf86d\ue82d\u8fd2\ua018\ud2af\u779d\u8fe5\u7c01\u19ac\u5317\u0e44\u8395\ufad3\u299e\u3223\ubc20\u1807\u875d\u5f06\ue95d\ue0a4\u3e5e\u8d40\u8a75\u12db\u07a0\u41ba\u616b\u8edc\uf13a\u6da0\uf694\u2fc4\u00c6".toCharArray();
        cArray8[30] = (char)(cArray8[30] ^ 0x4E4A);
        char[] cArray9 = "\ub4fd\u240b\u4fb5\u2e8d\u3258\u0729\ubf43\ucf88\ue8dd\u0934\u23ef\ua641\ub73d\ua9fe\u9e45\ub6b4\u9014\ufd3e\u0b21\ud5b4\u31eb\ucd4e\uf989\ucc62\u7621\u05a5\u7c8e\u3630\u0838\u8e9e\u66be".toCharArray();
        cArray9[22] = (char)(cArray9[22] ^ 0x74AA);
        char[] cArray10 = "\u9088\u5393\ua6eb\uff2d\u1845\u1d7f\u6bba\u325e\u7dbb\udb0c\u7c8f\u4317".toCharArray();
        cArray10[7] = (char)(cArray10[7] ^ 0x538B);
        this.dateNoRB = new CGRadioButton(qrbdtsxk.y(cArray8, (short)28959, (byte)3, (byte)3), parent, this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, qrbdtsxk.y(cArray9, (short)3516, (byte)2, (byte)5), (Object[])new Object[0]), qrbdtsxk.y(cArray10, (short)27892, (byte)2, (byte)4));
        char[] cArray11 = "\u25c7\ue4a9\u3460\u3075\u5835\ubaf8\uf63a\uac4b\u0a14\u4466\ud647\ue21c\uff5a\uc571\u20ee\ud19c\u09e6\u69c4\ud234\ua9b5\u3b41\u2025\u63af\ua558\ubc74\uee59\u2fad\uc49b\u12fd\u1765\ua990\u1b90\uff72\u24a4\u0690\ud194\u7beb\u1a16\u6f29\u3b55\u6660\u3bde\u110b\u844a\ue382\u0c48\u519a\uf172\u79d1\uad09\u1d06\ubd2b\u520c\u800e\u1a5e\ub6c8\u06aa\ua4ae\u6122\ub5b9\u71fd".toCharArray();
        cArray11[26] = (char)(cArray11[26] ^ 0x199);
        PdfViewerOptionsPanel.Uk("1dg7v0i", this.dateYesRB, qrbdtsxk.y(cArray11, (short)1243, (byte)1, (byte)0));
        char[] cArray12 = "\u4326\ue1bc\u8c2c\u3177\u4775\uccba\u7086\u4104\u9cc4\uc282\ub26e\u4c10\ud7fb\u237f\u7f6a\u596c\ue349\uf5ad\uc1c4\uce7f\u40b0\u5966\u07e7\u9f20\u2d04\u5dbb\u460e\uc979\ue863\udaac\uc58c\u8bbd\u3097\ud08a\u4d7a\u1394\u7dd1\u9dee\uf698\udba4\u01ee\u9e42\u45c4\uff87\ubfb5\u9166\uc0d6\uc8bb\ud021\u3e66\u3707\u0e15\u8280\u52a2\ud2c8\u5531\u52c7\u976d\u0aaf\u3b5b\u4450".toCharArray();
        cArray12[10] = (char)(cArray12[10] ^ 0x5EAC);
        PdfViewerOptionsPanel.Uk("1dg7v0i", this.dateNoRB, qrbdtsxk.y(cArray12, (short)9012, (byte)2, (byte)3));
        PdfViewerOptionsPanel.Uk("6e9v0m", this.dateYesRB, () -> {
            if (PdfViewerOptionsPanel.Uk("5rnuug", this.dateYesRB) != false) {
                this.updateAllDates(true);
            }
        });
        PdfViewerOptionsPanel.Uk("6e9v0m", this.dateNoRB, () -> {
            if (PdfViewerOptionsPanel.Uk("5rnuug", this.dateNoRB) != false) {
                this.updateAllDates(false);
            }
        });
        char[] cArray13 = "\uf28d\uc245\uda84\uf3d9\u4e87".toCharArray();
        cArray13[0] = (char)(cArray13[0] ^ 0x4807);
        char[] cArray14 = "\u357c\u0c29\u096c\ucbc0\u67bb".toCharArray();
        cArray14[3] = (char)(cArray14[3] ^ 0x6A84);
        if (PdfViewerOptionsPanel.Uk("2q1v0r", qrbdtsxk.y(cArray13, (short)6799, (byte)3, (byte)4), PdfViewerOptionsPanel.Uk("-15fg0v4", PdfViewerOptionsPanel.Uk("1d6tv0n"), UserProperties.GRAPHICSIGNATURE_DATE, (Object)qrbdtsxk.y(cArray14, (short)23310, (byte)0, (byte)0))) == false) {
            PdfViewerOptionsPanel.Uk("-15j20ug", this.dateNoRB, false);
            this.updateAllDates(false);
        } else {
            PdfViewerOptionsPanel.Uk("-15j20ug", this.dateYesRB, false);
            this.updateAllDates(true);
        }
    }

    private void updateAllDates(boolean showDate) {
        PdfViewerOptionsPanel.Uk("ojvv1b", this.appearanceBuilder, showDate);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Uk("-thg0up", PdfViewerOptionsPanel.Uk("h1fv12", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Uk("ivhuu0", app, showDate);
                PdfViewerOptionsPanel.Uk("-1u1q0uq", app);
            }
        }
    }

    private void drawLocationArea(DOMElement parent) {
        char[] cArray = "\ub6c5\ue000\u8e93\u0cc2\ue090\u4ad1\u4321\u0852\ua0b1\ude0e\u094c\u709e\u1c05\uf5d9\u875b\u7dfa\u12f8\ub9a8\ud629\ube57\u09dd\u8c00\u90d2\uc6cb\ud073\u1527\u45b8\u24cf\u2dc6\u9141\u4c1e\u562a\ue3eb\ucab3\u61c4\ue53c\ufd4d\u39ed\ua1a0\uaee6\u8d8c\uc694\uc2af\u83f8\u3983\u0c58\ue20a\u1742\u2798\u2863\u8024\uc169\u3a3d\uad39\u7901\u9e43\udcbf\u5788\u71c2\u27eb\uc1a7\u7ecf\u5d86".toCharArray();
        cArray[13] = (char)(cArray[13] ^ 0x56F0);
        Paragraph locationTitle = new Paragraph(vhhpyrok.N(cArray, (short)14916, 0, 4), parent, this.view, () -> {
            char[] cArray = "\u1ab5\ub804\u937d\u69b1\u439f\u2773\ub265\ua6e3\u4608\u5d5a\u7188\u1ba3\udaf4\u480a\uf185_\u28ad\u8f59\u4f22\uf6ed\u401d\ufe42\u78f6\ue83e\u2336\ud87e\u95d9\ue83b\u9a46\ufbf9\uc922\uba72\u42bd\u20c4\ua7c2\u63df\u7e40".toCharArray();
            cArray[11] = (char)(cArray[11] ^ 0x747A);
            return PdfViewerOptionsPanel.Uk("5hv35", i18n, qrbdtsxk.y(cArray, (short)876, (byte)1, (byte)2), (Object[])new Object[0]);
        });
        char[] cArray2 = "\ua24e\u51e4\u6e77\u2996\u6a56\u266a\uec97\ub169\u8e17\u8fd3\u44ed\u7536\u3cde\u0d1c\ua23c\ua65d\u3cc0\ud31b\udf76\u77b2\u3004\u824c\u6f29\u39d5\u2126\u652b\ue287\u21ac\ua592\u086c\u2980\u5cb0\u02f0\u454d\u5d01\u2866\ue0f3\u4fae\u0c39\u653e\uf684\u2495\u0f61\u7d32\u3e28\u4564\u973c\u7a2e\uc589\ua9ed\u5e29\u6e82\u818e\u8fde\u5f91".toCharArray();
        cArray2[6] = (char)(cArray2[6] ^ 0x31B9);
        PdfViewerOptionsPanel.Uk("1kqjuvo", locationTitle, vhhpyrok.N(cArray2, (short)17757, 4, 5));
        char[] cArray3 = "\u68fc\u463a\u6ddc\u5f9e\u1574\u2ec6\ua118\uba4a\ube9c\u4334\uc46c\ufc43\uaf36\u71c7\u66fe\u2b30\uc861\u1e7e\ue19a\uff30\ub22b\u416d\u2551\ud821\ub698\u4d89\u149f\u3b7c\u5f4a\u4188\ua16f\u4ae5\u3a4b\ufcaa\u3140\ue284\uf858\ua296\u402b\uc8ff\u60b1\u714b\ua8e4\u0cb5\ucf73\u5d3d\u7538\u837c\u1236\u96fc\u336f\ud597\u6c38\u3204\u7871\ucaaa\u1e60\u8d67\u76e1\u4b30\u8177\ud354\u6277\u861d\u24f5".toCharArray();
        cArray3[6] = (char)(cArray3[6] ^ 0x7337);
        DivContainer locationDivisor = new DivContainer(vhhpyrok.N(cArray3, (short)29833, 3, 2), parent, this.view);
        char[] cArray4 = "\ub77c\u78a8\ue7d3\uc851\u3925\ub12e\u6ec0\u09f7\uc4ad\u5cc9\u8159\udbc8\u96cd\ud91b\u68fd\u8fd7\u8f13\u793f\u13e7\u49ca\u5a64\ud67e\ub816\u1fc1\u112a\u1fc3\u73f8\u6232\u6ad0\u19d9\u203d\uc3cd\ue1f9\u5fff\ucad9\ua5e8\u8905\u586a\ub463\uf37d\u6a8b\ua470\uda23\u87bf\u0019\u2baa\u545d\u6271\u37c1\uab81\uc1a2\u0e1d\ub443\u8734\uba8c\uc721\u5d5c".toCharArray();
        cArray4[31] = (char)(cArray4[31] ^ 0x6514);
        PdfViewerOptionsPanel.Uk("-51u0td", locationDivisor, vhhpyrok.N(cArray4, (short)1028, 3, 2));
        char[] cArray5 = "\u3a91\u546b\u7c00\u5b70\ub530\u3fa3\u57c3\u7a6e\u23e6\u7f7c\u5a87\ua7da\u3bb6\u99d2\ue9b1\u828a\uebd5\u1ee9\ua61a\u2aec\uc71d\ua68e\u4a3f\u6b67\ufe33\u05d8\u5a05\u5d47\u31f6\u7a4a\u71fd\u99ba\u7007\ufc0d\u5b7f\u146c\u92b2\ue23c\u97fb\u410c\u4da2\u6fdc\u32de\u1190\ud093\u37f4\u19f9\u0ee4\u61a2\u387e\u9937\u7d33\u4e7a\u1eca\uff27\u1471\u3abc\ue9c9\u3db1\u5cdd\u06c8".toCharArray();
        cArray5[23] = (char)(cArray5[23] ^ 0x7BC9);
        char[] cArray6 = "\u270e\u7f29\u6026\ue1a0\u4ea2\ua57e\u237b\u1021\u1cd7\ud206\u0730\ufcfa\uc18f\ub33b\ub4d3\u317e\uf7ed\u897a\u138a\u458a\u12d0\u7ab4\u1b03\u1df6\u2678\uc877\u40b2\ua26f\u55c9\u1dcf\u7962\u650a".toCharArray();
        cArray6[24] = (char)(cArray6[24] ^ 0x12F8);
        char[] cArray7 = "\uedd0\u068f\ue00d\u07ff\u3468\u23f2\ubc5b\u678d\u5000\u4234\ua86a\u212f\u16bc\ufcce\ud017\u0a8c".toCharArray();
        cArray7[8] = (char)(cArray7[8] ^ 0x5EFF);
        this.locationYesRB = new CGRadioButton(vhhpyrok.N(cArray5, (short)25129, 2, 3), parent, this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, vhhpyrok.N(cArray6, (short)26064, 1, 5), (Object[])new Object[0]), vhhpyrok.N(cArray7, (short)30998, 2, 3));
        char[] cArray8 = "\u6473\u3855\u6f9b\ub7b9\ub716\u52eb\udeee\u14d6\u5b72\uf9ca\ubcbe\u2d5b\u962f\ue37f\u2bac\u781f\u6429\u5ad1\u80b9\u061c\ud235\u0778\uad57\ucc60\uc875\u4df8\u1a52\u399c\u5f76\u18b6\u36fc\u8ba6\ufa7d\u3a79\u6d3e\u1734\u93b1\uc46c\u0917\u44ec\u688f\u6e6a\u884a\u0b50\u86cc\u30fb\u3fb6\uedf5\u2cbb\u7097\u3ce1\u8720\uea8d\u6c2f\u16a3\u918a\u82ea\ue133\ud255\u01ec".toCharArray();
        cArray8[47] = (char)(cArray8[47] ^ 0x19FD);
        char[] cArray9 = "\u8c36\u117f\u0c52\u314b\u2374\u0650\u829e\u503c\u8740\u86a3\ud881\u1d16\uffaa\u1176\u64b3\u8f6c\u47f5\ua06f\ue754\ue740\udf9c\ubbd6\udd3d\ue553\ud8dc\u90b2\u78d2\u5ece\u99a4\u13c8\u59b3".toCharArray();
        cArray9[9] = (char)(cArray9[9] ^ 0x5E6A);
        char[] cArray10 = "\u9b78\u306d\uf8e2\ua6b1\u6cac\u9cde\u3353\ubcc9\uf163\u3d65\u9474\u5c73\u0481\u4f28\ua494\u4317".toCharArray();
        cArray10[10] = (char)(cArray10[10] ^ 0x1D5);
        this.locationNoRB = new CGRadioButton(vhhpyrok.N(cArray8, (short)29867, 3, 5), parent, this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, vhhpyrok.N(cArray9, (short)23590, 3, 2), (Object[])new Object[0]), vhhpyrok.N(cArray10, (short)1713, 4, 4));
        char[] cArray11 = "\ubeab\u2791\u7544\u51d1\u899d\ucb8f\u0093\u184a\u58e4\u7a7d\u8786\u7973\u1c45\u64b1\u97a6\uc66a\u2689\ubf6d\uce27\ucc5a\uf005\u84fe\u652b\u0248\u0225\u0b56\uae51\uf6f7\u3da5\u2c11\ubf66\u9fab\u01fd\u2d85\u5ef5\ud9c5\u910a\ua2d8\u3afb\u12c1\uf893\ub162\u2049\ub56d\u423f\u7d8f\u78e5\u445f\u33f2\u1217\u21d5\uae9e\uaa88\u91d0\ud5b2\u81ca\u7fa9\uc9b4\uee02\u4abb\u5c40".toCharArray();
        cArray11[56] = (char)(cArray11[56] ^ 0x1A52);
        PdfViewerOptionsPanel.Uk("1dg7v0i", this.locationYesRB, vhhpyrok.N(cArray11, (short)32467, 3, 2));
        char[] cArray12 = "\uf913\u4383\uf66c\u759d\u139b\u0496\ua5df\u5296\ub67c\u72cb\u74f1\u8976\uf10c\ud0bd\u31aa\u28ad\u552e\u0f51\u8997\u205f\u728f\ude7b\u6442\ub9b7\ud958\ua043\uc090\ue22c\uffc4\u03bf\u4c0b\uecce\u0413\u95c4\ud1ba\ufa1f\u07f2\uba0d\ua3c8\uce1b\ufcde\uc599\u8631\u3125\ue8e1\u4ba8\uc8a4\ub0ac\ub45f\ud6f7\uc8bb\u17fc\u2a71\u79d0\u00e3\u3089\ucf59\uf138\u50f5\u4bad\u6444".toCharArray();
        cArray12[8] = (char)(cArray12[8] ^ 0x754A);
        PdfViewerOptionsPanel.Uk("1dg7v0i", this.locationNoRB, vhhpyrok.N(cArray12, (short)29775, 3, 4));
        char[] cArray13 = "\u1510\ufff7\u4b9f\u4291\u5384\ud703\u470e\u013c\u1b2e\ua319\u986d\u45dc\u74b0\u0d6a\uc424\u0655\u415e\u217e\uc96c\ue71f\u0559\u7b6b\ue606\u8285\ue6bb\uf0f8\ua611\u459f\ua4ed\u8e0a\u9f15\uadfd\u2143\u0d15\u205f\u315a\u6756\u81ee\ud679\u42d0\ua8e2\uc1b9\u98f4\u98d7\u43b9\u3372\uda59\ud79c\ufdc8\u9476\uf06d\u185a\u5d0b\u8d5c\ud704\ueee2\u901a\u30c5\ua670\u40ef\u7de5\u19cc\ua47a\u3815\u78e2".toCharArray();
        cArray13[21] = (char)(cArray13[21] ^ 0x7A86);
        this.locationTextBox = new TextInput(vhhpyrok.N(cArray13, (short)11134, 0, 0), parent, this.view);
        char[] cArray14 = "\udde9\u1d87\ucc57\u6134\u28e0\u4d3b\u1fe9\ud225\u1eb9\u0626\u3b05\u5e4f\u94e0\u33f6\u5986\u59fb".toCharArray();
        cArray14[2] = (char)(cArray14[2] ^ 0x2AF0);
        PdfViewerOptionsPanel.Uk("r3tutt", this.locationTextBox, vhhpyrok.N(cArray14, (short)8961, 2, 0));
        char[] cArray15 = "\uc094\uea2b\u755e\ucd03\ue4a5\u7282\u42f6\udc1d\ub035\u1c7d\ub73c\u48e3\u551f".toCharArray();
        cArray15[6] = (char)(cArray15[6] ^ 0x5310);
        PdfViewerOptionsPanel.Uk("r3tutt", this.locationTextBox, vhhpyrok.N(cArray15, (short)27802, 4, 5));
        PdfViewerOptionsPanel.Uk("-j8q126", this.locationTextBox, obj -> this.updateAllLocations());
        PdfViewerOptionsPanel.Uk("6e9v0m", this.locationYesRB, () -> {
            if (PdfViewerOptionsPanel.Uk("5rnuug", this.locationYesRB) != false) {
                PdfViewerOptionsPanel.Uk("-cqs121", this.locationTextBox, true);
            }
        });
        PdfViewerOptionsPanel.Uk("6e9v0m", this.locationNoRB, () -> {
            if (PdfViewerOptionsPanel.Uk("5rnuug", this.locationNoRB) != false) {
                PdfViewerOptionsPanel.Uk("-cqs121", this.locationTextBox, false);
                PdfViewerOptionsPanel.Uk("-1otm0us", this.locationTextBox, "");
                PdfViewerOptionsPanel.Uk("-1n960uv", this.appearanceBuilder, "");
            }
        });
        char[] cArray16 = "\u1f7d\u5e6b\ucfb8\u3bd8\ubf8c\u6dd3".toCharArray();
        cArray16[2] = (char)(cArray16[2] ^ 0x2D99);
        char[] cArray17 = "\u01c8\u2ba0\u03b0\u4e11\u1073".toCharArray();
        cArray17[3] = (char)(cArray17[3] ^ 0x5F4A);
        if (PdfViewerOptionsPanel.Uk("2q1v0r", vhhpyrok.N(cArray16, (short)14886, 3, 0), PdfViewerOptionsPanel.Uk("-15fg0v4", PdfViewerOptionsPanel.Uk("1d6tv0n"), UserProperties.GRAPHICSIGNATURE_LOCALITA, (Object)vhhpyrok.N(cArray17, (short)30503, 5, 5))) == false) {
            PdfViewerOptionsPanel.Uk("-15j20ug", this.locationYesRB, false);
            PdfViewerOptionsPanel.Uk("-cqs121", this.locationTextBox, true);
        } else {
            PdfViewerOptionsPanel.Uk("-15j20ug", this.locationNoRB, false);
            PdfViewerOptionsPanel.Uk("-cqs121", this.locationTextBox, false);
            PdfViewerOptionsPanel.Uk("-1otm0us", this.locationTextBox, "");
            PdfViewerOptionsPanel.Uk("-1n960uv", this.appearanceBuilder, "");
        }
    }

    private void updateAllLocations() {
        Object location = PdfViewerOptionsPanel.Uk("-8si122", this.locationTextBox);
        PdfViewerOptionsPanel.Uk("-1n960uv", this.appearanceBuilder, location);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Uk("-thg0up", PdfViewerOptionsPanel.Uk("h1fv12", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Uk("-15nq0ut", app, location);
            }
        }
    }

    private void drawReasonArea(DOMElement parent) {
        char[] cArray = "\u3b34\u20f6\u2e5d\u09b4\ufa5c\uaeff\u8b43\ub0d2\u4af9\u2a44\uf8ba\u278f\ube12\u8116\ud770\u271b\uba8e\uc62e\u709d\u2121\ue473\udeb6\u41d1\ub8de\u437d\u1ea5\u9d5d\udf24\u4e6c\ub908\u1ee1\u6007\u2060\u95cb\u83af\uf678\u1405\u77c5\ue487\uddb2\uf90c\u1d91\u7c89\u3770\u18c4\u13e9\u68d7\u3952\u2079\ubab5\u8be0\u039e\u44ca\uf627\u98d1\ub33f\u2443\u95a2\u4151\u8795\u42aa".toCharArray();
        cArray[45] = (char)(cArray[45] ^ 0x6369);
        Paragraph reasonTitle = new Paragraph(rjvtsclo.j(cArray, (short)3785, 0, 1), parent, this.view, () -> {
            char[] cArray = "\u99f0\u3b2d\ub671\u343f\u130e\u2c4e\u5de1\u2a48\u7bc1\uc911\u7b1b\uba6a\u86b9\ufe0a\ua443\ud7ef\u769d\u4c9f\ufa4b\u3c46\u486f\u2082\u51a1\u58cd\uaa01\ucf8e\uae43\u09af\u6172\u8f8d\u2e0e\ud62a\u54c5\ud853\u416d".toCharArray();
            cArray[8] = (char)(cArray[8] ^ 0x169E);
            return PdfViewerOptionsPanel.Uk("5hv35", i18n, vhhpyrok.N(cArray, (short)32545, 1, 1), (Object[])new Object[0]);
        });
        char[] cArray2 = "\ub36d\u7074\u7275\u3853\uf812\u4657\u97e2\uc028\ua3bc\u2c29\u4fd6\u25d7\u683f\uab3f\u05e7\ue09e\ub6e8\u6d06\u8409\uee62\uae90\u1fc0\u427e\ufac7\ubd85\u2453\u4bbf\u014b\udd7d\uce0a\u889f\u5b64\u1394\u36f5\u4316\u2ffe\u8255\u80d7\ub118\u869d\u73df\ud8f6\u7d98\u7ea1\u24fd\u2820\u5069\u4c11\uccd9\u65b3\uc09a\u4ab3\ud8d3\ub7a6\u05bc".toCharArray();
        cArray2[25] = (char)(cArray2[25] ^ 0xB9C);
        PdfViewerOptionsPanel.Uk("1kqjuvo", reasonTitle, rjvtsclo.j(cArray2, (short)5450, 5, 3));
        char[] cArray3 = "\u7c22\u18fd\ua4f6\u79a9\u0cdd\u87e4\u412f\u313f\u2230\u35bb\ucd74\uc2be\ua360\u9ac9\u0395\u9908\u40ef\u3b79\ue022\u2744\ua25b\ua5be\u99f0\ua8af\u3b29\ufd14\u56d3\u8a69\u8727\u1a42\uc149\uf975\uf10e\uff09\ue48f\u6e8c\u89be\u73b0\u7c75\uc771\uefd1\u449f\uecfd\u1d25\uf21c\u22b5\u9cf2\u6ec3\u8e5b\u838e\u2998\u0812\uadcd\u1fb0\ue980\u7313\ud624\u163f\u4bc0\ua46c\u05b5\u81c8\u2c11".toCharArray();
        cArray3[31] = (char)(cArray3[31] ^ 0x34D);
        DivContainer reasonDivisor = new DivContainer(rjvtsclo.j(cArray3, (short)10944, 2, 0), parent, this.view);
        char[] cArray4 = "\u19bf\u17f3\u2158\u99f7\ub46c\ud214\u58ac\uad11\ucf01\u62ac\u16bf\ud748\u2d64\u4677\ubd31\u48bd\u9569\u2830\u0dff\u08db\u7426\ubd9f\u7285\u73bc\u62f3\uf7e5\ue452\uc0a7\ue5d7\ue187\u2d96\u3e4d\ufea6\uac49\u7717\ub56d\uedd2\ue443\u9319\uad25\u5544\ub41f\u4812\u2166\u51ac\u3353\u8d81\u6fee\u981e\ufc47\ua59e\ueb85\u0e09\u9cf3\u7495\uca20\u75b3".toCharArray();
        cArray4[55] = (char)(cArray4[55] ^ 0x6DD4);
        PdfViewerOptionsPanel.Uk("-51u0td", reasonDivisor, rjvtsclo.j(cArray4, (short)11761, 1, 0));
        char[] cArray5 = "\u06ad\u34e6\u3069\uc834\ud043\ub3ed\u7938\uf2db\udf5d\ubfa0\u587e\ud40d\u0c23\u0e05\u2fcc\ub3f4\u86bc\u5ee1\ubd7d\uaca7\uf865\ud4b8\u12d8\uef9c\u8d05\ue5af\uc09a\u82a3\u80e8\uf60a\u469c\u8256\uf447\u717d\u8c4c\u18a9\uf1ce\ub04c\udfbc\u7261\u0c64\ufa13\u40db\ubdc1\u85f9\ud646\u0f48\u2c35\ud6bc\ub92e\u101c\u1606\u3644\u0e51\u88a5\u8c59\u989c\ua013\u27a4".toCharArray();
        cArray5[12] = (char)(cArray5[12] ^ 0x6F2C);
        char[] cArray6 = "\ude21\u9684\u8daeV\u8934\ud260\u9c52\u0bef\u925b\u2caa\u2bdc\uf347\u701a\ued7b\ud70f\u9123\uaa0e\ud2cf\uf4f4\ue030\u660c\u65a7\u23e8\u3ca6\ub079\u9c64\u641c\u0d01\u4d4d\ucdab\u9bfd\u6553".toCharArray();
        cArray6[11] = (char)(cArray6[11] ^ 0x786C);
        char[] cArray7 = "\ufa40\u07e7\ue453\u60ec\u4649\ue269\ud9da\u7d29\u6d0a\uc757\u6e20\u17fd\u6a79\u6fb5".toCharArray();
        cArray7[10] = (char)(cArray7[10] ^ 0x5232);
        this.reasonYesRB = new CGRadioButton(rjvtsclo.j(cArray5, (short)4499, 4, 3), parent, this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, rjvtsclo.j(cArray6, (short)17898, 2, 1), (Object[])new Object[0]), rjvtsclo.j(cArray7, (short)15674, 0, 3));
        char[] cArray8 = "\ua0f0\uca01\ud50f\ue54b\u38a9\u5be8\u9bc8\ubb80\u07c0\u659a\uc9d7\u0d31\uf5a3\u73b8\u2cd3\uf134\u3be8\u145d\u6a75\u9571\u09a4\u00a3\ub393\u84b0\u7635\u6848\ub842\ucffc\uf7f9\u492e\u307b\u418b\ue4a5\u124a\ucf87\u0935\u9e46\u0f6e\u817a\u7d0c\uaac7\uaae1\u2c44\uac4b\u2916\uee20\ud015\u00bd\u11d2\ud8d2\ucd0e\u81f4\u3fed\u68b4\u726b\u5257\u9222\u308f\u502f".toCharArray();
        cArray8[21] = (char)(cArray8[21] ^ 0x5B3B);
        char[] cArray9 = "\uba8d\ubf30\u5bff\u2aaa\uee59\ue1af\u1c56\u0be4\u74d4\uc353\u9eeb\u0264\ucb77\ub2e4\u49c1\u490f\u094d\ua6af\u2c3b\ueb9f\u1af0\u71ac\u5e3b\u9d4c\u9ed9\u8e41\ub778\u2e54\uceef\u8dcf\u2958".toCharArray();
        cArray9[20] = (char)(cArray9[20] ^ 0x7267);
        char[] cArray10 = "\ub841\ub7bb\ud1b3\ub71c\u6448\ucb46\u8a33\udb1f\u935e\u9c49\uad73\u6bfd\uc5b9\u2ff2".toCharArray();
        cArray10[7] = (char)(cArray10[7] ^ 0x7DA5);
        this.reasonNoRB = new CGRadioButton(rjvtsclo.j(cArray8, (short)509, 2, 1), parent, this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, rjvtsclo.j(cArray9, (short)17987, 4, 1), (Object[])new Object[0]), rjvtsclo.j(cArray10, (short)16564, 3, 4));
        char[] cArray11 = "\ub140\u9dfe\u84e1\u121f\u6cdb\ufe2b\ua191\u8c19\uab39\ucbd9\u1365\u25be\u28a8\u8d3f\u8cdf\u574d\u017f\ue296\u1d72\ud6a8\u1a35\u17d7\u0244\u92c2\u575c\ue6f6\u01bd\u323e\ud7b1\u78dd\u7127\u4df4\uc70c\u949e\u7388\u8885\u10fa\u378b\u24dc\u2008\ucc5b\u290f\u13b8\u324d\u5be8\u0732\u0767\u9674\uf18b\ud892\ufef4\u70b4\u563e\uc272\ua798\u3056\u1fef\u26bb\u9467\ue9c6\u1d50".toCharArray();
        cArray11[24] = (char)(cArray11[24] ^ 0x12DC);
        PdfViewerOptionsPanel.Uk("1dg7v0i", this.reasonYesRB, rjvtsclo.j(cArray11, (short)9578, 0, 1));
        char[] cArray12 = "\u2184\u9543\u9af3\udf2b\u72e4\u0151\u762a\u2de5\u2a0f\ufbd7\u7c4d\u773c\ud276\uce79\uf541\uee6f\udec2\u9c6a\u1a7b\u877b\u1b93\ub57d\ub701\u629d\ud2d8\u57ef\u42c4\u4715\ub999\ud98b\u1584\ue1fb\u906d\ue7d2\u8c66\ub976\u3cc1\u6923\u6528\ud5e9\ubbbd\u476e\u5d43\u9789\u0633\ueee7\uee44\uc912\u1910\ub3f3\u54f0\u87dd\u34d7\u9c10\ub788\u52ed\ua65d\ue832\ufda4\u4256\u6839".toCharArray();
        cArray12[27] = (char)(cArray12[27] ^ 0x4803);
        PdfViewerOptionsPanel.Uk("1dg7v0i", this.reasonNoRB, rjvtsclo.j(cArray12, (short)29112, 4, 2));
        char[] cArray13 = "\u15c0\u2c3f\ucf1e\udc3e\u60a7\ued9b\uff79\ue665\uf5ac\ue20a\ua6b8\u3a19\ue903\u64da\u492c\u5586\u97a8\u33ac\u5cd1\ucf5f\u3a7e\u7f11\u5fd7\u933e\u3abd\u72f5\u9b88\uf1ee\uc370\u883a\u70a3\u8358\u16e0\u5dd8\u3b59\u7d75\ubc77\u90ee\ua38b\ud863\uaa9f\u55b9\ucbf7\ud476\ude1f\u7740\u6ee3\u8fb7\u7fa0\uf3f9\uf5e4\u7421\u2b92\u34b3\u6e1f\u350b\udb97\u2177\u0f7a\ucb3b\ua03a\u60d5\u5239".toCharArray();
        cArray13[49] = (char)(cArray13[49] ^ 0x3485);
        this.reasonTextBox = new TextInput(rjvtsclo.j(cArray13, (short)10033, 1, 2), parent, this.view);
        char[] cArray14 = "\u2714\u208d\u79a4\ucccb\u044e\u6130\u855e\u6889\uf0ff\u98ee\uf803\u0a7d\ua315\u0eed\u6fa6\u60d0".toCharArray();
        cArray14[1] = (char)(cArray14[1] ^ 0x48C0);
        PdfViewerOptionsPanel.Uk("r3tutt", this.reasonTextBox, rjvtsclo.j(cArray14, (short)3575, 2, 3));
        char[] cArray15 = "\u0d7f\u0648\ub63a\u18cb\u766a\ub7e3\u0f0b\u1977\u45e7\ud5eb\u9567\u8b5c\u417d".toCharArray();
        cArray15[10] = (char)(cArray15[10] ^ 0x494F);
        PdfViewerOptionsPanel.Uk("r3tutt", this.reasonTextBox, rjvtsclo.j(cArray15, (short)15434, 4, 2));
        PdfViewerOptionsPanel.Uk("-j8q126", this.reasonTextBox, obj -> this.updateAllReasons());
        PdfViewerOptionsPanel.Uk("6e9v0m", this.reasonYesRB, () -> {
            if (PdfViewerOptionsPanel.Uk("5rnuug", this.reasonYesRB) != false) {
                PdfViewerOptionsPanel.Uk("-cqs121", this.reasonTextBox, true);
            }
        });
        PdfViewerOptionsPanel.Uk("6e9v0m", this.reasonNoRB, () -> {
            if (PdfViewerOptionsPanel.Uk("5rnuug", this.reasonNoRB) != false) {
                PdfViewerOptionsPanel.Uk("-cqs121", this.reasonTextBox, false);
                PdfViewerOptionsPanel.Uk("-1otm0us", this.reasonTextBox, "");
                PdfViewerOptionsPanel.Uk("10huto", this.appearanceBuilder, "");
            }
        });
        char[] cArray16 = "\u614d\u867d\uda39\u1493\uf189\u4cf0".toCharArray();
        cArray16[1] = (char)(cArray16[1] ^ 0x593A);
        char[] cArray17 = "\u5dbf\u4feb\u7c1d\ufb95\u1d44".toCharArray();
        cArray17[2] = (char)(cArray17[2] ^ 0x4E52);
        if (PdfViewerOptionsPanel.Uk("2q1v0r", rjvtsclo.j(cArray16, (short)26215, 5, 3), PdfViewerOptionsPanel.Uk("-15fg0v4", PdfViewerOptionsPanel.Uk("1d6tv0n"), UserProperties.GRAPHICSIGNATURE_MOTIVO, (Object)rjvtsclo.j(cArray17, (short)11991, 2, 1))) == false) {
            PdfViewerOptionsPanel.Uk("-15j20ug", this.reasonYesRB, false);
            PdfViewerOptionsPanel.Uk("-cqs121", this.reasonTextBox, true);
        } else {
            PdfViewerOptionsPanel.Uk("-15j20ug", this.reasonNoRB, false);
            PdfViewerOptionsPanel.Uk("-cqs121", this.reasonTextBox, false);
            PdfViewerOptionsPanel.Uk("-1otm0us", this.reasonTextBox, "");
            PdfViewerOptionsPanel.Uk("10huto", this.appearanceBuilder, "");
        }
    }

    private void updateAllReasons() {
        Object reason = PdfViewerOptionsPanel.Uk("-8si122", this.reasonTextBox);
        PdfViewerOptionsPanel.Uk("10huto", this.appearanceBuilder, reason);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Uk("-thg0up", PdfViewerOptionsPanel.Uk("h1fv12", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Uk("kulutl", app, reason);
            }
        }
    }

    private void drawPreservePdfAArea(DOMElement parent) {
        char[] cArray = "\u9649\ub35b\u189b\u2568\u7200\ub18d\uda78\u2465\u130f\uc058\u672a\u42c4\u430e\u803f\u250b\u8fe6\u3a87\u7a3d\u5e33\u71bd\u2171\u0099\u320f\u1f58\u586c\ub19e\uffe4\u2c23\u79df\u7974\u7b87\u2502\udb19\ubb34\uff8a\u53eb\u4f4b\u85c6\u6031\u4a49\u9178\uc6c7\ue6b3\u6479\u36de\u7342\ubee8\u758b\u07d0\u2ed4\u166d\u2ade\u6116\u3f58\ud733\u445c\u30df\u3e2c\u81a7\u156c\u1fb9\uea3a\u348b\uc2d1\u3619\u3c1e\u1453".toCharArray();
        cArray[31] = (char)(cArray[31] ^ 0x77D6);
        Paragraph preservePDFATitle = new Paragraph(rjvtsclo.j(cArray, (short)12681, 1, 4), parent, this.view, () -> {
            char[] cArray = "\ubaa1\uf808\ub0a2\ue082\u5995\u3aa2\u63b3\u91c8\u54fd\ud3ca\u6816\u4ff7\u92d3\u9e45\ube4b\u45a7\ue11d\ueec7\u0ac3\u62ae\u3198\u4aea\u7041\uadf4\u88e0\ud247\uec81\u3716\u6eaf\u105e\u90c0\u2e48\u919b\u250e\uadef\u49fb\u1eaa\u0822\u018b\u6df8\ud313\u310b".toCharArray();
            cArray[25] = (char)(cArray[25] ^ 0x62C6);
            return PdfViewerOptionsPanel.Uk("5hv35", i18n, vhhpyrok.N(cArray, (short)3576, 2, 4), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u8157\uc7c1\uc71a\uda4b\u38f8\u5b95\u8df8\ua1b0\ud5d9\ufb8f\ud25a\u87b2\uf44e\udf7c\u579e\ubab8\uac1a\uc2fe\u1b8a\u2eef\u353d\uc6c0\u65ca\ua13e\u67fe\uca22\u1e56\uac73\uf55e\u5882\u315d\u9a6a\u4cf7\u7396\u2d98\ud5dc\u295d\u608e\u94f1\uce39\ucb03\u94be\u5d90\u1041\ub8c4\uf89d\uec7e\ueb19\ub55e\u1136\uadf6\u23b1\u45e1\ubf0e\u68bd".toCharArray();
        cArray2[34] = (char)(cArray2[34] ^ 0x57C9);
        PdfViewerOptionsPanel.Uk("1kqjuvo", preservePDFATitle, rjvtsclo.j(cArray2, (short)24334, 0, 5));
        char[] cArray3 = "\ub9eb\uba58\u5443\u642d\u74b5\u0893\uf4b1\u23ac\ud8a1\u8995\u1249\u89f1\u82a3\u8947\u97ea\u1478\u9fae\u92a3\u648e\u37e5\ua72f\ud01a\u113e\uad86\u5be2\u5e8e\u55c3\u73a9\u0257\u06a4\ue4a4\ucc5e\u0694\ubbcd\u89ce\ue336\u2745\u404e\u12d7\u8c2e\u9d61\ua1ed\u5a26\u414e\u91f0\ub33e\u6a4a\u74e4\u4330\ua1de\u9aea\u4604\uad51\u45a6\u2353\u367a\ue468\u83c0\u4718\u7676\u1fad\u44f6\u34f6\u4bec\u5742\u52a2\u1328\ub652\u4973".toCharArray();
        cArray3[0] = (char)(cArray3[0] ^ 0x2951);
        DivContainer preservePDFADivisor = new DivContainer(rjvtsclo.j(cArray3, (short)14914, 3, 1), parent, this.view);
        char[] cArray4 = "\u0b06\u090a\ua0b0\uc637\uee49\uab42\u4323\uf2cf\uf474\uc3d1\u3aa5\ufefe\uec2b\ude28\u86d7\uaaa3\uf0db\u93e1\uf258\u2a90\u3001\u5c50\uc509\ud58b\u534a\u5648\u2efb\u9375\u1eb7\u62a1\u0853\ua483\ud2f4\uba65\ue118\ua1d1\u9c4c\ud283\ud6a6\ub22a\u6029\ue27f\u140a\uce19\u70f3\ub034\u7aa7\u6be1\u3fb7\u84c8\u4056\u8439\udffc\ucf61\ufa5c\ua414\u2cf1".toCharArray();
        cArray4[42] = (char)(cArray4[42] ^ 0x7AB7);
        PdfViewerOptionsPanel.Uk("-51u0td", preservePDFADivisor, rjvtsclo.j(cArray4, (short)10288, 3, 5));
        char[] cArray5 = "\u95a6\uffde\u0928\u1eab\u68f6\u23b9\ufaab\uff34\u66a3\ufdcd\u8bc2\ua6a7\uc8a6\u6e44\u2efe\u4f70\ued51\u86cd\u3436\uaf09\uc7cc\u4f04\uc497\ub9a3\u340e\u403e\u1b0a\ufbdd\u7ce7\uc38c\u1856\u8cf5\u7e25\ueca9\u921f\ua268\u88e4\ub205\u8173\ua9ca\u7a66\uaa67\u2277\u624a\u865d\u3053\u85fe\u3484\ud438\u8f76\ue413\u2df7\u6360\ua1a2\u41a6\ud9cc\u4e01\u71fe\u3fd9\u5449\ub6c1\uc517\u0bf1\u5d36\u2716".toCharArray();
        cArray5[59] = (char)(cArray5[59] ^ 0x705B);
        char[] cArray6 = "\ub93c\u4d7d\ua23e\u440f\u37b1\uba5e\u369e\u4043\uaf38\ufe1d\u5f35\u582d\ua3a1\ueac5\u58a3\u7b5b\u9e84\ub9da\u650f\u5932\u5a8c\uec3c\u26db\u5031\u9917\u2582\ude42\ua882\ua2c8\u71b1\u8a14\u71cc".toCharArray();
        cArray6[15] = (char)(cArray6[15] ^ 0xDCD);
        char[] cArray7 = "\ua8a2\u6e0f\ue58c\u59b7\u9850\ua527\u44f0\uaf4f\uef06\ueb14\u25a8\ucd19\u1457\u2e87\u5c0d\u69af\ue965\u7610\u89c0\u070f".toCharArray();
        cArray7[15] = (char)(cArray7[15] ^ 0x443F);
        this.preservePDFAYesRB = new CGRadioButton(rjvtsclo.j(cArray5, (short)24605, 4, 0), parent, this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, rjvtsclo.j(cArray6, (short)2948, 2, 1), (Object[])new Object[0]), rjvtsclo.j(cArray7, (short)9556, 1, 4));
        char[] cArray8 = "\u2915\u5115\u353c\u87ad\u188a\u8f30\ueff7\u0c0d\u61d5\u609e\u95a5\u430f\ua444\u9a89\ufc49\uf6ac\u3143\uecdb\u7018\u24e3\uadd4\u3ecb\ucf3b\u677b\ud608\ub0ff\ubd1d\u2741\u51a0\uf85a\u63c1\u2637\u6884\ub769\ufaa5:\uaaa0\uf58a\ueb81\u03bb\ub40b\u0f4f\ua7fc\u481e\ubdde\u8e17\u38d4\uaad3\ubfbf\u7ad5\ue725\u971e\u90b6\u5e38\ub5e2\uebce\u0201\uccc2\uc034\uc355\u616f\u80e5\uad40\u1565".toCharArray();
        cArray8[61] = (char)(cArray8[61] ^ 0xF88);
        char[] cArray9 = "\ub3f8\ue981\u32fd\uccd3\u2b04\uefbd\ue1c3\ud6e5\uf5de\u692c\ud1fc\uef88\udda0o\u1877\ud3e7\u529b\ua334\u6562\ua777\u1325\u37f5\u6713\u9065\ua9bf\u459f\u982b\u83c5\u2e1f\ue07c\u0328".toCharArray();
        cArray9[18] = (char)(cArray9[18] ^ 0xB9A);
        char[] cArray10 = "\u338e\u35dc\u0887\u345c\ufb3f\uac08\u31df\u4964\u7ecf\ufab1\u2676\u9493\u61a3\u9d7e\ub6d4\u8d45\u09f1\ufe30\u8004\u21fc".toCharArray();
        cArray10[9] = (char)(cArray10[9] ^ 0x7301);
        this.preservePDFANoRB = new CGRadioButton(rjvtsclo.j(cArray8, (short)20355, 3, 0), parent, this.view, (String)PdfViewerOptionsPanel.Uk("5hv35", i18n, rjvtsclo.j(cArray9, (short)9553, 1, 4), (Object[])new Object[0]), rjvtsclo.j(cArray10, (short)12632, 4, 1));
        char[] cArray11 = "\u96fd\uaa14\u284b\uf94a\u74cf\u3ee8\u4417\u68e9\u1ee6\u4347\u845c\u2e41\u8e63\u7a88\u943a\uaad1\u90c3\ucddd\ufe3a\uedcb\u943a\u2cc4\ub418\u18bc\u0515\uff2a\u6ebd\udad1\ue54f\u2e9b\ua2f6\uc6f4\uc3d7\u43a9\uf8d7\u2ea7\u328f\u5b76\u25ea\uc738\u4de0\uf862\u7568\u4b65\u2141\u8702\u8b9e\u5670\u28c6\u89d1\u8543\uc124\u5baf\uae28\u9ba3\u027c\u4fc7\ubc59\u981b\u9f97\u1276".toCharArray();
        cArray11[3] = (char)(cArray11[3] ^ 0x7B46);
        PdfViewerOptionsPanel.Uk("1dg7v0i", this.preservePDFAYesRB, rjvtsclo.j(cArray11, (short)29137, 3, 5));
        char[] cArray12 = "\uaee8\ub3ca\ua1b8\u9a97\ue422\ud717\u4a5d\u7670\ude2c\ub3b4\u979b\u02fb\u446e\u41fe\ub9cb\u872c\ud0c7\u91d2\u562f\uc148\uec92\ub1a1\u9e59\u69cb\uee58\ubcea\u7dcc\ue7c7\u926b\uaf92\u6d35\u6e96\ua2bd\ue6ea\ue9b3\uaf5e\uf4f9\u8ec8\u2191\u9fd5\u204f\udbc5\u5022\uebbc\u3f0b\u27da\u79c6\u26b5\uf220\ue8c7\ue645\u4cf5\u9221\u7b79\u2f08\ucf7c\u6c91\uec5d\ufd85\ue5f7\u0df0".toCharArray();
        cArray12[0] = (char)(cArray12[0] ^ 0x2A41);
        PdfViewerOptionsPanel.Uk("1dg7v0i", this.preservePDFANoRB, rjvtsclo.j(cArray12, (short)23354, 2, 3));
        PdfViewerOptionsPanel.Uk("6e9v0m", this.preservePDFAYesRB, () -> {
            if (PdfViewerOptionsPanel.Uk("5rnuug", this.preservePDFAYesRB) != false) {
                this.updateAllPreservePdfA(true);
            }
        });
        PdfViewerOptionsPanel.Uk("6e9v0m", this.preservePDFANoRB, () -> {
            if (PdfViewerOptionsPanel.Uk("5rnuug", this.preservePDFANoRB) != false) {
                this.updateAllPreservePdfA(false);
            }
        });
        char[] cArray13 = "\u4db2\u4a0d\u96c6\uec36\u66a1".toCharArray();
        cArray13[2] = (char)(cArray13[2] ^ 0x5B5);
        char[] cArray14 = "\u7560\ufae1\u91ed\u07d3\u5bdb".toCharArray();
        cArray14[3] = (char)(cArray14[3] ^ 0x3CA9);
        if (PdfViewerOptionsPanel.Uk("2q1v0r", rjvtsclo.j(cArray13, (short)22088, 1, 1), PdfViewerOptionsPanel.Uk("-15fg0v4", PdfViewerOptionsPanel.Uk("1d6tv0n"), UserProperties.GRAPHICSIGNATURE_PRESERVEPDFA, (Object)rjvtsclo.j(cArray14, (short)20414, 3, 2))) == false) {
            PdfViewerOptionsPanel.Uk("-15j20ug", this.preservePDFANoRB, false);
            PdfViewerOptionsPanel.Uk("-jfo12e", this.appearanceBuilder, false);
        } else {
            PdfViewerOptionsPanel.Uk("-15j20ug", this.preservePDFAYesRB, false);
            PdfViewerOptionsPanel.Uk("-jfo12e", this.appearanceBuilder, true);
        }
    }

    private void updateAllPreservePdfA(boolean preserve) {
        PdfViewerOptionsPanel.Uk("-jfo12e", this.appearanceBuilder, preserve);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Uk("-thg0up", PdfViewerOptionsPanel.Uk("h1fv12", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Uk("-1pt6129", app, preserve);
                PdfViewerOptionsPanel.Uk("-1u1q0uq", app);
            }
        }
    }

    private void drawVerticalArea(DOMElement optionsContainer, DOMElement optionsArea) {
        char[] cArray = "\uf6b9\u518e\u69b6\u0b88\u9502\u748c\u8f2f\u694a\ue251\u8c8b\u40cb\ue624\u8e65\u2e24\u69e9\u2e0b\ue565\u7167\u3056\uba71\u114d\u1f2d\u2b99\u9fa7\ua159\u7f15\u87d8\u7c2e\uf1f7\u027c\uaacb\uf9c0\uc069\u84c6\u1180\u04bb\u0aea\u9d11\u21b7\u771c\u801c\uff5f\ue5db\u1153\u90ee\ud2a5\u53ff\u111b\ubfa9\u6768".toCharArray();
        cArray[24] = (char)(cArray[24] ^ 0x1F72);
        DivContainer verticalArea = new DivContainer(vhhpyrok.N(cArray, (short)11278, 0, 3), optionsContainer, this.view);
        char[] cArray2 = "\u2598\u1f45\ud5b5\u9458\u0f1c\uc2b0\u519d\u57d1\uf604\u0bca\u6e7b\u459f\uddc5\u046b\u6d75\u9a76\u4565\ue727\u1ff6\u42f6\u05db\u05fe\ue27f\u26c9\u7f40\u0497\u760d\uf087\u5deb\uef61\u7964\u7ca8\u1659\ueca0\u0a32\u0d36\uf99b\u220f\u26fc\u2c8c\u8114\ud116\u48a5\ufe40\u9d9e\u31e4\u8ca8\uc1e1\u51bf\u074d".toCharArray();
        cArray2[22] = (char)(cArray2[22] ^ 0x715);
        PdfViewerOptionsPanel.Uk("-51u0td", verticalArea, vhhpyrok.N(cArray2, (short)6961, 3, 5));
        char[] cArray3 = "\ud673\u4bd1\uda01\u7601\u1f74\u6d9b\u136e\u62f0\u71d1\u895f\u5524\uc775\u0f3b\u299c\uf9c6\uaca6\ufcd1\u7f78\u02b5\u2bb9\u0e05\u0866\u1a6a\u1e90\u348b\u48d5\ucd85\u07d1\ua2f3\ua0de\ud5d7\u488a\u3ffb\ua173\uedc3\ubf7e\u2741\u4909\uea23\uec78\u6899\u134b\ua0d5\u1cc8\u4d29\u87a6\u365b\u77d7\u324e\u6677".toCharArray();
        cArray3[27] = (char)(cArray3[27] ^ 0x6943);
        Paragraph optionsLabel = new Paragraph(vhhpyrok.N(cArray3, (short)32156, 2, 1), (DOMElement)verticalArea, this.view, () -> {
            char[] cArray = "\uc7ae\ue4ad\u469c\u49ff\u7f9d\u1e96\u039e\u8996\u8160\u6606\uf6ed\u7a04\u6a0f\u9c61\u8ffb\u731c\ubb1a\u7e83\u524b\u9176\u509e\uc8e5\u94b7\ub344\u8709\u2d5a\u754a".toCharArray();
            cArray[24] = (char)(cArray[24] ^ 0x5CF0);
            return PdfViewerOptionsPanel.Uk("5hv35", i18n, qrbdtsxk.y(cArray, (short)12171, (byte)5, (byte)5), (Object[])new Object[0]);
        });
        char[] cArray4 = "\ua3db\u5869\u71ec\u2a20\u33d0\uc33b\uab3a\u641f\uff50\uf4db\u07f6\u6926\udc6c\u58f5\u31dd\u6692\u2b4a\ua7db\u3f8d\u2b15\ubd18\ucaf4\u00a1\u488e\u3b1d\ufa90\u0827\u1417\udc21\uaf2e\u6cd4\u00ca\u1e02\udb93\u1365\u832c\u2d92\u7343\u89da\u2c92\u5d13\u5c56\u045f\uf2bc\u5f31\u5b4c\u1288\ueba2\u7082:".toCharArray();
        cArray4[13] = (char)(cArray4[13] ^ 0x1F82);
        PdfViewerOptionsPanel.Uk("1kqjuvo", optionsLabel, vhhpyrok.N(cArray4, (short)23140, 3, 1));
        char[] cArray5 = "\u8ea7\ub9c3\u643a\u1bf1\u678b\u1ddb\uc15e\ub694\u476a\ucfd8\u6472\u18dc\u5176\uc83c\u481d\udd51\u8ccb\u2efc\uecdf\u27cc\u0601\ud2b8\u7e95\u8a55\uaa61\ud206\u965e\u44bc\u7f5b\u3ef2\u8fab\u419c\ue64c\ue9c0\uad45\ue924\u08cb\u93af\u20ec\u8af4\uae60\uf177\u5d57\u7385\u82d1\u6c89\uab63\udbb4\uc331\u2578\u96cc\udf7c\u3114".toCharArray();
        cArray5[17] = (char)(cArray5[17] ^ 0xEFF);
        SpanContainer verticalAligner = new SpanContainer(vhhpyrok.N(cArray5, (short)31187, 5, 1), (DOMElement)verticalArea, this.view);
        char[] cArray6 = "\u2d2e\u8395\uebb7\u7bb1\ua700\ud9ff\u26c4\uf803\u62aa\u8922\u7c6e\u7922\ubb77\ud1ec\uf8dc\u8884\uee15\ue95a\uc23e\u7e09\u7e5a\uc55a\ucdaa\u3f7c\ua748\u76a4\ub83a\u52e1\u42fe\u1ec8\u1566\ud048\u33ad\u08b7\u1da8\u4281\u22b6\u35e4\uf588\ud3cf\ua6fb\u7bad\u229e\u0748\u50c0\u2251\u43f6\ufee5\uf756\u90bc\u0210\u2e5f\u722d".toCharArray();
        cArray6[35] = (char)(cArray6[35] ^ 0x7A45);
        PdfViewerOptionsPanel.Uk("-39k124", verticalAligner, vhhpyrok.N(cArray6, (short)9164, 1, 2));
        char[] cArray7 = "\u305e\ua16c\u07d2\u0983\u6882\u47be\u7b54\uae81\ua252\u0f55\ud2b3\u7f1d\uaa41\u4f3b\u7b5a\u7a14\u826a\u1565\ueba5\u6e07\ua13b\ua6e4\uf07e\u6a2e\u16c6\ue9c9\u3415\u126f\u7d99\u1218\uf80c\u83ae\u0a10\u3ae5\u3ffa\u54da\u271c\u9f5f\u2f66\u766b\u81f5\uc091\u3a65\u1610\ua9e8\ua3bf\u6ab6\ue4e1\u65b2".toCharArray();
        cArray7[14] = (char)(cArray7[14] ^ 0x5BB1);
        Image toggleOptions = new Image(vhhpyrok.N(cArray7, (short)32543, 4, 0), (DOMElement)verticalArea, this.view);
        char[] cArray8 = "\u7d23\ua93d\u5086\u789a\udf50\u970d\u1aa5\u4039\u8b1a\u88d9\uec86\uc803\uc5c1\u8e79\u10c6\u03e2\uab55\ua54f\u43ad\u1306\u52f6\ub933\u140e\u5f2a\udbf8\u3b64\u47ea\ub99a\ud29b\u26ff\ufde1\u51b3\ud54b\u334e\u58f2\u30a9\uabe6\u7b50\uc411\ud6c4\u9dac\uda19\u6532\u229a\ua3f5\u4dce\uf4b9\ub6c9\u547f".toCharArray();
        cArray8[21] = (char)(cArray8[21] ^ 0x6A12);
        PdfViewerOptionsPanel.Uk("-1oa4106", toggleOptions, vhhpyrok.N(cArray8, (short)25163, 2, 2));
        PdfViewerOptionsPanel.Uk("73lv34", toggleOptions, ARROW_LEFT);
        PdfViewerOptionsPanel.Uk("1obutp", verticalArea, evt -> {
            this.isOptionsVisible = !this.isOptionsVisible;
            PdfViewerOptionsPanel.Uk("lt7utr", optionsArea, this.isOptionsVisible);
            if (this.isOptionsVisible) {
                PdfViewerOptionsPanel.Uk("73lv34", toggleOptions, ARROW_RIGHT);
            } else {
                PdfViewerOptionsPanel.Uk("73lv34", toggleOptions, ARROW_LEFT);
            }
        });
    }

    public void remove() {
        if (this.imageYesRB != null) {
            PdfViewerOptionsPanel.Uk("1qnfutm", this.imageYesRB);
        }
        if (this.imageNoRB != null) {
            PdfViewerOptionsPanel.Uk("1qnfutm", this.imageNoRB);
        }
        if (this.dateYesRB != null) {
            PdfViewerOptionsPanel.Uk("1qnfutm", this.dateYesRB);
        }
        if (this.dateNoRB != null) {
            PdfViewerOptionsPanel.Uk("1qnfutm", this.dateNoRB);
        }
        if (this.locationYesRB != null) {
            PdfViewerOptionsPanel.Uk("1qnfutm", this.locationYesRB);
        }
        if (this.locationNoRB != null) {
            PdfViewerOptionsPanel.Uk("1qnfutm", this.locationNoRB);
        }
        if (this.reasonYesRB != null) {
            PdfViewerOptionsPanel.Uk("1qnfutm", this.reasonYesRB);
        }
        if (this.reasonNoRB != null) {
            PdfViewerOptionsPanel.Uk("1qnfutm", this.reasonNoRB);
        }
        if (this.preservePDFAYesRB != null) {
            PdfViewerOptionsPanel.Uk("1qnfutm", this.preservePDFAYesRB);
        }
        if (this.preservePDFANoRB != null) {
            PdfViewerOptionsPanel.Uk("1qnfutm", this.preservePDFANoRB);
        }
    }

    static {
        char[] cArray = "\u7971\u02ca\u0f0d\u4bf9\u1c89\u43a2\udbb3\u440c\udf55\ub934\u3aad\ud912\u28c3\u8040\ua17f\ud2f2\u33e8\u788e\u46d5\u7242\u73e8\u9b26\uf487\u58fb\u019e\u7fa1\u31a7\u51ec\ue6ef\u4f3c\u7618\u0f2f\u9a07\uedb7\u66cc".toCharArray();
        cArray[30] = (char)(cArray[30] ^ 0x4E7C);
        i18n = PdfViewerOptionsPanel.Uk("-9ro0vb", vhhpyrok.N(cArray, (short)29578, 5, 1));
        char[] cArray2 = "\u480e\u5958\u3a02\u7d96\ueafb\u115a\u1d14\u5497\u58a6\u8dab\u3ee5\u5e0f".toCharArray();
        cArray2[6] = (char)(cArray2[6] ^ 0x139E);
        ARROW_LEFT = PdfViewerOptionsPanel.Uk("-de101", vhhpyrok.N(cArray2, (short)27596, 3, 5));
        char[] cArray3 = "\uca28\u5a1b\ud3ec\u1c2b\uf6f4\u88e5\u2464\u1028\u970d\ud53a\u574a\u7bde".toCharArray();
        cArray3[2] = (char)(cArray3[2] ^ 0x2D06);
        ARROW_RIGHT = PdfViewerOptionsPanel.Uk("-de101", vhhpyrok.N(cArray3, (short)14966, 2, 4));
    }

    private static Object Uk(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(oqjnkbuz.t(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

