/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class ComboBox
extends DOMElement {
    private LinkedHashMap<String, Option> optionMap = new LinkedHashMap();

    public ComboBox(String id, View view, boolean create) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        if (create) {
            ComboBox.createElementWithID("select", id, view);
        }
    }

    public ComboBox(String id, String parentId, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("select", id, parentId);
    }

    public ComboBox(String id, DOMElement parent, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("select", id, parent.getId());
    }

    public void setValue(String value) {
        this.view.execute(new StringBuilder(this.id.length() + value.length() + 41).append("document.getElementById(\"").append(JsUtils.escapeJs(this.id)).append("\").value=\"").append(value).append("\";").toString());
    }

    public String getValue() {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + 6).append((CharSequence)this.jsToEvaluateElement).append(".value");
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)this.view.evaluate(new StringBuilder(evalueteJsElement.length() * 2 + 28).append("return (").append((CharSequence)evalueteJsElement).append("!=null&&").append((CharSequence)evalueteJsElement).append("!=undefined)").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (ret.booleanValue()) {
            return (String)this.view.evaluate(new StringBuilder(evalueteJsElement.length() + 7).append("return ").append((CharSequence)evalueteJsElement).toString());
        }
        return null;
    }

    public Option getSelectedOption() {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + 6).append((CharSequence)this.jsToEvaluateElement).append(".value");
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)this.view.evaluate(new StringBuilder(evalueteJsElement.length() * 2 + 28).append("return (").append((CharSequence)evalueteJsElement).append("!=null&&").append((CharSequence)evalueteJsElement).append("!=undefined)").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (ret.booleanValue()) {
            String value = (String)this.view.evaluate(new StringBuilder(evalueteJsElement.length() + 7).append("return ").append((CharSequence)evalueteJsElement).toString());
            if (value.equals("null")) {
                return null;
            }
            return this.optionMap.get(value);
        }
        return null;
    }

    public Option getOption(String value) {
        return this.optionMap.get(value);
    }

    public void select(int index) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + 20).append((CharSequence)this.jsToEvaluateElement).append(".selectedIndex=").append(index).toString());
    }

    public void select(String value) {
        int i = 0;
        boolean found = false;
        Iterator<String> it = this.optionMap.keySet().iterator();
        while (!found && it.hasNext()) {
            if (it.next().equals(value)) {
                found = true;
                this.select(i);
            }
            ++i;
        }
    }

    public void addOption(Option option) {
        this.optionMap.put(option.getValue(), option);
    }

    public void addOptions(List<Option> options) {
        for (Option op : options) {
            this.optionMap.put(op.getValue(), op);
        }
    }

    public List<Option> getOptions() {
        return new ArrayList<Option>(this.optionMap.values());
    }

    public void removeOption(String value) {
        Option op = (Option)this.optionMap.remove(value);
        if (op != null) {
            op.remove();
        }
    }

    public void empty() {
        this.clearSelect();
        this.optionMap.clear();
    }

    public void clearSelect() {
        this.view.execute(new StringBuilder(this.id.length() + 18).append("clearSelect(\"").append(this.id).append("\");").toString());
    }
}

