/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.pdf.panels;

import esecurity.crypto.gui.pdf.bean.PdfDocument;
import esecurity.crypto.gui.pdf.guielements.CGAppearance;
import esecurity.crypto.gui.pdf.guielements.CGAppearanceBuilder;
import esecurity.crypto.gui.pdf.panels.jduoguzh;
import esecurity.crypto.gui.pdf.panels.mxydyrtm;
import esecurity.crypto.gui.pdf.panels.orbhlnlm;
import esecurity.crypto.gui.pdf.panels.qsvcrfhj;
import esecurity.crypto.gui.properties.UserProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.crypto.gui.utils.guielements.CGRadioButton;
import esecurity.desktop.FileDialog;
import esecurity.desktop.View;
import esecurity.desktop.dom.Button;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.dom.Image;
import esecurity.desktop.dom.Paragraph;
import esecurity.desktop.dom.SpanContainer;
import esecurity.desktop.dom.TextInput;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;

public class PdfViewerOptionsPanel {
    private static final EllipsLogger logger = PdfViewerOptionsPanel.Sg("1nfveps", Constants.CAPI_LOGGER_NAME);
    private static final I18N i18n;
    private static final String ARROW_LEFT;
    private static final String ARROW_RIGHT;
    private final View view;
    private final CGAppearanceBuilder appearanceBuilder;
    private final List<PdfDocument> pdfDocuments;
    private CGRadioButton imageYesRB;
    private CGRadioButton imageNoRB;
    private Image appearanceImage;
    private Button modifyImageBtn;
    private CGRadioButton dateYesRB;
    private CGRadioButton dateNoRB;
    private CGRadioButton locationYesRB;
    private CGRadioButton locationNoRB;
    private TextInput locationTextBox;
    private CGRadioButton reasonYesRB;
    private CGRadioButton reasonNoRB;
    private TextInput reasonTextBox;
    private CGRadioButton preservePDFAYesRB;
    private CGRadioButton preservePDFANoRB;
    private boolean isOptionsVisible = false;
    private BufferedImage bufferedImage = null;

    public PdfViewerOptionsPanel(CGAppearanceBuilder appearanceBuilder, List<PdfDocument> pdfDocuments, DOMElement parent, View view) {
        this.appearanceBuilder = appearanceBuilder;
        this.pdfDocuments = pdfDocuments;
        this.view = view;
        this.draw(parent);
    }

    private void draw(DOMElement parent) {
        char[] cArray = "\ub555\u5c09\u9703\uc0f1\ue04e\u5eb0\u85d4\u2780\u172c\uee8f\ud0cb\u0dc4\uf513\u3f7f\u33dc\u35f9\u73a1\u9df9\u7781\u71ed\ub486\uf2d2\u1295\u5b16\u94e5\u35e1\u2689\u85fe\u1013\udf51\ufd30\ue31c\u6195\ua529\ua7f8\uf4db\ub128\ueca2\ue94d\ubfa6\ubd6a\u7382\uf7f8\u4bec\ub2e9\u45c0".toCharArray();
        cArray[11] = (char)(cArray[11] ^ 0x6B8F);
        DivContainer optionsContainer = new DivContainer(mxydyrtm.b(cArray, (short)23984, 0, (short)3), parent, this.view);
        char[] cArray2 = "\u3523\u31ea\udfe8\ua586\u8e17\u32b3\u75f7\u167b\ub527\u3167\ub781\u0ef7\ueba1\uf5f7\uf0b9\u38e2\uf330\u4489\u2d72\u27fd\u6af5\u24e1\u1c11\u083b\u633a\uadb9\u36ba\u4d45\uaa86\u29f1\u611c\u39c4\u0e4b\u5c1d\u46c6\ub969\u59f0\ub398\u5ab1\u5899\ud0bb\ub07e\u5ee5\u9f66\u1e0c\u7c6d".toCharArray();
        cArray2[32] = (char)(cArray2[32] ^ 0x56A9);
        PdfViewerOptionsPanel.Sg("-1tv2h4j", optionsContainer, mxydyrtm.b(cArray2, (short)22873, 0, (short)4));
        char[] cArray3 = "\ub11e\u8c01\ua6ad\ua5c9\u90be\uc27e\u72ff\u2d4f\u42eb\uf48e\u559c\u70a3\u1fc1\u9abd\u632a\u3035\ubec8\u88fb\u9cf8\u9f8f\u509c\ub096\u9206\u160f\ua0aa\u39ec\u3fc2\ue955\u3839\u4e59\u2159\uad24\ua9b8\u3d76\uac70\u5c87\u82ac\u537c\u475a\u43e6\ub19f\u6bae\u260e\uff3a\u9e6a\u6269\u44af\u1e65\r".toCharArray();
        cArray3[30] = (char)(cArray3[30] ^ 0x1EDB);
        DivContainer optionsArea = new DivContainer(mxydyrtm.b(cArray3, (short)29640, 0, (short)2), (DOMElement)optionsContainer, this.view);
        char[] cArray4 = "\u77ab\uf39c\u8c39\uaf8f\u8e48\u8b3b\uf07e\u4792\u4767\uce08\ub9ea\u0b64\u4f8d\u3a5a\u86a2\ubc5d\u88fb\u92db\u8a71\ub433\u4eab\u66c5\ue058\u7b81\u51a4\u87c9\ue0c9\u2ef7\u7ad1\uc93f\u8fe2\u412b\u4458\u4725\u47c1\ue986\uafad\u0b4e\ue24e\u26ca\u653a\ua957\u3826\uc4bb\ue053\u45aa\ub808\ub6bf\u6ee5".toCharArray();
        cArray4[35] = (char)(cArray4[35] ^ 0x1114);
        PdfViewerOptionsPanel.Sg("-1tv2h4j", optionsArea, mxydyrtm.b(cArray4, (short)21371, 2, (short)0));
        PdfViewerOptionsPanel.Sg("-1beeh09", optionsArea, false);
        char[] cArray5 = "\uc80e\u520c\u1c2d\u7a80\ucd2b\udc12\u8335\u8374\u5379\u2f4e\u4fc5\ubeba\ubf2b\u06cd\u475a\u38d3\ufaf5\ub7a7\u5fd5\ud20f\u864e\u78a3\u1dd6\u1c8b\u702c\u1593\u0d0d\u5c28\uc0fe\u68f7\u3a49\uff5d\uabde\u8569\u3626\uaf83\u671d\u416f\ub993\u70d2\uc207\ua782\u34fd\u258c\u02d1\ua86f\ue0ad\u7454\u45fd\uc9a0\u8b55\u2352\u61ef\u7c12\u5c79\u7b31".toCharArray();
        cArray5[53] = (char)(cArray5[53] ^ 0x3F59);
        DivContainer optionsAreaContent = new DivContainer(mxydyrtm.b(cArray5, (short)14079, 4, (short)4), (DOMElement)optionsArea, this.view);
        char[] cArray6 = "\u46a7\u1f07\uf5ad\u9d46\ua3f6\u4781\ud439\u5c20\uea71\ud409\u3c15\uc8f9\ub25b\ud34b\u8112\u2f58\ud585\u2613\u20a9\ud5fb\u617f\ue265\ua0e6\ueda9\u22be\uaf50\u49b5\u8d2a\ua459\uf065\u1687\ubc45\ub898\u41e2\ub492\u63cd\uf603\u33ca\uc951\uc7e2\u9f45\u3a19\u790e\u2e50\u9b87\u6d32\ued9e\u50c9\ub6d9\u9ab1\u0a31\ub04d\u1035\u3541\u7c1a\u369f".toCharArray();
        cArray6[11] = (char)(cArray6[11] ^ 0x6BAC);
        PdfViewerOptionsPanel.Sg("-1tv2h4j", optionsAreaContent, mxydyrtm.b(cArray6, (short)21539, 0, (short)2));
        char[] cArray7 = "\u5550\u2238\u3b75\ua165\ucbb0\uef4c\u46be\uc559\u2108\u3f0d\u91dd\u59f0\u7c13\u8752\uaa7a\u21b1\ufca4\u0e49\ua3ea\ud912\ud3ec\uf20e\u6c09\u07b6\u8890\u869a\u515d\ubf47\uf5f1\u5c52\u6fd4\ub90e\ucf1d\u1188\u50eb\u0219\u771d\u839c\u4b49\uaba0\uec5a\ue329\ue57c\u11d1\u66b4\u5dcd\u65e9\uc3d6\u4ecc\u0dd8\ucab0\u14a2\u902a\u4880".toCharArray();
        cArray7[44] = (char)(cArray7[44] ^ 0x6D72);
        Paragraph optionsInfo = new Paragraph(mxydyrtm.b(cArray7, (short)18331, 3, (short)1), (DOMElement)optionsArea, this.view, () -> {
            char[] cArray = "\u7d59\u307d\u64be\u8353\uf64a\ubf16\uda2b\u1dcf\u1b51\u498f\u935e\u2bba\u6802\u384a\u190f\ud8c4\u6e73\u6c35\uddf7\u9b79\u09c9\uf3ec\uf270\ua8ed\ue1ba\ub627\u86f4\u3593\u42d5\ub391\u9e78\ube81\u7c87\u09de\u6204\ua969\u7b89\u7c8d\u0498".toCharArray();
            cArray[23] = (char)(cArray[23] ^ 0x582F);
            return PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, mxydyrtm.b(cArray, (short)3115, 5, (short)1), (Object[])new Object[0]);
        });
        char[] cArray8 = "\u2620\u84b3\u7fc3\u4fd0\u5b44\u814e\uba59\u8fc0\udb7a\u0f54\uc317\ufce6\ucf05\u0c21\ub1ca\u219d\u946b\u1efd\u2f5b\uf335\u5a66\u36b2\uac12\uaa1e\u4070\u56b7\u4e15\u0df3\uf5e2\u17c6\u8452\u2af4\ua529\udb17\ufb5d\u6d70\ua228\u1e3b\uaf2b\u8965\u9fc4\u613b\u94ed\u649a\u143f\u3ab5\u5a37\uf402\u6836\ubd35\ua4cd\uce80\ufcd7\u788d".toCharArray();
        cArray8[35] = (char)(cArray8[35] ^ 0x6C18);
        PdfViewerOptionsPanel.Sg("-1i0sh54", optionsInfo, mxydyrtm.b(cArray8, (short)621, 0, (short)2));
        this.drawImageArea((DOMElement)optionsAreaContent);
        this.drawDateArea((DOMElement)optionsAreaContent);
        this.drawLocationArea((DOMElement)optionsAreaContent);
        this.drawReasonArea((DOMElement)optionsAreaContent);
        this.drawPreservePdfAArea((DOMElement)optionsAreaContent);
        this.drawVerticalArea((DOMElement)optionsContainer, (DOMElement)optionsArea);
    }

    private void drawImageArea(DOMElement parent) {
        char[] cArray = "\ufc1c\ue7e9\u13e6\u22b3\uffa1\uf010\u4b68\u80dd\uff7e\u6b2f\u81b3\ud3cd\uc87a\u9edc\u40f4\u7221\uc22c\ue77b\u248f\ubfc6\u6319\u5613\ucf60\ub838\u6851\u0aad\ubaed\u9a5a\u46b6\ua6da\ua2b3\u86a5\u9d30\ua842\u2bd0\uf271\uf2f6\ua85d\u32c7\ua324\u3d4f\uaa94\uc1ed\ue289\ube33\u2f56\u366d\u8567\ucf5d\u6ca2\u5edb\uf70e\uddcf\uc8dd\u2994\uff45\u8fa8\uf4f5\ucbfd\u00cc".toCharArray();
        cArray[43] = (char)(cArray[43] ^ 0x5BCA);
        Paragraph imageTitle = new Paragraph(orbhlnlm.y(cArray, (short)18646, (short)3, false), parent, this.view, () -> {
            char[] cArray = "\u7bde\u7cf8\u929c\u7c28\uccbc\u57a0\u8efc\u2ab9\u62ce\ufa2f\u48b8\u4db9\u6545\ub8d8\udaee\u186c\u6714\u9635\uba65\u9198\u4313\u7ccc\u2f5c\u2da3\u831c\u604a\u4d47\u5e9e\ue43c$\ue3aa\udc16\ufd46\u1a3b".toCharArray();
            cArray[31] = (char)(cArray[31] ^ 0x2F5);
            return PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, mxydyrtm.b(cArray, (short)11779, 1, (short)5), (Object[])new Object[0]);
        });
        char[] cArray2 = "\ucb70\u2bc2\ucad4\uf781\ud726\ue2c8\u8600\ue433\u0088\u6bf8\uc820\u1dea\ua3a8\uda32\u3662\u9320\u650f\u7dee\ub134\ua41c\u50cd\u9709\u6cc9\u8830\u5627\ua688\ubf14\u0d3f\ud421\ue18c\ubf5e\u1611\ubdbf\uc5e8\u9565\u6950\uc47a\ubc52\ud82e\u7940\u65d4\ub768\uc3d3\u66d8\u05b4\u1747\u47c1\u059a\ud153\u3608\u0c3c\uf094\u182d\uc227\u42c2".toCharArray();
        cArray2[13] = (char)(cArray2[13] ^ 0x72B7);
        PdfViewerOptionsPanel.Sg("-1i0sh54", imageTitle, orbhlnlm.y(cArray2, (short)1457, (short)5, true));
        char[] cArray3 = "\uc424\ud390\ub546\u119f\uccd9\u688c\ub71b\uf0f9U\u0cf4\uffe8\u752e\u394f\u78b0\u12c4\uede1\uc149\uc690\u950e\u9d0e\ud535\ub688\u0fd2\u4c6c\u55b3\u86e8\uae1a\u7e76\ubc3d\uaca3\uf626\u2047\ub29a\u6952\ufb39\u7919\uf4da\u1f11\ud5c9\u17b6\u31f0\uad57\u0e54\u0711\u4ce3\u38d1\u5635\ufcd5\uc961\ueb53\uc39c\udb24\ud134\u7428\uc26c\u6024\u7fb2\ue385\u3815\ubded\u163b\u0e8e".toCharArray();
        cArray3[48] = (char)(cArray3[48] ^ 0x3084);
        DivContainer imageDivisor = new DivContainer(orbhlnlm.y(cArray3, (short)10428, (short)3, false), parent, this.view);
        char[] cArray4 = "\u40b0\udbd4\u24af\ue217\u9e5b\ub290\ube36\u093d\u82c4\u1c7f\ufce8\ucfa7\u3360\u8ed0\ud4bc\u96d8\u7898\u42d2\uddbf\ub7f4\u13f1\udde4\u8453\u69e8\u6afc\u7db5\u9691\u6327\ue8df\uaa3d\ud95b\u5ed2\u4c84\u07d5\ua31c\u59dd\udbc2\u9624\u3df7\u5c8f\ue12a\u08e8\u637c\u56d6\u0eb5\u61ae\uad29\u1575\u4025\u7c5c\u3a9f\u4d35\u9a15\u67ae\uf1b2\u905d\u4659".toCharArray();
        cArray4[13] = (char)(cArray4[13] ^ 0xEF7);
        PdfViewerOptionsPanel.Sg("-1tv2h4j", imageDivisor, orbhlnlm.y(cArray4, (short)18000, (short)3, false));
        char[] cArray5 = "\u4a7e\uaa4f\u1bd5\ub5e0\u3ef8\u7cad\uc077\u12e5\u1bb2\u2f08\u4080\u972b\u9a97\u7f0d\ueb9d\ucdd1\u516d\u593a\ua02f\u57dc\u6d43\u49b9\u6877\u10bf\uc510\u1753\ubb52\ud915\u0fff\u1576\u7eff\uee14\u4093\u79cd\u9322\u4861\u1f95\u1fa2\ud2f0\u0e17\u92df\ub0f5\u576d\u6a39\ucb3e\uee08\u6130\ud2c6\u87d6\u1cd4\u7c9c\ub58e\ucebe\ude50\ue9ce\u94e1\udfab\u4ccf".toCharArray();
        cArray5[0] = (char)(cArray5[0] ^ 0x407);
        char[] cArray6 = "\u15a8\u7e2b\ub4f0\u332b\u8635\ud488\ue83b\u3298\udb6e\uf38a\ua5e4\u863b\u432a\uad61\u8707\u0308\u076c\ud194\u9e89\uf51c\uaa99\ucc64\u603e\u5ffb\u3d8c\u4c86\uc22c\u041f\u2791\u7e1e\ud754\u6ac8".toCharArray();
        cArray6[24] = (char)(cArray6[24] ^ 0x61FA);
        char[] cArray7 = "\ucd85\uc9c4\u23b0\ubcf3\u51a2\u89a1\u49af\u4e4b\u3fe8\u2e4d\u850e\ua779\u38fa".toCharArray();
        cArray7[7] = (char)(cArray7[7] ^ 0x3F4E);
        this.imageYesRB = new CGRadioButton(orbhlnlm.y(cArray5, (short)17492, (short)5, true), parent, this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, orbhlnlm.y(cArray6, (short)20625, (short)2, true), (Object[])new Object[0]), orbhlnlm.y(cArray7, (short)32726, (short)5, false));
        char[] cArray8 = "\u2b8e\uccaa\ub657\u3bd2\u3da6\u0a12\u949e\u63a9\u0383\u4529\u5c41\u28cd\ubbdc\u3c12\u7110\u6e3e\uf8f5\u010d\u9c47\ufaaa\u2eef\u4531\u71ca\u10a2\ud542\ud3ff\u3b37\u4a60\ua8d8\u19cb\u4558\ub504\u1681\ueb6c\uf809\uc82e\u3608\u2530\uc894\u7385\u8d64\ua055\u5e6a\u0c0d\u1226\u33a4\u660f\u8ace\u9453\u3ca8\ue0ed\uf5b6\u57e3\uec03\u9a59\u1d58\u4ecd".toCharArray();
        cArray8[2] = (char)(cArray8[2] ^ 0x62F5);
        char[] cArray9 = "\u9743\ub753\ufc0e\uc861\u2acb\u2f47\uc7d5\u8236\uab37\ua6d8\u65b7\u11b9\u2832\u18d1\u7e0e\ua6b5\ua47b\u1dfa\u6c30\u174f\u5bcc\uad0f\u4c4e\u531a\u59f0\ua3aa\u7de4\u2701\uf96e\u4bc9\u456e".toCharArray();
        cArray9[28] = (char)(cArray9[28] ^ 0x2162);
        char[] cArray10 = "\u5454\u1215\uc765\u8d54\u98ee\uc1e4\u96dc\uf806\u8539\u5dab\ue603\u0e2d\u0a57".toCharArray();
        cArray10[8] = (char)(cArray10[8] ^ 0x7AA);
        this.imageNoRB = new CGRadioButton(orbhlnlm.y(cArray8, (short)25542, (short)1, true), parent, this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, orbhlnlm.y(cArray9, (short)16149, (short)0, false), (Object[])new Object[0]), orbhlnlm.y(cArray10, (short)17666, (short)2, false));
        char[] cArray11 = "\u6545\ua93c\u98b8\uaf31\u9d56\ucf02\u3082\u497b\u7c3b\uac11\ud4c5\ucb0c\u88b7\uea79\uadb0\u5830\ufd76\u0b43\ufa4d\u483c\u804b\ubd76\u0501\u4a25\uffe9\ub518\u34c5\u197d\uf9b0\uc4f0\u4652\ua226\ued94\u1997\u0232\ufe49\u66b7\ua5b1\u7442\u4e97\uf7ae\u78b7\u648e\u11e4\udc0f\u2c8e\u7b02\u7d73\u71ed\u80e5\u4399\u59f0\u475a\u53a9\u1ed3\ud836\u1dbc\u9504\ue0a8\u0d8f\u3a49".toCharArray();
        cArray11[8] = (char)(cArray11[8] ^ 0x374);
        PdfViewerOptionsPanel.Sg("-1bjqh62", this.imageYesRB, orbhlnlm.y(cArray11, (short)3598, (short)2, true));
        char[] cArray12 = "\ua6c8\u3a29\u9300\u3e89\u6aad\u8c09\uf21c\u3895\ucb17\uc305\ub825\uc3c7\u773e\u9666\u1568\ua4d4\u1526\u69d8\ua09f\u270d\ucb22\u131d\u33a1\u8991\u13cd\u00ba\u7b38\ue040\u588f\uf37e\u88db\uf899\u2948\ud8f5\u28e3\ua74b\u2984\uaafc\u5559\u4711\ue8ee\u44da\u22ee\u8c83\u6b69\u38fe\uc609\uf9b9\uf6b3\u5307\u6531\u0102\u853e\u3af6\u4b3b\u4025\u457f\ud058\u5482\ua421\u3172".toCharArray();
        cArray12[37] = (char)(cArray12[37] ^ 0xFD2);
        PdfViewerOptionsPanel.Sg("-1bjqh62", this.imageNoRB, orbhlnlm.y(cArray12, (short)22953, (short)2, true));
        char[] cArray13 = "\u70c4\u7365\u0245\u61f6\u0089\ub52c\u7644\u4c55\ucdbf\u3ec9\u8915\uc33b\u9e28\u03d9\ud9ff\uab53\uef84\u4246\ud0b1\ua9a0\u555d\u2216\u8455\u0378\ub570\u64ad\uaf69\u03f6\ub616\uce8f\u342c\udaa6\ud906\u2888\ube3f\u1524\u5d91\u5eb0\u2805\ua364\u3b88\udbbe\u7a02\u7343\u4962\u18e5\u2238\ue4bf\u6760\u6f64\u0922\ua02f\u84fe\ue9a0\ubf80\u3893\u63f9\u4652\u7f93\ufb15\ud04c\u58ec\uc98d\uff7e\u4bfb".toCharArray();
        cArray13[5] = (char)(cArray13[5] ^ 0x504C);
        this.appearanceImage = new Image(orbhlnlm.y(cArray13, (short)21209, (short)1, true), parent, this.view);
        char[] cArray14 = "\u0533\u8579\ue15f\u1147\u2edb\uf5a3\u55bb\u31e3\u3202\ube7b\ucf41\u11a1\ued58\uc49e\u0fcf\uc46e\u3929\u474b\ua732\u93b8\u020f\u5fdf\ucaef\uf5a8\u2cfc\uc9d8\u70e3\u1a1b\ua43b\u37ec\u2a8a\uca51\ub37d\u078a\u82bc\u715f\u6842\u2162\u308d\u1959\u3b86\u6219\ub56e\u4858\u595e\u10b0\u38eb\u5107\u3bb3\u22d5\u8cce\uc014\u2125\u79dc\u1389\uc4b1\u3e24\u6442\uadda\u9f3c\ue018\u9fec\u1f85\u4da6\u3609".toCharArray();
        cArray14[45] = (char)(cArray14[45] ^ 0x4B4F);
        PdfViewerOptionsPanel.Sg("-1sjih0a", this.appearanceImage, orbhlnlm.y(cArray14, (short)4143, (short)0, true));
        if (PdfViewerOptionsPanel.Sg("4tdeq3", PdfViewerOptionsPanel.Sg("-1vuch60", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)"")) == false) {
            Object src = PdfViewerOptionsPanel.Sg("-7kih5r", new File((String)PdfViewerOptionsPanel.Sg("7bpeq2", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE)));
            if (src == null) {
                char[] cArray15 = "\u87d7\u9787\u65fc\u91d4\u1c3a\u69b2\u8d4a\u3200\u5324\u47a2\u0a5f\ua0d8\u7150\u0947\u0f8f\u9866\u31b9\u2a53\u38cb\u326c\ud96f\u5342\u4ff1\ubcd3\u59e8\u2a79\u72a1\u3a35\u647f\u5e38".toCharArray();
                cArray15[9] = (char)(cArray15[9] ^ 0x774);
                src = PdfViewerOptionsPanel.Sg("18nhevp", orbhlnlm.y(cArray15, (short)22252, (short)0, true));
            }
            PdfViewerOptionsPanel.Sg("dt3evo", this.appearanceImage, src);
        } else {
            char[] cArray16 = "\uf708\ud67d\ueeb3\u13c2\u3304\ucc49\uf49e\u028f\u4385\u5ae8\uc966\u4f6d\u3a1f\u4097\uda56\ud532\u2d8b\u7526\u516f\u98b0\u3303\uc367\u0c16\ua774\u3e4e\u0f64".toCharArray();
            cArray16[2] = (char)(cArray16[2] ^ 0xF17);
            Object defaultImageId = PdfViewerOptionsPanel.Sg("-1vuch60", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_IMAGE_DEFAULTSOURCE, (Object)orbhlnlm.y(cArray16, (short)24504, (short)4, true));
            char[] cArray17 = "\u0943\u0f8c\u90b8\u4573\u1c05\u9285\uf0d4\uae77\uec64\u87ea\u746a\u20bc\u92a2\uc172\ua18e\ucc97\u23e9\uf260\ua8a1\u6a5a\u001d\uaf52\u3a7e\u0236\u3be7\uc5cc\u45c1\u7809\u5270\u5b44".toCharArray();
            cArray17[28] = (char)(cArray17[28] ^ 0x1B71);
            if (PdfViewerOptionsPanel.Sg("-138uh5s", defaultImageId, orbhlnlm.y(cArray17, (short)21665, (short)3, false)) != false) {
                char[] cArray18 = "\u09b7\u1469\uaf74\u803a\ud8b1\u8985\u9c18\u593b\ue35e\u61bb\u52a1\u32da\udec8\u4aa4\u8a3a\udda2\uc3c6\u1ed3\ube8f\u0609\u11a3\ue08e\u3487\u03e9\u31b6\ud4b0\u73a4\u4a97\uff8c\u1d6e\u5388\u0b7d\u248b\u48c6".toCharArray();
                cArray18[29] = (char)(cArray18[29] ^ 0xE05);
                PdfViewerOptionsPanel.Sg("dt3evo", this.appearanceImage, PdfViewerOptionsPanel.Sg("18nhevp", orbhlnlm.y(cArray18, (short)25506, (short)5, false)));
            } else {
                char[] cArray19 = "\ub5c2\u08cc\uf767\u638c\u5f01\u9a40\uab76\u8e15\ud3b4\ue758\udd6e\u938c\u6979\u4e69\u00ba\u952f\ubc0b\u3fa5\u86b1\u0e03\ubef6\u2b67\uaa1a\u3344\u5d32\u493f\u7c6b\u5b8e\u4008\u304a".toCharArray();
                cArray19[28] = (char)(cArray19[28] ^ 0x74B4);
                PdfViewerOptionsPanel.Sg("dt3evo", this.appearanceImage, PdfViewerOptionsPanel.Sg("18nhevp", orbhlnlm.y(cArray19, (short)21357, (short)1, true)));
            }
        }
        char[] cArray20 = "\u6348\ua050\udb3c\uf286\ue310\ue926\u0b6e\u0f97\u4f23\u6c23\u3e07\u2d47\ub86b\u2cca\u0ec1\u6b9e\uc2ee\u6947\u2f7c\ucc94\uc641\u3099\u40e5\uba95\ub841\u094d\u1f6b\uc8da\ucfff\uc7ed\u8982\u62a3\u8682\ud32f\u7bb0\ua565\u9a11\uea61\ubb5c\uaa18\ua306\u884e\u53fd\u386f\u553e\ube88\ub8ce\u7fa6\ued96\u5e0b\u0019\ud579\u071d\u2351\ua1b9\ufd52\uc354\uc4d5\u6fe3\u596a\ua2c4\ubce4\u7d51m".toCharArray();
        cArray20[28] = (char)(cArray20[28] ^ 0x1530);
        this.modifyImageBtn = new Button(orbhlnlm.y(cArray20, (short)22952, (short)4, true), parent, this.view, () -> {
            char[] cArray = "\u5e75\u864f\udb4a\u399c\u4c3e\u1df8\ud3cd\u924a\u5e45\u1e95\uf8df\u824b\u0b1f\u61a2\uaae0\uc1d8\u4c8b\u8f3b\u73eb\u7e4d\uac6f\uc6ed\u92f8\ubb92\u90aa\u8a1a\u74ac\u74ad\uf730\u84a0\u8312\u9a84\u4e6c\uf32b\u2082".toCharArray();
            cArray[9] = (char)(cArray[9] ^ 0x183D);
            return PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, mxydyrtm.b(cArray, (short)4477, 2, (short)4), (Object[])new Object[0]);
        });
        char[] cArray21 = "\u7b70\u7211\u5957\u1c57\uc4e0\u1344\ud435\u4730\u984a\ue00f\uf214\u8765\u475b\u6dc0\u4b15\u9b81\u3114\ufcf6\ub610\u403b".toCharArray();
        cArray21[14] = (char)(cArray21[14] ^ 0x1F17);
        PdfViewerOptionsPanel.Sg("-nch4n", this.modifyImageBtn, orbhlnlm.y(cArray21, (short)24108, (short)3, true));
        char[] cArray22 = "\uf3fa\u6e24\u0f9b\u1cf3\u30a0\ubf35\u655b\u21c7\uadb2\u4327\u18c3\u056f\uf825\u64f0\uaaf7\u0809\u6f96\u8bf1\u2b18\u9332\u6d61\u17ae\u53f0\u3e03\u8115\uf88a\u5cd6\u34b6\ub642\u0193\ue1cb\uf7c0\u25d8\ub2c9\u2729\u3352\u20a8\u9637\ubea9\ueedf\ua1b4\u8fd7\u0a69\ueee4\u9b8c\u6391\u941c\u284a\ue6eb\u8e80\ue1e7\u14d7\u8512\u464a\ufb84\u8649\u5c91\u4b1a\uae9c\u4906\u20a3\u830b\u3cda\u2d60".toCharArray();
        cArray22[59] = (char)(cArray22[59] ^ 0x3C2D);
        PdfViewerOptionsPanel.Sg("-nch4n", this.modifyImageBtn, orbhlnlm.y(cArray22, (short)29937, (short)4, true));
        PdfViewerOptionsPanel.Sg("-1soah5p", this.imageYesRB, () -> {
            if (PdfViewerOptionsPanel.Sg("-fpkh2q", this.imageYesRB) != false) {
                this.onImageYesSelected();
            }
        });
        PdfViewerOptionsPanel.Sg("-1soah5p", this.imageNoRB, () -> {
            if (PdfViewerOptionsPanel.Sg("-fpkh2q", this.imageNoRB) != false) {
                this.onImageNoSelected();
            }
        });
        char[] cArray23 = "\uc3d9\u3f41\ueb8d\ud767\u4d45".toCharArray();
        cArray23[2] = (char)(cArray23[2] ^ 0x14F0);
        char[] cArray24 = "\uc9fa\ubb89\u185c\ubfa6\u4d52".toCharArray();
        cArray24[3] = (char)(cArray24[3] ^ 0x3D56);
        if (PdfViewerOptionsPanel.Sg("-138uh5s", orbhlnlm.y(cArray23, (short)24123, (short)1, true), PdfViewerOptionsPanel.Sg("-1vuch60", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_IMAGE, (Object)orbhlnlm.y(cArray24, (short)22900, (short)1, true))) == false) {
            PdfViewerOptionsPanel.Sg("e0deq6", this.imageNoRB, false);
            this.onImageNoSelected();
        } else {
            PdfViewerOptionsPanel.Sg("e0deq6", this.imageYesRB, false);
            this.onImageYesSelected();
        }
        PdfViewerOptionsPanel.Sg("tlrer8", this.modifyImageBtn, evt -> this.onModifyImage());
    }

    private void onImageYesSelected() {
        if (this.bufferedImage == null) {
            Object src = null;
            File srcFile = null;
            if (PdfViewerOptionsPanel.Sg("4tdeq3", PdfViewerOptionsPanel.Sg("-1vuch60", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)"")) == false) {
                srcFile = new File((String)PdfViewerOptionsPanel.Sg("-1vuch60", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)""));
                src = PdfViewerOptionsPanel.Sg("-7kih5r", srcFile);
            }
            if (src != null) {
                PdfViewerOptionsPanel.Sg("dt3evo", this.appearanceImage, src);
                try {
                    this.bufferedImage = PdfViewerOptionsPanel.Sg("it1eq9", srcFile);
                }
                catch (IOException ex) {
                    PdfViewerOptionsPanel.Sg("-3f6h4r", logger, PdfViewerOptionsPanel.Sg("182ver2", ex), (Object)ex);
                }
            } else {
                this.loadDefaultImage();
            }
        }
        char[] cArray = "\ub333\ud952\ufb32\ud95d\ucdfa\u8440\u2090\uaa73\u8c28\uebf3\u7bfb\u71ed\uee8b\ubfd6\u76cc".toCharArray();
        cArray[1] = (char)(cArray[1] ^ 0x63FF);
        PdfViewerOptionsPanel.Sg("-jnch5o", this.appearanceImage, qsvcrfhj.b(cArray, (short)10793, (byte)3, 1));
        PdfViewerOptionsPanel.Sg("-juih2l", this.modifyImageBtn, false);
        PdfViewerOptionsPanel.Sg("1h5neta", this.appearanceBuilder, true);
        PdfViewerOptionsPanel.Sg("-e9eh2j", this.appearanceBuilder, this.bufferedImage);
        this.updateAllImages(this.bufferedImage, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultImage() {
        Object tmpImg = null;
        try {
            Object src;
            char[] cArray = "\uce08\u7fb7\ud14a\u1a92\u66e5\udad8\ua618\u03af\u0f48".toCharArray();
            cArray[3] = (char)(cArray[3] ^ 0x69ED);
            char[] cArray2 = "\u8696\u616d\u1452\ude9e\u4cbd".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x38AA);
            tmpImg = PdfViewerOptionsPanel.Sg("-1kt8h2k", mxydyrtm.b(cArray, (short)29248, 1, (short)5), mxydyrtm.b(cArray2, (short)28949, 4, (short)2));
            char[] cArray3 = "\ua8a8\u562e\u4256\u6d3b\ub130\u07fa\u3ddc\uc4cc\u66ac\u0725\ubed0\u1bd1\ub3d1\u8af5\u4b52\uc270\ue79e\u5327\u5ee0\ud98e\ubc8f\u977f\u519c\u2f56\u1dec\u0379".toCharArray();
            cArray3[13] = (char)(cArray3[13] ^ 0x3B7B);
            Object defaultImageId = PdfViewerOptionsPanel.Sg("-1vuch60", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_IMAGE_DEFAULTSOURCE, (Object)mxydyrtm.b(cArray3, (short)11812, 4, (short)4));
            char[] cArray4 = "\ud16d\u13e2\u06f8\u45cc\uc368\u120a\udb6e\u6616\u4fbe\u94f3\u4cee\u6f36\u7e71\u256a\u6c7c\u2165\ubcb8\u1350\ue4d1\ue58b\ua9c6\u87f2\uc05d\ua3cc\u997b\udf07\u470e\uba65\ud1dc\u3ce0".toCharArray();
            cArray4[13] = (char)(cArray4[13] ^ 0x17F9);
            if (PdfViewerOptionsPanel.Sg("-138uh5s", defaultImageId, mxydyrtm.b(cArray4, (short)2896, 3, (short)2)) != false) {
                char[] cArray5 = "\udee0\u7efe\u534c\uf2e6\u45ef\u3bf6\ub998\ufb64\u7a3c\ua58e\ub8b6\u217e\u6613\u83d5\u360a\u0633\u5089\uf238\u3e4e\u1c07\u82c7\ub446\u954b\u9397\u94cc\u76d8\u8a25\ucbe2\u38e3\u8379\u734a\u8942\u1618\u7d42".toCharArray();
                cArray5[26] = (char)(cArray5[26] ^ 0x6EC9);
                src = PdfViewerOptionsPanel.Sg("18nhevp", mxydyrtm.b(cArray5, (short)25676, 0, (short)2));
                char[] cArray6 = "\ucd20\u3b42\uf11d\u3b3d\u6679\u7ce4\uf558\ue002\u76e5\u975c\u44dd\ub280\uc57d\ubab3\u96bd\u008d\u9591\uc168\u0e26\udfb3\u2cda\ud24c\u4afd\u10e2\udff1\u115a\uee0d\u07bb\u7606\ud78d\u99bc\u72ad\u6a77\u3701".toCharArray();
                cArray6[2] = (char)(cArray6[2] ^ 0x22F1);
                PdfViewerOptionsPanel.Sg("7gpetf", mxydyrtm.b(cArray6, (short)8656, 2, (short)1), tmpImg);
            } else {
                char[] cArray7 = "\uf7ad\uf5ac\u7a03\ua97d\u2c9a\u919e\u3bf5\ubae8\u88df\ub4a3\uc358\u67a2\u3011\uf929\u59e5\u1921\u017b\u077b\uf8e2\udc98\uef31\u5b29\u12a1\u772d\ud8b6\u46fa\uaa62\u1a2a\u3fd8\u3151".toCharArray();
                cArray7[13] = (char)(cArray7[13] ^ 0x79F4);
                src = PdfViewerOptionsPanel.Sg("18nhevp", mxydyrtm.b(cArray7, (short)12667, 5, (short)1));
                char[] cArray8 = "\u7b51\uc1de\u70f9\uda70\u2abb\uf7aa\uaec5\u5bb2\uf0c4\u4c3c\uc550\u1a3d\u74be\uf98f\u976c\uf822\u4767\u6841\u5f86\u20a8\uc46a\u5b26\u61fb\u1e56\uc6a1\u6a01\u4d09\u5b1f\u7109\u0411".toCharArray();
                cArray8[26] = (char)(cArray8[26] ^ 0x6B9);
                PdfViewerOptionsPanel.Sg("7gpetf", mxydyrtm.b(cArray8, (short)14362, 5, (short)0), tmpImg);
            }
            PdfViewerOptionsPanel.Sg("dt3evo", this.appearanceImage, src);
            this.bufferedImage = PdfViewerOptionsPanel.Sg("it1eq9", tmpImg);
            PdfViewerOptionsPanel.Sg("-9ceh2i", tmpImg);
        }
        catch (IOException ex) {
            PdfViewerOptionsPanel.Sg("-3f6h4r", logger, PdfViewerOptionsPanel.Sg("182ver2", ex), (Object)ex);
        }
        finally {
            PdfViewerOptionsPanel.Sg("-9ceh2i", tmpImg);
        }
    }

    private void onImageNoSelected() {
        char[] cArray = "\uafb4\u0898\u0b4f\u7c8d\ud1db\u41ae\uae39\u2123\u7d88\ua9c7\u9341\ubecc\u1d8f\u0c44\u7731".toCharArray();
        cArray[8] = (char)(cArray[8] ^ 0x74B7);
        PdfViewerOptionsPanel.Sg("-1sjih0a", this.appearanceImage, mxydyrtm.b(cArray, (short)5377, 0, (short)4));
        PdfViewerOptionsPanel.Sg("-juih2l", this.modifyImageBtn, true);
        PdfViewerOptionsPanel.Sg("1h5neta", this.appearanceBuilder, false);
        PdfViewerOptionsPanel.Sg("-e9eh2j", this.appearanceBuilder, null);
        this.updateAllImages(null, false);
    }

    private void onModifyImage() {
        char[] cArray = "\u362b\uce42\u265a\ubb51\u6046\u1c2c\ub86c\u9bf0\uce1d\u0441_\uc348\ua52c\u3d51\u7980\ua850\u8eac\u74b7\ua9fd\uc37f\u7993\uce5b\u0f8a\ub7e4\u4841\ube5f\u7fca\u6234\u0732\ud94a\u692c\u1a1b\uc622\ud23d\u79a6\u799e\ue7ed\u5ddb\u429f\u8c0e\ubd5a\u7c4c".toCharArray();
        cArray[18] = (char)(cArray[18] ^ 0x64E7);
        FileDialog dialog = new FileDialog(this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, mxydyrtm.b(cArray, (short)17549, 0, (short)1), (Object[])new Object[0]), esecurity.crypto.gui.utils.Constants.APPEARANCE_IMAGE_FORMATS);
        Object file = PdfViewerOptionsPanel.Sg("l9deth", dialog, false);
        if (file != null && !file.isEmpty()) {
            try {
                File imageFile = new File((String)file.get(0));
                PdfViewerOptionsPanel.Sg("dt3evo", this.appearanceImage, PdfViewerOptionsPanel.Sg("-7kih5r", imageFile));
                PdfViewerOptionsPanel.Sg("1h5neta", this.appearanceBuilder, true);
                this.bufferedImage = PdfViewerOptionsPanel.Sg("it1eq9", imageFile);
                PdfViewerOptionsPanel.Sg("-e9eh2j", this.appearanceBuilder, this.bufferedImage);
                this.updateAllImages(this.bufferedImage, true);
            }
            catch (IOException ex) {
                PdfViewerOptionsPanel.Sg("-3f6h4r", logger, PdfViewerOptionsPanel.Sg("182ver2", ex), (Object)ex);
            }
        }
    }

    private void updateAllImages(BufferedImage image, boolean useImage) {
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Sg("-1k7mh2d", PdfViewerOptionsPanel.Sg("-1f5uh2g", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Sg("-1pmh2e", app, useImage);
                PdfViewerOptionsPanel.Sg("1i6repl", app, image);
                PdfViewerOptionsPanel.Sg("bgrepk", app);
            }
        }
    }

    private void drawDateArea(DOMElement parent) {
        char[] cArray = "\u0a27\ub306\u645f\u510d\ucb99\uf918\u70fc\u2ae5\ua6b0\u0e05\u29c5\u3357\u45dd\u6582\uee76\ue06f\u466d\u2422\uab56=\u799f\ufc30\u178f\uaca1\u10f8\ub5a0\u1f7c\u34cb\uc57e\u4ee9\u18b0\u195a\u0c5e\uf453\u88f4\u9910\u79e9\u06b8\ub9bd\ude84\u9265\u1e25\ufed4\u176f\ufb7e\ubacc\u1c50\u94e4\uf581\uf53b\u49e3\uf5f6\uc129\u5172\u72aa\u7695\ua2be\uec39\u6785".toCharArray();
        cArray[37] = (char)(cArray[37] ^ 0x79BB);
        Paragraph dateTitle = new Paragraph(qsvcrfhj.b(cArray, (short)15043, (byte)4, 1), parent, this.view, () -> {
            char[] cArray = "\u9f4e\u4de8\u1863\u6ece\ud26f\u8358\u63f4\ufc49\u0794\u4056\uf1a5\uebaf\u5c4e\u1821\u1b80\u79a7\ud236\ua481\u5804\uc12c\u5264\u87cd\ua759\uf77c\u954a\u1f9c\u5128\u878c\ufaa1\u97cf\uaf29\u7d56\u7279".toCharArray();
            cArray[28] = (char)(cArray[28] ^ 0x518D);
            return PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, qsvcrfhj.b(cArray, (short)21682, (byte)2, 2), (Object[])new Object[0]);
        });
        char[] cArray2 = "\ufa6f\u8b37\uaa73\uad02\u00f7\u9407\u8e6b\ud725\uf242\ud9c6\ub3b8\u7d97\ud65d\u3e3d\ufcab\ub7b3\uf512\u8cec\uaedd\u9a61\u5d98\u9514\ub2a4\u77a4\u685f\u77a5\u6e6c\u9ad9\u4029\u278b\u0e71\u9348\u5bf1\ub19c\u686d\u386d\u04bd\u9d78\u0c1f\u0469\ud445\ubecc\ud84a\uf7a7\u678e\u5a49\u9a6b\u2e51\udf4b\uec09\u5cde\u9679\ufff1\ua009\u2672".toCharArray();
        cArray2[37] = (char)(cArray2[37] ^ 0x5983);
        PdfViewerOptionsPanel.Sg("-1i0sh54", dateTitle, qsvcrfhj.b(cArray2, (short)15028, (byte)3, 5));
        char[] cArray3 = "\u59a6\u50b8\ucf62\u80b7\u8b10\u38fc\ua8fc\u01e3\ue943\u7eba\u5663\u84e6\u6c5f\ub2a4\u937c\u4b11\u03ac\ufa84\u5a5b\u6514\uc398\u4a03\ue349\u6c6d\u4e9c\u5cc7\uefb0\u3f2f\u6c00\ub276\uaec7\u3ccd\uc8b2\u4350\u0233\u6f7e\ucd67\u6259\uf083\u1db1\uc1bb\ub697\u50f9\uac17\u6c1a\u52d4\ub9de\u02f7\ue70a\u2875\u1017\u6edf\ucf44\ubbc9\ua7d6\ub659\u1dcc\u8180\u4853\u72e7\u1a17".toCharArray();
        cArray3[9] = (char)(cArray3[9] ^ 0x401B);
        DivContainer dateDivisor = new DivContainer(qsvcrfhj.b(cArray3, (short)14935, (byte)4, 1), parent, this.view);
        char[] cArray4 = "\u5b86\uabba\ubc9a\ua016\ue613\ubc6d\udf51\u653e\uf080\ud1dd\ueefe\uc3a0\u00a4\uc1c4\u86f0\u7854\u778a\u1c2c\ua6c2\ue76f\udf10\ua04c\uc318\u50dc\ud695\u0dba\u2115\u244d\u49e9\u5ae3\u011d\u1936\ubb17\u8da9\u0dbe\u2d5d\u6e40\uae73\u1646\u5c37\ud792\u1a7a\u95e2\u6357\u0bf9\ue944\u1e08\ua7ab\uc681\ub0c2\uf055\uc300\u1210\u7e1e\u1d17\ufaac\u2da0".toCharArray();
        cArray4[15] = (char)(cArray4[15] ^ 0x1084);
        PdfViewerOptionsPanel.Sg("-1tv2h4j", dateDivisor, qsvcrfhj.b(cArray4, (short)16907, (byte)2, 1));
        char[] cArray5 = "\u1d3c\u1e90\uc145\u434e\u227e\ue7c7\u03df\u36f4\uf79f\uba60\u03a8\u76b4\u4b11\uedb7\u04c9\ud644\uecdc\u82ec\u7e30\uadb0\u6fdd\u6329\uab44\u8fb0\ubdb4\u9672\u384b\u7ee1\u0e88\u10d9\u3370\ua6e2\ue25d\u07d5\ucddf\u015e\u88f1\u2057\u81a3\u6e2f\uf654\uc95a\u837d\u98f3\u428d\u7176\u3621\ufaab\u2f03\u6e1a\u8944\u277c\ueff4\ua9d2\u00e1\u146e\u2714".toCharArray();
        cArray5[8] = (char)(cArray5[8] ^ 0x7535);
        char[] cArray6 = "\ucbf8\u4164\u13f0\u46bb\u4369\u87ce\u3a23\u7ec0\u1ea3\u1e9e\u0f49\uabf2\u07fd\ub29f\u2ff0\u1d2f\ucc77\ua790\u75be\u0a70\u35b3\u112f\uc40d\uec9a\u9723\u8ee9\ubf13\ude83\ub8f7\u6b22\ud22e\u230c".toCharArray();
        cArray6[28] = (char)(cArray6[28] ^ 0x2489);
        char[] cArray7 = "\uad2f\u74e5\uc481\u2b97\u7900\u4335\u7968\u1262\u194b\u5ba2\u64f6\u38b6".toCharArray();
        cArray7[7] = (char)(cArray7[7] ^ 0x3344);
        this.dateYesRB = new CGRadioButton(qsvcrfhj.b(cArray5, (short)16579, (byte)2, 3), parent, this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, qsvcrfhj.b(cArray6, (short)8236, (byte)0, 0), (Object[])new Object[0]), qsvcrfhj.b(cArray7, (short)11897, (byte)4, 5));
        char[] cArray8 = "\ue365\ufb5e\u9fe3\uaf55\u5043\u82e5\u8529\ua5bb\ufedf\ue4ec\ubfa7\ufd22\uc9ee\ud28e\u19a2\u40d0\ud656\uc9cb\u5742\u85dc\u4cea\uce44\u38a9\u6f1f\u2038\uc776\uf435\u6f8e\ua34b\ueaae\u6801\u024c\uec73\u95e1\u5684\uf691\uef50\u1bd6\u8fdb\u1294\u1b2d\u098c\ue139\u4c76\u58d3\u6d66\uf947\ua260\u4098\ufc6a\u9fa4\u8844\ucceb\u9b55\u03d4\u596e".toCharArray();
        cArray8[6] = (char)(cArray8[6] ^ 0x3322);
        char[] cArray9 = "\u9d1c\u6622\u40da\ud9f7\ub0e4\u2dc9\u53a2\u5236\u5ddc\ucee7\u60a7\ufd36\u499f\u4b98\u52e9\uf0f1\u05a0\u71b0\u40d9\u6fba\u2277\uf521\u35b3\u0ae8\u6cbc\u5b6c\u1620\u3910\u6ce2\ufb3a\u3ad0".toCharArray();
        cArray9[7] = (char)(cArray9[7] ^ 0x5B93);
        char[] cArray10 = "\udb97\ud3a3\u3f7e\uefd3\u1da3\ub6a7\uff22\u9b55\uec67\ue017\u61cb\u044b".toCharArray();
        cArray10[7] = (char)(cArray10[7] ^ 0x49D3);
        this.dateNoRB = new CGRadioButton(qsvcrfhj.b(cArray8, (short)29718, (byte)4, 2), parent, this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, qsvcrfhj.b(cArray9, (short)23741, (byte)0, 0), (Object[])new Object[0]), qsvcrfhj.b(cArray10, (short)2614, (byte)1, 4));
        char[] cArray11 = "\u0a63\u3066\ue2b0\u1fd0\u8c7c\uc2fc\u2f93\u5a03\u47d0\u1dbc\u2040\u9f19\uec6a\u3e55\u8d92\u2682\uc78e\ub8cf\ub4f2\u493d\u9263\u3d9e\udfd2\u83bd\u4710\uc375\u39dc\u1bbc\u30d0\ue6b3\ue814\u5b48\u84dd\ufb18\ub6c2\u15cb\u41eb\u47fd\u2cbf\ua08c\ud3ad\u5f85\u3467\u9cd7\ud210\u0139\u4959\u8e68\u6447\uab76\u2d2c\ud416\uac7d\uebe2\u1ec3\u0d87\u1fc0\u6d69\u27a6\u3528\u689a".toCharArray();
        cArray11[48] = (char)(cArray11[48] ^ 0x19B4);
        PdfViewerOptionsPanel.Sg("-1bjqh62", this.dateYesRB, qsvcrfhj.b(cArray11, (short)18262, (byte)2, 5));
        char[] cArray12 = "\u65d0\ue969\u67df\u25bb\u45de\u53b7\udf56\uc4e3\u1ff3\u2c9b\uc3ea\u5b3a\u5f0c\u3270\ud164\ued65\uc2f1\u3494\u49d2\ue322\u08de\uc26e\ueaaf\u08f5\u44b6\u1ee5\u2df7\ubc66\u5690\u0898\u140e\u22e1\u7a90\u00d1\u9399\u8e96\u63f9\u3bc0\ud797\ua8ed\ub032\u5e09\u04c0\u607a\ud4aa\u6954\u5b5b\u5b3e\uc9cb\uac3b\ua7e0\u59e7\ubd1e\u865a\ucd11\u3587\u0109\ubfc9\u3a9a\u7a72\u1002".toCharArray();
        cArray12[1] = (char)(cArray12[1] ^ 0xD84);
        PdfViewerOptionsPanel.Sg("-1bjqh62", this.dateNoRB, qsvcrfhj.b(cArray12, (short)20061, (byte)1, 3));
        PdfViewerOptionsPanel.Sg("-1soah5p", this.dateYesRB, () -> {
            if (PdfViewerOptionsPanel.Sg("-fpkh2q", this.dateYesRB) != false) {
                this.updateAllDates(true);
            }
        });
        PdfViewerOptionsPanel.Sg("-1soah5p", this.dateNoRB, () -> {
            if (PdfViewerOptionsPanel.Sg("-fpkh2q", this.dateNoRB) != false) {
                this.updateAllDates(false);
            }
        });
        char[] cArray13 = "\u45fa\u97ea\u9cab\ue26c\u2201".toCharArray();
        cArray13[1] = (char)(cArray13[1] ^ 0x1F4E);
        char[] cArray14 = "\uada3\uc839\u6a07\ua0fc\u664b".toCharArray();
        cArray14[3] = (char)(cArray14[3] ^ 0x34C2);
        if (PdfViewerOptionsPanel.Sg("-138uh5s", qsvcrfhj.b(cArray13, (short)15410, (byte)1, 3), PdfViewerOptionsPanel.Sg("-1vuch60", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_DATE, (Object)qsvcrfhj.b(cArray14, (short)28677, (byte)4, 2))) == false) {
            PdfViewerOptionsPanel.Sg("e0deq6", this.dateNoRB, false);
            this.updateAllDates(false);
        } else {
            PdfViewerOptionsPanel.Sg("e0deq6", this.dateYesRB, false);
            this.updateAllDates(true);
        }
    }

    private void updateAllDates(boolean showDate) {
        PdfViewerOptionsPanel.Sg("-856h69", this.appearanceBuilder, showDate);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Sg("-1k7mh2d", PdfViewerOptionsPanel.Sg("-1f5uh2g", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Sg("vspepm", app, showDate);
                PdfViewerOptionsPanel.Sg("bgrepk", app);
            }
        }
    }

    private void drawLocationArea(DOMElement parent) {
        char[] cArray = "\u9fe7\uf782\u7cbb\ucb29\u7785\u7784\u7c76\u1026\ub823\ub891\ud919\ue3ec\uad37\ua2a1\ub99c\u52a2\uee23\u337a\ufc4f\u025a\u8816\u3264\ufca0\u61ea\u01de\ud9e9\ud39f\u8608\u0b8a\u2aff\ua924\uada7\u07ae\u8b78\u4994\u1a15\u0ccf\u596d\ud6de\u83ab\u8ba2\uee07\u51af\ub3cb\u0ebf\ub71c\uabb4\ud6cc\ubf07\uc23a\udb4f\ub5ad\u4930\uc014\u59d7\u5b67\ud84d\ua61f\u9b13\u2cdb\u23eb\ud408\u3066".toCharArray();
        cArray[43] = (char)(cArray[43] ^ 0x4500);
        Paragraph locationTitle = new Paragraph(qsvcrfhj.b(cArray, (short)29508, (byte)5, 0), parent, this.view, () -> {
            char[] cArray = "\u046f\u1570\ufe68\ub964\uce16\uc6c3\u58ba\u28be\ua018\uf9e7\u4195\u563d\ua000\u5f34\udf1c\u079f\u7840\ub3a4\u8e46\ubab7\ufbf2\u1ada\u1f48\ub01c\uc699\u19b5\u8816\u8acf\uecea\ub653\uc3e1\u0dc3\u82b2\ufe0a\ua91c\u5d0c\u5913".toCharArray();
            cArray[26] = (char)(cArray[26] ^ 0x26C2);
            return PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, mxydyrtm.b(cArray, (short)12474, 0, (short)1), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u32df\uba59\u45d6\ue479\uf3a7\ucc85\u0ab2\ucf59\ubebf\u9e20\u9a24\u73ac\u8839\u15db\u56da\u43fe\u2934\u8525\ube1b\u2fe3\uc28a\u6c0d\ua9b0\uf56b\ua113\u5c02\ua1a9\u1fce\uc2c5\udeec\u1a47\ue2c1\u51fc\u1d42\u8295\u8dd7\uc9cd\u923a\ud45c\ufdcc\uf715\ubf17\u8b3f\ud895\u7e87\ude4f\u9138\ub2bc\u0eb0\u5d77\ueaeb\u39de\u92e3\ua5e1\u5c48".toCharArray();
        cArray2[13] = (char)(cArray2[13] ^ 0x2213);
        PdfViewerOptionsPanel.Sg("-1i0sh54", locationTitle, qsvcrfhj.b(cArray2, (short)30240, (byte)4, 1));
        char[] cArray3 = "\u60c6\u7d11\u99f2\u7fa5\ub85f\u864f\u218c\u0819\ud527\u6cac\uf6d0\u075d\u0e28\u36b4\u5b83\ud67f\u97b5\u6b37\u77f6\u7e7b\u4610\u5a6d\udce4\u5abf\u3924\u60a6\u40ae\u70f2\ue157\u0f0f\u2487\uaa7d\ub325\ube07\ue67b\uc1ff\u6602\uc161\uc8f0\ub301\u2e96\ud53a\u23dd\u9770\u850c\ua427\u9ea3\u0a37\ua2ce\u0d69\u415d\u4821\u59b3\u4305\u248a\u3a82\u2d2b\u97a2\u0869\u69a3\uef45\uf557\u1d95\u76fe\u6754".toCharArray();
        cArray3[53] = (char)(cArray3[53] ^ 0x2ABD);
        DivContainer locationDivisor = new DivContainer(qsvcrfhj.b(cArray3, (short)26933, (byte)0, 3), parent, this.view);
        char[] cArray4 = "\ufc29\ubdbc\u1557\uedfa\u3051\u198d\u1ca5\u56e9\u925d\u475e\ue83d\u7b86\ud0b9\uc73f\u38fb\ub739\uc239\uf498\u850a\u78bb\u52d7\u63f0\ud59b\u2eaa\u9c3f\ub173\u6355\u4ef6\ueda3\ue806\ubca6\u31a6\u1199\uf39f\u56b7\u8665\u547e\u04ba\u0de9\uc442\ue5ad\ue77b\u5725\ub356\uc836\u94bf\ua80a\u63df\uac0b\u7c30\u3e94\u37fb\u2c68\u135e\u2621\uf5ba\u1a7f".toCharArray();
        cArray4[20] = (char)(cArray4[20] ^ 0x20BF);
        PdfViewerOptionsPanel.Sg("-1tv2h4j", locationDivisor, qsvcrfhj.b(cArray4, (short)6463, (byte)2, 1));
        char[] cArray5 = "\u01c5\u1aa1\u46b7\ua56b\u8690\uc275\u9954\u4a4e\u1f60\u9c2b\ua3e7\u6f16\u314c\u7c68\u3bd7\ud993\u5b88\u7bb4\u4e07\u7a40\u42b4\u15ed\uf852\uc6dd\u721a\ucee5\uf3a1\uff40\ufb5e\u0748\u3e1a\u5f02\u63d2\u3f6c\u14ea\u11af\uacc8\u5dbf\ucb56\uad15\u3d4a\ua221\u0e5f\u9d2f\ua722\u2819\u8871\u8dbe\ucf1d\u15bb\u1aef\u4a04\ua1da\u337b\ubdad\u8e48\u491d\u03c4\ue1be\u2d00\u7b1d".toCharArray();
        cArray5[58] = (char)(cArray5[58] ^ 0x1D03);
        char[] cArray6 = "\ufcea\uc6ba\u4de9\ua352\u8bfa\u0cb7\u3518\ud549\ud00a\u8324\uf0b0\u80aa\ua8f0\u3c60\uc679\ue6e1\ud264\u8473\ub9f5\u9664\ua3fe\ue66e\u31d8\u9459\u282c\u2c86\ub877\u4e11\uaca3\ud2b8\u4050\u04e2".toCharArray();
        cArray6[20] = (char)(cArray6[20] ^ 0x1DF3);
        char[] cArray7 = "\ua931\u50bf\u3245\u19d1\u0495\u138f\ubff3\ud1b6\uc22f\u8c47\uecf0\ube80\uc0a3\u7587\u1d0c\u1fa1".toCharArray();
        cArray7[13] = (char)(cArray7[13] ^ 0xD37);
        this.locationYesRB = new CGRadioButton(qsvcrfhj.b(cArray5, (short)21243, (byte)1, 0), parent, this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, qsvcrfhj.b(cArray6, (short)9302, (byte)1, 3), (Object[])new Object[0]), qsvcrfhj.b(cArray7, (short)11683, (byte)5, 2));
        char[] cArray8 = "\u2102\ud78e\ua9f4\ubd31\u32e7\ue030\udfa2\u54bb\u6db7\ubf6d\u9f05\u9792\u9a1b\u5ea3\ufad8\ue44b\u1a2d\ud03f\ua41c\ub88c\u705a\udddd\u1004\u2f9d\uf52d\u7994\u9885\ufa50\ue08f\ud22e\u3b72\ubc21\ue42d\ub118\ud333\uf000\ub2db\ubd5c\u01b2\u116e\uf4e5\ubfdc\u4f2fO\ud5af\u6703\ubb35\u1a13\u4862\u89a3\ue129\u2598\ua3b2\u2e0f\u9a23\u13cd\u7f00\ue5ba\u964d\u4e22".toCharArray();
        cArray8[41] = (char)(cArray8[41] ^ 0x25A6);
        char[] cArray9 = "\u147c\u2397\u6328\uf8ca\ucdd6\u9606\u4c08\u115a\ue9bc\ubdd1\u0762\u0558\uf952\u7b96\u9b11\ubc26\ufa73\u5589\u3317\u1945\ube95\u3bfc\u453b\u82d0\u74fa\uc2b4\uf277\ub3dc\u85e4\u7910\u587f".toCharArray();
        cArray9[6] = (char)(cArray9[6] ^ 0x219B);
        char[] cArray10 = "\u6b7a\u30c9\u629b\u7906\u0556\u1d06\uefb4\u33bc\u450a\udfbb\u8481\ua860\uca32\u4aeb\u9f4c\u2b7d".toCharArray();
        cArray10[5] = (char)(cArray10[5] ^ 0xEBE);
        this.locationNoRB = new CGRadioButton(qsvcrfhj.b(cArray8, (short)4595, (byte)5, 1), parent, this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, qsvcrfhj.b(cArray9, (short)3340, (byte)1, 3), (Object[])new Object[0]), qsvcrfhj.b(cArray10, (short)16509, (byte)0, 0));
        char[] cArray11 = "\ube39\u7762\ua3c2\uec37\uc1e3\ua87d\u6c9f\ueaac\u3321\ua724\u7e01\uaac8\uc540\ubaf3\ub7ca\u307b\u87ca\u8629\u488a\u8983\ua6a7\uef07\u3c3b\u0019\u3c7f\u8caa\ub976\ua8c7\u9bf4\uf94e\ud040\ub588\u905c\u8e2b\u471f\u9f7d\ucf3c\uae83\ufe4f\ub654\u9903\u91be\uae05\u093e\u6bb5\uf055\u2800\ua458\u1f2a\ud380\u4a0c\u90b8\uaa6c\u3ed7\u686a\uc8e3\u69a8\uea50\u0381\ud17e\u379b".toCharArray();
        cArray11[56] = (char)(cArray11[56] ^ 0x1CCA);
        PdfViewerOptionsPanel.Sg("-1bjqh62", this.locationYesRB, qsvcrfhj.b(cArray11, (short)21177, (byte)3, 2));
        char[] cArray12 = "\uaca7\u12cc\u1741\u59f5\u8aff\uc2ec\u183d\ub9c2\u37cb\uf67c\ubaf5\uf07e\u9f06\u92a4\u54fd\uc035\uf0fd\u5a7f\u93fb\u8769\ua9d8\u273d\ufff7\u5018\ud7b4\u84e4\u4263\u8914\ub554\u3f6b\u931c\u1aa7\u3e83\u9f50\ufad8\ue540\u14d4\u8c6e\u64b6\uc28c\uf21e\ue8d7\u89f4\uf87b\ubfe2\ud7c9\ud942\u20de\u3e80\u1316\u616f\u7c92\u6eed\uade6\u09bc\uc17d\u33c9\u3ef8\u2edf\u9d28\u3fba".toCharArray();
        cArray12[52] = (char)(cArray12[52] ^ 0x6D23);
        PdfViewerOptionsPanel.Sg("-1bjqh62", this.locationNoRB, qsvcrfhj.b(cArray12, (short)31192, (byte)5, 4));
        char[] cArray13 = "\u72e3\u8489\uef4e\u0d42\u24c6\uc4d1\u91dd\u0f16\ue6bb\u5ac2\u19ba\u87d6\uf9ec\ub385\u4353\u19b7\u6e96\u7c33\uf44e\u29e7\uea5c\ub03b\u0463\uec47\u9f26\ubaac\ub8c0\u28b2\uf9aa\u273b\u01b5\u9bbb\ua0eb\u6e78\u4490\u9f2d\u3b82\ufbe7\u1e6a\uf44c\ubfae\u3ffc\u7e14\uaf85\uf73f\u9178\ub893\u6647\u3df1\u566a\u00d0\u7ade\u3ff2\u855c\u0e9a\u8662\u36e6\ub9dd\uaa99\uf958\u8d16\ua48a\u2f96\u5979\u6209".toCharArray();
        cArray13[34] = (char)(cArray13[34] ^ 0x58FB);
        this.locationTextBox = new TextInput(qsvcrfhj.b(cArray13, (short)27711, (byte)1, 5), parent, this.view);
        char[] cArray14 = "\u38ea\u857d\u711b\ufd8d\u9b02\u33ca\u7a65\u1a3e\uf168\u1485\u944a\u62b8\u390f\u8381\u88ad\u2727".toCharArray();
        cArray14[10] = (char)(cArray14[10] ^ 0x7D6A);
        PdfViewerOptionsPanel.Sg("rjnepp", this.locationTextBox, qsvcrfhj.b(cArray14, (short)4431, (byte)2, 4));
        char[] cArray15 = "\u2a07\u5b49\ufb04\u276c\u8290\ua5c3\ud87b\udca0\u4a47\u93c6\u9409\uc2da\u7ff3".toCharArray();
        cArray15[3] = (char)(cArray15[3] ^ 0x2E62);
        PdfViewerOptionsPanel.Sg("rjnepp", this.locationTextBox, qsvcrfhj.b(cArray15, (short)4508, (byte)3, 1));
        PdfViewerOptionsPanel.Sg("1bubepo", this.locationTextBox, obj -> this.updateAllLocations());
        PdfViewerOptionsPanel.Sg("-1soah5p", this.locationYesRB, () -> {
            if (PdfViewerOptionsPanel.Sg("-fpkh2q", this.locationYesRB) != false) {
                PdfViewerOptionsPanel.Sg("-h7uh35", this.locationTextBox, true);
            }
        });
        PdfViewerOptionsPanel.Sg("-1soah5p", this.locationNoRB, () -> {
            if (PdfViewerOptionsPanel.Sg("-fpkh2q", this.locationNoRB) != false) {
                PdfViewerOptionsPanel.Sg("-h7uh35", this.locationTextBox, false);
                PdfViewerOptionsPanel.Sg("-1g2ah36", this.locationTextBox, "");
                PdfViewerOptionsPanel.Sg("-14c2h33", this.appearanceBuilder, "");
            }
        });
        char[] cArray16 = "\u038f\ub187\uc8b8\ua1dd\ue806\u41ad".toCharArray();
        cArray16[2] = (char)(cArray16[2] ^ 0x274F);
        char[] cArray17 = "\ue78e\u024b<\u9c6a\u6a0f".toCharArray();
        cArray17[0] = (char)(cArray17[0] ^ 0x658A);
        if (PdfViewerOptionsPanel.Sg("-138uh5s", qsvcrfhj.b(cArray16, (short)21457, (byte)5, 3), PdfViewerOptionsPanel.Sg("-1vuch60", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_LOCALITA, (Object)qsvcrfhj.b(cArray17, (short)25085, (byte)0, 2))) == false) {
            PdfViewerOptionsPanel.Sg("e0deq6", this.locationYesRB, false);
            PdfViewerOptionsPanel.Sg("-h7uh35", this.locationTextBox, true);
        } else {
            PdfViewerOptionsPanel.Sg("e0deq6", this.locationNoRB, false);
            PdfViewerOptionsPanel.Sg("-h7uh35", this.locationTextBox, false);
            PdfViewerOptionsPanel.Sg("-1g2ah36", this.locationTextBox, "");
            PdfViewerOptionsPanel.Sg("-14c2h33", this.appearanceBuilder, "");
        }
    }

    private void updateAllLocations() {
        Object location = PdfViewerOptionsPanel.Sg("drress", this.locationTextBox);
        PdfViewerOptionsPanel.Sg("-14c2h33", this.appearanceBuilder, location);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Sg("-1k7mh2d", PdfViewerOptionsPanel.Sg("-1f5uh2g", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Sg("-16ouh31", app, location);
            }
        }
    }

    private void drawReasonArea(DOMElement parent) {
        char[] cArray = "\ued83\u4513\u2add\uecfa\u3d62\u7291\ua949\ubb5a\ub201\u1598\u2b86\u1884\u5faa\ud22e\u8cef\udeba\ud4f7\u2808\ue433\u696e\u2f2b\u7bb1\ua9c3\u5549\u6955\u5350\ubd0e\u3a3e\u4d89\u5d39\u695d\u2d35\u4563\u0c68\u65e3\ue5b2\u8077\uff98\u2f4f\uf32f\u8311\u0dd7\u8c7f\uae9a\ube0d\u60ec\n\u81cc\u072b\u80c6\ub4f7\u6460\u2fbe\u5bef\u2ffd\u7967\u11cd\u4334\u7781\u82c0\u0db6".toCharArray();
        cArray[47] = (char)(cArray[47] ^ 0xE03);
        Paragraph reasonTitle = new Paragraph(orbhlnlm.y(cArray, (short)25550, (short)1, true), parent, this.view, () -> {
            char[] cArray = "\uc808\u01bb\u9dec\u2d93\u906d\u9b4e\u176d\u2447\ua606\u018c\u8755\ufaee\u6c6c\u14d8\u79f4\u3050\u3f76\u170d\u16e5\u996c\u2e56\u84a1\ud97a\u764c\udd86\uc02f\uea23\ub1cd\u4cb9\u8c7d\u2adb\uf91b\ue28f\uedf1\u0c20".toCharArray();
            cArray[9] = (char)(cArray[9] ^ 0x7FAE);
            return PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, qsvcrfhj.b(cArray, (short)11154, (byte)2, 2), (Object[])new Object[0]);
        });
        char[] cArray2 = "\uf902\ua1c5\u8b90\u95ff\udfc6\u5e68\ubb81\uddf0\u1549\uc815\uce26\u3126\ub55d\ub4d6\uf981\ue0a2\u92c6\uc3ab\u8a0e\ubd5a\u9a3d\u73f6\uc77a\ubda4\u9d77\u32df\ue045\u3e60\u3373\u9bdf\u0758\u7911\u9f55\ua869\ud2d4\uea55\ub370\u1ac6\uc471\u05c3\ua526\u7703\ub2d2\uf15b\u26be\u8e02\u76ef\ue661\ue15c\ufd28\u8cc0\u8f9b\u02c0\u0667\u1d79".toCharArray();
        cArray2[26] = (char)(cArray2[26] ^ 0x4793);
        PdfViewerOptionsPanel.Sg("-1i0sh54", reasonTitle, orbhlnlm.y(cArray2, (short)10489, (short)4, false));
        char[] cArray3 = "\uddd3\uea45\u519d\u464e\u7297\uc271\uc84a\u4ced\u244a\u665f\ub326\ua714\u3cfd\udf13\u0f86\ua230\u6222\ub0aa\u4222\u9b10\ufec0\u7d6b\u94c2\ud53d\uc622\ub3ad\ua8f9\u68e3\u17de\u44f4\u3b68\u3a12\u5be5\u4825\ub5fa\uf84c\uac0c\u52fe\u6453\u7487\uf2b8\u678b\u9027\u1b5e\ue587\uaf5f\uc34d\u4992\u109d\uf372\u2601\u3656\ufd4d\u643f\u2fd0\u3b8e\u0e00\ubc53\uea1a\ucddf\ub073\u4d15\u6b79".toCharArray();
        cArray3[40] = (char)(cArray3[40] ^ 0x6D87);
        DivContainer reasonDivisor = new DivContainer(orbhlnlm.y(cArray3, (short)27922, (short)5, false), parent, this.view);
        char[] cArray4 = "\u9108\u03fd\u1a46\u1622\ua15e\ud74d\ue039\ucbe9\u0e62\u9a38\u9d80\ud28c\uffd4\ue9bf\u0802\u462c\ub445\u7c30\u7f53\uf689\ub68b\u770b\u0a40\uebab\udd50\u8afc\ud1dd\ub0a0\u9407\uc588\ud947\ud19d\uf8aa\ud13d\u9820\u9dd9\uba45B\u146c\u0f30\u8478\u1d3f\u8578\ued2a\uc7a7\u81ce\ue1b7\u2ed4\u2428\u7775\u2102\u72df\uf040\u2e07\uaf72\ua084\u2917".toCharArray();
        cArray4[53] = (char)(cArray4[53] ^ 0x2E30);
        PdfViewerOptionsPanel.Sg("-1tv2h4j", reasonDivisor, orbhlnlm.y(cArray4, (short)3823, (short)1, false));
        char[] cArray5 = "\ua5fd\udfac\u7846\ua759\u4be6\ua288\u2b91\ufb0c\uabb8\ude33\u6119\udb81\u4398\u1032\uc72a\u1d99\u9a01\u5403\ub6c5\u333e\u75ca\u9e83\u2cf6\u0ab4\u4120\u4622\u5bd3\ua353\u5c82\ub313\u5d18\u6a68\uc759\uff74\u11d1\u1ac0\ube68\u9cc8\u9eb4\u40b9\u8bc5\ud9b5\uf911\ue686\u9ec4\u1aeb\u6cd5\u7ff1\u0582\uf26e\u9377\u0fe9\u7f23\u9a7a\ub9b9\uefed\u8a20\ubff2\u6e2f".toCharArray();
        cArray5[13] = (char)(cArray5[13] ^ 0xDB4);
        char[] cArray6 = "\ueaaf\u5767\u6146\u8766\uda8c\u288d\udec2\u8c3e\u1872\u1a9a\ud373\u8c89\ud31e\u4514\u51a3\u1b4d\u7ab5\u9ea2\u316d\ua40b\ue462\u89ad\ub3ca\u572f\u896c\ubdc1\u467c\u0c28\u73b2\u89ab\uc26a\u200a".toCharArray();
        cArray6[28] = (char)(cArray6[28] ^ 0x4FCE);
        char[] cArray7 = "\u2ede\uf26c\u99fb\uc0e6\uaa41\ua2d4\u157f\u070e\ub720\u06de\ub3ae\u60c4\ub8aa\u7ca2".toCharArray();
        cArray7[10] = (char)(cArray7[10] ^ 0x7858);
        this.reasonYesRB = new CGRadioButton(orbhlnlm.y(cArray5, (short)24276, (short)3, true), parent, this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, orbhlnlm.y(cArray6, (short)22296, (short)2, false), (Object[])new Object[0]), orbhlnlm.y(cArray7, (short)9205, (short)1, true));
        char[] cArray8 = "\u7569\u8d51\u5c24\ucf42\ubb2d\u1da3\u811c\u7b26\u972e\u3a3a\u90e2\u4c26\u9611\ub753\u3752\u7af5\uf18d\u3249\u067e\u2ad4\ue53b\u0320\u96ff\u2a6f\u7e19\ucb2e\ua8da\ubfe5\udfc5\u8a4e\uf92c\u3c55\ub237\uc196\uc084(\ueeb0\u28b5\u2b45\u6149\u10ce\ucf60\uf7b0\u5333\ue15c\uf058\u75f8\u59db\uda30\u2dac\u0fb2\u79a6\ud8f4\u68ee\u70e3\ufd93\u92bf\u24fe\u77ec".toCharArray();
        cArray8[5] = (char)(cArray8[5] ^ 0xD4E);
        char[] cArray9 = "\ua6b2\udfb8\u2fe2\u2eef\u27de\ua857\u516d\u56d3\u5911\u06a8\u1e45\u5d61\ua2b8\u9350\u26fa\u1101\u1535\u2e4d\u1997\ub57e\ub912\u18c1\u6c53\u50fa\ud945\ucd11\u3162\u6b2e\uf156\udc5d\u487c".toCharArray();
        cArray9[5] = (char)(cArray9[5] ^ 0x709B);
        char[] cArray10 = "\uabf0\ud753\u5bf9\u4a64\uaae7\u2314\u34d9\ue69b7\ud2de\u33ba\u181b\u8305\u5663".toCharArray();
        cArray10[6] = (char)(cArray10[6] ^ 0x5AB0);
        this.reasonNoRB = new CGRadioButton(orbhlnlm.y(cArray8, (short)24597, (short)3, false), parent, this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, orbhlnlm.y(cArray9, (short)16828, (short)2, false), (Object[])new Object[0]), orbhlnlm.y(cArray10, (short)13798, (short)4, false));
        char[] cArray11 = "\uc705\u3151\ud7b4\u6885\ue55e\ufea6\ue0be\u9614\u5536\u2364\u0c0a\ua645\u5d70\ub077\u3b92\u3067\u9a19\u65b5\ua00a\u924f\u2db7\uc8ee\u4539\u4314\u102b\u9099\ubd8d\uad9d\ucab3\u27ae\u3184\u078f\u0a7c\ue4e7\ue7c1\u7b9f\u7187\ue5ea\u4cd0\u31e8\u1b4c\u92f3\u7e92\udde2\u2a09\u8d90\u2353\uccc7\ud946\u44a1\u21da\u19be\u6e5f\u0830\u947b\u84f2\uc8e1\uaeb8\ud538\u138e\u5ac9".toCharArray();
        cArray11[52] = (char)(cArray11[52] ^ 0x2E3E);
        PdfViewerOptionsPanel.Sg("-1bjqh62", this.reasonYesRB, orbhlnlm.y(cArray11, (short)22432, (short)2, true));
        char[] cArray12 = "\u91db\u236d\uc555\u366e\u948a\u2333\u4f1c\u1d7a\u95c6\u817e\ucabe\u040b\ub0d9\u8a56\uf34d\u1036\uecd0\u0645\u9d58\u924e\ue7c3\u4717\uff33\u2a6c\uda00\ue883\u487c\u56c0\u20d1\u9cc9\u7a2d\u04d6\u3781\uc218\u6dbc\uac71\u19db\u9f14\u933f\u60eb\u2a04\u84ac\u14cc\u253c\u4c69\u04a6\u7532\u8bb6\u0a34\uf5aa\u2262\u4526\u6768\u4b84\u1e0d\u53b0\u3bf7\ub57a\u08e9\uad55\u5a20".toCharArray();
        cArray12[4] = (char)(cArray12[4] ^ 0x48A);
        PdfViewerOptionsPanel.Sg("-1bjqh62", this.reasonNoRB, orbhlnlm.y(cArray12, (short)23187, (short)3, false));
        char[] cArray13 = "\u8949\u13a0\u70a6\u2345\u8dc9\u203d\ue3e0\u3cfb\u8e23\ud306\uad9d\u489f\u9374\u68a5\u54c6\u00d3\u1205\ud750\udd75\uc7c2\uccd5\ua3dd\u1309\u5a73\u5994\u8ef4\u4b02\uf125\u865d\u5c25\uaa06\ubf8b\ua416\ue87c\ue36a\uc734\u4e26\u820e\ua1f7\u9d2a\u5ada\ud2df\u2de0\u7c66\u328a\u0b6e\ubf5c\u040e\u2e3a\u8b70\uc33e\u9b7d\uf595\udaad\u803a\u28b7\ufd72\u677e\ua26c\u3331\ucfae\udee5\u04e6".toCharArray();
        cArray13[34] = (char)(cArray13[34] ^ 0x684E);
        this.reasonTextBox = new TextInput(orbhlnlm.y(cArray13, (short)24328, (short)3, false), parent, this.view);
        char[] cArray14 = "\u4bc1\ufb55\uc04b\uec3e\u6d98\ubc52\ubdd6\ub748\u1f09\u7fc8\u75aa\u974e\u6fae\u82d4\uf9ae\u4c5e".toCharArray();
        cArray14[2] = (char)(cArray14[2] ^ 0x28F0);
        PdfViewerOptionsPanel.Sg("rjnepp", this.reasonTextBox, orbhlnlm.y(cArray14, (short)23860, (short)1, true));
        char[] cArray15 = "\u6e99\u546f\uae53\u42aa\ue748\u5698\u55ea\u35af\u3a35\u1340\u9f7b\ude29\u14ef".toCharArray();
        cArray15[2] = (char)(cArray15[2] ^ 0x1802);
        PdfViewerOptionsPanel.Sg("rjnepp", this.reasonTextBox, orbhlnlm.y(cArray15, (short)1791, (short)5, false));
        PdfViewerOptionsPanel.Sg("1bubepo", this.reasonTextBox, obj -> this.updateAllReasons());
        PdfViewerOptionsPanel.Sg("-1soah5p", this.reasonYesRB, () -> {
            if (PdfViewerOptionsPanel.Sg("-fpkh2q", this.reasonYesRB) != false) {
                PdfViewerOptionsPanel.Sg("-h7uh35", this.reasonTextBox, true);
            }
        });
        PdfViewerOptionsPanel.Sg("-1soah5p", this.reasonNoRB, () -> {
            if (PdfViewerOptionsPanel.Sg("-fpkh2q", this.reasonNoRB) != false) {
                PdfViewerOptionsPanel.Sg("-h7uh35", this.reasonTextBox, false);
                PdfViewerOptionsPanel.Sg("-1g2ah36", this.reasonTextBox, "");
                PdfViewerOptionsPanel.Sg("-19nkh32", this.appearanceBuilder, "");
            }
        });
        char[] cArray16 = "\u776f\u5131\ubeeb\ufeb0\ua115\u37cb".toCharArray();
        cArray16[2] = (char)(cArray16[2] ^ 0x346D);
        char[] cArray17 = "\u4da7\uc551\ubbf4\u8f3f\u54b0".toCharArray();
        cArray17[0] = (char)(cArray17[0] ^ 0x7153);
        if (PdfViewerOptionsPanel.Sg("-138uh5s", orbhlnlm.y(cArray16, (short)6831, (short)5, true), PdfViewerOptionsPanel.Sg("-1vuch60", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_MOTIVO, (Object)orbhlnlm.y(cArray17, (short)13297, (short)3, true))) == false) {
            PdfViewerOptionsPanel.Sg("e0deq6", this.reasonYesRB, false);
            PdfViewerOptionsPanel.Sg("-h7uh35", this.reasonTextBox, true);
        } else {
            PdfViewerOptionsPanel.Sg("e0deq6", this.reasonNoRB, false);
            PdfViewerOptionsPanel.Sg("-h7uh35", this.reasonTextBox, false);
            PdfViewerOptionsPanel.Sg("-1g2ah36", this.reasonTextBox, "");
            PdfViewerOptionsPanel.Sg("-19nkh32", this.appearanceBuilder, "");
        }
    }

    private void updateAllReasons() {
        Object reason = PdfViewerOptionsPanel.Sg("drress", this.reasonTextBox);
        PdfViewerOptionsPanel.Sg("-19nkh32", this.appearanceBuilder, reason);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Sg("-1k7mh2d", PdfViewerOptionsPanel.Sg("-1f5uh2g", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Sg("3hbet1", app, reason);
            }
        }
    }

    private void drawPreservePdfAArea(DOMElement parent) {
        char[] cArray = "\u5190\u4257\u4e76\u8361\u8768\ua7e0\u302b\u674e\u5ae4\u7238\ue4fa\u4212\ubcef\uf635\u0e50\ud5ce\u2875\ue5ef\u0594\ud7d1\u77a5\u9c10\u6213\u5ea5\u2455\u9efd\u4d5b\ub5e4\u35a2\u3079\u7829\u2ba9\u3ee1\ucc81\u08eb\ucbbe\u1d32\u70a5\u5b84\u3b59\uca9b\u8fe8\u8869\u6cc0\udd00\udace\u9e8a\u1eeb\uda31\u1ab8\ud17f\u052a\ubf93\u9d0c\u091e\ua2c8\ue23b\uad04\u87d0\u8389\u2306\ud3e7\u7b4c\uaaa1\u6464\ud873\u6e1b".toCharArray();
        cArray[64] = (char)(cArray[64] ^ 0x4688);
        Paragraph preservePDFATitle = new Paragraph(mxydyrtm.b(cArray, (short)18121, 0, (short)0), parent, this.view, () -> {
            char[] cArray = "\u4dc7\u2b20\u2043\u7cc4\ue800\ue6a0\uf6cb\u6350\ue8e3\u642e\ufb27\u4790\u124a\u6416\u455d\u0a0d\u1792\ua5a6\u776a\u8ecd\uaab2\u362c\u7b6d\uf78a\u9831\ubb6d\u496d\u016f\ua91b\u1996\uf587\ud018\uadef\u7a4a\u5b8f\ub7ba\u45e4\u4b6c\udec7\u23fd\uff3c\u26ee".toCharArray();
            cArray[17] = (char)(cArray[17] ^ 0x47F4);
            return PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, qsvcrfhj.b(cArray, (short)29603, (byte)4, 0), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u2433\u20c7\u4f50\uc946\ub690\uf52c\uc496\u4911\u16b6\u9a9a\u6b54\uc35b\u3aba\ue379\ud2dc\ud68d\uf9ac\ub093\u6163\uf041\u7f27\u77ce\u48e7\u8cf1\u4592\ube8f\u38e1\ua6d8\udccc\ua8a4\u7f37\ue3f2\uf6dd\ub57b\u2a54\ued96\u6253\u0553\uc695\ubead\u79e4\ueeba\u7bf9\u5445\u3a10\u7095\uc7d1\ufca2\ub809\u28fa\u188d\ub8b8\u61fd\u5a80\u7e21".toCharArray();
        cArray2[40] = (char)(cArray2[40] ^ 0x19B4);
        PdfViewerOptionsPanel.Sg("-1i0sh54", preservePDFATitle, mxydyrtm.b(cArray2, (short)20296, 2, (short)2));
        char[] cArray3 = "\u8027\u5acb\u346c\u6bf2\uce9a\uc0c6\ua2fe\u3f6b\u79d4\uaa04\u4867\u7bad\ue76a\u2d85\u00a0\uea82\ud8b9\u3606\u5667\u2bd5\ue529\u10c4\u575d\ua535\u43ee\uf2ad\u78a7\u9374\uc44b\u38b1\u81cd\ua84f\u3837\u2d86\u223a\uf89f\u1b44\u532c\udee4\u8d6a\u2d43\ua5ef\ue0a8\u8ea8\u8b6d\uf2b7\u169f\u2bb2\u20b6\ub065\u7fac\u2ce2\u5f7e\u6b07\ucb41\u42d9\u0b71\u37a2\u8bff\uc967\ue5fc\uc7bc\uab42\uf227\u77fc\u86b4\uf4ff\u25ad\u68a6".toCharArray();
        cArray3[11] = (char)(cArray3[11] ^ 0x2AB2);
        DivContainer preservePDFADivisor = new DivContainer(mxydyrtm.b(cArray3, (short)9468, 4, (short)1), parent, this.view);
        char[] cArray4 = "\u66db\ued03\u02fc\u2e70\ua11d\ufa78\ude2d\ucefe\u7b6e\u26de\u805d\ue5f4\u9153\u3d3d\u6b47\u1f5a\u1dd1\u59c8\u841d\u4489\u835c\uf2c5\u63b4\ub494\u1cb5\u5926\u515e\uf109\udce8\u895e\ue914\ub808\u253c\u24d9\u62cd\u5f58\u78f9\u5bb1\u9849\u2a85\u117c\ubad8\u10f2\uf88a\ub7f8\u3a0f\ub024\udf97\uab18\u1df7\uf43d\u6d12\u8580\u53e9\uf29f\u3736\u72df".toCharArray();
        cArray4[6] = (char)(cArray4[6] ^ 0x1568);
        PdfViewerOptionsPanel.Sg("-1tv2h4j", preservePDFADivisor, mxydyrtm.b(cArray4, (short)31494, 2, (short)2));
        char[] cArray5 = "\u71ec\uace4\uc328\uf61e\ub69a\u157a\u9559\ua63a\ud5b9\u0fea\u273e\u26e8\ub1d0\u5bcf\u9744\u963f\u73ed\ua06f\u386e\u1b95\u9d8c\uab85\u37c8\uba27\uab0e\ud0c8\u7b0c\u3601\u9ac5\u61ec\uef10\ue734\u9ff3\u1cc7\uece6\u1084\uca79\u22ab\u7643\ud71c\ua51d\u4ca8\u4a6a\u5f3f\ud026\ubc02\ub632\u3c7c\u04bb\uc297\ued15\u1a58\udf60\u0450\u5931\ua5a4\uab15\u06fd\u51ee\ufae6\uc68a\ub26f\u0860\u885b\u0236".toCharArray();
        cArray5[16] = (char)(cArray5[16] ^ 0x1285);
        char[] cArray6 = "\uf4d9\u260f\u77b6\u8dff\uc18f\u1ee7\u4898\u5f2a\u9ff8\ueb80\uec49\u6bd6\uf466\u515d\u7688\u0148\u4426\ue405\u7bfe\ubb52\ub563\ud598\u0667\uefcc\u1d37\u08d3\uee16\u00ec\u99ee\ubef5\ud450\u31ac".toCharArray();
        cArray6[9] = (char)(cArray6[9] ^ 0xFAD);
        char[] cArray7 = "\uad42\u9d03\uc5a2\uf215\ue039\u079d\u03ce\u8091\u7343\u0267\u473f\u0928\ucfcd\ubf64\u8bff\u2bfc\u70d8\u7d66\u1120\u1178".toCharArray();
        cArray7[2] = (char)(cArray7[2] ^ 0x6156);
        this.preservePDFAYesRB = new CGRadioButton(mxydyrtm.b(cArray5, (short)2757, 5, (short)1), parent, this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, mxydyrtm.b(cArray6, (short)17401, 5, (short)5), (Object[])new Object[0]), mxydyrtm.b(cArray7, (short)5190, 2, (short)4));
        char[] cArray8 = "\ua64e\ud67e\u43ed\u218e\ub423\u7f23\u0e08\u9d0f\u7ba9\u173f\u01b2\u235d\u2784\u1611\u0005\u4718\u3d68\uc9c8\u3778\u0e2f\u696a\u76fd\u5c74\u0570\u6342\ueddb\u5237\ub978\u55ac\u0345\ub5e3\ueaa3\u3e2c\u49ac\u41db\uad33\u3829\ucc19\u39d5\u0f59\u5dae\u6a91\u3ef9\u5c18\ub232\u577b\u933d\ude2b\ua748\u5393\ue4c6\ud628\u8ebd\ud1ba\u1c60\ub912\u7a91\u5359\ue116\u7807\u27c2\ub9f5\ub839\u1465".toCharArray();
        cArray8[3] = (char)(cArray8[3] ^ 0x55B6);
        char[] cArray9 = "\u1d02\u24c5\uc016\u14d6\u47d1\uad8f\u155c\u5b92\uf99e\uc2b5\ue158\u171c\u1677\ua01c\u411a\ucdcb\ucde6\uebd2\u7344\ue183\u32fc\u3ec9\u2d2d\ucaa9\uabf3\ud08b\ufe4e\u38ed\uda14\ub4cd\u22ba".toCharArray();
        cArray9[19] = (char)(cArray9[19] ^ 0x1083);
        char[] cArray10 = "\ub664\u7c97\u395c\u68e4\u91a5\u82a7\uc4e0\ub1e3\u31ea\uce14\u5168\u52a9\u8b31\u4b91\u89f8\u3435\u4d7f\u63b0\u0e42\u48c2".toCharArray();
        cArray10[10] = (char)(cArray10[10] ^ 0x1011);
        this.preservePDFANoRB = new CGRadioButton(mxydyrtm.b(cArray8, (short)3652, 0, (short)4), parent, this.view, (String)PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, mxydyrtm.b(cArray9, (short)11012, 2, (short)1), (Object[])new Object[0]), mxydyrtm.b(cArray10, (short)30027, 4, (short)5));
        char[] cArray11 = "\u131b\u40be\ua2a9\u2749\u5d29\u61fb\u070d\ucf1f\uf840\ud644\u0b91\ud6fa\ub1d2\u0fba\uc508\ud5e5\u3641\u7356\u0af3\u24cd\ucd77\u47c1\ud4f1\u527c\u86cc\uce11\ufa59\u8252\ud6a3\u095a\u886d\u78cc\u4aa5\u8fb4\ufe67\u6409\uf75a\ub492\ue9be\u7c62\ue45b\u26c8\u24e6\ueffc\u54c3\ub8be\uff5b\u4653\ub245\ua3ba\u8304\uc0d6\u7e74\u48b7\u9cc8\u7009\u4b59\u2964\u0b45\ubf93\u45a5".toCharArray();
        cArray11[42] = (char)(cArray11[42] ^ 0x36EE);
        PdfViewerOptionsPanel.Sg("-1bjqh62", this.preservePDFAYesRB, mxydyrtm.b(cArray11, (short)25201, 2, (short)4));
        char[] cArray12 = "\u3541\uf73f\u3b5f\u944a\ua88a\ue684\u680b\uf08c\u6656\ud9fb\u97e1\u9407\u213b\u19e8\ub2a3\u14ed\u3f10\ubf5f\u7a05\u519c\u029e\ub514\u3f98\ua912\uf1a2\u3295\ufb62\u89cb\u8783\uba1b\u886b\ub5f0\u36f0\ucf5f\u234e\uf8db\uf6a5\uaf13\ude6e\u65bd\u4464\uc3df\u0a37\u8fe6\u11b1\u84b8\u2d3f\u8398\u49cf\u76c3\ua42f\u9ced\ub949\ud98a\ufc86\ue106\ue44b\u3286\ufa35\u463d\u26ec".toCharArray();
        cArray12[47] = (char)(cArray12[47] ^ 0x40CE);
        PdfViewerOptionsPanel.Sg("-1bjqh62", this.preservePDFANoRB, mxydyrtm.b(cArray12, (short)8458, 3, (short)2));
        PdfViewerOptionsPanel.Sg("-1soah5p", this.preservePDFAYesRB, () -> {
            if (PdfViewerOptionsPanel.Sg("-fpkh2q", this.preservePDFAYesRB) != false) {
                this.updateAllPreservePdfA(true);
            }
        });
        PdfViewerOptionsPanel.Sg("-1soah5p", this.preservePDFANoRB, () -> {
            if (PdfViewerOptionsPanel.Sg("-fpkh2q", this.preservePDFANoRB) != false) {
                this.updateAllPreservePdfA(false);
            }
        });
        char[] cArray13 = "\u356f\uca84\u7f39\u69be\u3383".toCharArray();
        cArray13[1] = (char)(cArray13[1] ^ 0x7DE6);
        char[] cArray14 = "\ucf53\u9824\ub8a4\uafbc\u0dd8".toCharArray();
        cArray14[1] = (char)(cArray14[1] ^ 0x5AA2);
        if (PdfViewerOptionsPanel.Sg("-138uh5s", mxydyrtm.b(cArray13, (short)31812, 0, (short)2), PdfViewerOptionsPanel.Sg("-1vuch60", PdfViewerOptionsPanel.Sg("-18rsh5v"), UserProperties.GRAPHICSIGNATURE_PRESERVEPDFA, (Object)mxydyrtm.b(cArray14, (short)17074, 1, (short)4))) == false) {
            PdfViewerOptionsPanel.Sg("e0deq6", this.preservePDFANoRB, false);
            PdfViewerOptionsPanel.Sg("-1pqkh30", this.appearanceBuilder, false);
        } else {
            PdfViewerOptionsPanel.Sg("e0deq6", this.preservePDFAYesRB, false);
            PdfViewerOptionsPanel.Sg("-1pqkh30", this.appearanceBuilder, true);
        }
    }

    private void updateAllPreservePdfA(boolean preserve) {
        PdfViewerOptionsPanel.Sg("-1pqkh30", this.appearanceBuilder, preserve);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Sg("-1k7mh2d", PdfViewerOptionsPanel.Sg("-1f5uh2g", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Sg("1e5jet3", app, preserve);
                PdfViewerOptionsPanel.Sg("bgrepk", app);
            }
        }
    }

    private void drawVerticalArea(DOMElement optionsContainer, DOMElement optionsArea) {
        char[] cArray = "\u707e\u78ae\u43bb\ua248\uf8ac\u3e04\uc7b7\ucc78\uce27\u9e18\ud37c\ueae1\u5691\ua50a\u5a93\u425c\u2bbd\u89ce\u7c48\u9433\u516e\u56ab\u43e3\ua8ec\u9220\ua109\ua70a\uf69b\u4cc6\u7f4e\u4a34\uf8b3\u5fae\u838c\u75d3\ue161\u9060\u5788\uabf0\u2052\ua652\u13fb\ue408\u20cf\u01d9\uad1e\u4a24\ub3dd\u5bb9\u4314".toCharArray();
        cArray[46] = (char)(cArray[46] ^ 0x5B73);
        DivContainer verticalArea = new DivContainer(mxydyrtm.b(cArray, (short)25887, 2, (short)1), optionsContainer, this.view);
        char[] cArray2 = "\u3503\u9b6e\ubabf\ua293\u8ccd\ud275\u2d39\u11b0\u9a40\u4b9f\u1eb8\u2ee4\u25ef\u6fa9\ucfcb\u6e34\u16c8\udd06\udf48\ub7fc\ub021\u96d4\u6d00\u4799\u8546\ua25a\u7ca0\u3568\u7b1d\u05de\u544f\u30c7\u8b6e\u0da1\uaaa3\uc715\ub4d9\ud4f8\u6989\u867f\u82a6\u7239\uee3e\u3366\u4f02\uaa3c\ue279\ud2fe\uf128\u3cb1".toCharArray();
        cArray2[22] = (char)(cArray2[22] ^ 0x238C);
        PdfViewerOptionsPanel.Sg("-1tv2h4j", verticalArea, mxydyrtm.b(cArray2, (short)18903, 3, (short)2));
        char[] cArray3 = "\u7af9\u7522\u26a0\u1f09\u93c2\uddcc\ube13\u7f99\u1cc5\u309d\ue500\uec0f\u497c\ud65c\u140e\uf417\u711d\u7a03\ube89\u8249\u0619\uc038\u831a\u243a\uad4d\u7fd8\uddc4\u097c\u10d2\u7246\ubaf5\u7260\u9485\u2763\uccde\u97e2\uecb7\u2de7\ue281\uc999\u3d37\uf31e\u6907\uda4a\u644c\u8716\u9078\u6ff6\uaea7\u11e6".toCharArray();
        cArray3[1] = (char)(cArray3[1] ^ 0x527);
        Paragraph optionsLabel = new Paragraph(mxydyrtm.b(cArray3, (short)16818, 2, (short)1), (DOMElement)verticalArea, this.view, () -> {
            char[] cArray = "\u18f5\u245c\uae4a\ua315\ue2a4\uea96\u0cc8\u18db\u63c1\ufca5\uf2b7\u2cc0\u3aff\u1d87\u31a9\u7733\uf8ed\u5947\u553c\u801c\ud64d\u4cb0\ua166\u6c1c\u1569\u2f18\u5b89".toCharArray();
            cArray[22] = (char)(cArray[22] ^ 0x78A0);
            return PdfViewerOptionsPanel.Sg("-1fsgh4h", i18n, qsvcrfhj.b(cArray, (short)14224, (byte)4, 0), (Object[])new Object[0]);
        });
        char[] cArray4 = "\ue61b\u8d9d\u3f67\u6ed5\ubef7\u3df2\u0b8e\udffd\u3cd6\u75a3\u180c\u86ee\uc1bf\uaacf\u917c\u23a6\uee05\u8fdd\u7fa1\u8b24\u388d\ub311\ue6bd\u450e\u0d7d\uc106\uf7e0\u66ca\u1d3a\ua635\u85f3\u68a9\ucb17\u768c\ue29c\uc6af\u6fc8\ub44e\ue4aa\u0308\uf697\u62cd\u1bb6\u8a26\u9280\ue543\u0e5e\u93d9\u34f1\u75ec".toCharArray();
        cArray4[27] = (char)(cArray4[27] ^ 0x436E);
        PdfViewerOptionsPanel.Sg("-1i0sh54", optionsLabel, mxydyrtm.b(cArray4, (short)1815, 4, (short)0));
        char[] cArray5 = "\uc245\u488b\u90cb\uf83f\u5fcd\u6c16\ufcdc\u6815\u52bd\u3279\u24dd\u4ca0\uacd2\u3960\ucfb6\u4985\ufcd5\u58da\ucbad\u5904\uce13\ucbc0\u6e07\ub988\ufb44\u3090\u87e0\u2356\ub2a6\u45bc\ue0fc\ua956\u8d5e\uc2b3\u7eac\u2967\u78c8\u3258\u0583\ueb4d\ub369\u2e98\u6778\ube1e\u9973\u363f\u95ae\u21b1\u6748\uede6\u9037\u4ec2\u6994".toCharArray();
        cArray5[39] = (char)(cArray5[39] ^ 0x71FA);
        SpanContainer verticalAligner = new SpanContainer(mxydyrtm.b(cArray5, (short)14973, 3, (short)3), (DOMElement)verticalArea, this.view);
        char[] cArray6 = "\u543d\u8924\u2900\u0148\u657e\u32e2\u0a9d\ub242\u3aad\ua383\uac29\u6650\uc6e9\ufa20\uf248\u8934\u10d3\u1f1d\u36e0\udd3c\ud5c6\u3f1d\u5492\uf7f1\u0daa\u804e\u8ed9\u6f2b\u49f2\u48dd\u7d76\uada7\u75c9\u723f\u3d7f\u3165\ua865\u346c\u76ca\u1b33\uebe6\uac91\u7c44\ua2b2\u11e8\u6b39\uc8ec\ua7d1\u94c4\uc9a9\u6595\u9c5b\u5e96".toCharArray();
        cArray6[18] = (char)(cArray6[18] ^ 0x14CC);
        PdfViewerOptionsPanel.Sg("-15kih2u", verticalAligner, mxydyrtm.b(cArray6, (short)2711, 3, (short)5));
        char[] cArray7 = "\ua47d\u584e\u87de\u204f\ua004\uc59e\u6815\u6975\uee36\u7a56\u7691\ucf1f\ub8b5\u5937\ua215\u3d57\u79dd\u1c73\u3f8d\uc5d7\ue919\u3b8b\u134f\u2c31\ue3bc\u42bd\u803b\u7861\u6667\udc94\uf035\ufe3b\u0e6f\ua8cf\u2901\u0623\uecb0\u53a6\u3a00\u1603\u9230\ua940\u74df\u98cb\ue3f7\u3485\ubc84\u0f20\u3e37".toCharArray();
        cArray7[17] = (char)(cArray7[17] ^ 0x7142);
        Image toggleOptions = new Image(mxydyrtm.b(cArray7, (short)16399, 2, (short)3), (DOMElement)verticalArea, this.view);
        char[] cArray8 = "\u25b1\u6825\u033c\u8fc6\uf8d2\u20da\u0241\u60e4\udcc0\u2c0b\ud845\u51db\u7e0d\u3f58\u3719\u66f8\u1d85\u8fb4\ua8fe\ua9e2\u0d3b\u751e\u460e\u39ea\u2689\u0374\u3384\u8f5c\u244b\u35e5\u3ee8\u4bef\uafb9\u49ed\u1bdc\uea78\ubd65\uf011\ua214\uefe9\u96cd\u56d9\ue3df\u0396\u8913\ufa5c\u7dbf\u7311\u734c".toCharArray();
        cArray8[40] = (char)(cArray8[40] ^ 0x3047);
        PdfViewerOptionsPanel.Sg("-1sjih0a", toggleOptions, mxydyrtm.b(cArray8, (short)25723, 0, (short)2));
        PdfViewerOptionsPanel.Sg("dt3evo", toggleOptions, ARROW_LEFT);
        PdfViewerOptionsPanel.Sg("-11j4h2r", verticalArea, evt -> {
            this.isOptionsVisible = !this.isOptionsVisible;
            PdfViewerOptionsPanel.Sg("-1h48h2p", optionsArea, this.isOptionsVisible);
            if (this.isOptionsVisible) {
                PdfViewerOptionsPanel.Sg("dt3evo", toggleOptions, ARROW_RIGHT);
            } else {
                PdfViewerOptionsPanel.Sg("dt3evo", toggleOptions, ARROW_LEFT);
            }
        });
    }

    public void remove() {
        if (this.imageYesRB != null) {
            PdfViewerOptionsPanel.Sg("-149ah2s", this.imageYesRB);
        }
        if (this.imageNoRB != null) {
            PdfViewerOptionsPanel.Sg("-149ah2s", this.imageNoRB);
        }
        if (this.dateYesRB != null) {
            PdfViewerOptionsPanel.Sg("-149ah2s", this.dateYesRB);
        }
        if (this.dateNoRB != null) {
            PdfViewerOptionsPanel.Sg("-149ah2s", this.dateNoRB);
        }
        if (this.locationYesRB != null) {
            PdfViewerOptionsPanel.Sg("-149ah2s", this.locationYesRB);
        }
        if (this.locationNoRB != null) {
            PdfViewerOptionsPanel.Sg("-149ah2s", this.locationNoRB);
        }
        if (this.reasonYesRB != null) {
            PdfViewerOptionsPanel.Sg("-149ah2s", this.reasonYesRB);
        }
        if (this.reasonNoRB != null) {
            PdfViewerOptionsPanel.Sg("-149ah2s", this.reasonNoRB);
        }
        if (this.preservePDFAYesRB != null) {
            PdfViewerOptionsPanel.Sg("-149ah2s", this.preservePDFAYesRB);
        }
        if (this.preservePDFANoRB != null) {
            PdfViewerOptionsPanel.Sg("-149ah2s", this.preservePDFANoRB);
        }
    }

    static {
        char[] cArray = "\u9a3d\u00e3\ub529\u51cb\u4140\ue29a\ube8f\u0bc5\u0825\ua60d\u3583\ua041\ud225\u6c05\u0dc2\u281e\uc577\ua13e\u5287\u250b\u116c\u81c3\u9259\u1597\uee84\udc3e\u7e6d\u4959\ubda6\ud50d\ub954\u3029\ua332\ue4c7\u459b".toCharArray();
        cArray[13] = (char)(cArray[13] ^ 0x6F1F);
        i18n = PdfViewerOptionsPanel.Sg("j15epv", mxydyrtm.b(cArray, (short)1201, 1, (short)1));
        char[] cArray2 = "\ua067\ub84d\ub516\u88da\uca8e\u2068\uc895\u97a0\u0bd4\u26a6\u4828\u53ae".toCharArray();
        cArray2[5] = (char)(cArray2[5] ^ 0x6F83);
        ARROW_LEFT = PdfViewerOptionsPanel.Sg("18nhevp", mxydyrtm.b(cArray2, (short)21901, 2, (short)3));
        char[] cArray3 = "\ufc96\u5811\u0ceb\u7153\u112f\ud9c7\u6399\u7414\u4c56\uddbd\u5302\u5163".toCharArray();
        cArray3[0] = (char)(cArray3[0] ^ 0x1B63);
        ARROW_RIGHT = PdfViewerOptionsPanel.Sg("18nhevp", mxydyrtm.b(cArray3, (short)2218, 2, (short)0));
    }

    private static Object Sg(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(jduoguzh.P(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

