/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.generator;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.asic.generator.ASiCGeneratorOptions;
import it.actalis.ellips.capi.asic.generator.ASiCUpdater;
import it.actalis.ellips.capi.asic.utils.ASiCCommonUtils;
import it.actalis.ellips.capi.asic.utils.MetaInfSignatureInfo;
import it.actalis.ellips.capi.asic.utils.xml.ASiCXMLUtils;
import it.actalis.ellips.capi.cms.CadesSignatureGenerator;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.container.ContainerGenerator;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.util.ClonerInputStream;
import it.actalis.ellips.capi.xades.XadesSignatureGenerator;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public class ASiCGenerator
extends ContainerGenerator<ASiCGeneratorOptions, SignatureOptions> {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private List<a> b;
    private boolean c;
    private File d;
    private Map<byte[], MetaInfSignatureInfo> e;
    private ZipOutputStream f;
    private ASiCGeneratorOptions g;

    private String a() {
        switch (this.g.getAsicOpts().getSignatureType()) {
            case CADES: {
                return "META-INF/signature.p7s";
            }
            case XADES: {
                return "META-INF/signatures.xml";
            }
            case TIMESTAMP: {
                return "META-INF/timestamp.tst";
            }
        }
        return null;
    }

    protected void specificValidateOptions(ASiCGeneratorOptions aSiCGeneratorOptions) throws CapiException {
        if (aSiCGeneratorOptions.getAsicOpts().getFormat() == null) {
            throw new CapiException("ASiC options: desired ASiC format is null.", 1001);
        }
        if (aSiCGeneratorOptions.getAsicOpts().getSignatureType() == null) {
            throw new CapiException("ASiC options: desired signature type is null.", 1001);
        }
        if (aSiCGeneratorOptions.getAsicOpts().getFormat() == ASiCFormat.SIMPLE && aSiCGeneratorOptions.getSignEntriesOptions().size() != 1) {
            throw new CapiException("ASiC options: ASiC-S format detected, but more than one signing entry is specified.", 1002);
        }
        this.g = aSiCGeneratorOptions;
    }

    protected void specificValidateEntryOptions(SignatureOptions signatureOptions) throws CapiException {
        if (signatureOptions.getSignatureMode() == null) {
            signatureOptions.setSignatureMode(SignatureMode.DETACHED);
        }
        if (signatureOptions.getSignatureMode() != SignatureMode.DETACHED) {
            throw new CapiException("ASiC options: signing entry signature mode is not detached! In ASiC, only detached is supported. If you want you can pass null as signature mode and the container generator will handle the rest for you.", 1002);
        }
        if (this.g.getAsicOpts().getSignatureType() != ASiCSignatureType.TIMESTAMP) {
            if (signatureOptions.getAlias() == null) {
                throw new CapiException("ASiC options: signing entry alias is null.", 1001);
            }
            if (signatureOptions.getSignatureMode() == null) {
                signatureOptions.setSignatureMode(SignatureMode.DETACHED);
            }
        }
        if (this.g.getAsicOpts().getSignatureType() == ASiCSignatureType.TIMESTAMP) {
            if (signatureOptions.getTimeStampOptions() == null) {
                throw new CapiException("ASiC options: signature type is timestamp, but no timestamp options are specified.", 1002);
            }
            if (signatureOptions.getTimeStampOptions().getTSAClient() == null) {
                throw new CapiException("ASiC options: signature type is timestamp, but no timestamp client is specified.", 1002);
            }
        }
    }

    protected void specificPreProcessEntries(ASiCGeneratorOptions object) throws CapiException {
        try {
            Object object2 = this.g.getOutDoc();
            this.f = new ZipOutputStream(object2.getAsOutputStream());
            this.f.setComment("mimetype=" + (this.g.getAsicOpts().getFormat() == ASiCFormat.SIMPLE ? "application/vnd.etsi.asic-s+zip" : "application/vnd.etsi.asic-e+zip"));
            object = ASiCCommonUtils.getMimeTypeForFormat(object.getAsicOpts().getFormat()).getBytes();
            object2 = new CRC32();
            object2.update((byte[])object);
            this.f.setMethod(0);
            ZipEntry zipEntry = new ZipEntry("mimetype");
            zipEntry.setSize(((ASiCGeneratorOptions)object).length);
            zipEntry.setCompressedSize(((ASiCGeneratorOptions)object).length);
            zipEntry.setCrc(((CRC32)object2).getValue());
            this.f.putNextEntry(zipEntry);
            this.f.write((byte[])object);
            this.f.setMethod(8);
            this.e = new HashMap<byte[], MetaInfSignatureInfo>();
            return;
        }
        catch (IOException iOException) {
            try {
                this.f.close();
            }
            catch (IOException iOException2) {
                a.error("Unable to close ZIP output stream.", (Throwable)iOException2);
            }
            throw new CapiException("IOException occurred: ", 1003, (Throwable)iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void specificPackEntry(SignatureOptions signatureOptions) throws CapiException {
        try {
            void var3_12;
            Object object2 = signatureOptions;
            Object object3 = this;
            boolean bl = true;
            Object object4 = object2;
            if (object4.getInput().getName() == null) {
                object2 = TmpFileUtils.createTempFile((String)"asic_", (String)"");
                File object5 = new File(((File)object2).getName());
                ((File)object2).delete();
            } else {
                File file = new File(object4.getInput().getName());
            }
            object3.b = new ArrayList<a>();
            object3.c = false;
            object3.d = null;
            object3.b.add(new a((ASiCGenerator)((Object)object3), (File)var3_12, object4.getInput().getInputAsNewStream(), 0));
            for (a a2 : this.b) {
                Object sAXException;
                object3 = a2.a;
                object2 = object3;
                object3 = this;
                object3 = null;
                object3 = ((File)object2).getName();
                object2 = new ZipEntry((String)object3);
                this.f.putNextEntry((ZipEntry)object2);
                object2 = new ByteArrayOutputStream();
                ClonerInputStream clonerInputStream = new ClonerInputStream((InputStream)new BufferedInputStream(a2.b), (OutputStream)this.f);
                byte[] byArray = null;
                try {
                    block77: {
                        Object object;
                        block76: {
                            if (!this.g.getAsicOpts().getFormat().equals((Object)ASiCFormat.SIMPLE)) break block76;
                            switch (this.g.getAsicOpts().getSignatureType()) {
                                case CADES: {
                                    object = DataHandlerBuilder.get().setInputStream((InputStream)clonerInputStream).buildInput();
                                    sAXException = new CadesSignatureGenerator();
                                    CadesSignatureOptions cadesSignatureOptions = new CadesSignatureOptions();
                                    cadesSignatureOptions.setKeyStore(signatureOptions.getKeyStore());
                                    cadesSignatureOptions.setKeyStorePassword(signatureOptions.getKeyStorePassword());
                                    cadesSignatureOptions.setAlias(signatureOptions.getAlias());
                                    cadesSignatureOptions.setSignatureMode(SignatureMode.DETACHED);
                                    cadesSignatureOptions.setSignatureLevel(signatureOptions.getSignatureLevel());
                                    if (signatureOptions.getSignatureLevel() != SignatureLevel.BES) {
                                        cadesSignatureOptions.setTimeStampOptions(signatureOptions.getTimeStampOptions());
                                        cadesSignatureOptions.setCertdb(signatureOptions.getCertdb());
                                    }
                                    cadesSignatureOptions.setInput(object);
                                    cadesSignatureOptions.setOutput(DataHandlerBuilder.get().setOutputStream((OutputStream)object2).buildOutput());
                                    cadesSignatureOptions.setDerEncoded(true);
                                    cadesSignatureOptions.setDigestAlgorithm(signatureOptions.getDigestAlgorithm());
                                    sAXException.sign((SignatureOptions)cadesSignatureOptions);
                                    break block77;
                                }
                                case TIMESTAMP: {
                                    object = signatureOptions.getTimeStampOptions().getTSAClient().stamp((InputStream)clonerInputStream, signatureOptions.getTimeStampOptions());
                                    object = new TimeStampToken((byte[])object);
                                    ((OutputStream)object2).write(object.toByteArray(false, true));
                                    byArray = object.getHashedMessage();
                                    break block77;
                                }
                                case XADES: {
                                    object = DataHandlerBuilder.get().setInputStream((InputStream)clonerInputStream).buildInput();
                                    sAXException = new XadesSignatureGenerator();
                                    CadesSignatureOptions cadesSignatureOptions = new XadesSignatureOptions();
                                    cadesSignatureOptions.setKeyStore(signatureOptions.getKeyStore());
                                    cadesSignatureOptions.setKeyStorePassword(signatureOptions.getKeyStorePassword());
                                    cadesSignatureOptions.setAlias(signatureOptions.getAlias());
                                    cadesSignatureOptions.setSignatureMode(SignatureMode.DETACHED);
                                    cadesSignatureOptions.setSignatureLevel(signatureOptions.getSignatureLevel());
                                    if (signatureOptions.getSignatureLevel() != SignatureLevel.BES) {
                                        cadesSignatureOptions.setTimeStampOptions(signatureOptions.getTimeStampOptions());
                                        cadesSignatureOptions.setCertdb(signatureOptions.getCertdb());
                                    }
                                    cadesSignatureOptions.setInput(object);
                                    cadesSignatureOptions.setOutput(DataHandlerBuilder.get().setOutputStream((OutputStream)object2).buildOutput());
                                    cadesSignatureOptions.setDigestAlgorithm(signatureOptions.getDigestAlgorithm());
                                    sAXException.sign((SignatureOptions)cadesSignatureOptions);
                                    object2 = ASiCXMLUtils.augmentXadesSignature((ByteArrayOutputStream)object2);
                                    break block77;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Invalid signature type has been specified.");
                                }
                            }
                        }
                        if (this.g.getAsicOpts().getFormat().equals((Object)ASiCFormat.EXTENDED)) {
                            switch (this.g.getAsicOpts().getSignatureType()) {
                                case CADES: {
                                    object = DataHandlerBuilder.get().setInputStream((InputStream)clonerInputStream).buildInput();
                                    sAXException = DigestUtils.getDigest((String)signatureOptions.getDigestAlgorithm().toString());
                                    byArray = DigestUtils.updateDigest((MessageDigest)sAXException, (InputStream)object.getInputAsNewStream()).digest();
                                    break;
                                }
                                case TIMESTAMP: {
                                    object = DataHandlerBuilder.get().setInputStream((InputStream)clonerInputStream).buildInput();
                                    byArray = DigestUtils.sha256((InputStream)object.getInputAsNewStream());
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Invalid signature type has been specified.");
                                }
                            }
                        }
                    }
                    ((OutputStream)object2).flush();
                }
                catch (CapiException capiException) {
                    sAXException = capiException;
                    throw capiException;
                }
                catch (XMLStreamException iOException) {
                    throw new CapiException("Inner exception: ", 1003, (Throwable)iOException);
                }
                catch (ParserConfigurationException iOException) {
                    throw new CapiException("Inner exception: ", 1003, (Throwable)iOException);
                }
                catch (SAXException malformedURLException) {
                    throw new CapiException("Inner exception: ", 1003, (Throwable)malformedURLException);
                }
                catch (TransformerException transformerException) {
                    throw new CapiException("Inner exception: ", 1003, (Throwable)transformerException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    a.error(fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
                }
                catch (MalformedURLException malformedURLException) {
                    a.error(malformedURLException.getMessage(), (Throwable)malformedURLException);
                }
                catch (KeyStoreException keyStoreException) {
                    a.error(keyStoreException.getMessage(), (Throwable)keyStoreException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    a.error(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    a.error(unrecoverableKeyException.getMessage(), (Throwable)unrecoverableKeyException);
                }
                catch (KeyManagementException keyManagementException) {
                    a.error(keyManagementException.getMessage(), (Throwable)keyManagementException);
                }
                catch (URISyntaxException uRISyntaxException) {
                    a.error(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
                }
                finally {
                    try {
                        clonerInputStream.close();
                    }
                    catch (IOException keyStoreException) {
                        a.error("Unable to close input cloner stream.", (Throwable)keyStoreException);
                    }
                    try {
                        ((ByteArrayOutputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        a.error("Unable to close META-INF output stream.", (Throwable)iOException);
                    }
                }
                sAXException = new MetaInfSignatureInfo();
                ((MetaInfSignatureInfo)sAXException).setDataFilename((String)object3);
                ((MetaInfSignatureInfo)sAXException).setDigestValue(byArray);
                ((MetaInfSignatureInfo)sAXException).setDigestMethod(signatureOptions.getDigestAlgorithm());
                this.e.put(((ByteArrayOutputStream)object2).toByteArray(), (MetaInfSignatureInfo)sAXException);
                object3 = this;
                object3.g.getAsicOpts().getFormat();
            }
            return;
        }
        catch (IOException iOException) {
            throw new CapiException("IOException occurred.", 1003, (Throwable)iOException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void specificPostProcessEntries(ASiCGeneratorOptions object) throws CapiException {
        block43: {
            Iterator<Map.Entry<byte[], MetaInfSignatureInfo>> iterator;
            int n;
            block42: {
                try {
                    n = 0;
                    if (this.g.getAsicOpts().getFormat().equals((Object)ASiCFormat.SIMPLE)) {
                        iterator = this.e.entrySet().iterator();
                        break block42;
                    }
                    if (!this.g.getAsicOpts().getFormat().equals((Object)ASiCFormat.EXTENDED)) break block43;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    String string = this.a();
                    Object object2 = MessageFormat.format("META-INF/ASiCManifest{0,number,#}.xml", 1);
                    ZipEntry zipEntry = new ZipEntry((String)object2);
                    this.f.putNextEntry(zipEntry);
                    CacheOutputStream cacheOutputStream = new CacheOutputStream();
                    Object object3 = XMLOutputFactory.newInstance();
                    object2 = ((XMLOutputFactory)object3).createXMLStreamWriter((OutputStream)cacheOutputStream, "UTF-8");
                    ASiCXMLUtils.startManifest((XMLStreamWriter)object2);
                    ASiCXMLUtils.completeSigRef((XMLStreamWriter)object2, string, this.g.getAsicOpts().getSignatureType());
                    for (Map.Entry entry : this.e.entrySet()) {
                        MetaInfSignatureInfo metaInfSignatureInfo = (MetaInfSignatureInfo)entry.getValue();
                        ASiCXMLUtils.completeDataObjRef((XMLStreamWriter)object2, metaInfSignatureInfo.getDataFilename(), metaInfSignatureInfo.getDigestMethod(), Base64.toBase64String((byte[])metaInfSignatureInfo.getDigestValue()));
                    }
                    ASiCXMLUtils.endManifest((XMLStreamWriter)object2);
                    object2.flush();
                    object2.close();
                    object3 = new ClonerInputStream((InputStream)new BufferedInputStream(cacheOutputStream.getCache()), (OutputStream)this.f);
                    SignatureOptions signatureOptions = (SignatureOptions)this.g.getSignEntriesOptions().get(0);
                    switch (this.g.getAsicOpts().getSignatureType()) {
                        case CADES: {
                            InputHandler inputHandler = DataHandlerBuilder.get().setInputStream((InputStream)object3).buildInput();
                            object2 = new CadesSignatureGenerator();
                            zipEntry = new CadesSignatureOptions();
                            zipEntry.setKeyStore(signatureOptions.getKeyStore());
                            zipEntry.setKeyStorePassword(signatureOptions.getKeyStorePassword());
                            zipEntry.setAlias(signatureOptions.getAlias());
                            zipEntry.setSignatureMode(SignatureMode.DETACHED);
                            zipEntry.setSignatureLevel(signatureOptions.getSignatureLevel());
                            if (signatureOptions.getSignatureLevel() != SignatureLevel.BES) {
                                zipEntry.setTimeStampOptions(signatureOptions.getTimeStampOptions());
                                zipEntry.setCertdb(signatureOptions.getCertdb());
                            }
                            zipEntry.setInput(inputHandler);
                            zipEntry.setOutput(DataHandlerBuilder.get().setOutputStream((OutputStream)byteArrayOutputStream).buildOutput());
                            zipEntry.setDerEncoded(true);
                            zipEntry.setDigestAlgorithm(signatureOptions.getDigestAlgorithm());
                            object2.sign((SignatureOptions)zipEntry);
                            break;
                        }
                        case TIMESTAMP: {
                            byte[] byArray = signatureOptions.getTimeStampOptions().getTSAClient().stamp((InputStream)object3, signatureOptions.getTimeStampOptions());
                            TimeStampToken timeStampToken = new TimeStampToken(byArray);
                            byteArrayOutputStream.write(timeStampToken.toByteArray(false, true));
                            break;
                        }
                    }
                    zipEntry = new ZipEntry(string);
                    this.f.putNextEntry(zipEntry);
                    byteArrayOutputStream.flush();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    try {
                        int n2;
                        while ((n2 = ((InputStream)byteArrayInputStream).read()) >= 0) {
                            this.f.write((byte)n2);
                        }
                    }
                    catch (IOException iOException) {
                        object2 = iOException;
                        throw iOException;
                    }
                    finally {
                        try {
                            ((InputStream)byteArrayInputStream).close();
                        }
                        catch (IOException iOException) {
                            a.error("Unable to close META-INF input stream.", (Throwable)iOException);
                        }
                    }
                    object3.close();
                    break block43;
                }
                catch (IOException iOException) {
                    try {
                        java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, iOException);
                        throw new CapiException("IOException occurred.", 1003, (Throwable)iOException);
                        catch (XMLStreamException xMLStreamException) {
                            java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, xMLStreamException);
                            throw new CapiException("XMLStreamException occurred: ", 1003, (Throwable)xMLStreamException);
                        }
                        catch (KeyStoreException keyStoreException) {
                            java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, keyStoreException);
                            throw new CapiException("KeyStoreException occurred: ", 1003, (Throwable)keyStoreException);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, noSuchAlgorithmException);
                            throw new CapiException("NoSuchAlgorithmException occurred: ", 1003, (Throwable)noSuchAlgorithmException);
                        }
                        catch (UnrecoverableKeyException unrecoverableKeyException) {
                            java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, unrecoverableKeyException);
                            throw new CapiException("UnrecoverableKeyException occurred: ", 1003, (Throwable)unrecoverableKeyException);
                        }
                        catch (KeyManagementException keyManagementException) {
                            java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, keyManagementException);
                            throw new CapiException("KeyManagementException occurred: ", 1003, (Throwable)keyManagementException);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            java.util.logging.Logger.getLogger(ASiCGenerator.class.getName()).log(Level.SEVERE, null, uRISyntaxException);
                            throw new CapiException("URISyntaxException occurred: ", 1003, (Throwable)uRISyntaxException);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            this.f.close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {
                            a.error("Unable to close ZIP output stream.", (Throwable)iOException2);
                        }
                        throw throwable;
                    }
                }
            }
            while (iterator.hasNext()) {
                Map.Entry<byte[], MetaInfSignatureInfo> entry = iterator.next();
                ++n;
                Object object4 = entry.getKey();
                MetaInfSignatureInfo metaInfSignatureInfo = entry.getValue();
                String string = this.a();
                Object object5 = new ZipEntry(string);
                this.f.putNextEntry((ZipEntry)object5);
                object4 = new ByteArrayInputStream((byte[])object4);
                try {
                    int n3;
                    while ((n3 = ((InputStream)object4).read()) >= 0) {
                        this.f.write((byte)n3);
                    }
                }
                catch (IOException iOException) {
                    object5 = iOException;
                    throw iOException;
                }
                finally {
                    try {
                        ((InputStream)object4).close();
                    }
                    catch (IOException iOException) {
                        a.error("Unable to close META-INF input stream.", (Throwable)iOException);
                    }
                }
                if (((ASiCGeneratorOptions)((Object)object)).getAsicOpts().getFormat() == ASiCFormat.SIMPLE) continue;
                metaInfSignatureInfo.setSignatureFilename(string);
                metaInfSignatureInfo.setIndex(n);
            }
        }
        try {
            this.f.close();
            return;
        }
        catch (IOException iOException) {
            a.error("Unable to close ZIP output stream.", (Throwable)iOException);
            return;
        }
    }

    protected void innerUpdate(SignatureOptions signatureOptions) throws CapiException {
        ASiCUpdater.update(signatureOptions);
    }

    private final class a {
        private final File a;
        private final InputStream b;

        private a(ASiCGenerator aSiCGenerator, File file, InputStream inputStream) {
            this.a = file;
            this.b = inputStream;
        }

        /* synthetic */ a(ASiCGenerator aSiCGenerator, File file, InputStream inputStream, byte by) {
            this(aSiCGenerator, file, inputStream);
        }
    }
}

