/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.logging;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.statistics.utils.AdditionalLogInfo;
import esecurity.statistics.utils.StatisticsInfoUtils;
import it.actalis.ellips.capi.logging.JsonEvent;
import it.actalis.ellips.capi.logging.log4j.Layout;
import it.actalis.ellips.capi.logging.log4j.spi.LocationInfo;
import it.actalis.ellips.capi.logging.log4j.spi.LoggingEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class JsonLayout
extends Layout {
    private final ObjectMapper mapper = new ObjectMapper();
    private String loggerName;

    public JsonLayout(String loggerName) {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.loggerName = loggerName;
    }

    @Override
    public String format(LoggingEvent event) {
        LocationInfo locationInfo;
        JsonEvent jEvent = new JsonEvent();
        jEvent.setApplication(this.loggerName);
        jEvent.setLogger_name(this.loggerName);
        jEvent.setLevel(event.getLevel().getStrLevel());
        jEvent.setThread_name(event.getThreadName());
        Date eventDate = new Date(event.getTimeStamp());
        jEvent.setTimestamp(eventDate);
        AdditionalLogInfo additionalLogInfo = StatisticsInfoUtils.getAdditionalInfo();
        if (additionalLogInfo != null) {
            jEvent.setMetrics(additionalLogInfo.getMetrics());
            jEvent.setClinetId(additionalLogInfo.getClinetId());
            jEvent.setClinetIp(additionalLogInfo.getClinetIp());
            jEvent.setCorrelationId(additionalLogInfo.getCorrelationId());
            jEvent.setTotalTime(additionalLogInfo.getTotalTime());
        }
        if ((locationInfo = event.getLocationInformation()) != null) {
            jEvent.setCodeInfo(locationInfo.getClassName() + "." + locationInfo.getMethodName() + "(" + locationInfo.getFileName() + ":" + locationInfo.getLineNumber() + ")");
        }
        if (event.getThrowableInformation() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter wr = new PrintWriter(sw);
            event.getThrowableInformation().getThrowable().printStackTrace(wr);
            jEvent.setStack_trace(sw.toString());
            event.resetThrowableInfo();
        }
        jEvent.setMessage(event.getMessage().toString());
        try {
            return this.mapper.writeValueAsString((Object)jEvent);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public boolean ignoresThrowable() {
        return true;
    }

    @Override
    public void activateOptions() {
    }
}

