/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import esecurity.validator.bean.CertStatusValidation;
import esecurity.validator.bean.RefCRL;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.signature.SignatureLevel;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class LevelValidation {
    protected SignatureLevel level = SignatureLevel.BES;
    protected CertStatusValidation signerStatus = null;
    protected CertStatusValidation tsaSignerStatus = null;
    protected X509Certificate signerCertificate = null;
    protected CertDBItem[] signerChain = null;
    protected X509Certificate tsaCertificate = null;
    protected CertDBItem[] tsaChain = null;
    protected LinkedList<X509Certificate> chain = null;
    protected LinkedList<BasicOCSPResp> ocsps = null;
    protected LinkedList<RefCRL> crls = null;
    protected Date verificationDate;

    public SignatureLevel getLevel() {
        return this.level;
    }

    public void setLevel(SignatureLevel signatureLevel) {
        this.level = signatureLevel;
    }

    public CertStatusValidation getSignerStatus() {
        return this.signerStatus;
    }

    public void setSignerStatus(CertStatusValidation certStatusValidation) {
        this.signerStatus = certStatusValidation;
    }

    public CertStatusValidation getTsaSignerStatus() {
        return this.tsaSignerStatus;
    }

    public void setTsaSignerStatus(CertStatusValidation certStatusValidation) {
        this.tsaSignerStatus = certStatusValidation;
    }

    public CertDBItem[] getSignerChain() {
        return this.signerChain;
    }

    public void setSignerChain(CertDBItem[] certDBItemArray) {
        this.signerChain = certDBItemArray;
    }

    public CertDBItem[] getTsaChain() {
        return this.tsaChain;
    }

    public void setTsaChain(CertDBItem[] certDBItemArray) {
        this.tsaChain = certDBItemArray;
    }

    public X509Certificate getSignerCertificate() {
        return this.signerCertificate;
    }

    public void setSignerCertificate(X509Certificate x509Certificate) {
        this.signerCertificate = x509Certificate;
    }

    public X509Certificate getTsaCertificate() {
        return this.tsaCertificate;
    }

    public void setTsaCertificate(X509Certificate x509Certificate) {
        this.tsaCertificate = x509Certificate;
    }

    public LinkedList<X509Certificate> getChain() {
        return this.chain;
    }

    public void setChain(LinkedList<X509Certificate> linkedList) {
        this.chain = linkedList;
    }

    public LinkedList<BasicOCSPResp> getOcsps() {
        return this.ocsps;
    }

    public void setOcsps(LinkedList<BasicOCSPResp> linkedList) {
        this.ocsps = linkedList;
    }

    public LinkedList<RefCRL> getCrls() {
        return this.crls;
    }

    public void setCrls(LinkedList<RefCRL> linkedList) {
        this.crls = linkedList;
    }

    public Date getVerificationDate() {
        return this.verificationDate;
    }

    public void setVerificationDate(Date date) {
        this.verificationDate = date;
    }

    public X509Certificate getChainRootCertificate(X509Certificate object) throws CapiException {
        X509Certificate x509Certificate;
        block6: {
            block7: {
                if (object == null) {
                    return null;
                }
                x509Certificate = null;
                if (this.signerCertificate == null || !this.signerCertificate.equals(object)) break block7;
                if (this.signerChain == null || this.signerChain.length <= 0) break block6;
                while (0 < this.signerChain.length) {
                    object = this.signerChain[0].getCertificate().getIssuerDN();
                    boolean bl = false;
                    for (int i = 0; i < this.signerChain.length; ++i) {
                        String string;
                        if (i == 0 || !(string = this.signerChain[0].getCertificate().getSubjectDN()).equals(object)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    x509Certificate = this.signerChain[0].getCertificate().getInternalCert();
                    break block6;
                }
                break block6;
            }
            if (this.tsaCertificate != null && this.tsaCertificate.equals(object) && this.tsaChain != null && this.tsaChain.length > 0) {
                while (0 < this.tsaChain.length) {
                    object = this.tsaChain[0].getCertificate().getIssuerDN();
                    boolean bl = false;
                    for (int i = 0; i < this.tsaChain.length; ++i) {
                        String string;
                        if (i == 0 || !(string = this.tsaChain[0].getCertificate().getSubjectDN()).equals(object)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    x509Certificate = this.tsaChain[0].getCertificate().getInternalCert();
                    break;
                }
            }
        }
        return x509Certificate;
    }

    public CertDBItem[] getChain(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        if (this.signerCertificate != null && this.signerCertificate.equals(x509Certificate)) {
            return this.getSignerChain();
        }
        if (this.tsaCertificate != null && this.tsaCertificate.equals(x509Certificate)) {
            return this.getTsaChain();
        }
        return null;
    }
}

