/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms;

import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLTaggedObject;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class CadesSignedDataProxy {
    private CMSSignedDataParser a = null;
    private CMSSignedData b = null;

    public CadesSignedDataProxy(CMSSignedDataParser cMSSignedDataParser) {
        this.a = cMSSignedDataParser;
    }

    public CadesSignedDataProxy(CMSSignedData cMSSignedData) {
        this.b = cMSSignedData;
    }

    public CMSSignedDataParser getParser() {
        return this.a;
    }

    public CMSSignedData getSignedData() {
        return this.b;
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this.a != null) {
            return this.a.getSignerInfos();
        }
        return this.b.getSignerInfos();
    }

    public LinkedList<X509Certificate> getCertificates() throws CMSException, CertificateException {
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        Collection collection = this.a != null ? this.a.getCertificates().getMatches(null) : this.b.getCertificates().getMatches(null);
        if (collection.isEmpty()) {
            return linkedList;
        }
        collection = new LinkedList(collection);
        for (X509CertificateHolder x509CertificateHolder : collection) {
            linkedList.add(new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate(x509CertificateHolder));
        }
        return linkedList;
    }

    public LinkedList<CRL> getCRLS() throws CapiException, CRLException, CMSException {
        LinkedList<CRL> linkedList = new LinkedList<CRL>();
        Collection collection = this.a != null ? this.a.getCRLs().getMatches(null) : this.b.getCRLs().getMatches(null);
        if (collection.isEmpty()) {
            return linkedList;
        }
        collection = new LinkedList(collection);
        for (X509CRLHolder x509CRLHolder : collection) {
            linkedList.add(new CRL(new JcaX509CRLConverter().setProvider(ProvUtils.bcProvider).getCRL(x509CRLHolder).getEncoded()));
        }
        return linkedList;
    }

    public LinkedList<BasicOCSPResp> getBasicOCSPResponses() throws CMSException, CRLException {
        LinkedList<BasicOCSPResp> linkedList = new LinkedList<BasicOCSPResp>();
        Collection collection = this.a != null ? this.a.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic).getMatches(null) : this.b.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic).getMatches(null);
        if (collection.isEmpty()) {
            return linkedList;
        }
        collection = new LinkedList(collection);
        for (Object object : collection) {
            object = (ASN1Sequence)object;
            object = BasicOCSPResponse.getInstance((Object)object);
            object = new BasicOCSPResp(object);
            linkedList.add((BasicOCSPResp)object);
        }
        return linkedList;
    }

    public LinkedList<OCSPResp> getOCSPResponses() throws CMSException, CRLException {
        LinkedList<OCSPResp> linkedList = new LinkedList<OCSPResp>();
        Collection collection = this.a != null ? this.a.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response).getMatches(null) : this.b.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response).getMatches(null);
        if (collection.isEmpty()) {
            return linkedList;
        }
        collection = new LinkedList(collection);
        for (Object object : collection) {
            object = (ASN1Sequence)object;
            object = OCSPResponse.getInstance((Object)object);
            object = new OCSPResp(object);
            linkedList.add((OCSPResp)object);
        }
        return linkedList;
    }

    public byte[] getRawSignature(int n) throws CapiException {
        try {
            Object object = this.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            String string = "DER";
            if (((Vector)object).elementAt(n) != null && ((SignerInformation)((Vector)object).elementAt(n)).toASN1Structure() != null && ((SignerInformation)((Vector)object).elementAt(n)).toASN1Structure().getAuthenticatedAttributes() != null && !Arrays.equals(((SignerInformation)((Vector)object).elementAt(n)).toASN1Structure().getAuthenticatedAttributes().getEncoded(), ((SignerInformation)((Vector)object).elementAt(n)).toASN1Structure().getAuthenticatedAttributes().getEncoded("DER"))) {
                string = "DL";
                SignerInfo signerInfo = ((SignerInformation)((Vector)object).elementAt(n)).toASN1Structure();
                object = string;
                SignerInfo signerInfo2 = signerInfo;
                string = new ASN1EncodableVector(7);
                string.add((ASN1Encodable)signerInfo2.getVersion());
                string.add((ASN1Encodable)signerInfo2.getSID());
                string.add((ASN1Encodable)signerInfo2.getDigestAlgorithm());
                if (signerInfo2.getAuthenticatedAttributes() != null) {
                    string.add((ASN1Encodable)new DLTaggedObject(false, 0, (ASN1Encodable)signerInfo2.getAuthenticatedAttributes()));
                }
                string.add((ASN1Encodable)signerInfo2.getDigestEncryptionAlgorithm());
                string.add((ASN1Encodable)signerInfo2.getEncryptedDigest());
                if (signerInfo2.getUnauthenticatedAttributes() != null) {
                    string.add((ASN1Encodable)new DLTaggedObject(false, 1, (ASN1Encodable)signerInfo2.getUnauthenticatedAttributes()));
                }
                return new DLSequence((ASN1EncodableVector)string).getEncoded((String)object);
            }
            return ((SignerInformation)((Vector)object).elementAt(n)).toASN1Structure().getEncoded(string);
        }
        catch (CapiException capiException) {
            CapiException capiException2 = capiException;
            throw capiException;
        }
        catch (Exception exception) {
            throw new CapiException("Cannot get signature value", 50023);
        }
    }

    public Date getSigningTime(int n) throws CapiException {
        try {
            Object object = this.a != null ? this.a.getSignerInfos() : this.b.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            SignerInformation signerInformation2 = signerInformation;
            signerInformation2 = signerInformation;
            signerInformation2 = signerInformation.getSignedAttributes();
            object = null;
            if (signerInformation2 != null && (signerInformation2 = signerInformation2.get(CMSAttributes.signingTime)) != null) {
                signerInformation2 = Time.getInstance((Object)signerInformation2.getAttrValues().getObjectAt(0).toASN1Primitive());
                object = signerInformation2.getDate();
            }
            return object;
        }
        catch (CapiException capiException) {
            CapiException capiException2 = capiException;
            throw capiException;
        }
        catch (Exception exception) {
            throw new CapiException("Cannot get signature value", 50023);
        }
    }

    public int getNumberOfSigners() {
        int n = -1;
        SignerInformationStore signerInformationStore = null;
        if (this.a != null) {
            try {
                signerInformationStore = this.a.getSignerInfos();
            }
            catch (CMSException cMSException) {}
        } else {
            signerInformationStore = this.b.getSignerInfos();
        }
        if (signerInformationStore != null && signerInformationStore.getSigners() != null) {
            n = signerInformationStore.getSigners().size();
        }
        return n;
    }
}

