/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.User32;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.common.AbstractOSVersionInfoEx;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsOSVersionInfoEx
extends AbstractOSVersionInfoEx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOSVersionInfoEx.class);
    private static final WmiUtil.ValueType[] queryTypes = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32};
    private transient Map<String, List<Object>> versionInfo = WmiUtil.selectObjectsFrom(null, "Win32_OperatingSystem", "Version,ProductType,BuildNumber,CSDVersion,SuiteMask", null, queryTypes);

    public WindowsOSVersionInfoEx() {
        if (this.versionInfo.get("Version").isEmpty()) {
            LOG.warn("No version data available.");
            this.setVersion(System.getProperty("os.version"));
            this.setCodeName("");
            this.setBuildNumber("");
        } else {
            this.setVersion(this.parseVersion());
            this.setCodeName(this.parseCodeName());
            this.setBuildNumber(this.parseBuildNumber());
            LOG.debug("Initialized OSVersionInfoEx");
        }
    }

    private String parseVersion() {
        String sp;
        boolean ntWorkstation;
        String version = System.getProperty("os.version");
        String[] verSplit = ((String)this.versionInfo.get("Version").get(0)).split("\\D");
        int major = verSplit.length > 0 ? ParseUtil.parseIntOrDefault(verSplit[0], 0) : 0;
        int minor = verSplit.length > 1 ? ParseUtil.parseIntOrDefault(verSplit[1], 0) : 0;
        boolean bl = ntWorkstation = (Long)this.versionInfo.get("ProductType").get(0) == 1L;
        if (major == 10) {
            if (minor == 0) {
                version = ntWorkstation ? "10" : "Server 2016";
            }
        } else if (major == 6) {
            if (minor == 3) {
                version = ntWorkstation ? "8.1" : "Server 2012 R2";
            } else if (minor == 2) {
                version = ntWorkstation ? "8" : "Server 2012";
            } else if (minor == 1) {
                version = ntWorkstation ? "7" : "Server 2008 R2";
            } else if (minor == 0) {
                version = ntWorkstation ? "Vista" : "Server 2008";
            }
        } else if (major == 5) {
            if (minor == 2) {
                version = (this.getSuiteMask() & 0x8000) != 0 ? "Home Server" : (ntWorkstation ? "XP" : (User32.INSTANCE.GetSystemMetrics(89) != 0 ? "Server 2003" : "Server 2003 R2"));
            } else if (minor == 1) {
                version = "XP";
            } else if (minor == 0) {
                version = "2000";
            }
        }
        if (!(sp = (String)this.versionInfo.get("CSDVersion").get(0)).isEmpty() && !"unknown".equals(sp)) {
            version = version + " " + sp.replace("Service Pack ", "SP");
        }
        return version;
    }

    private String parseCodeName() {
        ArrayList<String> suites = new ArrayList<String>();
        int bitmask = this.getSuiteMask();
        if ((bitmask & 2) != 0) {
            suites.add("Enterprise");
        }
        if ((bitmask & 4) != 0) {
            suites.add("BackOffice");
        }
        if ((bitmask & 8) != 0) {
            suites.add("Communication Server");
        }
        if ((bitmask & 0x80) != 0) {
            suites.add("Datacenter");
        }
        if ((bitmask & 0x200) != 0) {
            suites.add("Home");
        }
        if ((bitmask & 0x400) != 0) {
            suites.add("Web Server");
        }
        if ((bitmask & 0x2000) != 0) {
            suites.add("Storage Server");
        }
        if ((bitmask & 0x4000) != 0) {
            suites.add("Compute Cluster");
        }
        String separator = "";
        StringBuilder sb = new StringBuilder();
        for (String s : suites) {
            sb.append(separator).append(s);
            separator = ",";
        }
        return sb.toString();
    }

    private int getSuiteMask() {
        return (int)((Long)this.versionInfo.get("SuiteMask").get(0)).longValue();
    }

    private String parseBuildNumber() {
        return (String)this.versionInfo.get("BuildNumber").get(0);
    }
}

