/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationStep;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.ValidationStep;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.AbstractSequentialList;
import java.util.LinkedList;

public abstract class SingleValidationStepImpl
extends ValidationStep
implements SingleValidationStep {
    public SingleValidationStepImpl(ValidationType validationType) {
        super(validationType);
    }

    @Override
    public ValidatorMessage check(ValidationContextParameters validationContextParameters) {
        ValidatorMessage validatorMessage;
        try {
            Object object = this.checkSubSteps(validationContextParameters);
            object = StepsUtils.filterMessageByProfile(object, validationContextParameters.getProfile());
            validatorMessage = this.innerCheck((LinkedList<ValidatorMessage>)object, validationContextParameters);
            if (validatorMessage != null) {
                object = ((AbstractSequentialList)object).iterator();
                while (object.hasNext()) {
                    ValidatorMessage validatorMessage2 = (ValidatorMessage)object.next();
                    validatorMessage.addNotes(validatorMessage2);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ValidationStep \"{}\" ha generato un messaggio codice {} livello {}:", new Object[]{this.getClass().getName(), validatorMessage.getMessageCode(), validatorMessage.getLevel().toString()});
                }
            }
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ValidationStep \"{}\" ha generato un errore non gestito: ", (Object)this.getClass().getName(), (Object)throwable);
            }
            validatorMessage = new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        return validatorMessage;
    }

    protected abstract ValidatorMessage innerCheck(LinkedList<ValidatorMessage> var1, ValidationContextParameters var2);
}

