/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.CertificateExpiredException;
import it.actalis.ellips.capi.core.CertificateNotYetValidException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.CrlID;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.slf4j.Logger;

public class OCSPResponse {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private OCSPResp b;
    private SingleResp c;
    private BasicOCSPResp d;
    private RespID e;
    public static int GOOD = 0;
    public static int REVOKED = 1;
    public static int UNKNOWN = 2;
    public static int OCSP_WITHOUT_ARCHIVE_CUTOFF = 3;
    public static int OCSP_WITH_ARCHIVE_CUTOFF_CRT_TOO_OLD = 4;

    public OCSPResponse(OCSPResp singleRespArray, CertificateID object) throws CapiException, Exception {
        this.b = singleRespArray;
        this.d = (BasicOCSPResp)this.b.getResponseObject();
        if (this.d == null) {
            int n = this.b.getStatus();
            object = OCSPResponse.getResponseStatusName(n);
            throw new CapiException("OCSP responder error: status " + (String)object + " (" + n + ")", 31008);
        }
        this.e = this.d.getResponderId();
        singleRespArray = this.d.getResponses();
        this.c = null;
        object = OCSPResponse.certificateIDToASN1Primitive(object);
        for (SingleResp singleResp : singleRespArray) {
            ASN1Primitive aSN1Primitive = OCSPResponse.certificateIDToASN1Primitive(singleResp.getCertID());
            if (!aSN1Primitive.equals((ASN1Primitive)object)) continue;
            this.c = singleResp;
        }
        if (this.c == null) {
            throw new CapiException("Not found SingleResp for the specified CertID", 31008);
        }
    }

    public String getResponseStatusName() {
        int n = this.b.getStatus();
        return OCSPResponse.getResponseStatusName(n);
    }

    public static String getResponseStatusName(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "successful";
                break;
            }
            case 1: {
                string = "malformedRequest";
                break;
            }
            case 2: {
                string = "internalError";
                break;
            }
            case 3: {
                string = "tryLater";
                break;
            }
            case 5: {
                string = "sigRequired";
                break;
            }
            case 6: {
                string = "unauthorized";
                break;
            }
            default: {
                string = "unauthorized";
            }
        }
        return string;
    }

    public int getResponseStatus() {
        return this.b.getStatus();
    }

    public BasicOCSPResp getBasicOcspResponse() {
        return this.d;
    }

    public OCSPResp getFullOcspResponse() {
        return this.b;
    }

    public RespID getResponderID() {
        return this.e;
    }

    public String getResponderIDtoString() {
        if (this.e == null) {
            return null;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)this.e.toASN1Primitive().toASN1Primitive();
        if (aSN1TaggedObject.getTagNo() == 1) {
            aSN1TaggedObject = X500Name.getInstance((Object)aSN1TaggedObject.getObject());
            return aSN1TaggedObject.toString();
        }
        aSN1TaggedObject = ASN1OctetString.getInstance((Object)aSN1TaggedObject.getObject());
        return aSN1TaggedObject.toString();
    }

    public Date getProducedAt() {
        return this.d.getProducedAt();
    }

    public String getName() {
        return this.e.toASN1Primitive().toASN1Primitive().toString();
    }

    public byte[] getKeyHash() throws IOException {
        return this.e.toASN1Primitive().toASN1Primitive().getEncoded();
    }

    public SingleResp getSingleResponse() {
        return this.c;
    }

    public Date getArchiveCutoff() {
        try {
            Object object = this.c.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_archive_cutoff);
            if (object == null) {
                return null;
            }
            byte[] byArray = object.getExtnValue().getEncoded();
            object = byArray;
            if (byArray == null) {
                return null;
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            object = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            if ((object = ASN1GeneralizedTime.getInstance((Object)object.readObject())) == null) {
                return null;
            }
            object = object.getDate();
            return object;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public int warningArchiveCutoff(Certificate object) throws CapiException {
        Object object2 = this.c.getCertStatus();
        if (object2 != CertificateStatus.GOOD) {
            return 0;
        }
        try {
            ((Certificate)object).isValid();
            return 0;
        }
        catch (CertificateExpiredException certificateExpiredException) {
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return 0;
        }
        catch (CapiException capiException) {
            object2 = capiException;
            throw capiException;
        }
        object2 = "yyyyMMddHHmmss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object2);
        Date date = this.getArchiveCutoff();
        if (date == null) {
            return OCSP_WITHOUT_ARCHIVE_CUTOFF;
        }
        object = ((Certificate)object).getValidityNotAfter((String)object2);
        try {
            object = simpleDateFormat.parse((String)object);
        }
        catch (ParseException parseException) {
            throw new CapiException("Certificate expiry date parsing exception", 30002);
        }
        if (((Date)object).compareTo(date) >= 0) {
            return 0;
        }
        return OCSP_WITH_ARCHIVE_CUTOFF_CRT_TOO_OLD;
    }

    public int getCertStatus() {
        if (this.c.getCertStatus() == CertificateStatus.GOOD) {
            return 0;
        }
        a.debug("OCSP certificate status: " + this.c.getCertStatus().getClass().getName());
        if (this.c.getCertStatus() instanceof RevokedStatus) {
            a.info("OCSP certificate status: OCSP status revoked");
            a.info("OCSP Revocation time:" + ((RevokedStatus)this.c.getCertStatus()).getRevocationTime());
            return 1;
        }
        if (this.c.getCertStatus() instanceof UnknownStatus) {
            a.info("OCSP status unknown");
            return 2;
        }
        return 2;
    }

    public String getCertStatusName() {
        this.getCertStatus();
        String string = "unknown";
        return "unknown";
    }

    public Date getThisUpdate() {
        return this.c.getThisUpdate();
    }

    public Date getNextUpdate() {
        return this.c.getNextUpdate();
    }

    public CrlID getCrlID() throws IOException {
        Object object = this.c.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_crl);
        byte[] byArray = object.getExtnValue().getEncoded();
        object = byArray;
        if (byArray == null) {
            return null;
        }
        object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
        object = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
        object = CrlID.getInstance((Object)ASN1Sequence.getInstance((Object)object.readObject()));
        return object;
    }

    public byte[] getNonce() {
        Extension extension = this.d.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (extension == null || extension.getExtnValue() == null) {
            return null;
        }
        try {
            return extension.getExtnValue().getEncoded();
        }
        catch (IOException iOException) {
            a.warn("Impossibile recuperare il nonce : " + iOException.getMessage(), (Throwable)iOException);
            return null;
        }
    }

    public String getReasonCodeName() throws IOException {
        CertificateStatus certificateStatus = this.c.getCertStatus();
        if (certificateStatus == CertificateStatus.GOOD) {
            return null;
        }
        if (certificateStatus instanceof RevokedStatus) {
            ((RevokedStatus)certificateStatus).getRevocationReason();
        } else if (certificateStatus instanceof UnknownStatus) {
            return null;
        }
        return null;
    }

    public int getReasonCode() {
        CertificateStatus certificateStatus = this.c.getCertStatus();
        if (certificateStatus == CertificateStatus.GOOD) {
            return -1;
        }
        if (certificateStatus instanceof RevokedStatus) {
            int n = ((RevokedStatus)certificateStatus).getRevocationReason();
            return n;
        }
        if (certificateStatus instanceof UnknownStatus) {
            return -1;
        }
        return -1;
    }

    public Date getRevocationTime() throws ParseException {
        CertificateStatus certificateStatus = this.c.getCertStatus();
        if (certificateStatus == CertificateStatus.GOOD) {
            return null;
        }
        if (certificateStatus instanceof RevokedStatus) {
            return ((RevokedStatus)certificateStatus).getRevocationTime();
        }
        if (certificateStatus instanceof UnknownStatus) {
            return null;
        }
        return null;
    }

    public static ASN1Primitive certificateIDToASN1Primitive(CertificateID certificateID) {
        if (certificateID.toASN1Primitive().getHashAlgorithm().getParameters() instanceof DERNull) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add((ASN1Encodable)new AlgorithmIdentifier(certificateID.toASN1Primitive().getHashAlgorithm().getAlgorithm(), null));
            aSN1EncodableVector.add((ASN1Encodable)certificateID.toASN1Primitive().getIssuerNameHash());
            aSN1EncodableVector.add((ASN1Encodable)certificateID.toASN1Primitive().getIssuerKeyHash());
            aSN1EncodableVector.add((ASN1Encodable)certificateID.toASN1Primitive().getSerialNumber());
            certificateID = new DERSequence(aSN1EncodableVector);
        } else {
            certificateID = certificateID.toASN1Primitive().toASN1Primitive();
        }
        return certificateID;
    }
}

