/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core.http.providers;

import esecurity.dsd.core.Log;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HTTPUrl {
    private URI uri;

    protected HTTPUrl(Builder builder) {
        String path = builder.path();
        String query = builder.query();
        try {
            this.uri = new URI(builder.scheme, builder.user, builder.hostName, builder.portno, path, query, builder.fragment);
        }
        catch (URISyntaxException e) {
            Log.logger().error("Error building HTTP Url: ".concat(e.getMessage()));
            e.printStackTrace();
        }
    }

    public Builder newBuilder() {
        Builder result = new Builder();
        result.scheme = this.uri.getScheme();
        result.user = this.uri.getRawUserInfo();
        result.hostName = this.uri.getHost();
        result.portno = this.uri.getPort();
        result.addPathSegments(this.uri.getRawPath());
        result.addQuery(this.uri.getRawQuery());
        result.fragment = this.uri.getRawFragment();
        return result;
    }

    public URL toURL() throws MalformedURLException {
        return this.uri.toURL();
    }

    public static class Builder {
        private String user = "";
        private String scheme = "http";
        private String hostName = "localhost";
        private String fragment = "";
        private int portno = -1;
        private List<String> pathSegs = new LinkedList<String>();
        private Map<String, List<String>> query = new LinkedHashMap<String, List<String>>();

        public String query() {
            StringBuilder sb = new StringBuilder();
            this.query.forEach((key, value) -> {
                sb.append((String)key);
                if (value != null && !value.isEmpty()) {
                    value.forEach(item -> sb.append("=".concat((String)item)));
                }
                sb.append("&");
            });
            return sb.toString();
        }

        public String path() {
            return "/".concat(this.pathSegs.stream().collect(Collectors.joining("/")));
        }

        public Builder scheme(String protocol) {
            this.scheme = protocol;
            return this;
        }

        public Builder host(String hn) {
            this.hostName = hn;
            return this;
        }

        public Builder fragment(String fg) {
            this.fragment = fg;
            return this;
        }

        public Builder addPathSegments(String paths) {
            String[] split = paths.split("/");
            this.pathSegs.addAll(Stream.of(split).filter(s -> !"".equals(s)).collect(Collectors.toList()));
            return this;
        }

        public Builder addPathSegment(String path) {
            if (path != null && !"".equals(path)) {
                this.pathSegs.add(path);
            }
            return this;
        }

        public Builder addQueryParameter(String key, String value) {
            if (this.query.get(key) == null) {
                LinkedList<String> list = new LinkedList<String>();
                if (value != null && !"".equals(value)) {
                    list.add(value);
                }
                this.query.put(key, list);
            } else {
                this.query.get(key).add(value);
            }
            return this;
        }

        public Builder addQueryParameter(String key) {
            return this.addQueryParameter(key, "");
        }

        public Builder addQuery(String query) {
            String[] qParts;
            for (String part : qParts = query.split("&")) {
                int separator = part.indexOf("=");
                String key = separator == -1 ? part : part.substring(0, separator - 1);
                String value = separator == -1 ? "" : part.substring(separator + 1);
                this.addQueryParameter(key, value);
            }
            return this;
        }

        public HTTPUrl build() {
            return new HTTPUrl(this);
        }

        public Builder port(int port) {
            this.portno = port;
            return this;
        }
    }
}

