/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.xades.bean.XadesSignatureReference;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class XadesStepSignatureDPCM45HashAlgoCheck
extends SingleValidationSubStepImpl {
    public XadesStepSignatureDPCM45HashAlgoCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> xadesSignerInfoData, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters == null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if (validationContextParameters.getSignature() == null || validationContextParameters.getSignature().getSignatureInfo() == null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        xadesSignerInfoData = (XadesSignerInfoData)validationContextParameters.getSignature().getSignerInfoData();
        if (xadesSignerInfoData != null && xadesSignerInfoData.getReferences() != null && xadesSignerInfoData.getReferences().size() > 0) {
            for (XadesSignatureReference xadesSignatureReference : xadesSignerInfoData.getReferences()) {
                if (xadesSignatureReference != null && xadesSignatureReference.getDigestMethodAlgorithm() != null && xadesSignatureReference.getDigestMethodAlgorithm().equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#sha256")) continue;
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0006_NOSHA256, new Object[]{((Object)((Object)this)).getClass().getName()});
            }
        }
        if (xadesSignerInfoData != null && (xadesSignerInfoData.getSignatureMethod() == null || !xadesSignerInfoData.getSignatureMethod().equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256") && !xadesSignerInfoData.getSignatureMethod().equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"))) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0006_NOSHA256, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if (xadesSignerInfoData != null && xadesSignerInfoData.getSigningCertificates() != null && xadesSignerInfoData.getSigningCertificates().size() > 0) {
            for (XadesSignatureReference xadesSignatureReference : xadesSignerInfoData.getSigningCertificates()) {
                if (xadesSignatureReference != null && xadesSignatureReference.getDigestMethod() != null && xadesSignatureReference.getDigestMethod().equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#sha256")) continue;
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0006_NOSHA256, new Object[]{((Object)((Object)this)).getClass().getName()});
            }
        }
        return null;
    }
}

