/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7.RFC5652;

import it.actalis.ellips.capi.cms.CadesSignedDataProxy;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pkcs7.CapiSignerInformation;
import it.actalis.ellips.capi.pkcs7.RFC5652.VerificationResult;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSSignerDigestMismatchException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.CMSVerifierCertificateNotValidException;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.RawContentVerifier;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.TeeOutputStream;
import org.slf4j.Logger;

public class CheckSignerInformation {
    private static boolean a = false;
    private static boolean b = true;
    private static final Logger c = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static boolean verify(SignerInformationVerifier signerInformationVerifier, SignerInformation signerInformation, CadesSignedDataProxy cadesSignedDataProxy) throws CMSException {
        X509CertificateHolder x509CertificateHolder;
        if (signerInformation == null) {
            return false;
        }
        SignerInfo signerInfo = signerInformation.toASN1Structure();
        signerInfo = CheckSignerInformation.a(signerInfo);
        if (signerInformationVerifier.hasAssociatedCertificate() && signerInfo != null && !(x509CertificateHolder = signerInformationVerifier.getAssociatedCertificate()).isValidOn(signerInfo.getDate()) && a) {
            throw new CMSVerifierCertificateNotValidException("verifier not valid at signingTime");
        }
        return CheckSignerInformation.doCustomVerify(signerInformationVerifier, signerInformation, cadesSignedDataProxy);
    }

    public static boolean isSigningTimeCheckedAgainstCert() {
        return a;
    }

    public static void setIsSigningTimeCheckedAgainstCert(boolean bl) {
        a = bl;
    }

    public static void setIsSignedAttributesDEREncoded(boolean bl) {
        b = bl;
    }

    private static Time a(SignerInfo signerInfo) throws CMSException {
        if ((signerInfo = CheckSignerInformation.a(CMSAttributes.signingTime, "signing-time", signerInfo)) == null) {
            return null;
        }
        try {
            return Time.getInstance((Object)signerInfo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }

    public static boolean doCustomVerify(SignerInformationVerifier signerInformationVerifier, SignerInformation signerInformation, CadesSignedDataProxy object) throws CMSException {
        TeeOutputStream teeOutputStream;
        OutputStream outputStream;
        Object object2;
        Object object3;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = signerInformation.getContentType();
        SignerInfo signerInfo = signerInformation.toASN1Structure();
        boolean bl = aSN1ObjectIdentifier == null;
        ASN1Set aSN1Set = signerInfo.getAuthenticatedAttributes();
        byte[] byArray = null;
        CMSProcessable cMSProcessable = null;
        if (!b && aSN1Set != null) {
            try {
                object3 = aSN1Set.getEncoded("DER");
                object2 = aSN1Set.getEncoded();
            }
            catch (IOException iOException) {
                throw new CMSException("can't compare two signed attribute's encoding: " + iOException.getMessage(), (Exception)iOException);
            }
            if (java.util.Arrays.equals((byte[])object3, object2)) {
                return false;
            }
        }
        if (object != null && ((CadesSignedDataProxy)object).getSignedData() != null) {
            cMSProcessable = (CMSProcessable)((CadesSignedDataProxy)object).getSignedData().getSignedContent().getContent();
        } else {
            byArray = signerInformation.getContentDigest();
        }
        object3 = CMSSignedHelper.INSTANCE.getEncryptionAlgName(signerInformation.getEncryptionAlgOID());
        try {
            object2 = signerInformationVerifier.getContentVerifier(new AlgorithmIdentifier(new ASN1ObjectIdentifier(signerInformation.getEncryptionAlgOID())), new AlgorithmIdentifier(new ASN1ObjectIdentifier(signerInformation.getDigestAlgOID())));
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMSException("can't create content verifier: " + operatorCreationException.getMessage(), (Exception)((Object)operatorCreationException));
        }
        try {
            object = object2.getOutputStream();
            if (byArray == null) {
                signerInformationVerifier = signerInformationVerifier.getDigestCalculator(new AlgorithmIdentifier(new ASN1ObjectIdentifier(signerInformation.getDigestAlgOID())));
                if (cMSProcessable != null) {
                    outputStream = signerInformationVerifier.getOutputStream();
                    if (aSN1Set == null) {
                        if (object2 instanceof RawContentVerifier) {
                            cMSProcessable.write(outputStream);
                        } else {
                            teeOutputStream = new TeeOutputStream(outputStream, (OutputStream)object);
                            cMSProcessable.write((OutputStream)teeOutputStream);
                            teeOutputStream.close();
                        }
                    } else {
                        cMSProcessable.write(outputStream);
                        if (b) {
                            ((OutputStream)object).write(aSN1Set.getEncoded("DER"));
                        } else {
                            ((OutputStream)object).write(aSN1Set.getEncoded());
                        }
                    }
                    outputStream.close();
                } else if (aSN1Set != null) {
                    if (b) {
                        ((OutputStream)object).write(aSN1Set.getEncoded("DER"));
                    } else {
                        ((OutputStream)object).write(aSN1Set.getEncoded());
                    }
                } else {
                    throw new CMSException("data not encapsulated in signature - use detached constructor.");
                }
                byArray = signerInformationVerifier.getDigest();
            } else if (aSN1Set == null) {
                if (cMSProcessable != null) {
                    cMSProcessable.write((OutputStream)object);
                }
            } else if (b) {
                ((OutputStream)object).write(aSN1Set.getEncoded("DER"));
            } else {
                ((OutputStream)object).write(aSN1Set.getEncoded());
            }
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", (Exception)iOException);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMSException("can't create digest calculator: " + operatorCreationException.getMessage(), (Exception)((Object)operatorCreationException));
        }
        object = CheckSignerInformation.a(CMSAttributes.contentType, "content-type", signerInfo);
        if (object == null) {
            if (!bl && aSN1Set != null) {
                throw new CMSException("The content-type attribute type MUST be present whenever signed attributes are present in signed-data");
            }
        } else {
            if (bl) {
                throw new CMSException("[For counter signatures,] the signedAttributes field MUST NOT contain a content-type attribute");
            }
            if (!(object instanceof ASN1ObjectIdentifier)) {
                throw new CMSException("content-type attribute value not of ASN.1 type 'OBJECT IDENTIFIER'");
            }
            signerInformationVerifier = (ASN1ObjectIdentifier)object;
            if (!signerInformationVerifier.equals((ASN1Primitive)aSN1ObjectIdentifier)) {
                throw new CMSException("content-type attribute value does not match eContentType");
            }
        }
        object = null;
        if (signerInfo.getAuthenticatedAttributes() != null) {
            object = new AttributeTable(signerInfo.getAuthenticatedAttributes());
        }
        signerInformationVerifier = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            signerInformationVerifier = new AttributeTable(signerInfo.getUnauthenticatedAttributes());
        }
        if (signerInformationVerifier != null && signerInformationVerifier.getAll(CMSAttributes.cmsAlgorithmProtect).size() > 0) {
            throw new CMSException("A cmsAlgorithmProtect attribute MUST be a signed attribute");
        }
        if (object != null) {
            outputStream = object.getAll(CMSAttributes.cmsAlgorithmProtect);
            if (outputStream.size() > 1) {
                throw new CMSException("Only one instance of a cmsAlgorithmProtect attribute can be present");
            }
            if (outputStream.size() > 0) {
                teeOutputStream = Attribute.getInstance((Object)outputStream.get(0));
                if (teeOutputStream.getAttrValues().size() != 1) {
                    throw new CMSException("A cmsAlgorithmProtect attribute MUST contain exactly one value");
                }
                signerInformationVerifier = CMSAlgorithmProtection.getInstance((Object)teeOutputStream.getAttributeValues()[0]);
                if (!CMSUtils.isEquivalent((AlgorithmIdentifier)signerInformationVerifier.getDigestAlgorithm(), (AlgorithmIdentifier)signerInfo.getDigestAlgorithm())) {
                    throw new CMSException("CMS Algorithm Identifier Protection check failed for digestAlgorithm");
                }
                if (!CMSUtils.isEquivalent((AlgorithmIdentifier)signerInformationVerifier.getSignatureAlgorithm(), (AlgorithmIdentifier)signerInfo.getDigestEncryptionAlgorithm())) {
                    throw new CMSException("CMS Algorithm Identifier Protection check failed for signatureAlgorithm");
                }
            }
        }
        if ((signerInformationVerifier = CheckSignerInformation.a(CMSAttributes.messageDigest, "message-digest", signerInfo)) == null) {
            if (aSN1Set != null) {
                throw new CMSException("the message-digest signed attribute type MUST be present when there are any signed attributes present");
            }
        } else {
            if (!(signerInformationVerifier instanceof ASN1OctetString)) {
                throw new CMSException("message-digest attribute value not of ASN.1 type 'OCTET STRING'");
            }
            outputStream = (ASN1OctetString)signerInformationVerifier;
            if (!Arrays.constantTimeAreEqual((byte[])byArray, (byte[])outputStream.getOctets())) {
                throw new CMSSignerDigestMismatchException("message-digest attribute value does not match calculated value");
            }
        }
        if (object != null && object.getAll(CMSAttributes.counterSignature).size() > 0) {
            throw new CMSException("A countersignature attribute MUST NOT be a signed attribute");
        }
        signerInformationVerifier = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            signerInformationVerifier = new AttributeTable(signerInfo.getUnauthenticatedAttributes());
        }
        if (signerInformationVerifier != null) {
            outputStream = signerInformationVerifier.getAll(CMSAttributes.counterSignature);
            for (int i = 0; i < outputStream.size(); ++i) {
                signerInformationVerifier = Attribute.getInstance((Object)outputStream.get(i));
                if (signerInformationVerifier.getAttrValues().size() > 0) continue;
                throw new CMSException("A countersignature attribute MUST contain at least one AttributeValue");
            }
        }
        try {
            if (aSN1Set == null && byArray != null && object2 instanceof RawContentVerifier) {
                signerInformationVerifier = (RawContentVerifier)object2;
                if (((String)object3).equals("RSA")) {
                    outputStream = new DigestInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier(signerInformation.getDigestAlgOID()), (ASN1Encodable)DERNull.INSTANCE), byArray);
                    return signerInformationVerifier.verify(outputStream.getEncoded("DER"), signerInformation.getSignature());
                }
                return signerInformationVerifier.verify(byArray, signerInformation.getSignature());
            }
            return object2.verify(signerInformation.getSignature());
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", (Exception)iOException);
        }
    }

    public static VerificationResult customVerify(SignerInformationVerifier signerInformationVerifier, SignerInformation signerInformation, CadesSignedDataProxy object) throws CMSException {
        TeeOutputStream teeOutputStream;
        OutputStream outputStream;
        Object object2;
        Object object3;
        VerificationResult verificationResult = new VerificationResult();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = signerInformation.getContentType();
        SignerInfo signerInfo = signerInformation.toASN1Structure();
        boolean bl = aSN1ObjectIdentifier == null;
        ASN1Set aSN1Set = signerInfo.getAuthenticatedAttributes();
        byte[] byArray = null;
        CMSProcessable cMSProcessable = null;
        try {
            object3 = CheckSignerInformation.a(signerInfo);
            if (signerInformationVerifier.hasAssociatedCertificate() && object3 != null && !(object2 = signerInformationVerifier.getAssociatedCertificate()).isValidOn(object3.getDate())) {
                verificationResult.setValidSigningTime(false);
            }
        }
        catch (CMSException cMSException) {
            verificationResult.setValidSigningTime(false);
            c.debug(cMSException.getMessage(), (Throwable)cMSException);
        }
        if (aSN1Set != null) {
            try {
                object3 = aSN1Set.getEncoded("DER");
                object2 = aSN1Set.getEncoded();
                if (java.util.Arrays.equals((byte[])object3, (byte[])object2)) {
                    verificationResult.setDerEncodedSignedAttributes(true);
                    b = true;
                } else {
                    b = false;
                    verificationResult.setDerEncodedSignedAttributes(false);
                }
            }
            catch (IOException iOException) {
                b = false;
                verificationResult.setDerEncodedSignedAttributes(false);
                c.debug(iOException.getMessage(), (Throwable)iOException);
            }
        }
        if (object != null && ((CadesSignedDataProxy)object).getSignedData() != null) {
            cMSProcessable = (CMSProcessable)((CadesSignedDataProxy)object).getSignedData().getSignedContent().getContent();
        } else {
            try {
                byArray = signerInformation.getContentDigest();
            }
            catch (IllegalStateException illegalStateException) {
                if (signerInformation instanceof CapiSignerInformation) {
                    cMSProcessable = ((CapiSignerInformation)signerInformation).getSignedContent();
                }
                c.debug(illegalStateException.getMessage(), (Throwable)illegalStateException);
            }
        }
        object3 = CMSSignedHelper.INSTANCE.getEncryptionAlgName(signerInformation.getEncryptionAlgOID());
        object2 = null;
        try {
            object2 = signerInformationVerifier.getContentVerifier(signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getDigestAlgorithm());
        }
        catch (OperatorCreationException operatorCreationException) {
            verificationResult.setCreateContentVerifier(false);
            c.debug(operatorCreationException.getMessage(), (Throwable)operatorCreationException);
        }
        if (object2 != null) {
            try {
                outputStream = object2.getOutputStream();
                if (byArray == null) {
                    signerInformationVerifier = signerInformationVerifier.getDigestCalculator(signerInformation.getDigestAlgorithmID());
                    if (cMSProcessable != null) {
                        object = signerInformationVerifier.getOutputStream();
                        if (aSN1Set == null) {
                            if (object2 instanceof RawContentVerifier) {
                                cMSProcessable.write((OutputStream)object);
                            } else {
                                teeOutputStream = new TeeOutputStream((OutputStream)object, outputStream);
                                cMSProcessable.write((OutputStream)teeOutputStream);
                                teeOutputStream.close();
                            }
                        } else {
                            cMSProcessable.write((OutputStream)object);
                            if (b) {
                                outputStream.write(aSN1Set.getEncoded("DER"));
                            } else {
                                outputStream.write(aSN1Set.getEncoded());
                            }
                        }
                        ((OutputStream)object).close();
                    } else if (aSN1Set != null) {
                        if (b) {
                            outputStream.write(aSN1Set.getEncoded("DER"));
                        } else {
                            outputStream.write(aSN1Set.getEncoded());
                        }
                    } else {
                        verificationResult.setDataEncapsulatedInSignature(false);
                    }
                    byArray = signerInformationVerifier.getDigest();
                } else if (aSN1Set == null) {
                    if (cMSProcessable != null) {
                        cMSProcessable.write(outputStream);
                    }
                } else if (b) {
                    outputStream.write(aSN1Set.getEncoded("DER"));
                } else {
                    outputStream.write(aSN1Set.getEncoded());
                }
                outputStream.close();
            }
            catch (IOException iOException) {
                verificationResult.setProcessMimeObjectToCreateSignature(false);
                c.debug(iOException.getMessage(), (Throwable)iOException);
            }
            catch (OperatorCreationException operatorCreationException) {
                verificationResult.setCreateDigestCalculator(false);
                c.debug(operatorCreationException.getMessage(), (Throwable)operatorCreationException);
            }
            outputStream = CheckSignerInformation.a(CMSAttributes.contentType, "content-type", signerInfo);
            if (outputStream == null) {
                if (!bl && aSN1Set != null) {
                    verificationResult.setContentTypePresent(false);
                }
            } else if (bl) {
                verificationResult.setSignedAttributesContainContentType(true);
            } else if (!(outputStream instanceof ASN1ObjectIdentifier)) {
                verificationResult.setContentTypeValueOfObjectIdentifier(false);
            } else {
                signerInformationVerifier = (ASN1ObjectIdentifier)outputStream;
                if (!signerInformationVerifier.equals((ASN1Primitive)aSN1ObjectIdentifier)) {
                    verificationResult.setContentTypeMatchEContentType(false);
                }
            }
        }
        outputStream = null;
        if (signerInfo.getAuthenticatedAttributes() != null) {
            outputStream = new AttributeTable(signerInfo.getAuthenticatedAttributes());
        }
        signerInformationVerifier = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            signerInformationVerifier = new AttributeTable(signerInfo.getUnauthenticatedAttributes());
        }
        if (signerInformationVerifier != null && signerInformationVerifier.getAll(CMSAttributes.cmsAlgorithmProtect).size() > 0) {
            verificationResult.setCmsAlgorithmProtectASignedAttribute(false);
        }
        if (outputStream != null) {
            object = outputStream.getAll(CMSAttributes.cmsAlgorithmProtect);
            if (object.size() > 1) {
                verificationResult.setCmsAlgorithmProtectOnlyOneInstance(false);
            }
            if (object.size() > 0) {
                teeOutputStream = Attribute.getInstance((Object)object.get(0));
                if (teeOutputStream.getAttrValues().size() != 1) {
                    verificationResult.setCmsAlgorithmProtectAttributeContainExactlyOneValue(false);
                }
                if (!CMSUtils.isEquivalent((AlgorithmIdentifier)(signerInformationVerifier = CMSAlgorithmProtection.getInstance((Object)teeOutputStream.getAttributeValues()[0])).getDigestAlgorithm(), (AlgorithmIdentifier)signerInfo.getDigestAlgorithm())) {
                    verificationResult.setDigestAlgorithmCMSAlgorithmIdentifierProtectionCheckFailed(true);
                }
                if (!CMSUtils.isEquivalent((AlgorithmIdentifier)signerInformationVerifier.getSignatureAlgorithm(), (AlgorithmIdentifier)signerInfo.getDigestEncryptionAlgorithm())) {
                    verificationResult.setSignatureAlgorithmCMSAlgorithmIdentifierProtectionCheckFailed(true);
                }
            }
        }
        if ((signerInformationVerifier = CheckSignerInformation.a(CMSAttributes.messageDigest, "message-digest", signerInfo)) == null) {
            if (aSN1Set != null) {
                verificationResult.setMessageDigestSignedAttributeTypePresent(false);
            }
        } else {
            if (!(signerInformationVerifier instanceof ASN1OctetString)) {
                verificationResult.setMessageDigestValueOfOctetString(false);
            }
            if (!Arrays.constantTimeAreEqual((byte[])byArray, (byte[])(object = (ASN1OctetString)signerInformationVerifier).getOctets())) {
                verificationResult.setMessageDigestMatchCalculatedValue(false);
            }
        }
        if (outputStream != null && outputStream.getAll(CMSAttributes.counterSignature).size() > 0) {
            verificationResult.setCounterSignatureASignedAttribute(true);
        }
        signerInformationVerifier = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            signerInformationVerifier = new AttributeTable(signerInfo.getUnauthenticatedAttributes());
        }
        if (signerInformationVerifier != null) {
            object = signerInformationVerifier.getAll(CMSAttributes.counterSignature);
            for (int i = 0; i < object.size(); ++i) {
                signerInformationVerifier = Attribute.getInstance((Object)object.get(i));
                if (signerInformationVerifier.getAttrValues().size() > 0) continue;
                verificationResult.setCounterSignatureContainAttributeValue(false);
            }
        }
        if (object2 != null) {
            try {
                boolean bl2 = false;
                if (aSN1Set == null && byArray != null) {
                    if (object2 instanceof RawContentVerifier) {
                        object = (RawContentVerifier)object2;
                        if (((String)object3).equals("RSA")) {
                            DigestInfo digestInfo = new DigestInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier(signerInformation.getDigestAlgOID()), (ASN1Encodable)DERNull.INSTANCE), byArray);
                            bl2 = object.verify(digestInfo.getEncoded("DER"), signerInformation.getSignature());
                        } else {
                            bl2 = object.verify(byArray, signerInformation.getSignature());
                        }
                    }
                } else {
                    bl2 = object2.verify(signerInformation.getSignature());
                }
                verificationResult.setSignatureVerified(bl2);
            }
            catch (IOException iOException) {
                verificationResult.setProcessMimeObjectToCreateSignature(false);
                verificationResult.setSignatureVerified(false);
                c.debug(iOException.getMessage(), (Throwable)iOException);
            }
        }
        return verificationResult;
    }

    private static ASN1Primitive a(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string, SignerInfo signerInfo) throws CMSException {
        AttributeTable attributeTable = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            attributeTable = new AttributeTable(signerInfo.getUnauthenticatedAttributes());
        }
        if (attributeTable != null && attributeTable.getAll(aSN1ObjectIdentifier).size() > 0) {
            throw new CMSException("The " + string + " attribute MUST NOT be an unsigned attribute");
        }
        attributeTable = null;
        if (signerInfo.getAuthenticatedAttributes() != null) {
            attributeTable = new AttributeTable(signerInfo.getAuthenticatedAttributes());
        }
        if (attributeTable == null) {
            return null;
        }
        aSN1ObjectIdentifier = attributeTable.getAll(aSN1ObjectIdentifier);
        switch (aSN1ObjectIdentifier.size()) {
            case 0: {
                return null;
            }
            case 1: {
                aSN1ObjectIdentifier = (Attribute)aSN1ObjectIdentifier.get(0);
                aSN1ObjectIdentifier = aSN1ObjectIdentifier.getAttrValues();
                if (aSN1ObjectIdentifier.size() != 1) {
                    throw new CMSException("A " + string + " attribute MUST have a single attribute value");
                }
                return aSN1ObjectIdentifier.getObjectAt(0).toASN1Primitive();
            }
        }
        throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + string + " attribute");
    }
}

