/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import esecurity.enroll.CSRUtils;
import esecurity.enroll.bean.CertificateFields;
import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.AbstractSWKey;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.PureSWKey;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.ellips.capi.util.KeyUtils;
import it.actalis.ellips.capi.util.ini.IniFileException;
import it.actalis.ellips.capi.util.ini.SignedIniFile;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.spec.KeySpec;
import java.util.Enumeration;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class SoftToken
extends TokenSpi {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private boolean b = false;
    private String c = null;
    private boolean d = false;
    private boolean e = false;
    private String f = "Ellips.tok";
    private String g = null;
    private boolean h = false;
    private String i = null;
    private String j = null;
    private String k = null;
    private X509Certificate[] l = null;
    private SignedIniFile m = null;

    @Override
    public boolean exist(String string) throws CapiException {
        if (this.m == null) {
            throw new CapiException("Session not opened", 10013);
        }
        return this.m.containsObject(string);
    }

    @Override
    public String generateID(String[] stringArray) {
        this.i = stringArray[0];
        return this.i;
    }

    @Override
    public void initializeLib(String[] stringArray, boolean bl) throws CapiException {
        this.b = bl;
        this.initializeLib(stringArray);
    }

    @Override
    public void initializeLib(String[] stringArray) throws CapiException {
        String string;
        if (stringArray == null || stringArray.length <= 0 || stringArray[0] == null) {
            throw new CapiException("Wrong args", 1001);
        }
        this.i = stringArray[0];
        this.g = null;
        if (this.i.endsWith(File.separator)) {
            string = this.i.substring(0, this.i.length() - 1);
            this.g = this.i;
        } else {
            string = this.i;
            this.g = this.i + File.separator;
        }
        a.debug("path_nosep :" + string);
        a.debug("path_sep   :" + this.g);
        if (!SoftToken.a(this.g) && !SoftToken.a(string)) {
            throw new CapiException(this.i + " not exist", 12000);
        }
        if (!SoftToken.b(this.g) && !SoftToken.b(string)) {
            throw new CapiException(this.i + " is not a directory", 12001);
        }
        this.d = false;
        if (stringArray.length > 1 && stringArray[1] != null && stringArray[1].length() > 0) {
            this.d = true;
        }
        this.a(true);
        SoftToken softToken = this;
        softToken.initProviders(softToken);
        a.debug("init softToken");
    }

    @Override
    public void finalizeLib() {
        this.i = null;
    }

    public SoftToken(byte[] byArray, String string) throws CapiException {
        SoftToken softToken = this;
        softToken.initProviders(softToken);
        this.a(new ByteArrayInputStream(byArray), string);
    }

    public SoftToken(InputStream inputStream, String string) throws CapiException {
        this.a(inputStream, string);
    }

    private void a(InputStream object, String string) throws CapiException {
        Object object2;
        Object object3;
        Object object4;
        a.debug("init security providers");
        if (object == null || string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        Key key = null;
        it.actalis.ellips.capi.core.Certificate certificate = null;
        String string2 = null;
        try {
            object4 = KeyStore.getInstance("PKCS12", ProvUtils.bcProvider);
            ((KeyStore)object4).load((InputStream)object, string.toCharArray());
        }
        catch (KeyStoreException keyStoreException) {
            a.debug(keyStoreException.getMessage(), (Throwable)keyStoreException);
            throw new CapiException("KeyStoreException", 10035, keyStoreException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            a.debug(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            throw new CapiException("IllegalArgumentException-Cannot instance PKCS12", 10035, illegalArgumentException);
        }
        catch (IOException iOException) {
            a.debug(iOException.getMessage(), (Throwable)iOException);
            throw new CapiException(iOException.getMessage(), 10036, iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("NoSuchAlgorithmException", 10035);
        }
        catch (CertificateException certificateException) {
            a.debug(certificateException.getMessage(), (Throwable)certificateException);
            throw new CapiException("CertificateException", 10035);
        }
        catch (ClassCastException classCastException) {
            a.debug(classCastException.getMessage(), (Throwable)classCastException);
            throw new CapiException("Invalid PKCS12", 10035);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
        try {
            object = ((KeyStore)object4).aliases();
            while (object.hasMoreElements()) {
                key = null;
                object3 = (String)object.nextElement();
                if (!((KeyStore)object4).isKeyEntry((String)object3) || (key = (PrivateKey)((KeyStore)object4).getKey((String)object3, string.toCharArray())) == null || (object2 = ((KeyStore)object4).getCertificate((String)object3)) == null) continue;
                certificate = new it.actalis.ellips.capi.core.Certificate(((Certificate)object2).getEncoded());
                string2 = object3;
                break;
            }
            if (certificate == null) {
                throw new CapiException("PKCS12 Key and Certificate not found", 10035);
            }
            if (key.getAlgorithm().equalsIgnoreCase("RSA")) {
                int n = ((RSAKey)((Object)key)).getModulus().bitLength();
                a.debug("[SoftToken]pkcs12 key length=" + n);
            } else {
                object3 = PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])key.getEncoded()));
                object2 = ECNamedCurveTable.getName((ASN1ObjectIdentifier)((ASN1ObjectIdentifier)object3.getPrivateKeyAlgorithm().getParameters().toASN1Primitive()));
                a.debug("[SoftToken]pkcs12 Curve name =" + (String)object2);
            }
            a.debug("[SoftToken]pkcs12alias=" + string2);
            try {
                object3 = ((KeyStore)object4).getCertificateChain(string2);
                if (object3 != null && ((Certificate[])object3).length > 0) {
                    this.l = new X509Certificate[((Certificate[])object3).length];
                    object2 = CertificateFactory.getInstance("X.509");
                    for (int i = 0; object3 != null && i < ((Certificate[])object3).length; ++i) {
                        object4 = new ByteArrayInputStream(object3[i].getEncoded());
                        this.l[i] = (X509Certificate)((CertificateFactory)object2).generateCertificate((InputStream)object4);
                    }
                }
            }
            catch (Exception exception) {
                object3 = exception;
                exception.printStackTrace();
                this.l = null;
            }
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
        try {
            this.k = string;
            this.m = new SignedIniFile();
            this.a(string2, (PrivateKey)key, string);
            this.m.setProperty(string2, "class", "8");
            this.m.setProperty(string2, "usage", Integer.toString(3));
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error setting cred property", 10040);
        }
        a.debug("[SoftToken]pkcs12 instcert...");
        try {
            if ((this.getObjectType(string2) & 0xC) <= 0) {
                throw new CapiException("Alias is not a credential", 10021);
            }
            PublicKey publicKey = this.getPublicKey(string2);
            if (!certificate.getPublicKey().equals(publicKey)) {
                throw new CapiException("Public key not corresponding", 10033);
            }
            try {
                this.m.setProperty(string2, "class", "4");
                this.m.setProperty(string2, "certificate", certificate.getEncoded());
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Error setting cert property", 10040);
            }
            object3 = new SecureRandom();
            object2 = new BigInteger(130, (Random)object3).toString(32);
            this.setId((String)object2);
            Token.tokenTable.put(this.getId(), this);
            this.e = true;
            this.d = true;
            a.debug("[SoftToken]pkcs12 instcert ok");
            return;
        }
        catch (CapiException capiException) {
            a.debug("[SoftToken]install cert KO. " + capiException.getMessage());
            throw capiException;
        }
    }

    public SoftToken(KeyStore keyStore, String string) throws CapiException {
        Object object;
        Object object2;
        a.debug("init security providers");
        SoftToken softToken = this;
        softToken.initProviders(softToken);
        if (keyStore == null || string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        PrivateKey privateKey = null;
        it.actalis.ellips.capi.core.Certificate certificate = null;
        Certificate[] certificateArray = null;
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                privateKey = null;
                object2 = enumeration.nextElement();
                if (!keyStore.isKeyEntry((String)object2) || (privateKey = (PrivateKey)keyStore.getKey((String)object2, string.toCharArray())) == null || (object = keyStore.getCertificate((String)object2)) == null) continue;
                certificate = new it.actalis.ellips.capi.core.Certificate(((Certificate)object).getEncoded());
                certificateArray = object2;
                break;
            }
            if (certificate == null) {
                throw new CapiException("PKCS12 Key and Certificate not found", 10035);
            }
            int n = ((RSAKey)((Object)privateKey)).getModulus().bitLength();
            a.debug("[SoftToken]pkcs12 key length=" + n);
            a.debug("[SoftToken]pkcs12alias=" + certificateArray);
            try {
                object2 = keyStore.getCertificateChain((String)certificateArray);
                if (object2 != null && ((Certificate[])object2).length > 0) {
                    this.l = new X509Certificate[((Certificate[])object2).length];
                    object = CertificateFactory.getInstance("X.509");
                    for (int i = 0; object2 != null && i < ((Certificate[])object2).length; ++i) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(object2[i].getEncoded());
                        this.l[i] = (X509Certificate)((CertificateFactory)object).generateCertificate(byteArrayInputStream);
                    }
                }
            }
            catch (Exception exception) {
                object2 = exception;
                exception.printStackTrace();
                this.l = null;
            }
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
        try {
            this.k = string;
            this.m = new SignedIniFile();
            this.a((String)certificateArray, privateKey, string);
            this.m.setProperty((String)certificateArray, "class", "8");
            this.m.setProperty((String)certificateArray, "usage", Integer.toString(3));
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error setting cred property", 10040);
        }
        a.debug("[SoftToken]pkcs12 instcert...");
        try {
            if ((this.getObjectType((String)certificateArray) & 0xC) <= 0) {
                throw new CapiException("Alias is not a credential", 10021);
            }
            PublicKey publicKey = this.getPublicKey((String)certificateArray);
            if (!certificate.getPublicKey().equals(publicKey)) {
                throw new CapiException("Public key not corresponding", 10033);
            }
            try {
                this.m.setProperty((String)certificateArray, "class", "4");
                this.m.setProperty((String)certificateArray, "certificate", certificate.getEncoded());
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Error setting cert property", 10040);
            }
            object2 = new SecureRandom();
            object = new BigInteger(130, (Random)object2).toString(32);
            this.setId((String)object);
            Token.tokenTable.put(this.getId(), this);
            this.e = true;
            this.d = true;
            a.debug("[SoftToken]pkcs12 instcert ok");
            return;
        }
        catch (CapiException capiException) {
            a.debug("[SoftToken]install cert KO. " + capiException.getMessage());
            throw capiException;
        }
    }

    public void destroy() {
        try {
            Token.tokenTable.remove(this.getId());
            this.l = null;
            a.debug("[SoftToken] destroy done.");
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    public X509Certificate[] getP12SignerChain() {
        return this.l;
    }

    public SoftToken() {
    }

    @Override
    public String[] getLibInfo() {
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Software";
        stringArray2[1] = this.i;
        stringArray2[2] = "Ellips software Token";
        stringArray2[3] = "1.0";
        stringArray2[4] = "Actalis S.p.A.";
        stringArray2[5] = this.i;
        stringArray2[6] = "Actalis S.p.A.";
        stringArray2[7] = this.f;
        stringArray2[8] = "Actalis S.p.A.";
        return stringArray2;
    }

    @Override
    public boolean isTokenInserted() throws CapiException {
        this.a(false);
        try {
            if (this.e) {
                return true;
            }
            if (this.d) {
                return SoftToken.a(this.i);
            }
            return SoftToken.a(this.j) && SoftToken.c(this.j);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    @Override
    public String getSerialNumber() throws CapiException {
        return "0";
    }

    @Override
    public String getLabel() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            Object object;
            if (this.m == null) {
                object = new SignedIniFile("dummyID");
                object = ((SignedIniFile)object).loadHeader(this.j, false);
            } else {
                object = this.m.loadHeader(this.j, false);
            }
            this.c = new String((byte[])object, "ISO8859_1");
            return this.c;
        }
        catch (IniFileException iniFileException) {
            a.debug(iniFileException.getMessage(), (Throwable)iniFileException);
            throw iniFileException.toCapiException();
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("TokenID cannot be retrieved", 12003);
        }
    }

    @Override
    public long getMaxRSAKeyLength() throws CapiException {
        return 4096L;
    }

    @Override
    public long getMinRSAKeyLength() throws CapiException {
        return 768L;
    }

    @Override
    public long getFreeSpace() throws CapiException {
        return -1L;
    }

    @Override
    public void openSession(boolean bl, String string, int n) throws CapiException {
        this.openSession(bl, string);
    }

    @Override
    public void openSession(boolean bl, String string) throws CapiException {
        if (this.e) {
            return;
        }
        this.a(false);
        this.k = string;
        if (this.d && !SoftToken.a(this.j)) {
            this.m = new SignedIniFile("Ellips Software Token v1.0");
            return;
        }
        try {
            this.m = new SignedIniFile(this.j, Util.getBytes(string));
            return;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            a.debug(unrecoverableKeyException.getMessage(), (Throwable)unrecoverableKeyException);
            throw new CapiException("Wrong PIN", 2000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            a.debug(fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            throw new CapiException("Token not initalized", 10010);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong token format", 12003);
        }
    }

    @Override
    public void openSessionAuthPath(boolean bl) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    @Override
    public void openPublicSession() throws CapiException {
        throw new CapiException("openPublicSession not supported", 1004);
    }

    @Override
    public void closeSession() throws CapiException {
        this.m = null;
        this.k = null;
    }

    @Override
    public boolean isSessionOpen() throws CapiException {
        if (this.m == null) {
            return false;
        }
        if (!this.isTokenInserted()) {
            a.debug("Token not inserted");
            this.closeSession();
            return false;
        }
        if (this.e) {
            return true;
        }
        if (this.d && !SoftToken.a(this.j)) {
            a.debug("create new to check ...");
            return true;
        }
        try {
            this.m.loadHeader(this.j, true);
            return true;
        }
        catch (IniFileException iniFileException) {
            a.debug(iniFileException.getMessage(), (Throwable)iniFileException);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            a.debug("token probably removed ");
        }
        this.closeSession();
        return false;
    }

    @Override
    public byte[] getData(String string) throws CapiException {
        try {
            return Util.base64DecodeStr(this.m.getProperty(string, "data"));
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Alias is not a data object", 10020);
        }
    }

    @Override
    public void setData(String string, byte[] byArray, int n) throws CapiException {
        this.a(string, n);
        try {
            this.m.setProperty(string, "class", "1");
            this.m.setProperty(string, "data", Util.base64EncodeStr(byArray));
            this.m.store(this.j, Util.getBytes(this.k));
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public String getCert(String string) throws CapiException {
        try {
            return this.m.getProperty(string, "certificate");
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Alias is not a cert", 10022);
        }
    }

    @Override
    public void setCert(String string, byte[] object, int n, boolean bl) throws CapiException {
        this.a(string, n);
        object = new it.actalis.ellips.capi.core.Certificate((byte[])object);
        try {
            this.m.setProperty(string, "class", "2");
            this.m.setProperty(string, "certificate", ((it.actalis.ellips.capi.core.Certificate)object).getEncoded());
            this.m.store(this.j, Util.getBytes(this.k));
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public String installCertificate(it.actalis.ellips.capi.core.Certificate certificate) throws CapiException {
        a.debug("installCertificate find alias ...");
        PublicKey publicKey = null;
        String string = null;
        for (String string2 : this.m.getObjectList2()) {
            if ((this.getObjectType(string2) & 0xC) <= 0) continue;
            PublicKey publicKey2 = this.getPublicKey(string2);
            try {
                certificate.getInternalCert().verify(publicKey2);
                SoftToken softToken = this;
                if (!softToken.checkKeyUsage(softToken.getKeyUsage(string2, true), certificate.getKeyUsageBits())) continue;
                publicKey = publicKey2;
                string = string2;
                break;
            }
            catch (Exception exception) {}
        }
        if (publicKey == null) {
            throw new CapiException("Public key not corresponding", 10033);
        }
        a.debug("Public key Found {}", string);
        this.instCert(string, certificate, true, false);
        return string;
    }

    @Override
    public void changePIN(String string, String string2) throws CapiException {
        boolean bl = false;
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        if (this.isSessionOpen()) {
            bl = true;
        } else {
            this.openSession(false, string);
        }
        String[] stringArray = this.listObjects(null, (byte)12);
        for (int i = 0; i < stringArray.length; ++i) {
            this.recipherPrivateKey(stringArray[i], string, string2);
        }
        try {
            this.m.store(this.j, Util.getBytes(string2));
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error writing file", 12004);
        }
        this.k = string2;
        if (!bl) {
            this.closeSession();
        }
    }

    @Override
    public void changePUK(String string, String string2) throws CapiException {
        throw new CapiException("Change PUK not supported", 1004);
    }

    @Override
    public void unblockPIN(String string, String string2) throws CapiException {
        throw new CapiException("Unblock not supported", 1004);
    }

    @Override
    public boolean canImport() {
        return true;
    }

    @Override
    public boolean canExport(String string) {
        return true;
    }

    @Override
    public int canUnblock() {
        return 0;
    }

    @Override
    public void genKeyPair(String string, int n, int n2, int n3) throws CapiException {
        this.genKeyPair(string, KeyAlgo.RSA, n, n2, n3);
    }

    @Override
    public void genKeyPair(String string, KeyAlgo object, int n, int n2, int n3) throws CapiException {
        this.a(string, n3);
        object = new PureSWKey(string, (KeyAlgo)((Object)object), this.k, n2);
        object = ((AbstractSWKey)object).getEncoded();
        try {
            this.m.setProperty(string, "class", "8");
            this.m.setProperty(string, "usage", Integer.toString(n));
            this.m.setProperty(string, "keys", Util.base64EncodeStr((byte[])object));
            this.m.store(this.j, Util.getBytes(this.k));
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public String impCred(String string, PrivateKey privateKey, int n, int n2) throws CapiException {
        this.a(string, n2);
        this.a(string, privateKey, this.k);
        try {
            this.m.setProperty(string, "class", "8");
            this.m.setProperty(string, "usage", Integer.toString(n));
            this.m.store(this.j, Util.getBytes(this.k));
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error writing file", 12004);
        }
        return string;
    }

    @Override
    public PrivateKey expCred(String string) throws CapiException {
        return this.getPrivateKeySpi(string, this.k);
    }

    @Override
    public PublicKey getPublicKey(String string) throws CapiException {
        try {
            return KeyUtils.rebuildPublicKeyFromPrivate((AbstractSWKey)this.getPrivateKey(string, this.k));
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error getting key", 10021);
        }
    }

    public PrivateKey getPrivateKey(String string, String string2) throws CapiException {
        try {
            String string3 = this.m.getProperty(string, "keys");
            Object object = this.m.getProperty(string, "keyclass");
            a.debug("[getPrivateKey] keyclass is: " + (String)object);
            if (object == null || ((String)object).compareTo("it.actalis.ellips.capi.provider.PureSWKey") == 0) {
                a.debug("[getPrivateKey] PureSWKey ... TokenSpi.fromPKCS8");
                object = new PureSWKey(string, string2, Util.base64DecodeStr(string3));
            } else {
                a.debug("[getPrivateKey] AbstractSWKey");
                object = (AbstractSWKey)Class.forName((String)object, false, Thread.currentThread().getContextClassLoader()).newInstance();
                ((Actalis_PrivateKey)object).setAlias(string);
                ((AbstractSWKey)object).setEncoded(Util.base64DecodeStr(string3));
                ((AbstractSWKey)object).setPin(string2);
            }
            ((Actalis_PrivateKey)object).setCryptoDev(this);
            return object;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error getting key", 10021);
        }
    }

    public void recipherPrivateKey(String string, String object, String object2) throws CapiException {
        try {
            String string2 = this.m.getProperty(string, "keys");
            Object object3 = this.m.getProperty(string, "keyclass");
            a.debug("[recipherPrivateKey] keyclass is: " + (String)object3);
            if (object3 == null || ((String)object3).compareTo("it.actalis.ellips.capi.PureSWKey") == 0) {
                a.debug("[recipherPrivateKey] PureSWKey ... TokenSpi.fromPKCS8");
                a.debug("keys for " + string + ": " + string2);
                object3 = new PureSWKey(string, (String)object, Util.base64DecodeStr(string2));
                ((Actalis_PrivateKey)object3).setCryptoDev(this);
                object = new PureSWKey(string, (String)object2, ((AbstractSWKey)object3).getPrivateKeySpi());
                ((Actalis_PrivateKey)object).setCryptoDev(this);
            } else {
                a.debug("[recipherPrivateKey] AbstractSWKey");
                object3 = (AbstractSWKey)Class.forName((String)object3, false, Thread.currentThread().getContextClassLoader()).newInstance();
                ((Actalis_PrivateKey)object3).setAlias(string);
                ((AbstractSWKey)object3).setEncoded(Util.base64DecodeStr(string2));
                ((AbstractSWKey)object3).setPin((String)object);
                ((Actalis_PrivateKey)object3).setCryptoDev(this);
                object = object3;
                ((Actalis_PrivateKey)object).setCryptoDev(this);
                ((AbstractSWKey)object).setPin((String)object2);
            }
            object2 = ((AbstractSWKey)object).getEncoded();
            a.debug(object2 == null ? "[recipherPrivateKey] sk is null" : "[setPrivateKey] sk is not null");
            a.debug("[recipherPrivateKey][ini.setProperty] alias:" + string + " keyclass:" + object.getClass().getName());
            this.m.setProperty(string, "keyclass", object.getClass().getName());
            a.debug("[ini.setProperty] alias:" + string + " keys:" + Util.base64EncodeStr((byte[])object2));
            this.m.setProperty(string, "keys", Util.base64EncodeStr((byte[])object2));
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error getting key", 10021);
        }
    }

    public PrivateKey getPrivateKeySpi(String object, String object2) throws CapiException {
        try {
            object = this.m.getProperty((String)object, "keys");
            object = SoftToken.fromPKCS8(Util.base64DecodeStr((String)object), (String)object2);
            object2 = KeyFactory.getInstance("RSA");
            object = ((KeyFactory)object2).generatePrivate((KeySpec)object);
            return object;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error getting key", 10021);
        }
    }

    @Override
    public void instCert(String string, it.actalis.ellips.capi.core.Certificate certificate, boolean bl, boolean bl2) throws CapiException {
        if ((this.getObjectType(string) & 0xC) <= 0) {
            throw new CapiException("Alias is not a credential", 10021);
        }
        PublicKey publicKey = this.getPublicKey(string);
        if (!certificate.getPublicKey().equals(publicKey)) {
            throw new CapiException("Public key not corresponding", 10033);
        }
        if (bl) {
            SoftToken softToken = this;
            if (!softToken.checkKeyUsage(softToken.getKeyUsage(string, true), certificate.getKeyUsageBits())) {
                throw new CapiException("Key usage not corresponding", 10037);
            }
        }
        try {
            this.m.setProperty(string, "class", "4");
            this.m.setProperty(string, "certificate", certificate.getEncoded());
            this.m.store(this.j, Util.getBytes(this.k));
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public int getKeyUsage(String string, boolean bl) throws CapiException {
        try {
            string = this.m.getProperty(string, "usage");
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Not a credential", 10021);
        }
    }

    @Override
    public int getKeyLength(String string) throws CapiException {
        try {
            PublicKey publicKey = this.getPublicKey(string);
            int n = ((RSAKey)((Object)publicKey)).getModulus().bitLength();
            int n2 = (n + 255) / 256 << 8;
            a.debug("getKeyLength alias=" + string + " value=" + n + " ->" + n2);
            return n2;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 10040);
        }
    }

    @Override
    public byte[] doSign(byte[] byArray, String object, int n) throws CapiException {
        a.debug("doSign alias=" + (String)object);
        try {
            object = (AbstractSWKey)this.getPrivateKey((String)object, this.k);
            a.debug("signing RSA LENGTH: in=" + byArray.length);
            a.debug("hash  : " + new String(Hex.encode((byte[])byArray)));
            if (((Actalis_PrivateKey)object).getAlgorithm().equalsIgnoreCase("RSA")) {
                if (n == 3) {
                    ((AbstractSWKey)object).init("RSA/ECB/NoPadding", 1);
                } else {
                    ((AbstractSWKey)object).init("RSA/ECB/PKCS1Padding", 1);
                }
            }
            byArray = ((AbstractSWKey)object).doFinal(byArray, n);
            a.debug("result: " + new String(Hex.encode((byte[])byArray)));
            return byArray;
        }
        catch (CapiException capiException) {
            object = capiException;
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Invalid signature", 3010);
        }
    }

    @Override
    public byte[] doDecrypt(byte[] byArray, String object, int n) throws CapiException {
        a.debug("doDecrypt alias=" + (String)object);
        try {
            object = (AbstractSWKey)this.getPrivateKey((String)object, this.k);
            a.debug("RSA LENGTH: in=" + byArray.length);
            a.debug("digest: " + new String(Hex.encode((byte[])byArray)));
            if (n == 4) {
                ((AbstractSWKey)object).init("RSA/ECB/NoPadding", 2);
            } else {
                ((AbstractSWKey)object).init("RSA/ECB/PKCS1Padding", 2);
            }
            byArray = ((AbstractSWKey)object).doFinal(byArray, n);
            a.debug("result: " + new String(Hex.encode((byte[])byArray)));
            return byArray;
        }
        catch (CapiException capiException) {
            object = capiException;
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Invalid signature", 3010);
        }
    }

    @Override
    public String[] listObjects(String string, byte by) throws CapiException {
        try {
            String[] stringArray = this.m.getObjectList2();
            if (stringArray == null) {
                return new String[0];
            }
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if ((this.getObjectType(stringArray[i]) & by) == 0 || string != null && stringArray[i].indexOf(string) < 0) continue;
                stringArray2[n++] = stringArray[i];
            }
            if (n == 0) {
                return new String[0];
            }
            String[] stringArray3 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray3[i] = stringArray2[i];
            }
            return stringArray3;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("internal error", 1003);
        }
    }

    @Override
    public void deleteObject(String string) throws CapiException {
        try {
            if (this.m.removeObject(string)) {
                this.m.store(this.j, Util.getBytes(this.k));
            }
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public byte getObjectType(String string) throws CapiException {
        try {
            string = this.m.getProperty(string, "class");
            int n = Integer.valueOf(string);
            return (byte)n;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong alias", 10023);
        }
    }

    @Override
    public int getObjectSize(String string) throws CapiException {
        return -1;
    }

    @Override
    public void renameObject(String string, String string2, int n) throws CapiException {
        if (!this.m.containsObject(string)) {
            throw new CapiException("Object not found", 10023);
        }
        this.a(string2, n);
        try {
            if (this.m.renameObject(string, string2)) {
                this.m.store(this.j, Util.getBytes(this.k));
            }
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error writing file", 12004);
        }
    }

    @Override
    public long getMaxPINLen() throws CapiException {
        return 80L;
    }

    @Override
    public long getMinPINLen() throws CapiException {
        return 8L;
    }

    private void a(boolean bl) {
        a.debug("trying fallback " + bl);
        if (bl) {
            this.h = false;
        } else {
            if (this.h) {
                return;
            }
            this.h = true;
        }
        this.f = "Ellips.tok";
        this.j = this.g + this.f;
        if (this.d) {
            if (this.b) {
                this.f = "SIAsecure.tok";
                this.j = this.g + this.f;
            }
            return;
        }
        if (SoftToken.a(this.j) && SoftToken.c(this.j)) {
            return;
        }
        this.f = "SIAsecure.tok";
        this.j = this.g + this.f;
        if (SoftToken.a(this.j) && SoftToken.c(this.j)) {
            return;
        }
        this.f = this.b ? "SIAsecure.tok" : "Ellips.tok";
        this.j = this.g + this.f;
        a.debug("path full  :" + this.j);
    }

    private static boolean a(String object) {
        try {
            object = new File((String)object);
            a.debug("exists? " + ((File)object).getAbsolutePath());
            return ((File)object).exists();
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    private static boolean b(String object) {
        try {
            object = new File((String)object);
            a.debug("canonical dir:" + ((File)object).getCanonicalPath());
            return ((File)object).isDirectory();
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    private static boolean c(String object) {
        try {
            object = new File((String)object);
            a.debug("canonical file:" + ((File)object).getCanonicalPath());
            return ((File)object).isFile();
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    private void a(String string, PrivateKey object, String string2) throws CapiException {
        try {
            AbstractSWKey abstractSWKey;
            if (object instanceof AbstractSWKey) {
                a.debug("[setPrivateKey] key instanceof AbstractSWKey");
                abstractSWKey = (AbstractSWKey)object;
            } else {
                a.debug("[setPrivateKey] key instanceof PureSWKey");
                abstractSWKey = new PureSWKey(string, string2, (PrivateKey)object);
            }
            abstractSWKey.setCryptoDev(this);
            if (object instanceof AbstractSWKey) {
                a.debug("[setPrivateKey] AbstractSWKey.getEncoded()");
                object = abstractSWKey.getEncoded();
            } else {
                a.debug("[setPrivateKey] PureSWKey.getForcedEncoded()");
                object = abstractSWKey.getForcedEncoded(string2);
            }
            a.debug("[ini.setProperty] alias:" + string + " keyclass:" + abstractSWKey.getClass().getName());
            this.m.setProperty(string, "keyclass", abstractSWKey.getClass().getName());
            a.debug("[ini.setProperty] alias:" + string + " keys:" + Util.base64EncodeStr((byte[])object));
            this.m.setProperty(string, "keys", Util.base64EncodeStr((byte[])object));
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error writing file", 12004);
        }
    }

    private void a(String string, int n) throws CapiException {
        if (this.m == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (n == 2) {
            throw new CapiException("Unsupported multiple mode on token software", 10034);
        }
        if (this.m.containsObject(string) && n == 0) {
            throw new CapiException("Object already exist", 10024);
        }
        this.m.removeObject(string);
    }

    @Override
    public PrivateKey getPrivateKey(String string) throws CapiException {
        return this.getPrivateKey(string, this.k);
    }

    @Override
    public String getLibName() {
        return null;
    }

    @Override
    public String getObjectID(String string) throws CapiException {
        return null;
    }

    @Override
    public void setCert(String string, it.actalis.ellips.capi.core.Certificate certificate, int n, byte[] byArray, boolean bl) throws CapiException {
    }

    @Override
    public void setCkaId(String string, String string2, byte[] byArray) throws CapiException {
    }

    @Override
    public CertificationRequest generatePKCS10CertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        if (x500Name == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        try {
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), publicKey.getEncoded());
            publicKey = new CertificationRequestInfo(x500Name, subjectPublicKeyInfo, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't encode public key");
        }
        Signature signature = Signature.getInstance("SHA1withRSA", ActalisSingleton.getActalisProvider());
        signature.initSign(privateKey);
        try {
            signature.update(publicKey.getEncoded("DER"));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("exception encoding TBS cert request - " + exception);
        }
        x500Name = new CertificationRequestInfo(x500Name, subjectPublicKeyInfo, null);
        x500Name = new CertificationRequest((CertificationRequestInfo)x500Name, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE), new DERBitString(signature.sign()));
        return x500Name;
    }

    @Override
    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, String string) throws CapiException {
        return this.certReq(x500Name, publicKey, privateKey, Security.getProvider(string));
    }

    @Override
    public String certReq(String string, X500Name x500Name) throws CapiException {
        return this.certReq(x500Name, this.getPublicKey(string), this.getPrivateKey(string), ProvUtils.actalisProvider);
    }

    @Override
    public byte[] generateCertificateRequest(KeyType object, KeyAlgo keyAlgo, int n, String string, GeneralNames[] generalNamesArray, String object2) throws CapiException {
        try {
            object2 = new CertificateFields(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            a.error(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            throw new CapiException("Invalid CN: " + string, 1003);
        }
        string = "GenericKey%d";
        String string2 = "";
        KeyPair keyPair = null;
        for (int i = 0; i < 3; ++i) {
            block11: {
                try {
                    string2 = String.format(string, i);
                    this.genKeyPair(string2, keyAlgo, 1, n, 0);
                    keyPair = new KeyPair(this.getPublicKey(string2), this.getPrivateKey(string2));
                }
                catch (CapiException capiException) {
                    CapiException capiException2 = capiException;
                    if (capiException.getErrorCode() == 11002) {
                        throw capiException2;
                    }
                    a.error(capiException2.getMessage(), (Throwable)capiException2);
                    if (object == KeyType.CNS) {
                        throw new CapiException("Unable To Generate Key", 10032, capiException2);
                    }
                }
                catch (Exception exception) {
                    a.error(exception.getMessage(), (Throwable)exception);
                    if (object != KeyType.CNS) break block11;
                    throw new CapiException("Unable To Generate Key", 10032, exception);
                }
            }
            if (keyPair != null) break;
        }
        if (keyPair == null) {
            throw new CapiException("Unable To Generate Key", 10032);
        }
        try {
            PKCS10CertificationRequest pKCS10CertificationRequest = CSRUtils.generateCertificateRequest(ProvUtils.actalisProvider, keyPair, (CertificateFields)object2, generalNamesArray);
            object = pKCS10CertificationRequest.getEncoded();
        }
        catch (IOException | NoSuchAlgorithmException | OperatorCreationException throwable) {
            this.deleteObject(string2);
            throw new CapiException("Unable To Generate Csr", 1003, throwable);
        }
        return object;
    }

    @Override
    public void initializeLib(TokenParameters tokenParameters) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean requiredExtendedAuth() {
        return false;
    }

    @Override
    public RecoverySessionCredential openSessionWithExtendedAuth(boolean bl, String string, ExtendedCredentials extendedCredentials) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name object, PublicKey object2, PrivateKey privateKey, Provider provider) throws CapiException {
        try {
            a.debug("creating and signing certreq...");
            a.debug("subject: " + object.toString());
            try {
                object = new JcaPKCS10CertificationRequestBuilder(object, (PublicKey)object2);
                object = object.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider(provider).build(privateKey));
            }
            catch (Exception exception) {
                object = exception;
                throw exception;
            }
            a.debug("certRequest ok");
        }
        catch (IllegalStateException illegalStateException) {
            a.debug(illegalStateException.getMessage(), (Throwable)illegalStateException);
            throw new CapiException("IllegalStateException", 1003);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("NoSuchProviderException", 1003);
        }
        try {
            object2 = new StringWriter();
            privateKey = new PEMWriter((Writer)object2);
            privateKey.writeObject(object);
            privateKey.close();
            object = new String(((StringWriter)object2).getBuffer());
            return object;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Exception saving PEM certificate Requet", 1003);
        }
    }

    @Override
    public void resetToken(String string) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

