/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.beans;

import esecurity.crypto.gui.model.CardHandler;
import esecurity.crypto.gui.model.ListHandler;
import esecurity.crypto.gui.model.signer.CardSigner;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.util.List;

public class CardCertificateListHandler
extends ListHandler<CardHandler> {
    private static CardCertificateListHandler a = new CardCertificateListHandler();
    private static final EllipsLogger b = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static CardCertificateListHandler getInstance() {
        return a;
    }

    public List<CardHandler> getCardCerts() {
        return this.getList(CardHandler.class);
    }

    @Override
    public void clear() {
        if (this.OBJECTS.size() > 0) {
            for (CardHandler cardHandler : this.getCardCerts()) {
                try {
                    TokenHelper.destroy((TokenSpi)cardHandler.getCard().getToken());
                }
                catch (CapiException capiException) {
                    b.error(capiException.getMessage(), (Throwable)capiException);
                }
            }
        }
        this.OBJECTS.clear();
        this.LISTENERS.forEach(listener -> listener.notify(this.OBJECTS));
    }

    public CardSigner getCertificateFromKey(String string) {
        for (CardHandler cardHandler : this.getCardCerts()) {
            for (CardSigner cardSigner : cardHandler.getCardSigners()) {
                if (!cardSigner.getValidatedCertificate().getCertSerial().equals(string)) continue;
                return cardSigner;
            }
        }
        return null;
    }
}

