/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.provider.PureSWKey;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import sun.security.rsa.RSAPrivateCrtKeyImpl;

public class KeyUtils {
    public static PublicKey rebuildPublicKeyFromPrivate(PrivateKey object) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        if (object.getAlgorithm().equalsIgnoreCase("RSA")) {
            PrivateKey privateKey = object;
            if (object instanceof PureSWKey) {
                privateKey = ((PureSWKey)object).getPrivateKeySpi();
            }
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider());
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)RSAPrivateCrtKeyImpl.newKey((byte[])privateKey.getEncoded());
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent());
            return (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        }
        if (object.getAlgorithm().equalsIgnoreCase("EC") || object.getAlgorithm().equalsIgnoreCase("ECDSA")) {
            PrivateKey privateKey = object;
            ECPoint eCPoint = null;
            ECParameterSpec eCParameterSpec = null;
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", (Provider)new BouncyCastleProvider());
            if (object instanceof PureSWKey) {
                privateKey = ((PureSWKey)object).getPrivateKeySpi();
            }
            if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
                object = PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])privateKey.getEncoded()));
                object = ECNamedCurveTable.getName((ASN1ObjectIdentifier)((ASN1ObjectIdentifier)object.getPrivateKeyAlgorithm().getParameters().toASN1Primitive()));
                eCParameterSpec = org.bouncycastle.jce.ECNamedCurveTable.getParameterSpec((String)object);
                eCPoint = eCParameterSpec.getG().multiply(((java.security.interfaces.ECPrivateKey)privateKey).getS());
            }
            if (privateKey instanceof ECPrivateKey) {
                eCParameterSpec = ((ECPrivateKey)privateKey).getParameters();
                eCPoint = eCParameterSpec.getG().multiply(((ECPrivateKey)privateKey).getD());
            }
            object = eCPoint.getEncoded(false);
            object = eCParameterSpec.getCurve().decodePoint((byte[])object);
            object = new ECPublicKeySpec((ECPoint)object, eCParameterSpec);
            return (ECPublicKey)keyFactory.generatePublic((KeySpec)object);
        }
        throw new InvalidKeyException("Unsupported Key Type");
    }
}

