/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.util.java6;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.ATR;
import it.actalis.vol.utils.Constants;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;

public class PCSC6 {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private TerminalFactory b = null;
    private List c = null;
    private String[] d = null;
    private int e = 0;
    private Card f = null;
    private CardChannel g = null;
    private CardTerminal h = null;
    public boolean exclusive = true;
    private String i = null;
    private String j = null;

    public PCSC6() throws Exception {
        try {
            this.b = TerminalFactory.getDefault();
            this.c = this.b.terminals().list();
            if (this.c == null || this.c.isEmpty() || this.c.size() == 0) {
                this.d = null;
                PCSC6.a("No reader found.");
                throw new CardException("");
            }
            this.d = new String[this.c.size()];
            PCSC6.a("Found " + this.c.size() + " readers.");
            for (int i = 0; i < this.c.size(); ++i) {
                CardTerminal cardTerminal = (CardTerminal)this.c.get(i);
                this.d[i] = cardTerminal.getName().trim();
                PCSC6.a("Found reader: " + this.d[i] + " - n. " + i);
            }
            this.i = System.getProperty("os.name");
            this.j = System.getProperty("java.version");
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PCSC6.a(exception);
            throw exception2;
        }
    }

    public List<String> getAllATR() {
        if (this.c == null || this.c.isEmpty()) {
            PCSC6.a("No reader found.");
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.c.size(); ++i) {
            byte[] byArray = this.a(i, -1L);
            if (byArray == null || byArray.length <= 0) continue;
            arrayList.add(ATR.toHexString(byArray).toLowerCase());
        }
        return arrayList;
    }

    public String[] getPcscReaders() {
        return this.d;
    }

    public int getLastSlotWithCardPresent() {
        return this.e;
    }

    public boolean waitCardRemoveFromReader() {
        boolean bl;
        block5: {
            if (this.h == null) {
                return true;
            }
            try {
                bl = true;
                if (!this.i.toLowerCase().startsWith("mac os") || this.j.compareTo("1.7") < 0) break block5;
                PCSC6.a("mac os and java version " + this.j);
                Thread.sleep(1000L);
                Object object = this.h.connect("*");
                byte[] byArray = this.a((Card)object);
                object = byArray;
                return byArray == null || ((Object)object).length <= 0;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                PCSC6.a(exception);
                return true;
            }
        }
        if (this.h.isCardPresent()) {
            bl = this.h.waitForCardAbsent(500L);
        }
        return bl;
    }

    public byte[] getATR() {
        return this.waitCardIntoReader(-1, -1L);
    }

    public byte[] waitCardIntoReader(int n, long l) {
        try {
            if (this.c == null || this.c.isEmpty() || this.c.size() == 0 || n >= this.c.size()) {
                PCSC6.a("No reader found.");
                return null;
            }
            if (n == -1) {
                for (n = 0; n < this.c.size(); ++n) {
                    byte[] byArray = this.a(n, l);
                    if (byArray == null || byArray.length <= 0) continue;
                    return byArray;
                }
            } else {
                byte[] byArray = this.a(n, l);
                return byArray;
            }
            return null;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PCSC6.a(exception);
            return null;
        }
    }

    private byte[] a(int n, long l) {
        try {
            Card card;
            byte[] byArray;
            PCSC6.a("getting ATR of card in reader n. " + n + " ...");
            CardTerminal cardTerminal = (CardTerminal)this.c.get(n);
            if (this.i.toLowerCase().startsWith("mac os") && this.j.compareTo("1.7") >= 0) {
                PCSC6.a("mac os and java version " + this.j);
                if (l > 0L) {
                    Thread.sleep(l);
                }
            } else {
                boolean bl = l >= 0L ? cardTerminal.waitForCardPresent(l) : cardTerminal.isCardPresent();
                if (!bl) {
                    PCSC6.a("card not present in reader " + cardTerminal.getName().trim());
                    return null;
                }
            }
            if ((byArray = this.a(card = cardTerminal.connect("*"))) != null && byArray.length > 0) {
                PCSC6.a("atr: " + PCSC6.byteArrayToHexString(byArray));
                PCSC6.a("reader n. " + n);
                PCSC6.a("reader name: " + cardTerminal.getName().trim());
                this.e = n;
                this.f = card;
                this.h = cardTerminal;
            } else {
                PCSC6.a("no atr from card in reader " + cardTerminal.getName().trim());
            }
            return byArray;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PCSC6.a(exception);
            return null;
        }
    }

    private byte[] a(Card object) throws Exception {
        if (object == null) {
            PCSC6.a("Card is null");
            return null;
        }
        if ((object = ((Card)object).getATR()) == null) {
            PCSC6.a("ATR is null");
            return null;
        }
        byte[] byArray = ((javax.smartcardio.ATR)object).getBytes();
        object = byArray;
        if (byArray != null && ((Object)object).length > 0) {
            PCSC6.a("atr successfully detected");
        } else {
            PCSC6.a("no atr bytes");
        }
        return object;
    }

    public void connect() throws Exception {
        if (this.f == null) {
            throw new Exception("No card inserted.");
        }
        PCSC6.a("APDU communication - exclusive is " + this.exclusive);
        this.g = this.f.getBasicChannel();
        if (this.exclusive) {
            this.f.beginExclusive();
            PCSC6.a("APDU communication is exclusive ");
        }
    }

    public byte[] sendAPDU(byte[] object) throws Exception {
        ResponseAPDU responseAPDU = this.g.transmit(new CommandAPDU((byte[])object));
        object = responseAPDU;
        return responseAPDU.getBytes();
    }

    public void disconnect() {
        if (this.f == null) {
            return;
        }
        try {
            if (this.exclusive) {
                this.f.endExclusive();
            }
            this.f.disconnect(false);
            return;
        }
        catch (CardException cardException) {
            CardException cardException2 = cardException;
            PCSC6.a(cardException);
            return;
        }
    }

    public static byte[] hexStringToByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            int n2 = n = i << 1;
            n = Integer.parseInt(string.substring(n2, n2 + 2), 16);
            byArray[i] = (byte)n;
        }
        return byArray;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length << 1);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString().toUpperCase();
    }

    private static void a(String string) {
        a.debug("[PCSC6] {}", (Object)string);
    }

    private static void a(Exception exception) {
        a.debug(exception.getMessage(), (Throwable)exception);
    }
}

