/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.encrypt;

import it.actalis.ellips.capi.cms.encrypt.EncryptEnvelopeOptions;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;

public class EncryptEnvelopeGenerator {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public void encrypt(EncryptEnvelopeOptions encryptEnvelopeOptions) throws CapiException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        try {
            try {
                JceKeyTransRecipientInfoGenerator jceKeyTransRecipientInfoGenerator;
                int n;
                inputStream = encryptEnvelopeOptions.getInput().getInputAsNewStream();
                outputStream = encryptEnvelopeOptions.getOutput().getAsOutputStream();
                byte[] byArray = new byte[64000];
                CMSEnvelopedDataStreamGenerator cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
                for (n = 0; n < encryptEnvelopeOptions.getRecipients().size(); ++n) {
                    jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(encryptEnvelopeOptions.getRecipients().get(n));
                    cMSEnvelopedDataStreamGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)jceKeyTransRecipientInfoGenerator);
                }
                n = inputStream.read(byArray);
                jceKeyTransRecipientInfoGenerator = new ASN1ObjectIdentifier(encryptEnvelopeOptions.getAlgorithm().getOid());
                encryptEnvelopeOptions = new JceCMSContentEncryptorBuilder((ASN1ObjectIdentifier)jceKeyTransRecipientInfoGenerator);
                encryptEnvelopeOptions.setProvider(ProvUtils.bcProvider);
                encryptEnvelopeOptions = encryptEnvelopeOptions.build();
                outputStream2 = cMSEnvelopedDataStreamGenerator.open(outputStream, (OutputEncryptor)encryptEnvelopeOptions);
                while (n != -1) {
                    outputStream2.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                outputStream2.close();
                outputStream2 = null;
                outputStream.close();
                outputStream = null;
                inputStream.close();
                inputStream = null;
                return;
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("Encrypt Envelope Generation Exception:" + iOException.getMessage(), 50040);
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Encrypt Envelope Generation Exception:" + exception.getMessage(), 50040);
            }
        }
        catch (Throwable throwable) {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage(), (Throwable)iOException);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage(), (Throwable)iOException);
                }
            }
            if (outputStream2 != null) {
                try {
                    outputStream2.close();
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage(), (Throwable)iOException);
                }
            }
            throw throwable;
        }
    }
}

