/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.arubasign.gui;

import esecurity.crypto.gui.utils.swt.ImageHandler;
import esecurity.desktop.DOMEvent;
import esecurity.desktop.Event;
import esecurity.desktop.Listener;
import esecurity.desktop.View;
import esecurity.desktop.dom.Button;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.dom.Image;
import it.arubapec.arubasign.gui.DropdownList;
import java.util.HashMap;
import java.util.Map;

public class DropdownEntry {
    private DivContainer menuContent;
    private final Button menuEntry;
    private Map<String, Image> iconsMap = new HashMap<String, Image>();
    private final Listener<Event> onSelectListener;

    public DivContainer getMenuContent() {
        return this.menuContent;
    }

    public Map<String, Image> getIconsMap() {
        return this.iconsMap;
    }

    public Button getMenuEntry() {
        return this.menuEntry;
    }

    public DropdownEntry(DropdownList list, String menuEntryLabel, Map<Button, Runnable> menuContentButtons, String bodyId, View view) {
        this.menuEntry = new Button(list.getParent().getId() + "_" + menuEntryLabel + "_menuEntry", (DOMElement)list.getParent(), view, () -> menuEntryLabel);
        this.menuEntry.addClass("cg-menuBarMenuEntry");
        this.menuContent = new DivContainer(list.getParent().getId() + "_" + menuEntryLabel + "_menuContent", (DOMElement)list.getParent(), view);
        this.menuContent.addClass("cg-menuBarDropDownMenu");
        this.menuContent.setVisible(false);
        for (Button btn : menuContentButtons.keySet()) {
            this.menuContent.appendChild((DOMElement)btn);
            btn.onClick(evt -> {
                ((Runnable)menuContentButtons.get(btn)).run();
                this.menuContent.setVisible(false);
            });
        }
        this.onSelectListener = evt -> {
            if (this.menuContent.isDisplayed()) {
                this.menuContent.setVisible(false);
            } else {
                this.menuContent.setVisible(true);
            }
        };
        this.menuEntry.onClick(this.onSelectListener);
        view.setEventListenerById(bodyId, DOMEvent.CLICK, evt -> this.menuContent.setVisible(false), false);
    }

    public DropdownEntry(DropdownList list, String menuEntryLabel, Map<Button, Runnable> menuContentButtons, String bodyId, View view, String imageSrc) {
        this.menuEntry = new Button(list.getParent().getId() + "_" + menuEntryLabel + "_menuEntry", (DOMElement)list.getParent(), view, () -> menuEntryLabel);
        this.menuEntry.addClass("cg-menuBarMenuEntry");
        this.menuContent = new DivContainer(list.getParent().getId() + "_" + menuEntryLabel + "_menuContent", (DOMElement)list.getParent(), view);
        this.menuContent.addClass("cg-menuBarDropDownMenu");
        this.menuContent.setVisible(false);
        for (Button btn : menuContentButtons.keySet()) {
            Image image = new Image(btn.getId() + "_image", (DOMElement)btn, view);
            image.setSource(ImageHandler.retrieveBase64Image((String)imageSrc));
            image.addClass("cg-dropDownMenuConfirmImage");
            image.setVisible(false);
            this.menuContent.appendChild((DOMElement)btn);
            this.iconsMap.put(btn.getId() + "_image", image);
            btn.onClick(evt -> {
                if (!image.isDisplayed()) {
                    image.setVisible(true);
                } else {
                    image.setVisible(false);
                }
                ((Runnable)menuContentButtons.get(btn)).run();
                this.menuContent.setVisible(false);
            });
        }
        this.onSelectListener = evt -> {
            if (this.menuContent.isDisplayed()) {
                this.menuContent.setVisible(false);
            } else {
                this.menuContent.setVisible(true);
            }
        };
        this.menuEntry.onClick(this.onSelectListener);
        view.setEventListenerById(bodyId, DOMEvent.CLICK, evt -> this.menuContent.setVisible(false), false);
    }

    public DropdownEntry(String menuEntryLabel, DropdownList list, View view) {
        this.menuEntry = new Button(list.getParent().getId() + "_" + menuEntryLabel + "_menuEntry", (DOMElement)list.getParent(), view, () -> menuEntryLabel);
        this.menuEntry.addClass("cg-menuBarMenuEntry");
        this.onSelectListener = null;
    }

    public void hideMenu() {
        this.menuContent.setVisible(false);
    }
}

