/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import esecurity.dts.TimeStampToken;
import esecurity.tsl.CertChain;
import esecurity.tsl.CertDb;
import esecurity.tsl.v5.TrustStatusListType;
import esecurity.validator.ValidationDate;
import esecurity.validator.constants.ValidationProfile;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.xml.parser.SignedXMLEnvelope;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.tsp.TimeStampResponse;
import org.slf4j.Logger;

public class TSLDownloader {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private final NetworkConfig b;
    private boolean c = false;

    public TSLDownloader(NetworkConfig networkConfig, Logger logger) {
        this.b = networkConfig;
        if (logger != null) {
            a = logger;
        }
    }

    public InputHandler downloadTsl(String string) throws IOException {
        try {
            return DataHandlerBuilder.get().setUrl(new URL(string)).setUrlNetConf(this.b).buildInput();
        }
        catch (Throwable throwable) {
            throw new IOException("Unable do Download TSL: " + string, throwable);
        }
    }

    public TrustStatusListType parseTSL(InputHandler jAXBElement, CertDb object) throws IOException {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{TrustStatusListType.class});
            CertDb certDb = object;
            Object object2 = jAXBElement;
            object = this;
            if (certDb == null) {
                a.debug("TSL signature validation is skipped");
            } else {
                object = new SignedXMLEnvelope((InputHandler)object2);
                if ((object2 = ((SignedXMLEnvelope)object).listSigners()) == null || ((String[])object2).length <= 0) {
                    a.debug("No signers found. TSL is not signed");
                    throw new CapiException("TSL is not signed", 50001);
                }
                a.debug("Checking first TSL signature");
                try {
                    Object object3;
                    Object object4;
                    object2 = ((SignedXMLEnvelope)object).verify(0);
                    Object object5 = new Certificate(((String)object2).getBytes());
                    a.debug("TSL signature verified successfully.");
                    a.debug("Signed TSL. TSL signer: " + ((Certificate)object5).getSubjectDN());
                    object5 = null;
                    try {
                        if (((SignedXMLEnvelope)object).getNumSignatureTimeStamp(0) > 0 && (object4 = ((SignedXMLEnvelope)object).getSignatureTimeStamp(0, 0)) != null) {
                            object5 = new ByteArrayInputStream(((TimeStampToken)object4).toByteArray(true));
                            object3 = new TimeStampResponse((InputStream)object5);
                            object5 = Util.getDateFromTStamp(object3.getTimeStampToken());
                            a.debug("TSL TimeStamped signTime: {}", (Object)((Date)object5).toString());
                        }
                    }
                    catch (Exception exception) {
                        object5 = null;
                    }
                    if (object5 == null && (object4 = ((SignedXMLEnvelope)object).getSigningTime(0)) != null) {
                        try {
                            a.debug("[verifyXMLSignature] parse TSL signTime: " + (String)object4);
                            object5 = TSLDownloader.a((String)object4);
                            a.debug("TSL signTime: " + ((Date)object5).toString());
                        }
                        catch (Exception exception) {
                            a.debug("Unable to parse SignTime: " + exception.getMessage());
                        }
                    }
                    int n = ((SignedXMLEnvelope)object).getNumReference(0);
                    a.debug("TSL signature has " + n + " Reference items...");
                    for (int i = 0; i < n; ++i) {
                        boolean bl = ((SignedXMLEnvelope)object).getReferenceIsVerified(0, i);
                        a.debug(i + " Reference verification is " + bl);
                        if (bl) continue;
                        a.debug("reference item " + i + " verification failed");
                        throw new CapiException("reference item " + i + " verification failed ", 3010);
                    }
                    Certificate certificate = new Certificate(((String)object2).getBytes());
                    object3 = certDb.retrieveCertificateChain(certificate);
                    if (!(((CertChain)object3).isMatchProfile(ValidationProfile.ADVANCED_ELECTRONIC_SIGNATURE_PROFILE, ValidationDate.getNow()) && ((CertChain)object3).overAllOk() || certDb.containsCertificate(certificate))) {
                        throw new CapiException("Invalid TSL Signature", 3010);
                    }
                }
                catch (CapiException capiException) {
                    a.debug(capiException.getMessage(), (Throwable)capiException);
                    throw capiException;
                }
                catch (Exception exception) {
                    a.debug("TSL has an invalid signature");
                    a.debug(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Exception verifying TSL signature " + exception.getMessage(), 3010);
                }
            }
            object = jAXBContext.createUnmarshaller();
            jAXBElement = (JAXBElement)object.unmarshal(jAXBElement.getInputAsNewStream());
            return (TrustStatusListType)jAXBElement.getValue();
        }
        catch (Exception exception) {
            throw new IOException("Unable do parse TSL.", exception);
        }
    }

    private static Date a(String string) throws Exception {
        try {
            Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            cloneable.setTimeZone(TimeZone.getTimeZone("Zulu"));
            cloneable = cloneable.parse(string);
            return cloneable;
        }
        catch (Exception exception) {
            try {
                Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                cloneable.setTimeZone(TimeZone.getTimeZone("Zulu"));
                cloneable = cloneable.parse(string);
                return cloneable;
            }
            catch (Exception exception2) {
                try {
                    Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                    cloneable.setTimeZone(TimeZone.getTimeZone("Zulu"));
                    cloneable = cloneable.parse(string.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2"));
                    return cloneable;
                }
                catch (Exception exception3) {
                    a.debug("Exception parsing TSL issue date: " + exception3.getMessage());
                    return null;
                }
            }
        }
    }

    public boolean isForceHttps() {
        return this.c;
    }

    public void setForceHttps(boolean bl) {
        this.c = bl;
    }

    public void setReadTimeout(int n) {
        this.b.setReadTimeOut("" + n);
    }

    public void setConnectionTimeout(int n) {
        this.b.setConnectionTimeOut("" + n);
    }

    public NetworkConfig getNetworkConfig() {
        return this.b;
    }
}

