/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

public class DsDef {
    public static final String[] DS_TYPES = new String[]{"GAUGE", "COUNTER", "DERIVE", "ABSOLUTE"};
    private String dsName;
    private String dsType;
    private long heartbeat;
    private double minValue;
    private double maxValue;

    public DsDef(String string, String string2, long l, double d, double d2) throws RrdException {
        this.dsName = string;
        this.dsType = string2;
        this.heartbeat = l;
        this.minValue = d;
        this.maxValue = d2;
        this.validate();
    }

    public String getDsName() {
        return this.dsName;
    }

    public String getDsType() {
        return this.dsType;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    private void validate() throws RrdException {
        if (this.dsName == null || this.dsName.length() == 0) {
            throw new RrdException("Invalid datasource name specified");
        }
        if (!DsDef.isValidDsType(this.dsType)) {
            throw new RrdException("Invalid datasource type specified: " + this.dsType);
        }
        if (this.heartbeat <= 0L) {
            throw new RrdException("Invalid heartbeat, must be positive: " + this.heartbeat);
        }
        if (!Double.isNaN(this.minValue) && !Double.isNaN(this.maxValue) && this.minValue >= this.maxValue) {
            throw new RrdException("Invalid min/max values specified: " + this.minValue + "/" + this.maxValue);
        }
    }

    public static boolean isValidDsType(String string) {
        for (int i = 0; i < DS_TYPES.length; ++i) {
            if (!DS_TYPES[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public String dump() {
        return "DS:" + this.dsName + ":" + this.dsType + ":" + this.heartbeat + ":" + Util.formatDouble(this.minValue, "U", false) + ":" + Util.formatDouble(this.maxValue, "U", false);
    }

    public boolean equals(Object object) {
        if (object instanceof DsDef) {
            DsDef dsDef = (DsDef)object;
            return this.dsName.equals(dsDef.dsName);
        }
        return false;
    }

    boolean exactlyEqual(DsDef dsDef) {
        return this.dsName.equals(dsDef.dsName) && this.dsType.equals(dsDef.dsType) && this.heartbeat == dsDef.heartbeat && Util.equal(this.minValue, dsDef.minValue) && Util.equal(this.maxValue, dsDef.maxValue);
    }
}

