/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.monitor;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.videolan.vlma.VLMaService;
import org.videolan.vlma.model.Server;
import org.videolan.vlma.monitor.Monitor;

public class ServerStateMonitor
implements Monitor {
    private static final Logger logger = Logger.getLogger(ServerStateMonitor.class);
    private Configuration configuration;
    private VLMaService vlmaService;
    private Thread checkVLCThread;
    private Thread serverStateMonitorDaemonThread;
    private AtomicBoolean shouldRun = new AtomicBoolean(true);
    private Runnable vLCchecker = new Runnable(){

        public void run() {
            ArrayList<CheckThread> checkThreads = new ArrayList<CheckThread>();
            for (Server server : ServerStateMonitor.this.vlmaService.getServers()) {
                CheckThread checkThread = new CheckThread(ServerStateMonitor.this.vlmaService, server);
                checkThreads.add(checkThread);
                checkThread.start();
            }
            for (Thread thread : checkThreads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {}
            }
        }
    };
    Runnable serverStateMonitor = new Runnable(){

        public void run() {
            ServerStateMonitor.this.shouldRun.set(true);
            while (ServerStateMonitor.this.shouldRun.get()) {
                try {
                    Thread.sleep(1000 * ServerStateMonitor.this.configuration.getInt("vlma.monitor.server.interval"));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!ServerStateMonitor.this.shouldRun.get()) continue;
                ServerStateMonitor.this.startCheckVLCThread();
            }
            logger.debug((Object)"ServerStateMonitor thread stopped.");
        }
    };

    public boolean isCheckingVLC() {
        return this.checkVLCThread != null && this.checkVLCThread.isAlive();
    }

    public boolean isDaemonMonitoring() {
        return this.serverStateMonitorDaemonThread != null && this.serverStateMonitorDaemonThread.isAlive();
    }

    public synchronized void startCheckVLCThread() {
        if (!this.isCheckingVLC()) {
            this.checkVLCThread = new Thread(this.vLCchecker);
            this.checkVLCThread.setName("checkVLCThread");
            this.checkVLCThread.start();
        }
    }

    public synchronized void start() {
        if (!this.isDaemonMonitoring()) {
            logger.info((Object)("Starting " + this.getClass().getSimpleName()));
            this.serverStateMonitorDaemonThread = new Thread(this.serverStateMonitor);
            this.serverStateMonitorDaemonThread.setName("serverStateMonitorThread");
            this.serverStateMonitorDaemonThread.start();
        }
    }

    public synchronized void stop() {
        logger.info((Object)("Stopping " + this.getClass().getSimpleName()));
        this.shouldRun.set(false);
        this.serverStateMonitorDaemonThread.interrupt();
    }

    public void setVlmaService(VLMaService vlmaService) {
        this.vlmaService = vlmaService;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private class CheckThread
    extends Thread {
        private VLMaService vlmaService;
        private Server server;

        public CheckThread(VLMaService vlmaService, Server server) {
            this.vlmaService = vlmaService;
            this.server = server;
        }

        public void run() {
            this.vlmaService.checkVLC(this.server);
        }
    }
}

