// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Storage_H
#define WINRT_Windows_Storage_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Storage.FileProperties.2.h"
#include "winrt/impl/Windows.Storage.Provider.2.h"
#include "winrt/impl/Windows.Storage.Search.2.h"
#include "winrt/impl/Windows.Storage.Streams.2.h"
#include "winrt/impl/Windows.System.2.h"
#include "winrt/impl/Windows.Storage.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Storage_IAppDataPaths<D>::Cookies() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Cookies(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Cookies(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IAppDataPaths<D>::Desktop() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Desktop(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Desktop(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IAppDataPaths<D>::Documents() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Documents(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Documents(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IAppDataPaths<D>::Favorites() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Favorites(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Favorites(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IAppDataPaths<D>::History() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_History(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_History(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IAppDataPaths<D>::InternetCache() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InternetCache(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_InternetCache(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IAppDataPaths<D>::LocalAppData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LocalAppData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_LocalAppData(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IAppDataPaths<D>::ProgramData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProgramData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_ProgramData(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IAppDataPaths<D>::RoamingAppData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RoamingAppData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_RoamingAppData(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IAppDataPathsStatics<D>::GetForUser(winrt::Windows::System::User const& user) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPathsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPathsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPathsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetForUser(*(void**)(&user), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPathsStatics>**)this;
            check_hresult(_winrt_abi_type->GetForUser(*(void**)(&user), &result));
        }
        return winrt::Windows::Storage::AppDataPaths{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IAppDataPathsStatics<D>::GetDefault() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IAppDataPathsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IAppDataPathsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPathsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefault(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IAppDataPathsStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefault(&result));
        }
        return winrt::Windows::Storage::AppDataPaths{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::Version() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Version(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->get_Version(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::SetVersionAsync(uint32_t desiredVersion, winrt::Windows::Storage::ApplicationDataSetVersionHandler const& handler) const
    {
        void* setVersionOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetVersionAsync(desiredVersion, *(void**)(&handler), &setVersionOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->SetVersionAsync(desiredVersion, *(void**)(&handler), &setVersionOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ setVersionOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::ClearAsync() const
    {
        void* clearOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClearAllAsync(&clearOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->ClearAllAsync(&clearOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ clearOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::ClearAsync(winrt::Windows::Storage::ApplicationDataLocality const& locality) const
    {
        void* clearOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClearAsync(static_cast<int32_t>(locality), &clearOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->ClearAsync(static_cast<int32_t>(locality), &clearOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ clearOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::LocalSettings() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LocalSettings(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->get_LocalSettings(&value));
        }
        return winrt::Windows::Storage::ApplicationDataContainer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::RoamingSettings() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RoamingSettings(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->get_RoamingSettings(&value));
        }
        return winrt::Windows::Storage::ApplicationDataContainer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::LocalFolder() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LocalFolder(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->get_LocalFolder(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::RoamingFolder() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RoamingFolder(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->get_RoamingFolder(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::TemporaryFolder() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TemporaryFolder(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->get_TemporaryFolder(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::DataChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::ApplicationData, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DataChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->add_DataChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::DataChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::ApplicationData, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, DataChanged_revoker>(this, DataChanged(handler));
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::DataChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DataChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            _winrt_abi_type->remove_DataChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::SignalDataChanged() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SignalDataChanged());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->SignalDataChanged());
        }
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData<D>::RoamingStorageQuota() const
    {
        uint64_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RoamingStorageQuota(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData>**)this;
            check_hresult(_winrt_abi_type->get_RoamingStorageQuota(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData2<D>::LocalCacheFolder() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LocalCacheFolder(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData2>**)this;
            check_hresult(_winrt_abi_type->get_LocalCacheFolder(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData3<D>::GetPublisherCacheFolder(param::hstring const& folderName) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetPublisherCacheFolder(*(void**)(&folderName), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData3>**)this;
            check_hresult(_winrt_abi_type->GetPublisherCacheFolder(*(void**)(&folderName), &value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData3<D>::ClearPublisherCacheFolderAsync(param::hstring const& folderName) const
    {
        void* clearOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClearPublisherCacheFolderAsync(*(void**)(&folderName), &clearOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData3>**)this;
            check_hresult(_winrt_abi_type->ClearPublisherCacheFolderAsync(*(void**)(&folderName), &clearOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ clearOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationData3<D>::SharedLocalFolder() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationData3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationData3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SharedLocalFolder(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationData3>**)this;
            check_hresult(_winrt_abi_type->get_SharedLocalFolder(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationDataContainer<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationDataContainer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationDataContainer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationDataContainer<D>::Locality() const
    {
        winrt::Windows::Storage::ApplicationDataLocality value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationDataContainer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationDataContainer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Locality(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)this;
            check_hresult(_winrt_abi_type->get_Locality(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IApplicationDataContainer<D>::Values() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationDataContainer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationDataContainer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Values(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)this;
            check_hresult(_winrt_abi_type->get_Values(&value));
        }
        return winrt::Windows::Foundation::Collections::IPropertySet{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationDataContainer<D>::Containers() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationDataContainer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationDataContainer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Containers(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)this;
            check_hresult(_winrt_abi_type->get_Containers(&value));
        }
        return winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::Storage::ApplicationDataContainer>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationDataContainer<D>::CreateContainer(param::hstring const& name, winrt::Windows::Storage::ApplicationDataCreateDisposition const& disposition) const
    {
        void* container{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationDataContainer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationDataContainer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateContainer(*(void**)(&name), static_cast<int32_t>(disposition), &container));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)this;
            check_hresult(_winrt_abi_type->CreateContainer(*(void**)(&name), static_cast<int32_t>(disposition), &container));
        }
        return winrt::Windows::Storage::ApplicationDataContainer{ container, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationDataContainer<D>::DeleteContainer(param::hstring const& name) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationDataContainer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationDataContainer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DeleteContainer(*(void**)(&name)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataContainer>**)this;
            check_hresult(_winrt_abi_type->DeleteContainer(*(void**)(&name)));
        }
    }
    template <typename D> auto consume_Windows_Storage_IApplicationDataStatics<D>::Current() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationDataStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationDataStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Current(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataStatics>**)this;
            check_hresult(_winrt_abi_type->get_Current(&value));
        }
        return winrt::Windows::Storage::ApplicationData{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IApplicationDataStatics2<D>::GetForUserAsync(winrt::Windows::System::User const& user) const
    {
        void* getForUserOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IApplicationDataStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IApplicationDataStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetForUserAsync(*(void**)(&user), &getForUserOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IApplicationDataStatics2>**)this;
            check_hresult(_winrt_abi_type->GetForUserAsync(*(void**)(&user), &getForUserOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::ApplicationData>{ getForUserOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ICachedFileManagerStatics<D>::DeferUpdates(winrt::Windows::Storage::IStorageFile const& file) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ICachedFileManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ICachedFileManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ICachedFileManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DeferUpdates(*(void**)(&file)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ICachedFileManagerStatics>**)this;
            check_hresult(_winrt_abi_type->DeferUpdates(*(void**)(&file)));
        }
    }
    template <typename D> auto consume_Windows_Storage_ICachedFileManagerStatics<D>::CompleteUpdatesAsync(winrt::Windows::Storage::IStorageFile const& file) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ICachedFileManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ICachedFileManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ICachedFileManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CompleteUpdatesAsync(*(void**)(&file), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ICachedFileManagerStatics>**)this;
            check_hresult(_winrt_abi_type->CompleteUpdatesAsync(*(void**)(&file), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Provider::FileUpdateStatus>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IDownloadsFolderStatics<D>::CreateFileAsync(param::hstring const& desiredName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IDownloadsFolderStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IDownloadsFolderStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFileAsync(*(void**)(&desiredName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics>**)this;
            check_hresult(_winrt_abi_type->CreateFileAsync(*(void**)(&desiredName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IDownloadsFolderStatics<D>::CreateFolderAsync(param::hstring const& desiredName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IDownloadsFolderStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IDownloadsFolderStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFolderAsync(*(void**)(&desiredName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics>**)this;
            check_hresult(_winrt_abi_type->CreateFolderAsync(*(void**)(&desiredName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IDownloadsFolderStatics<D>::CreateFileAsync(param::hstring const& desiredName, winrt::Windows::Storage::CreationCollisionOption const& option) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IDownloadsFolderStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IDownloadsFolderStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFileWithCollisionOptionAsync(*(void**)(&desiredName), static_cast<int32_t>(option), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics>**)this;
            check_hresult(_winrt_abi_type->CreateFileWithCollisionOptionAsync(*(void**)(&desiredName), static_cast<int32_t>(option), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IDownloadsFolderStatics<D>::CreateFolderAsync(param::hstring const& desiredName, winrt::Windows::Storage::CreationCollisionOption const& option) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IDownloadsFolderStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IDownloadsFolderStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFolderWithCollisionOptionAsync(*(void**)(&desiredName), static_cast<int32_t>(option), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics>**)this;
            check_hresult(_winrt_abi_type->CreateFolderWithCollisionOptionAsync(*(void**)(&desiredName), static_cast<int32_t>(option), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IDownloadsFolderStatics2<D>::CreateFileForUserAsync(winrt::Windows::System::User const& user, param::hstring const& desiredName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IDownloadsFolderStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IDownloadsFolderStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFileForUserAsync(*(void**)(&user), *(void**)(&desiredName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics2>**)this;
            check_hresult(_winrt_abi_type->CreateFileForUserAsync(*(void**)(&user), *(void**)(&desiredName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IDownloadsFolderStatics2<D>::CreateFolderForUserAsync(winrt::Windows::System::User const& user, param::hstring const& desiredName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IDownloadsFolderStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IDownloadsFolderStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFolderForUserAsync(*(void**)(&user), *(void**)(&desiredName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics2>**)this;
            check_hresult(_winrt_abi_type->CreateFolderForUserAsync(*(void**)(&user), *(void**)(&desiredName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IDownloadsFolderStatics2<D>::CreateFileForUserAsync(winrt::Windows::System::User const& user, param::hstring const& desiredName, winrt::Windows::Storage::CreationCollisionOption const& option) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IDownloadsFolderStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IDownloadsFolderStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFileForUserWithCollisionOptionAsync(*(void**)(&user), *(void**)(&desiredName), static_cast<int32_t>(option), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics2>**)this;
            check_hresult(_winrt_abi_type->CreateFileForUserWithCollisionOptionAsync(*(void**)(&user), *(void**)(&desiredName), static_cast<int32_t>(option), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IDownloadsFolderStatics2<D>::CreateFolderForUserAsync(winrt::Windows::System::User const& user, param::hstring const& desiredName, winrt::Windows::Storage::CreationCollisionOption const& option) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IDownloadsFolderStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IDownloadsFolderStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFolderForUserWithCollisionOptionAsync(*(void**)(&user), *(void**)(&desiredName), static_cast<int32_t>(option), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IDownloadsFolderStatics2>**)this;
            check_hresult(_winrt_abi_type->CreateFolderForUserWithCollisionOptionAsync(*(void**)(&user), *(void**)(&desiredName), static_cast<int32_t>(option), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::ReadTextAsync(winrt::Windows::Storage::IStorageFile const& file) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadTextAsync(*(void**)(&file), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->ReadTextAsync(*(void**)(&file), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::ReadTextAsync(winrt::Windows::Storage::IStorageFile const& file, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadTextWithEncodingAsync(*(void**)(&file), static_cast<int32_t>(encoding), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->ReadTextWithEncodingAsync(*(void**)(&file), static_cast<int32_t>(encoding), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::WriteTextAsync(winrt::Windows::Storage::IStorageFile const& file, param::hstring const& contents) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteTextAsync(*(void**)(&file), *(void**)(&contents), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteTextAsync(*(void**)(&file), *(void**)(&contents), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::WriteTextAsync(winrt::Windows::Storage::IStorageFile const& file, param::hstring const& contents, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteTextWithEncodingAsync(*(void**)(&file), *(void**)(&contents), static_cast<int32_t>(encoding), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteTextWithEncodingAsync(*(void**)(&file), *(void**)(&contents), static_cast<int32_t>(encoding), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::AppendTextAsync(winrt::Windows::Storage::IStorageFile const& file, param::hstring const& contents) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AppendTextAsync(*(void**)(&file), *(void**)(&contents), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->AppendTextAsync(*(void**)(&file), *(void**)(&contents), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::AppendTextAsync(winrt::Windows::Storage::IStorageFile const& file, param::hstring const& contents, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AppendTextWithEncodingAsync(*(void**)(&file), *(void**)(&contents), static_cast<int32_t>(encoding), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->AppendTextWithEncodingAsync(*(void**)(&file), *(void**)(&contents), static_cast<int32_t>(encoding), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::ReadLinesAsync(winrt::Windows::Storage::IStorageFile const& file) const
    {
        void* linesOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadLinesAsync(*(void**)(&file), &linesOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->ReadLinesAsync(*(void**)(&file), &linesOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVector<hstring>>{ linesOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::ReadLinesAsync(winrt::Windows::Storage::IStorageFile const& file, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* linesOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadLinesWithEncodingAsync(*(void**)(&file), static_cast<int32_t>(encoding), &linesOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->ReadLinesWithEncodingAsync(*(void**)(&file), static_cast<int32_t>(encoding), &linesOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVector<hstring>>{ linesOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::WriteLinesAsync(winrt::Windows::Storage::IStorageFile const& file, param::async_iterable<hstring> const& lines) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteLinesAsync(*(void**)(&file), *(void**)(&lines), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteLinesAsync(*(void**)(&file), *(void**)(&lines), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::WriteLinesAsync(winrt::Windows::Storage::IStorageFile const& file, param::async_iterable<hstring> const& lines, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteLinesWithEncodingAsync(*(void**)(&file), *(void**)(&lines), static_cast<int32_t>(encoding), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteLinesWithEncodingAsync(*(void**)(&file), *(void**)(&lines), static_cast<int32_t>(encoding), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::AppendLinesAsync(winrt::Windows::Storage::IStorageFile const& file, param::async_iterable<hstring> const& lines) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AppendLinesAsync(*(void**)(&file), *(void**)(&lines), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->AppendLinesAsync(*(void**)(&file), *(void**)(&lines), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::AppendLinesAsync(winrt::Windows::Storage::IStorageFile const& file, param::async_iterable<hstring> const& lines, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AppendLinesWithEncodingAsync(*(void**)(&file), *(void**)(&lines), static_cast<int32_t>(encoding), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->AppendLinesWithEncodingAsync(*(void**)(&file), *(void**)(&lines), static_cast<int32_t>(encoding), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::ReadBufferAsync(winrt::Windows::Storage::IStorageFile const& file) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadBufferAsync(*(void**)(&file), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->ReadBufferAsync(*(void**)(&file), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::WriteBufferAsync(winrt::Windows::Storage::IStorageFile const& file, winrt::Windows::Storage::Streams::IBuffer const& buffer) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteBufferAsync(*(void**)(&file), *(void**)(&buffer), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteBufferAsync(*(void**)(&file), *(void**)(&buffer), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IFileIOStatics<D>::WriteBytesAsync(winrt::Windows::Storage::IStorageFile const& file, array_view<uint8_t const> buffer) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IFileIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IFileIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteBytesAsync(*(void**)(&file), buffer.size(), get_abi(buffer), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IFileIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteBytesAsync(*(void**)(&file), buffer.size(), get_abi(buffer), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersCameraRollStatics<D>::CameraRoll() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersCameraRollStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersCameraRollStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersCameraRollStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CameraRoll(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersCameraRollStatics>**)this;
            check_hresult(_winrt_abi_type->get_CameraRoll(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersPlaylistsStatics<D>::Playlists() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersPlaylistsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersPlaylistsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersPlaylistsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Playlists(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersPlaylistsStatics>**)this;
            check_hresult(_winrt_abi_type->get_Playlists(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersSavedPicturesStatics<D>::SavedPictures() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersSavedPicturesStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersSavedPicturesStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersSavedPicturesStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SavedPictures(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersSavedPicturesStatics>**)this;
            check_hresult(_winrt_abi_type->get_SavedPictures(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics<D>::MusicLibrary() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MusicLibrary(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)this;
            check_hresult(_winrt_abi_type->get_MusicLibrary(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics<D>::PicturesLibrary() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PicturesLibrary(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)this;
            check_hresult(_winrt_abi_type->get_PicturesLibrary(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics<D>::VideosLibrary() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VideosLibrary(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)this;
            check_hresult(_winrt_abi_type->get_VideosLibrary(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics<D>::DocumentsLibrary() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DocumentsLibrary(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)this;
            check_hresult(_winrt_abi_type->get_DocumentsLibrary(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics<D>::HomeGroup() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HomeGroup(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)this;
            check_hresult(_winrt_abi_type->get_HomeGroup(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics<D>::RemovableDevices() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RemovableDevices(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)this;
            check_hresult(_winrt_abi_type->get_RemovableDevices(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics<D>::MediaServerDevices() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MediaServerDevices(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics>**)this;
            check_hresult(_winrt_abi_type->get_MediaServerDevices(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics2<D>::Objects3D() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Objects3D(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics2>**)this;
            check_hresult(_winrt_abi_type->get_Objects3D(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics2<D>::AppCaptures() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AppCaptures(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics2>**)this;
            check_hresult(_winrt_abi_type->get_AppCaptures(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics2<D>::RecordedCalls() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecordedCalls(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics2>**)this;
            check_hresult(_winrt_abi_type->get_RecordedCalls(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics3<D>::GetFolderForUserAsync(winrt::Windows::System::User const& user, winrt::Windows::Storage::KnownFolderId const& folderId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFolderForUserAsync(*(void**)(&user), static_cast<int32_t>(folderId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics3>**)this;
            check_hresult(_winrt_abi_type->GetFolderForUserAsync(*(void**)(&user), static_cast<int32_t>(folderId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics4<D>::RequestAccessAsync(winrt::Windows::Storage::KnownFolderId const& folderId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestAccessAsync(static_cast<int32_t>(folderId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics4>**)this;
            check_hresult(_winrt_abi_type->RequestAccessAsync(static_cast<int32_t>(folderId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::KnownFoldersAccessStatus>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics4<D>::RequestAccessForUserAsync(winrt::Windows::System::User const& user, winrt::Windows::Storage::KnownFolderId const& folderId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestAccessForUserAsync(*(void**)(&user), static_cast<int32_t>(folderId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics4>**)this;
            check_hresult(_winrt_abi_type->RequestAccessForUserAsync(*(void**)(&user), static_cast<int32_t>(folderId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::KnownFoldersAccessStatus>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IKnownFoldersStatics4<D>::GetFolderAsync(winrt::Windows::Storage::KnownFolderId const& folderId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IKnownFoldersStatics4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IKnownFoldersStatics4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFolderAsync(static_cast<int32_t>(folderId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IKnownFoldersStatics4>**)this;
            check_hresult(_winrt_abi_type->GetFolderAsync(static_cast<int32_t>(folderId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::ReadTextAsync(param::hstring const& absolutePath) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadTextAsync(*(void**)(&absolutePath), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->ReadTextAsync(*(void**)(&absolutePath), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::ReadTextAsync(param::hstring const& absolutePath, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadTextWithEncodingAsync(*(void**)(&absolutePath), static_cast<int32_t>(encoding), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->ReadTextWithEncodingAsync(*(void**)(&absolutePath), static_cast<int32_t>(encoding), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::WriteTextAsync(param::hstring const& absolutePath, param::hstring const& contents) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteTextAsync(*(void**)(&absolutePath), *(void**)(&contents), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteTextAsync(*(void**)(&absolutePath), *(void**)(&contents), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::WriteTextAsync(param::hstring const& absolutePath, param::hstring const& contents, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteTextWithEncodingAsync(*(void**)(&absolutePath), *(void**)(&contents), static_cast<int32_t>(encoding), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteTextWithEncodingAsync(*(void**)(&absolutePath), *(void**)(&contents), static_cast<int32_t>(encoding), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::AppendTextAsync(param::hstring const& absolutePath, param::hstring const& contents) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AppendTextAsync(*(void**)(&absolutePath), *(void**)(&contents), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->AppendTextAsync(*(void**)(&absolutePath), *(void**)(&contents), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::AppendTextAsync(param::hstring const& absolutePath, param::hstring const& contents, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* textOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AppendTextWithEncodingAsync(*(void**)(&absolutePath), *(void**)(&contents), static_cast<int32_t>(encoding), &textOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->AppendTextWithEncodingAsync(*(void**)(&absolutePath), *(void**)(&contents), static_cast<int32_t>(encoding), &textOperation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ textOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::ReadLinesAsync(param::hstring const& absolutePath) const
    {
        void* linesOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadLinesAsync(*(void**)(&absolutePath), &linesOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->ReadLinesAsync(*(void**)(&absolutePath), &linesOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVector<hstring>>{ linesOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::ReadLinesAsync(param::hstring const& absolutePath, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* linesOperation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadLinesWithEncodingAsync(*(void**)(&absolutePath), static_cast<int32_t>(encoding), &linesOperation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->ReadLinesWithEncodingAsync(*(void**)(&absolutePath), static_cast<int32_t>(encoding), &linesOperation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVector<hstring>>{ linesOperation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::WriteLinesAsync(param::hstring const& absolutePath, param::async_iterable<hstring> const& lines) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteLinesAsync(*(void**)(&absolutePath), *(void**)(&lines), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteLinesAsync(*(void**)(&absolutePath), *(void**)(&lines), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::WriteLinesAsync(param::hstring const& absolutePath, param::async_iterable<hstring> const& lines, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteLinesWithEncodingAsync(*(void**)(&absolutePath), *(void**)(&lines), static_cast<int32_t>(encoding), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteLinesWithEncodingAsync(*(void**)(&absolutePath), *(void**)(&lines), static_cast<int32_t>(encoding), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::AppendLinesAsync(param::hstring const& absolutePath, param::async_iterable<hstring> const& lines) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AppendLinesAsync(*(void**)(&absolutePath), *(void**)(&lines), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->AppendLinesAsync(*(void**)(&absolutePath), *(void**)(&lines), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::AppendLinesAsync(param::hstring const& absolutePath, param::async_iterable<hstring> const& lines, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AppendLinesWithEncodingAsync(*(void**)(&absolutePath), *(void**)(&lines), static_cast<int32_t>(encoding), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->AppendLinesWithEncodingAsync(*(void**)(&absolutePath), *(void**)(&lines), static_cast<int32_t>(encoding), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::ReadBufferAsync(param::hstring const& absolutePath) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadBufferAsync(*(void**)(&absolutePath), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->ReadBufferAsync(*(void**)(&absolutePath), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::WriteBufferAsync(param::hstring const& absolutePath, winrt::Windows::Storage::Streams::IBuffer const& buffer) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteBufferAsync(*(void**)(&absolutePath), *(void**)(&buffer), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteBufferAsync(*(void**)(&absolutePath), *(void**)(&buffer), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IPathIOStatics<D>::WriteBytesAsync(param::hstring const& absolutePath, array_view<uint8_t const> buffer) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IPathIOStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IPathIOStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->WriteBytesAsync(*(void**)(&absolutePath), buffer.size(), get_abi(buffer), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IPathIOStatics>**)this;
            check_hresult(_winrt_abi_type->WriteBytesAsync(*(void**)(&absolutePath), buffer.size(), get_abi(buffer), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISetVersionDeferral<D>::Complete() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISetVersionDeferral>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISetVersionDeferral, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISetVersionDeferral>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Complete());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISetVersionDeferral>**)this;
            check_hresult(_winrt_abi_type->Complete());
        }
    }
    template <typename D> auto consume_Windows_Storage_ISetVersionRequest<D>::CurrentVersion() const
    {
        uint32_t currentVersion{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISetVersionRequest>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISetVersionRequest, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISetVersionRequest>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CurrentVersion(&currentVersion));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISetVersionRequest>**)this;
            check_hresult(_winrt_abi_type->get_CurrentVersion(&currentVersion));
        }
        return currentVersion;
    }
    template <typename D> auto consume_Windows_Storage_ISetVersionRequest<D>::DesiredVersion() const
    {
        uint32_t desiredVersion{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISetVersionRequest>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISetVersionRequest, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISetVersionRequest>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DesiredVersion(&desiredVersion));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISetVersionRequest>**)this;
            check_hresult(_winrt_abi_type->get_DesiredVersion(&desiredVersion));
        }
        return desiredVersion;
    }
    template <typename D> auto consume_Windows_Storage_ISetVersionRequest<D>::GetDeferral() const
    {
        void* deferral{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISetVersionRequest>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISetVersionRequest, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISetVersionRequest>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&deferral));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISetVersionRequest>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&deferral));
        }
        return winrt::Windows::Storage::SetVersionDeferral{ deferral, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::FileType() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FileType(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->get_FileType(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::ContentType() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ContentType(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->get_ContentType(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::OpenAsync(winrt::Windows::Storage::FileAccessMode const& accessMode) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OpenAsync(static_cast<int32_t>(accessMode), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->OpenAsync(static_cast<int32_t>(accessMode), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IRandomAccessStream>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::OpenTransactedWriteAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OpenTransactedWriteAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->OpenTransactedWriteAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageStreamTransaction>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::CopyAsync(winrt::Windows::Storage::IStorageFolder const& destinationFolder) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CopyOverloadDefaultNameAndOptions(*(void**)(&destinationFolder), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->CopyOverloadDefaultNameAndOptions(*(void**)(&destinationFolder), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::CopyAsync(winrt::Windows::Storage::IStorageFolder const& destinationFolder, param::hstring const& desiredNewName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CopyOverloadDefaultOptions(*(void**)(&destinationFolder), *(void**)(&desiredNewName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->CopyOverloadDefaultOptions(*(void**)(&destinationFolder), *(void**)(&desiredNewName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::CopyAsync(winrt::Windows::Storage::IStorageFolder const& destinationFolder, param::hstring const& desiredNewName, winrt::Windows::Storage::NameCollisionOption const& option) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CopyOverload(*(void**)(&destinationFolder), *(void**)(&desiredNewName), static_cast<int32_t>(option), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->CopyOverload(*(void**)(&destinationFolder), *(void**)(&desiredNewName), static_cast<int32_t>(option), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::CopyAndReplaceAsync(winrt::Windows::Storage::IStorageFile const& fileToReplace) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CopyAndReplaceAsync(*(void**)(&fileToReplace), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->CopyAndReplaceAsync(*(void**)(&fileToReplace), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::MoveAsync(winrt::Windows::Storage::IStorageFolder const& destinationFolder) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MoveOverloadDefaultNameAndOptions(*(void**)(&destinationFolder), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->MoveOverloadDefaultNameAndOptions(*(void**)(&destinationFolder), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::MoveAsync(winrt::Windows::Storage::IStorageFolder const& destinationFolder, param::hstring const& desiredNewName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MoveOverloadDefaultOptions(*(void**)(&destinationFolder), *(void**)(&desiredNewName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->MoveOverloadDefaultOptions(*(void**)(&destinationFolder), *(void**)(&desiredNewName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::MoveAsync(winrt::Windows::Storage::IStorageFolder const& destinationFolder, param::hstring const& desiredNewName, winrt::Windows::Storage::NameCollisionOption const& option) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MoveOverload(*(void**)(&destinationFolder), *(void**)(&desiredNewName), static_cast<int32_t>(option), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->MoveOverload(*(void**)(&destinationFolder), *(void**)(&desiredNewName), static_cast<int32_t>(option), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile<D>::MoveAndReplaceAsync(winrt::Windows::Storage::IStorageFile const& fileToReplace) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MoveAndReplaceAsync(*(void**)(&fileToReplace), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile>**)this;
            check_hresult(_winrt_abi_type->MoveAndReplaceAsync(*(void**)(&fileToReplace), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile2<D>::OpenAsync(winrt::Windows::Storage::FileAccessMode const& accessMode, winrt::Windows::Storage::StorageOpenOptions const& options) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OpenWithOptionsAsync(static_cast<int32_t>(accessMode), static_cast<uint32_t>(options), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile2>**)this;
            check_hresult(_winrt_abi_type->OpenWithOptionsAsync(static_cast<int32_t>(accessMode), static_cast<uint32_t>(options), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IRandomAccessStream>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFile2<D>::OpenTransactedWriteAsync(winrt::Windows::Storage::StorageOpenOptions const& options) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFile2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFile2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->OpenTransactedWriteWithOptionsAsync(static_cast<uint32_t>(options), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFile2>**)this;
            check_hresult(_winrt_abi_type->OpenTransactedWriteWithOptionsAsync(static_cast<uint32_t>(options), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageStreamTransaction>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFilePropertiesWithAvailability<D>::IsAvailable() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFilePropertiesWithAvailability>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFilePropertiesWithAvailability, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFilePropertiesWithAvailability>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAvailable(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFilePropertiesWithAvailability>**)this;
            check_hresult(_winrt_abi_type->get_IsAvailable(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IStorageFileStatics<D>::GetFileFromPathAsync(param::hstring const& path) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFileStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFileStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFileFromPathAsync(*(void**)(&path), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)this;
            check_hresult(_winrt_abi_type->GetFileFromPathAsync(*(void**)(&path), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFileStatics<D>::GetFileFromApplicationUriAsync(winrt::Windows::Foundation::Uri const& uri) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFileStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFileStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFileFromApplicationUriAsync(*(void**)(&uri), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)this;
            check_hresult(_winrt_abi_type->GetFileFromApplicationUriAsync(*(void**)(&uri), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFileStatics<D>::CreateStreamedFileAsync(param::hstring const& displayNameWithExtension, winrt::Windows::Storage::StreamedFileDataRequestedHandler const& dataRequested, winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& thumbnail) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFileStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFileStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateStreamedFileAsync(*(void**)(&displayNameWithExtension), *(void**)(&dataRequested), *(void**)(&thumbnail), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)this;
            check_hresult(_winrt_abi_type->CreateStreamedFileAsync(*(void**)(&displayNameWithExtension), *(void**)(&dataRequested), *(void**)(&thumbnail), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFileStatics<D>::ReplaceWithStreamedFileAsync(winrt::Windows::Storage::IStorageFile const& fileToReplace, winrt::Windows::Storage::StreamedFileDataRequestedHandler const& dataRequested, winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& thumbnail) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFileStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFileStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReplaceWithStreamedFileAsync(*(void**)(&fileToReplace), *(void**)(&dataRequested), *(void**)(&thumbnail), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)this;
            check_hresult(_winrt_abi_type->ReplaceWithStreamedFileAsync(*(void**)(&fileToReplace), *(void**)(&dataRequested), *(void**)(&thumbnail), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFileStatics<D>::CreateStreamedFileFromUriAsync(param::hstring const& displayNameWithExtension, winrt::Windows::Foundation::Uri const& uri, winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& thumbnail) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFileStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFileStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateStreamedFileFromUriAsync(*(void**)(&displayNameWithExtension), *(void**)(&uri), *(void**)(&thumbnail), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)this;
            check_hresult(_winrt_abi_type->CreateStreamedFileFromUriAsync(*(void**)(&displayNameWithExtension), *(void**)(&uri), *(void**)(&thumbnail), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFileStatics<D>::ReplaceWithStreamedFileFromUriAsync(winrt::Windows::Storage::IStorageFile const& fileToReplace, winrt::Windows::Foundation::Uri const& uri, winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& thumbnail) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFileStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFileStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReplaceWithStreamedFileFromUriAsync(*(void**)(&fileToReplace), *(void**)(&uri), *(void**)(&thumbnail), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics>**)this;
            check_hresult(_winrt_abi_type->ReplaceWithStreamedFileFromUriAsync(*(void**)(&fileToReplace), *(void**)(&uri), *(void**)(&thumbnail), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFileStatics2<D>::GetFileFromPathForUserAsync(winrt::Windows::System::User const& user, param::hstring const& path) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFileStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFileStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFileFromPathForUserAsync(*(void**)(&user), *(void**)(&path), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFileStatics2>**)this;
            check_hresult(_winrt_abi_type->GetFileFromPathForUserAsync(*(void**)(&user), *(void**)(&path), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder<D>::CreateFileAsync(param::hstring const& desiredName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFileAsyncOverloadDefaultOptions(*(void**)(&desiredName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)this;
            check_hresult(_winrt_abi_type->CreateFileAsyncOverloadDefaultOptions(*(void**)(&desiredName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder<D>::CreateFileAsync(param::hstring const& desiredName, winrt::Windows::Storage::CreationCollisionOption const& options) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFileAsync(*(void**)(&desiredName), static_cast<int32_t>(options), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)this;
            check_hresult(_winrt_abi_type->CreateFileAsync(*(void**)(&desiredName), static_cast<int32_t>(options), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder<D>::CreateFolderAsync(param::hstring const& desiredName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFolderAsyncOverloadDefaultOptions(*(void**)(&desiredName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)this;
            check_hresult(_winrt_abi_type->CreateFolderAsyncOverloadDefaultOptions(*(void**)(&desiredName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder<D>::CreateFolderAsync(param::hstring const& desiredName, winrt::Windows::Storage::CreationCollisionOption const& options) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateFolderAsync(*(void**)(&desiredName), static_cast<int32_t>(options), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)this;
            check_hresult(_winrt_abi_type->CreateFolderAsync(*(void**)(&desiredName), static_cast<int32_t>(options), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder<D>::GetFileAsync(param::hstring const& name) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFileAsync(*(void**)(&name), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)this;
            check_hresult(_winrt_abi_type->GetFileAsync(*(void**)(&name), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder<D>::GetFolderAsync(param::hstring const& name) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFolderAsync(*(void**)(&name), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)this;
            check_hresult(_winrt_abi_type->GetFolderAsync(*(void**)(&name), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder<D>::GetItemAsync(param::hstring const& name) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetItemAsync(*(void**)(&name), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)this;
            check_hresult(_winrt_abi_type->GetItemAsync(*(void**)(&name), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::IStorageItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder<D>::GetFilesAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFilesAsyncOverloadDefaultOptionsStartAndCount(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)this;
            check_hresult(_winrt_abi_type->GetFilesAsyncOverloadDefaultOptionsStartAndCount(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Storage::StorageFile>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder<D>::GetFoldersAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFoldersAsyncOverloadDefaultOptionsStartAndCount(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)this;
            check_hresult(_winrt_abi_type->GetFoldersAsyncOverloadDefaultOptionsStartAndCount(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Storage::StorageFolder>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder<D>::GetItemsAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetItemsAsyncOverloadDefaultStartAndCount(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder>**)this;
            check_hresult(_winrt_abi_type->GetItemsAsyncOverloadDefaultStartAndCount(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Storage::IStorageItem>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder2<D>::TryGetItemAsync(param::hstring const& name) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetItemAsync(*(void**)(&name), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder2>**)this;
            check_hresult(_winrt_abi_type->TryGetItemAsync(*(void**)(&name), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::IStorageItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolder3<D>::TryGetChangeTracker() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolder3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolder3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetChangeTracker(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolder3>**)this;
            check_hresult(_winrt_abi_type->TryGetChangeTracker(&result));
        }
        return winrt::Windows::Storage::StorageLibraryChangeTracker{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolderStatics<D>::GetFolderFromPathAsync(param::hstring const& path) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolderStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolderStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolderStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFolderFromPathAsync(*(void**)(&path), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolderStatics>**)this;
            check_hresult(_winrt_abi_type->GetFolderFromPathAsync(*(void**)(&path), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageFolderStatics2<D>::GetFolderFromPathForUserAsync(winrt::Windows::System::User const& user, param::hstring const& path) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageFolderStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageFolderStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolderStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetFolderFromPathForUserAsync(*(void**)(&user), *(void**)(&path), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageFolderStatics2>**)this;
            check_hresult(_winrt_abi_type->GetFolderFromPathForUserAsync(*(void**)(&user), *(void**)(&path), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem<D>::RenameAsync(param::hstring const& desiredName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RenameAsyncOverloadDefaultOptions(*(void**)(&desiredName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)this;
            check_hresult(_winrt_abi_type->RenameAsyncOverloadDefaultOptions(*(void**)(&desiredName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem<D>::RenameAsync(param::hstring const& desiredName, winrt::Windows::Storage::NameCollisionOption const& option) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RenameAsync(*(void**)(&desiredName), static_cast<int32_t>(option), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)this;
            check_hresult(_winrt_abi_type->RenameAsync(*(void**)(&desiredName), static_cast<int32_t>(option), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem<D>::DeleteAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DeleteAsyncOverloadDefaultOptions(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)this;
            check_hresult(_winrt_abi_type->DeleteAsyncOverloadDefaultOptions(&operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem<D>::DeleteAsync(winrt::Windows::Storage::StorageDeleteOption const& option) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DeleteAsync(static_cast<int32_t>(option), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)this;
            check_hresult(_winrt_abi_type->DeleteAsync(static_cast<int32_t>(option), &operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem<D>::GetBasicPropertiesAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBasicPropertiesAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)this;
            check_hresult(_winrt_abi_type->GetBasicPropertiesAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::BasicProperties>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem<D>::Name() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)this;
            check_hresult(_winrt_abi_type->get_Name(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem<D>::Path() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Path(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)this;
            check_hresult(_winrt_abi_type->get_Path(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem<D>::Attributes() const
    {
        winrt::Windows::Storage::FileAttributes value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Attributes(reinterpret_cast<uint32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)this;
            check_hresult(_winrt_abi_type->get_Attributes(reinterpret_cast<uint32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem<D>::DateCreated() const
    {
        winrt::Windows::Foundation::DateTime value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DateCreated(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)this;
            check_hresult(_winrt_abi_type->get_DateCreated(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem<D>::IsOfType(winrt::Windows::Storage::StorageItemTypes const& type) const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsOfType(static_cast<uint32_t>(type), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem>**)this;
            check_hresult(_winrt_abi_type->IsOfType(static_cast<uint32_t>(type), &value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem2<D>::GetParentAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetParentAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem2>**)this;
            check_hresult(_winrt_abi_type->GetParentAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItem2<D>::IsEqual(winrt::Windows::Storage::IStorageItem const& item) const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItem2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItem2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsEqual(*(void**)(&item), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItem2>**)this;
            check_hresult(_winrt_abi_type->IsEqual(*(void**)(&item), &value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemProperties<D>::GetThumbnailAsync(winrt::Windows::Storage::FileProperties::ThumbnailMode const& mode) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetThumbnailAsyncOverloadDefaultSizeDefaultOptions(static_cast<int32_t>(mode), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)this;
            check_hresult(_winrt_abi_type->GetThumbnailAsyncOverloadDefaultSizeDefaultOptions(static_cast<int32_t>(mode), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemProperties<D>::GetThumbnailAsync(winrt::Windows::Storage::FileProperties::ThumbnailMode const& mode, uint32_t requestedSize) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetThumbnailAsyncOverloadDefaultOptions(static_cast<int32_t>(mode), requestedSize, &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)this;
            check_hresult(_winrt_abi_type->GetThumbnailAsyncOverloadDefaultOptions(static_cast<int32_t>(mode), requestedSize, &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemProperties<D>::GetThumbnailAsync(winrt::Windows::Storage::FileProperties::ThumbnailMode const& mode, uint32_t requestedSize, winrt::Windows::Storage::FileProperties::ThumbnailOptions const& options) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetThumbnailAsync(static_cast<int32_t>(mode), requestedSize, static_cast<uint32_t>(options), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)this;
            check_hresult(_winrt_abi_type->GetThumbnailAsync(static_cast<int32_t>(mode), requestedSize, static_cast<uint32_t>(options), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemProperties<D>::DisplayName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DisplayName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)this;
            check_hresult(_winrt_abi_type->get_DisplayName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemProperties<D>::DisplayType() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DisplayType(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)this;
            check_hresult(_winrt_abi_type->get_DisplayType(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemProperties<D>::FolderRelativeId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FolderRelativeId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)this;
            check_hresult(_winrt_abi_type->get_FolderRelativeId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemProperties<D>::Properties() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Properties(&value));
        }
        return winrt::Windows::Storage::FileProperties::StorageItemContentProperties{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemProperties2<D>::GetScaledImageAsThumbnailAsync(winrt::Windows::Storage::FileProperties::ThumbnailMode const& mode) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemProperties2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemProperties2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetScaledImageAsThumbnailAsyncOverloadDefaultSizeDefaultOptions(static_cast<int32_t>(mode), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties2>**)this;
            check_hresult(_winrt_abi_type->GetScaledImageAsThumbnailAsyncOverloadDefaultSizeDefaultOptions(static_cast<int32_t>(mode), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemProperties2<D>::GetScaledImageAsThumbnailAsync(winrt::Windows::Storage::FileProperties::ThumbnailMode const& mode, uint32_t requestedSize) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemProperties2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemProperties2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetScaledImageAsThumbnailAsyncOverloadDefaultOptions(static_cast<int32_t>(mode), requestedSize, &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties2>**)this;
            check_hresult(_winrt_abi_type->GetScaledImageAsThumbnailAsyncOverloadDefaultOptions(static_cast<int32_t>(mode), requestedSize, &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemProperties2<D>::GetScaledImageAsThumbnailAsync(winrt::Windows::Storage::FileProperties::ThumbnailMode const& mode, uint32_t requestedSize, winrt::Windows::Storage::FileProperties::ThumbnailOptions const& options) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemProperties2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemProperties2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetScaledImageAsThumbnailAsync(static_cast<int32_t>(mode), requestedSize, static_cast<uint32_t>(options), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemProperties2>**)this;
            check_hresult(_winrt_abi_type->GetScaledImageAsThumbnailAsync(static_cast<int32_t>(mode), requestedSize, static_cast<uint32_t>(options), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageItemPropertiesWithProvider<D>::Provider() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageItemPropertiesWithProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageItemPropertiesWithProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemPropertiesWithProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Provider(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageItemPropertiesWithProvider>**)this;
            check_hresult(_winrt_abi_type->get_Provider(&value));
        }
        return winrt::Windows::Storage::StorageProvider{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibrary<D>::RequestAddFolderAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibrary>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibrary, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestAddFolderAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)this;
            check_hresult(_winrt_abi_type->RequestAddFolderAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibrary<D>::RequestRemoveFolderAsync(winrt::Windows::Storage::StorageFolder const& folder) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibrary>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibrary, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestRemoveFolderAsync(*(void**)(&folder), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)this;
            check_hresult(_winrt_abi_type->RequestRemoveFolderAsync(*(void**)(&folder), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibrary<D>::Folders() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibrary>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibrary, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Folders(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)this;
            check_hresult(_winrt_abi_type->get_Folders(&value));
        }
        return winrt::Windows::Foundation::Collections::IObservableVector<winrt::Windows::Storage::StorageFolder>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibrary<D>::SaveFolder() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibrary>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibrary, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SaveFolder(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)this;
            check_hresult(_winrt_abi_type->get_SaveFolder(&value));
        }
        return winrt::Windows::Storage::StorageFolder{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibrary<D>::DefinitionChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::StorageLibrary, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token eventCookie{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibrary>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibrary, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DefinitionChanged(*(void**)(&handler), put_abi(eventCookie)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)this;
            check_hresult(_winrt_abi_type->add_DefinitionChanged(*(void**)(&handler), put_abi(eventCookie)));
        }
        return eventCookie;
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibrary<D>::DefinitionChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::StorageLibrary, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, DefinitionChanged_revoker>(this, DefinitionChanged(handler));
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibrary<D>::DefinitionChanged(winrt::event_token const& eventCookie) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibrary>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibrary, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DefinitionChanged(impl::bind_in(eventCookie));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary>**)this;
            _winrt_abi_type->remove_DefinitionChanged(impl::bind_in(eventCookie));
        }
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibrary2<D>::ChangeTracker() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibrary2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibrary2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChangeTracker(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary2>**)this;
            check_hresult(_winrt_abi_type->get_ChangeTracker(&value));
        }
        return winrt::Windows::Storage::StorageLibraryChangeTracker{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibrary3<D>::AreFolderSuggestionsAvailableAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibrary3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibrary3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AreFolderSuggestionsAvailableAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibrary3>**)this;
            check_hresult(_winrt_abi_type->AreFolderSuggestionsAvailableAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChange<D>::ChangeType() const
    {
        winrt::Windows::Storage::StorageLibraryChangeType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChange>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChange, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChange>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChangeType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChange>**)this;
            check_hresult(_winrt_abi_type->get_ChangeType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChange<D>::Path() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChange>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChange, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChange>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Path(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChange>**)this;
            check_hresult(_winrt_abi_type->get_Path(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChange<D>::PreviousPath() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChange>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChange, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChange>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PreviousPath(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChange>**)this;
            check_hresult(_winrt_abi_type->get_PreviousPath(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChange<D>::IsOfType(winrt::Windows::Storage::StorageItemTypes const& type) const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChange>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChange, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChange>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsOfType(static_cast<uint32_t>(type), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChange>**)this;
            check_hresult(_winrt_abi_type->IsOfType(static_cast<uint32_t>(type), &value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChange<D>::GetStorageItemAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChange>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChange, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChange>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetStorageItemAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChange>**)this;
            check_hresult(_winrt_abi_type->GetStorageItemAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::IStorageItem>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChangeReader<D>::ReadBatchAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChangeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChangeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadBatchAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeReader>**)this;
            check_hresult(_winrt_abi_type->ReadBatchAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Storage::StorageLibraryChange>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChangeReader<D>::AcceptChangesAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChangeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChangeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AcceptChangesAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeReader>**)this;
            check_hresult(_winrt_abi_type->AcceptChangesAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChangeReader2<D>::GetLastChangeId() const
    {
        uint64_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChangeReader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChangeReader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeReader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetLastChangeId(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeReader2>**)this;
            check_hresult(_winrt_abi_type->GetLastChangeId(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChangeTracker<D>::GetChangeReader() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChangeTracker>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChangeTracker, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTracker>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetChangeReader(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTracker>**)this;
            check_hresult(_winrt_abi_type->GetChangeReader(&value));
        }
        return winrt::Windows::Storage::StorageLibraryChangeReader{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChangeTracker<D>::Enable() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChangeTracker>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChangeTracker, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTracker>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Enable());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTracker>**)this;
            check_hresult(_winrt_abi_type->Enable());
        }
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChangeTracker<D>::Reset() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChangeTracker>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChangeTracker, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTracker>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Reset());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTracker>**)this;
            check_hresult(_winrt_abi_type->Reset());
        }
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChangeTracker2<D>::Enable(winrt::Windows::Storage::StorageLibraryChangeTrackerOptions const& options) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChangeTracker2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChangeTracker2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTracker2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->EnableWithOptions(*(void**)(&options)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTracker2>**)this;
            check_hresult(_winrt_abi_type->EnableWithOptions(*(void**)(&options)));
        }
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChangeTracker2<D>::Disable() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChangeTracker2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChangeTracker2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTracker2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Disable());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTracker2>**)this;
            check_hresult(_winrt_abi_type->Disable());
        }
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChangeTrackerOptions<D>::TrackChangeDetails() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TrackChangeDetails(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions>**)this;
            check_hresult(_winrt_abi_type->get_TrackChangeDetails(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryChangeTrackerOptions<D>::TrackChangeDetails(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TrackChangeDetails(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions>**)this;
            check_hresult(_winrt_abi_type->put_TrackChangeDetails(value));
        }
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryLastChangeIdStatics<D>::Unknown() const
    {
        uint64_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryLastChangeIdStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryLastChangeIdStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryLastChangeIdStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Unknown(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryLastChangeIdStatics>**)this;
            check_hresult(_winrt_abi_type->get_Unknown(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryStatics<D>::GetLibraryAsync(winrt::Windows::Storage::KnownLibraryId const& libraryId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetLibraryAsync(static_cast<int32_t>(libraryId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryStatics>**)this;
            check_hresult(_winrt_abi_type->GetLibraryAsync(static_cast<int32_t>(libraryId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageLibrary>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageLibraryStatics2<D>::GetLibraryForUserAsync(winrt::Windows::System::User const& user, winrt::Windows::Storage::KnownLibraryId const& libraryId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageLibraryStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageLibraryStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetLibraryForUserAsync(*(void**)(&user), static_cast<int32_t>(libraryId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageLibraryStatics2>**)this;
            check_hresult(_winrt_abi_type->GetLibraryForUserAsync(*(void**)(&user), static_cast<int32_t>(libraryId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageLibrary>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageProvider<D>::Id() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageProvider>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageProvider<D>::DisplayName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DisplayName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageProvider>**)this;
            check_hresult(_winrt_abi_type->get_DisplayName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageProvider2<D>::IsPropertySupportedForPartialFileAsync(param::hstring const& propertyCanonicalName) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageProvider2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageProvider2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageProvider2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsPropertySupportedForPartialFileAsync(*(void**)(&propertyCanonicalName), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageProvider2>**)this;
            check_hresult(_winrt_abi_type->IsPropertySupportedForPartialFileAsync(*(void**)(&propertyCanonicalName), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageStreamTransaction<D>::Stream() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageStreamTransaction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageStreamTransaction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageStreamTransaction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Stream(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageStreamTransaction>**)this;
            check_hresult(_winrt_abi_type->get_Stream(&value));
        }
        return winrt::Windows::Storage::Streams::IRandomAccessStream{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStorageStreamTransaction<D>::CommitAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStorageStreamTransaction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStorageStreamTransaction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageStreamTransaction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CommitAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStorageStreamTransaction>**)this;
            check_hresult(_winrt_abi_type->CommitAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncAction{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IStreamedFileDataRequest<D>::FailAndClose(winrt::Windows::Storage::StreamedFileFailureMode const& failureMode) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IStreamedFileDataRequest>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IStreamedFileDataRequest, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStreamedFileDataRequest>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FailAndClose(static_cast<int32_t>(failureMode)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IStreamedFileDataRequest>**)this;
            check_hresult(_winrt_abi_type->FailAndClose(static_cast<int32_t>(failureMode)));
        }
    }
    template <typename D> auto consume_Windows_Storage_ISystemAudioProperties<D>::EncodingBitrate() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemAudioProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemAudioProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemAudioProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EncodingBitrate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemAudioProperties>**)this;
            check_hresult(_winrt_abi_type->get_EncodingBitrate(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::Fonts() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Fonts(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Fonts(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::ProgramData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ProgramData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_ProgramData(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::Public() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Public(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Public(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::PublicDesktop() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PublicDesktop(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_PublicDesktop(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::PublicDocuments() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PublicDocuments(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_PublicDocuments(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::PublicDownloads() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PublicDownloads(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_PublicDownloads(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::PublicMusic() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PublicMusic(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_PublicMusic(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::PublicPictures() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PublicPictures(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_PublicPictures(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::PublicVideos() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PublicVideos(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_PublicVideos(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::System() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_System(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_System(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::SystemHost() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemHost(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_SystemHost(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::SystemX86() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemX86(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_SystemX86(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::SystemX64() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemX64(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_SystemX64(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::SystemArm() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SystemArm(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_SystemArm(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::UserProfiles() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UserProfiles(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_UserProfiles(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPaths<D>::Windows() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Windows(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Windows(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemDataPathsStatics<D>::GetDefault() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemDataPathsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemDataPathsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPathsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefault(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemDataPathsStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefault(&result));
        }
        return winrt::Windows::Storage::SystemDataPaths{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemGPSProperties<D>::LatitudeDecimal() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemGPSProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemGPSProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemGPSProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LatitudeDecimal(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemGPSProperties>**)this;
            check_hresult(_winrt_abi_type->get_LatitudeDecimal(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemGPSProperties<D>::LongitudeDecimal() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemGPSProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemGPSProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemGPSProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LongitudeDecimal(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemGPSProperties>**)this;
            check_hresult(_winrt_abi_type->get_LongitudeDecimal(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemImageProperties<D>::HorizontalSize() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemImageProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemImageProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemImageProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HorizontalSize(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemImageProperties>**)this;
            check_hresult(_winrt_abi_type->get_HorizontalSize(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemImageProperties<D>::VerticalSize() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemImageProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemImageProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemImageProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VerticalSize(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemImageProperties>**)this;
            check_hresult(_winrt_abi_type->get_VerticalSize(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMediaProperties<D>::Duration() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMediaProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMediaProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Duration(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)this;
            check_hresult(_winrt_abi_type->get_Duration(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMediaProperties<D>::Producer() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMediaProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMediaProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Producer(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)this;
            check_hresult(_winrt_abi_type->get_Producer(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMediaProperties<D>::Publisher() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMediaProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMediaProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Publisher(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)this;
            check_hresult(_winrt_abi_type->get_Publisher(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMediaProperties<D>::SubTitle() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMediaProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMediaProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SubTitle(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)this;
            check_hresult(_winrt_abi_type->get_SubTitle(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMediaProperties<D>::Writer() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMediaProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMediaProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Writer(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)this;
            check_hresult(_winrt_abi_type->get_Writer(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMediaProperties<D>::Year() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMediaProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMediaProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Year(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMediaProperties>**)this;
            check_hresult(_winrt_abi_type->get_Year(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMusicProperties<D>::AlbumArtist() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMusicProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMusicProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AlbumArtist(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)this;
            check_hresult(_winrt_abi_type->get_AlbumArtist(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMusicProperties<D>::AlbumTitle() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMusicProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMusicProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AlbumTitle(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)this;
            check_hresult(_winrt_abi_type->get_AlbumTitle(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMusicProperties<D>::Artist() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMusicProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMusicProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Artist(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)this;
            check_hresult(_winrt_abi_type->get_Artist(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMusicProperties<D>::Composer() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMusicProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMusicProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Composer(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)this;
            check_hresult(_winrt_abi_type->get_Composer(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMusicProperties<D>::Conductor() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMusicProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMusicProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Conductor(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)this;
            check_hresult(_winrt_abi_type->get_Conductor(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMusicProperties<D>::DisplayArtist() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMusicProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMusicProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DisplayArtist(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)this;
            check_hresult(_winrt_abi_type->get_DisplayArtist(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMusicProperties<D>::Genre() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMusicProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMusicProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Genre(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)this;
            check_hresult(_winrt_abi_type->get_Genre(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemMusicProperties<D>::TrackNumber() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemMusicProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemMusicProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TrackNumber(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemMusicProperties>**)this;
            check_hresult(_winrt_abi_type->get_TrackNumber(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemPhotoProperties<D>::CameraManufacturer() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemPhotoProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemPhotoProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemPhotoProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CameraManufacturer(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemPhotoProperties>**)this;
            check_hresult(_winrt_abi_type->get_CameraManufacturer(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemPhotoProperties<D>::CameraModel() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemPhotoProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemPhotoProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemPhotoProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CameraModel(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemPhotoProperties>**)this;
            check_hresult(_winrt_abi_type->get_CameraModel(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemPhotoProperties<D>::DateTaken() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemPhotoProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemPhotoProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemPhotoProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DateTaken(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemPhotoProperties>**)this;
            check_hresult(_winrt_abi_type->get_DateTaken(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemPhotoProperties<D>::Orientation() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemPhotoProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemPhotoProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemPhotoProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Orientation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemPhotoProperties>**)this;
            check_hresult(_winrt_abi_type->get_Orientation(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemPhotoProperties<D>::PeopleNames() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemPhotoProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemPhotoProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemPhotoProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PeopleNames(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemPhotoProperties>**)this;
            check_hresult(_winrt_abi_type->get_PeopleNames(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Author() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Author(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Author(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Comment() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Comment(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Comment(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::ItemNameDisplay() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ItemNameDisplay(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_ItemNameDisplay(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Keywords() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Keywords(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Keywords(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Rating() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Rating(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Rating(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Title() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Audio() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Audio(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Audio(&value));
        }
        return winrt::Windows::Storage::SystemAudioProperties{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::GPS() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_GPS(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_GPS(&value));
        }
        return winrt::Windows::Storage::SystemGPSProperties{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Media() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Media(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Media(&value));
        }
        return winrt::Windows::Storage::SystemMediaProperties{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Music() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Music(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Music(&value));
        }
        return winrt::Windows::Storage::SystemMusicProperties{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Photo() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Photo(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Photo(&value));
        }
        return winrt::Windows::Storage::SystemPhotoProperties{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Video() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Video(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Video(&value));
        }
        return winrt::Windows::Storage::SystemVideoProperties{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemProperties<D>::Image() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Image(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemProperties>**)this;
            check_hresult(_winrt_abi_type->get_Image(&value));
        }
        return winrt::Windows::Storage::SystemImageProperties{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemVideoProperties<D>::Director() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemVideoProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemVideoProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemVideoProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Director(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemVideoProperties>**)this;
            check_hresult(_winrt_abi_type->get_Director(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemVideoProperties<D>::FrameHeight() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemVideoProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemVideoProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemVideoProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FrameHeight(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemVideoProperties>**)this;
            check_hresult(_winrt_abi_type->get_FrameHeight(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemVideoProperties<D>::FrameWidth() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemVideoProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemVideoProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemVideoProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FrameWidth(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemVideoProperties>**)this;
            check_hresult(_winrt_abi_type->get_FrameWidth(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemVideoProperties<D>::Orientation() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemVideoProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemVideoProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemVideoProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Orientation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemVideoProperties>**)this;
            check_hresult(_winrt_abi_type->get_Orientation(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_ISystemVideoProperties<D>::TotalBitrate() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::ISystemVideoProperties>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::ISystemVideoProperties, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemVideoProperties>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TotalBitrate(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::ISystemVideoProperties>**)this;
            check_hresult(_winrt_abi_type->get_TotalBitrate(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::CameraRoll() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CameraRoll(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_CameraRoll(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Cookies() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Cookies(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Cookies(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Desktop() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Desktop(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Desktop(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Documents() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Documents(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Documents(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Downloads() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Downloads(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Downloads(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Favorites() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Favorites(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Favorites(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::History() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_History(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_History(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::InternetCache() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_InternetCache(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_InternetCache(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::LocalAppData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LocalAppData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_LocalAppData(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::LocalAppDataLow() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LocalAppDataLow(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_LocalAppDataLow(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Music() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Music(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Music(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Pictures() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Pictures(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Pictures(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Profile() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Profile(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Profile(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Recent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Recent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Recent(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::RoamingAppData() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RoamingAppData(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_RoamingAppData(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::SavedPictures() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SavedPictures(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_SavedPictures(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Screenshots() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Screenshots(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Screenshots(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Templates() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Templates(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Templates(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPaths<D>::Videos() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPaths>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPaths, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Videos(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPaths>**)this;
            check_hresult(_winrt_abi_type->get_Videos(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPathsStatics<D>::GetForUser(winrt::Windows::System::User const& user) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPathsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPathsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPathsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetForUser(*(void**)(&user), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPathsStatics>**)this;
            check_hresult(_winrt_abi_type->GetForUser(*(void**)(&user), &result));
        }
        return winrt::Windows::Storage::UserDataPaths{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_IUserDataPathsStatics<D>::GetDefault() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::IUserDataPathsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::IUserDataPathsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPathsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefault(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::IUserDataPathsStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefault(&result));
        }
        return winrt::Windows::Storage::UserDataPaths{ result, take_ownership_from_abi };
    }
    template <typename H> struct delegate<winrt::Windows::Storage::ApplicationDataSetVersionHandler, H> final : implements_delegate<winrt::Windows::Storage::ApplicationDataSetVersionHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::Storage::ApplicationDataSetVersionHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* setVersionRequest) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Storage::SetVersionRequest const*>(&setVersionRequest));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename H> struct delegate<winrt::Windows::Storage::StreamedFileDataRequestedHandler, H> final : implements_delegate<winrt::Windows::Storage::StreamedFileDataRequestedHandler, H>
    {
        delegate(H&& handler) : implements_delegate<winrt::Windows::Storage::StreamedFileDataRequestedHandler, H>(std::forward<H>(handler)) {}

        int32_t __stdcall Invoke(void* stream) noexcept final try
        {
            (*this)(*reinterpret_cast<winrt::Windows::Storage::StreamedFileDataRequest const*>(&stream));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IAppDataPaths> : produce_base<D, winrt::Windows::Storage::IAppDataPaths>
    {
        int32_t __stdcall get_Cookies(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Cookies());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Desktop(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Desktop());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Documents(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Documents());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Favorites(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Favorites());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_History(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().History());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_InternetCache(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().InternetCache());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LocalAppData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().LocalAppData());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ProgramData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ProgramData());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RoamingAppData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().RoamingAppData());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IAppDataPathsStatics> : produce_base<D, winrt::Windows::Storage::IAppDataPathsStatics>
    {
        int32_t __stdcall GetForUser(void* user, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Storage::AppDataPaths>(this->shim().GetForUser(*reinterpret_cast<winrt::Windows::System::User const*>(&user)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDefault(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Storage::AppDataPaths>(this->shim().GetDefault());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IApplicationData> : produce_base<D, winrt::Windows::Storage::IApplicationData>
    {
        int32_t __stdcall get_Version(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Version());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetVersionAsync(uint32_t desiredVersion, void* handler, void** setVersionOperation) noexcept final try
        {
            clear_abi(setVersionOperation);
            typename D::abi_guard guard(this->shim());
            *setVersionOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().SetVersionAsync(desiredVersion, *reinterpret_cast<winrt::Windows::Storage::ApplicationDataSetVersionHandler const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClearAllAsync(void** clearOperation) noexcept final try
        {
            clear_abi(clearOperation);
            typename D::abi_guard guard(this->shim());
            *clearOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().ClearAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClearAsync(int32_t locality, void** clearOperation) noexcept final try
        {
            clear_abi(clearOperation);
            typename D::abi_guard guard(this->shim());
            *clearOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().ClearAsync(*reinterpret_cast<winrt::Windows::Storage::ApplicationDataLocality const*>(&locality)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LocalSettings(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::ApplicationDataContainer>(this->shim().LocalSettings());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RoamingSettings(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::ApplicationDataContainer>(this->shim().RoamingSettings());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LocalFolder(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().LocalFolder());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RoamingFolder(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().RoamingFolder());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TemporaryFolder(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().TemporaryFolder());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_DataChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().DataChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::ApplicationData, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_DataChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DataChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall SignalDataChanged() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SignalDataChanged();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RoamingStorageQuota(uint64_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint64_t>(this->shim().RoamingStorageQuota());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IApplicationData2> : produce_base<D, winrt::Windows::Storage::IApplicationData2>
    {
        int32_t __stdcall get_LocalCacheFolder(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().LocalCacheFolder());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IApplicationData3> : produce_base<D, winrt::Windows::Storage::IApplicationData3>
    {
        int32_t __stdcall GetPublisherCacheFolder(void* folderName, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().GetPublisherCacheFolder(*reinterpret_cast<hstring const*>(&folderName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClearPublisherCacheFolderAsync(void* folderName, void** clearOperation) noexcept final try
        {
            clear_abi(clearOperation);
            typename D::abi_guard guard(this->shim());
            *clearOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().ClearPublisherCacheFolderAsync(*reinterpret_cast<hstring const*>(&folderName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SharedLocalFolder(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().SharedLocalFolder());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IApplicationDataContainer> : produce_base<D, winrt::Windows::Storage::IApplicationDataContainer>
    {
        int32_t __stdcall get_Name(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Name());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Locality(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::ApplicationDataLocality>(this->shim().Locality());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Values(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IPropertySet>(this->shim().Values());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Containers(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::Storage::ApplicationDataContainer>>(this->shim().Containers());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateContainer(void* name, int32_t disposition, void** container) noexcept final try
        {
            clear_abi(container);
            typename D::abi_guard guard(this->shim());
            *container = detach_from<winrt::Windows::Storage::ApplicationDataContainer>(this->shim().CreateContainer(*reinterpret_cast<hstring const*>(&name), *reinterpret_cast<winrt::Windows::Storage::ApplicationDataCreateDisposition const*>(&disposition)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DeleteContainer(void* name) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DeleteContainer(*reinterpret_cast<hstring const*>(&name));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IApplicationDataStatics> : produce_base<D, winrt::Windows::Storage::IApplicationDataStatics>
    {
        int32_t __stdcall get_Current(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::ApplicationData>(this->shim().Current());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IApplicationDataStatics2> : produce_base<D, winrt::Windows::Storage::IApplicationDataStatics2>
    {
        int32_t __stdcall GetForUserAsync(void* user, void** getForUserOperation) noexcept final try
        {
            clear_abi(getForUserOperation);
            typename D::abi_guard guard(this->shim());
            *getForUserOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::ApplicationData>>(this->shim().GetForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ICachedFileManagerStatics> : produce_base<D, winrt::Windows::Storage::ICachedFileManagerStatics>
    {
        int32_t __stdcall DeferUpdates(void* file) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DeferUpdates(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CompleteUpdatesAsync(void* file, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Provider::FileUpdateStatus>>(this->shim().CompleteUpdatesAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IDownloadsFolderStatics> : produce_base<D, winrt::Windows::Storage::IDownloadsFolderStatics>
    {
        int32_t __stdcall CreateFileAsync(void* desiredName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CreateFileAsync(*reinterpret_cast<hstring const*>(&desiredName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFolderAsync(void* desiredName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().CreateFolderAsync(*reinterpret_cast<hstring const*>(&desiredName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFileWithCollisionOptionAsync(void* desiredName, int32_t option, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CreateFileAsync(*reinterpret_cast<hstring const*>(&desiredName), *reinterpret_cast<winrt::Windows::Storage::CreationCollisionOption const*>(&option)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFolderWithCollisionOptionAsync(void* desiredName, int32_t option, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().CreateFolderAsync(*reinterpret_cast<hstring const*>(&desiredName), *reinterpret_cast<winrt::Windows::Storage::CreationCollisionOption const*>(&option)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IDownloadsFolderStatics2> : produce_base<D, winrt::Windows::Storage::IDownloadsFolderStatics2>
    {
        int32_t __stdcall CreateFileForUserAsync(void* user, void* desiredName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CreateFileForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&desiredName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFolderForUserAsync(void* user, void* desiredName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().CreateFolderForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&desiredName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFileForUserWithCollisionOptionAsync(void* user, void* desiredName, int32_t option, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CreateFileForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&desiredName), *reinterpret_cast<winrt::Windows::Storage::CreationCollisionOption const*>(&option)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFolderForUserWithCollisionOptionAsync(void* user, void* desiredName, int32_t option, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().CreateFolderForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&desiredName), *reinterpret_cast<winrt::Windows::Storage::CreationCollisionOption const*>(&option)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IFileIOStatics> : produce_base<D, winrt::Windows::Storage::IFileIOStatics>
    {
        int32_t __stdcall ReadTextAsync(void* file, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().ReadTextAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadTextWithEncodingAsync(void* file, int32_t encoding, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().ReadTextAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteTextAsync(void* file, void* contents, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteTextAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<hstring const*>(&contents)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteTextWithEncodingAsync(void* file, void* contents, int32_t encoding, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteTextAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<hstring const*>(&contents), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AppendTextAsync(void* file, void* contents, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AppendTextAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<hstring const*>(&contents)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AppendTextWithEncodingAsync(void* file, void* contents, int32_t encoding, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AppendTextAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<hstring const*>(&contents), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadLinesAsync(void* file, void** linesOperation) noexcept final try
        {
            clear_abi(linesOperation);
            typename D::abi_guard guard(this->shim());
            *linesOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVector<hstring>>>(this->shim().ReadLinesAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadLinesWithEncodingAsync(void* file, int32_t encoding, void** linesOperation) noexcept final try
        {
            clear_abi(linesOperation);
            typename D::abi_guard guard(this->shim());
            *linesOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVector<hstring>>>(this->shim().ReadLinesAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteLinesAsync(void* file, void* lines, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteLinesAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&lines)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteLinesWithEncodingAsync(void* file, void* lines, int32_t encoding, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteLinesAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&lines), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AppendLinesAsync(void* file, void* lines, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AppendLinesAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&lines)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AppendLinesWithEncodingAsync(void* file, void* lines, int32_t encoding, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AppendLinesAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&lines), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadBufferAsync(void* file, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>>(this->shim().ReadBufferAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteBufferAsync(void* file, void* buffer, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteBufferAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), *reinterpret_cast<winrt::Windows::Storage::Streams::IBuffer const*>(&buffer)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteBytesAsync(void* file, uint32_t __bufferSize, uint8_t* buffer, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteBytesAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file), array_view<uint8_t const>(reinterpret_cast<uint8_t const *>(buffer), reinterpret_cast<uint8_t const *>(buffer) + __bufferSize)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IKnownFoldersCameraRollStatics> : produce_base<D, winrt::Windows::Storage::IKnownFoldersCameraRollStatics>
    {
        int32_t __stdcall get_CameraRoll(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().CameraRoll());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IKnownFoldersPlaylistsStatics> : produce_base<D, winrt::Windows::Storage::IKnownFoldersPlaylistsStatics>
    {
        int32_t __stdcall get_Playlists(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().Playlists());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IKnownFoldersSavedPicturesStatics> : produce_base<D, winrt::Windows::Storage::IKnownFoldersSavedPicturesStatics>
    {
        int32_t __stdcall get_SavedPictures(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().SavedPictures());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IKnownFoldersStatics> : produce_base<D, winrt::Windows::Storage::IKnownFoldersStatics>
    {
        int32_t __stdcall get_MusicLibrary(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().MusicLibrary());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PicturesLibrary(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().PicturesLibrary());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VideosLibrary(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().VideosLibrary());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DocumentsLibrary(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().DocumentsLibrary());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_HomeGroup(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().HomeGroup());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RemovableDevices(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().RemovableDevices());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MediaServerDevices(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().MediaServerDevices());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IKnownFoldersStatics2> : produce_base<D, winrt::Windows::Storage::IKnownFoldersStatics2>
    {
        int32_t __stdcall get_Objects3D(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().Objects3D());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AppCaptures(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().AppCaptures());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RecordedCalls(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().RecordedCalls());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IKnownFoldersStatics3> : produce_base<D, winrt::Windows::Storage::IKnownFoldersStatics3>
    {
        int32_t __stdcall GetFolderForUserAsync(void* user, int32_t folderId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().GetFolderForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<winrt::Windows::Storage::KnownFolderId const*>(&folderId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IKnownFoldersStatics4> : produce_base<D, winrt::Windows::Storage::IKnownFoldersStatics4>
    {
        int32_t __stdcall RequestAccessAsync(int32_t folderId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::KnownFoldersAccessStatus>>(this->shim().RequestAccessAsync(*reinterpret_cast<winrt::Windows::Storage::KnownFolderId const*>(&folderId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestAccessForUserAsync(void* user, int32_t folderId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::KnownFoldersAccessStatus>>(this->shim().RequestAccessForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<winrt::Windows::Storage::KnownFolderId const*>(&folderId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetFolderAsync(int32_t folderId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().GetFolderAsync(*reinterpret_cast<winrt::Windows::Storage::KnownFolderId const*>(&folderId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IPathIOStatics> : produce_base<D, winrt::Windows::Storage::IPathIOStatics>
    {
        int32_t __stdcall ReadTextAsync(void* absolutePath, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().ReadTextAsync(*reinterpret_cast<hstring const*>(&absolutePath)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadTextWithEncodingAsync(void* absolutePath, int32_t encoding, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().ReadTextAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteTextAsync(void* absolutePath, void* contents, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteTextAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<hstring const*>(&contents)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteTextWithEncodingAsync(void* absolutePath, void* contents, int32_t encoding, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteTextAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<hstring const*>(&contents), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AppendTextAsync(void* absolutePath, void* contents, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AppendTextAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<hstring const*>(&contents)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AppendTextWithEncodingAsync(void* absolutePath, void* contents, int32_t encoding, void** textOperation) noexcept final try
        {
            clear_abi(textOperation);
            typename D::abi_guard guard(this->shim());
            *textOperation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AppendTextAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<hstring const*>(&contents), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadLinesAsync(void* absolutePath, void** linesOperation) noexcept final try
        {
            clear_abi(linesOperation);
            typename D::abi_guard guard(this->shim());
            *linesOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVector<hstring>>>(this->shim().ReadLinesAsync(*reinterpret_cast<hstring const*>(&absolutePath)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadLinesWithEncodingAsync(void* absolutePath, int32_t encoding, void** linesOperation) noexcept final try
        {
            clear_abi(linesOperation);
            typename D::abi_guard guard(this->shim());
            *linesOperation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVector<hstring>>>(this->shim().ReadLinesAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteLinesAsync(void* absolutePath, void* lines, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteLinesAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&lines)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteLinesWithEncodingAsync(void* absolutePath, void* lines, int32_t encoding, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteLinesAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&lines), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AppendLinesAsync(void* absolutePath, void* lines, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AppendLinesAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&lines)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AppendLinesWithEncodingAsync(void* absolutePath, void* lines, int32_t encoding, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AppendLinesAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&lines), *reinterpret_cast<winrt::Windows::Storage::Streams::UnicodeEncoding const*>(&encoding)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadBufferAsync(void* absolutePath, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>>(this->shim().ReadBufferAsync(*reinterpret_cast<hstring const*>(&absolutePath)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteBufferAsync(void* absolutePath, void* buffer, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteBufferAsync(*reinterpret_cast<hstring const*>(&absolutePath), *reinterpret_cast<winrt::Windows::Storage::Streams::IBuffer const*>(&buffer)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall WriteBytesAsync(void* absolutePath, uint32_t __bufferSize, uint8_t* buffer, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().WriteBytesAsync(*reinterpret_cast<hstring const*>(&absolutePath), array_view<uint8_t const>(reinterpret_cast<uint8_t const *>(buffer), reinterpret_cast<uint8_t const *>(buffer) + __bufferSize)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISetVersionDeferral> : produce_base<D, winrt::Windows::Storage::ISetVersionDeferral>
    {
        int32_t __stdcall Complete() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Complete();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISetVersionRequest> : produce_base<D, winrt::Windows::Storage::ISetVersionRequest>
    {
        int32_t __stdcall get_CurrentVersion(uint32_t* currentVersion) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *currentVersion = detach_from<uint32_t>(this->shim().CurrentVersion());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DesiredVersion(uint32_t* desiredVersion) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *desiredVersion = detach_from<uint32_t>(this->shim().DesiredVersion());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeferral(void** deferral) noexcept final try
        {
            clear_abi(deferral);
            typename D::abi_guard guard(this->shim());
            *deferral = detach_from<winrt::Windows::Storage::SetVersionDeferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageFile> : produce_base<D, winrt::Windows::Storage::IStorageFile>
    {
        int32_t __stdcall get_FileType(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FileType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ContentType(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ContentType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OpenAsync(int32_t accessMode, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IRandomAccessStream>>(this->shim().OpenAsync(*reinterpret_cast<winrt::Windows::Storage::FileAccessMode const*>(&accessMode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OpenTransactedWriteAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageStreamTransaction>>(this->shim().OpenTransactedWriteAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CopyOverloadDefaultNameAndOptions(void* destinationFolder, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CopyAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFolder const*>(&destinationFolder)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CopyOverloadDefaultOptions(void* destinationFolder, void* desiredNewName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CopyAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFolder const*>(&destinationFolder), *reinterpret_cast<hstring const*>(&desiredNewName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CopyOverload(void* destinationFolder, void* desiredNewName, int32_t option, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CopyAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFolder const*>(&destinationFolder), *reinterpret_cast<hstring const*>(&desiredNewName), *reinterpret_cast<winrt::Windows::Storage::NameCollisionOption const*>(&option)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CopyAndReplaceAsync(void* fileToReplace, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().CopyAndReplaceAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&fileToReplace)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MoveOverloadDefaultNameAndOptions(void* destinationFolder, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().MoveAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFolder const*>(&destinationFolder)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MoveOverloadDefaultOptions(void* destinationFolder, void* desiredNewName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().MoveAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFolder const*>(&destinationFolder), *reinterpret_cast<hstring const*>(&desiredNewName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MoveOverload(void* destinationFolder, void* desiredNewName, int32_t option, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().MoveAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFolder const*>(&destinationFolder), *reinterpret_cast<hstring const*>(&desiredNewName), *reinterpret_cast<winrt::Windows::Storage::NameCollisionOption const*>(&option)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MoveAndReplaceAsync(void* fileToReplace, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().MoveAndReplaceAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&fileToReplace)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageFile2> : produce_base<D, winrt::Windows::Storage::IStorageFile2>
    {
        int32_t __stdcall OpenWithOptionsAsync(int32_t accessMode, uint32_t options, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IRandomAccessStream>>(this->shim().OpenAsync(*reinterpret_cast<winrt::Windows::Storage::FileAccessMode const*>(&accessMode), *reinterpret_cast<winrt::Windows::Storage::StorageOpenOptions const*>(&options)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall OpenTransactedWriteWithOptionsAsync(uint32_t options, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageStreamTransaction>>(this->shim().OpenTransactedWriteAsync(*reinterpret_cast<winrt::Windows::Storage::StorageOpenOptions const*>(&options)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageFilePropertiesWithAvailability> : produce_base<D, winrt::Windows::Storage::IStorageFilePropertiesWithAvailability>
    {
        int32_t __stdcall get_IsAvailable(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsAvailable());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageFileStatics> : produce_base<D, winrt::Windows::Storage::IStorageFileStatics>
    {
        int32_t __stdcall GetFileFromPathAsync(void* path, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().GetFileFromPathAsync(*reinterpret_cast<hstring const*>(&path)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetFileFromApplicationUriAsync(void* uri, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().GetFileFromApplicationUriAsync(*reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateStreamedFileAsync(void* displayNameWithExtension, void* dataRequested, void* thumbnail, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CreateStreamedFileAsync(*reinterpret_cast<hstring const*>(&displayNameWithExtension), *reinterpret_cast<winrt::Windows::Storage::StreamedFileDataRequestedHandler const*>(&dataRequested), *reinterpret_cast<winrt::Windows::Storage::Streams::IRandomAccessStreamReference const*>(&thumbnail)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReplaceWithStreamedFileAsync(void* fileToReplace, void* dataRequested, void* thumbnail, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().ReplaceWithStreamedFileAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&fileToReplace), *reinterpret_cast<winrt::Windows::Storage::StreamedFileDataRequestedHandler const*>(&dataRequested), *reinterpret_cast<winrt::Windows::Storage::Streams::IRandomAccessStreamReference const*>(&thumbnail)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateStreamedFileFromUriAsync(void* displayNameWithExtension, void* uri, void* thumbnail, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CreateStreamedFileFromUriAsync(*reinterpret_cast<hstring const*>(&displayNameWithExtension), *reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri), *reinterpret_cast<winrt::Windows::Storage::Streams::IRandomAccessStreamReference const*>(&thumbnail)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReplaceWithStreamedFileFromUriAsync(void* fileToReplace, void* uri, void* thumbnail, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().ReplaceWithStreamedFileFromUriAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&fileToReplace), *reinterpret_cast<winrt::Windows::Foundation::Uri const*>(&uri), *reinterpret_cast<winrt::Windows::Storage::Streams::IRandomAccessStreamReference const*>(&thumbnail)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageFileStatics2> : produce_base<D, winrt::Windows::Storage::IStorageFileStatics2>
    {
        int32_t __stdcall GetFileFromPathForUserAsync(void* user, void* path, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().GetFileFromPathForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&path)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageFolder> : produce_base<D, winrt::Windows::Storage::IStorageFolder>
    {
        int32_t __stdcall CreateFileAsyncOverloadDefaultOptions(void* desiredName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CreateFileAsync(*reinterpret_cast<hstring const*>(&desiredName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFileAsync(void* desiredName, int32_t options, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().CreateFileAsync(*reinterpret_cast<hstring const*>(&desiredName), *reinterpret_cast<winrt::Windows::Storage::CreationCollisionOption const*>(&options)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFolderAsyncOverloadDefaultOptions(void* desiredName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().CreateFolderAsync(*reinterpret_cast<hstring const*>(&desiredName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CreateFolderAsync(void* desiredName, int32_t options, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().CreateFolderAsync(*reinterpret_cast<hstring const*>(&desiredName), *reinterpret_cast<winrt::Windows::Storage::CreationCollisionOption const*>(&options)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetFileAsync(void* name, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFile>>(this->shim().GetFileAsync(*reinterpret_cast<hstring const*>(&name)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetFolderAsync(void* name, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().GetFolderAsync(*reinterpret_cast<hstring const*>(&name)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetItemAsync(void* name, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::IStorageItem>>(this->shim().GetItemAsync(*reinterpret_cast<hstring const*>(&name)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetFilesAsyncOverloadDefaultOptionsStartAndCount(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Storage::StorageFile>>>(this->shim().GetFilesAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetFoldersAsyncOverloadDefaultOptionsStartAndCount(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Storage::StorageFolder>>>(this->shim().GetFoldersAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetItemsAsyncOverloadDefaultStartAndCount(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Storage::IStorageItem>>>(this->shim().GetItemsAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageFolder2> : produce_base<D, winrt::Windows::Storage::IStorageFolder2>
    {
        int32_t __stdcall TryGetItemAsync(void* name, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::IStorageItem>>(this->shim().TryGetItemAsync(*reinterpret_cast<hstring const*>(&name)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageFolder3> : produce_base<D, winrt::Windows::Storage::IStorageFolder3>
    {
        int32_t __stdcall TryGetChangeTracker(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Storage::StorageLibraryChangeTracker>(this->shim().TryGetChangeTracker());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageFolderStatics> : produce_base<D, winrt::Windows::Storage::IStorageFolderStatics>
    {
        int32_t __stdcall GetFolderFromPathAsync(void* path, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().GetFolderFromPathAsync(*reinterpret_cast<hstring const*>(&path)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageFolderStatics2> : produce_base<D, winrt::Windows::Storage::IStorageFolderStatics2>
    {
        int32_t __stdcall GetFolderFromPathForUserAsync(void* user, void* path, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().GetFolderFromPathForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<hstring const*>(&path)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageItem> : produce_base<D, winrt::Windows::Storage::IStorageItem>
    {
        int32_t __stdcall RenameAsyncOverloadDefaultOptions(void* desiredName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().RenameAsync(*reinterpret_cast<hstring const*>(&desiredName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RenameAsync(void* desiredName, int32_t option, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().RenameAsync(*reinterpret_cast<hstring const*>(&desiredName), *reinterpret_cast<winrt::Windows::Storage::NameCollisionOption const*>(&option)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DeleteAsyncOverloadDefaultOptions(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().DeleteAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DeleteAsync(int32_t option, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().DeleteAsync(*reinterpret_cast<winrt::Windows::Storage::StorageDeleteOption const*>(&option)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetBasicPropertiesAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::BasicProperties>>(this->shim().GetBasicPropertiesAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Name(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Name());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Path(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Path());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Attributes(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::FileAttributes>(this->shim().Attributes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DateCreated(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::DateTime>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::DateTime>(this->shim().DateCreated());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsOfType(uint32_t type, bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsOfType(*reinterpret_cast<winrt::Windows::Storage::StorageItemTypes const*>(&type)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageItem2> : produce_base<D, winrt::Windows::Storage::IStorageItem2>
    {
        int32_t __stdcall GetParentAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().GetParentAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsEqual(void* item, bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsEqual(*reinterpret_cast<winrt::Windows::Storage::IStorageItem const*>(&item)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageItemProperties> : produce_base<D, winrt::Windows::Storage::IStorageItemProperties>
    {
        int32_t __stdcall GetThumbnailAsyncOverloadDefaultSizeDefaultOptions(int32_t mode, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>>(this->shim().GetThumbnailAsync(*reinterpret_cast<winrt::Windows::Storage::FileProperties::ThumbnailMode const*>(&mode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetThumbnailAsyncOverloadDefaultOptions(int32_t mode, uint32_t requestedSize, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>>(this->shim().GetThumbnailAsync(*reinterpret_cast<winrt::Windows::Storage::FileProperties::ThumbnailMode const*>(&mode), requestedSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetThumbnailAsync(int32_t mode, uint32_t requestedSize, uint32_t options, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>>(this->shim().GetThumbnailAsync(*reinterpret_cast<winrt::Windows::Storage::FileProperties::ThumbnailMode const*>(&mode), requestedSize, *reinterpret_cast<winrt::Windows::Storage::FileProperties::ThumbnailOptions const*>(&options)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DisplayName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DisplayName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DisplayType(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DisplayType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FolderRelativeId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FolderRelativeId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Properties(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::FileProperties::StorageItemContentProperties>(this->shim().Properties());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageItemProperties2> : produce_base<D, winrt::Windows::Storage::IStorageItemProperties2>
    {
        int32_t __stdcall GetScaledImageAsThumbnailAsyncOverloadDefaultSizeDefaultOptions(int32_t mode, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>>(this->shim().GetScaledImageAsThumbnailAsync(*reinterpret_cast<winrt::Windows::Storage::FileProperties::ThumbnailMode const*>(&mode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetScaledImageAsThumbnailAsyncOverloadDefaultOptions(int32_t mode, uint32_t requestedSize, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>>(this->shim().GetScaledImageAsThumbnailAsync(*reinterpret_cast<winrt::Windows::Storage::FileProperties::ThumbnailMode const*>(&mode), requestedSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetScaledImageAsThumbnailAsync(int32_t mode, uint32_t requestedSize, uint32_t options, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::FileProperties::StorageItemThumbnail>>(this->shim().GetScaledImageAsThumbnailAsync(*reinterpret_cast<winrt::Windows::Storage::FileProperties::ThumbnailMode const*>(&mode), requestedSize, *reinterpret_cast<winrt::Windows::Storage::FileProperties::ThumbnailOptions const*>(&options)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageItemPropertiesWithProvider> : produce_base<D, winrt::Windows::Storage::IStorageItemPropertiesWithProvider>
    {
        int32_t __stdcall get_Provider(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageProvider>(this->shim().Provider());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibrary> : produce_base<D, winrt::Windows::Storage::IStorageLibrary>
    {
        int32_t __stdcall RequestAddFolderAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageFolder>>(this->shim().RequestAddFolderAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestRemoveFolderAsync(void* folder, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().RequestRemoveFolderAsync(*reinterpret_cast<winrt::Windows::Storage::StorageFolder const*>(&folder)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Folders(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IObservableVector<winrt::Windows::Storage::StorageFolder>>(this->shim().Folders());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SaveFolder(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageFolder>(this->shim().SaveFolder());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_DefinitionChanged(void* handler, winrt::event_token* eventCookie) noexcept final try
        {
            zero_abi<winrt::event_token>(eventCookie);
            typename D::abi_guard guard(this->shim());
            *eventCookie = detach_from<winrt::event_token>(this->shim().DefinitionChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::StorageLibrary, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_DefinitionChanged(winrt::event_token eventCookie) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DefinitionChanged(*reinterpret_cast<winrt::event_token const*>(&eventCookie));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibrary2> : produce_base<D, winrt::Windows::Storage::IStorageLibrary2>
    {
        int32_t __stdcall get_ChangeTracker(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageLibraryChangeTracker>(this->shim().ChangeTracker());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibrary3> : produce_base<D, winrt::Windows::Storage::IStorageLibrary3>
    {
        int32_t __stdcall AreFolderSuggestionsAvailableAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().AreFolderSuggestionsAvailableAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibraryChange> : produce_base<D, winrt::Windows::Storage::IStorageLibraryChange>
    {
        int32_t __stdcall get_ChangeType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageLibraryChangeType>(this->shim().ChangeType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Path(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Path());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PreviousPath(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PreviousPath());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsOfType(uint32_t type, bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsOfType(*reinterpret_cast<winrt::Windows::Storage::StorageItemTypes const*>(&type)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetStorageItemAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::IStorageItem>>(this->shim().GetStorageItemAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibraryChangeReader> : produce_base<D, winrt::Windows::Storage::IStorageLibraryChangeReader>
    {
        int32_t __stdcall ReadBatchAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Storage::StorageLibraryChange>>>(this->shim().ReadBatchAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AcceptChangesAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AcceptChangesAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibraryChangeReader2> : produce_base<D, winrt::Windows::Storage::IStorageLibraryChangeReader2>
    {
        int32_t __stdcall GetLastChangeId(uint64_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<uint64_t>(this->shim().GetLastChangeId());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibraryChangeTracker> : produce_base<D, winrt::Windows::Storage::IStorageLibraryChangeTracker>
    {
        int32_t __stdcall GetChangeReader(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::StorageLibraryChangeReader>(this->shim().GetChangeReader());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Enable() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Enable();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Reset() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Reset();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibraryChangeTracker2> : produce_base<D, winrt::Windows::Storage::IStorageLibraryChangeTracker2>
    {
        int32_t __stdcall EnableWithOptions(void* options) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Enable(*reinterpret_cast<winrt::Windows::Storage::StorageLibraryChangeTrackerOptions const*>(&options));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Disable() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Disable();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions> : produce_base<D, winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions>
    {
        int32_t __stdcall get_TrackChangeDetails(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().TrackChangeDetails());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TrackChangeDetails(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TrackChangeDetails(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibraryLastChangeId> : produce_base<D, winrt::Windows::Storage::IStorageLibraryLastChangeId>
    {
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibraryLastChangeIdStatics> : produce_base<D, winrt::Windows::Storage::IStorageLibraryLastChangeIdStatics>
    {
        int32_t __stdcall get_Unknown(uint64_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint64_t>(this->shim().Unknown());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibraryStatics> : produce_base<D, winrt::Windows::Storage::IStorageLibraryStatics>
    {
        int32_t __stdcall GetLibraryAsync(int32_t libraryId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageLibrary>>(this->shim().GetLibraryAsync(*reinterpret_cast<winrt::Windows::Storage::KnownLibraryId const*>(&libraryId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageLibraryStatics2> : produce_base<D, winrt::Windows::Storage::IStorageLibraryStatics2>
    {
        int32_t __stdcall GetLibraryForUserAsync(void* user, int32_t libraryId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::StorageLibrary>>(this->shim().GetLibraryForUserAsync(*reinterpret_cast<winrt::Windows::System::User const*>(&user), *reinterpret_cast<winrt::Windows::Storage::KnownLibraryId const*>(&libraryId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageProvider> : produce_base<D, winrt::Windows::Storage::IStorageProvider>
    {
        int32_t __stdcall get_Id(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DisplayName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DisplayName());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageProvider2> : produce_base<D, winrt::Windows::Storage::IStorageProvider2>
    {
        int32_t __stdcall IsPropertySupportedForPartialFileAsync(void* propertyCanonicalName, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().IsPropertySupportedForPartialFileAsync(*reinterpret_cast<hstring const*>(&propertyCanonicalName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStorageStreamTransaction> : produce_base<D, winrt::Windows::Storage::IStorageStreamTransaction>
    {
        int32_t __stdcall get_Stream(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IRandomAccessStream>(this->shim().Stream());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CommitAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().CommitAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IStreamedFileDataRequest> : produce_base<D, winrt::Windows::Storage::IStreamedFileDataRequest>
    {
        int32_t __stdcall FailAndClose(int32_t failureMode) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FailAndClose(*reinterpret_cast<winrt::Windows::Storage::StreamedFileFailureMode const*>(&failureMode));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISystemAudioProperties> : produce_base<D, winrt::Windows::Storage::ISystemAudioProperties>
    {
        int32_t __stdcall get_EncodingBitrate(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().EncodingBitrate());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISystemDataPaths> : produce_base<D, winrt::Windows::Storage::ISystemDataPaths>
    {
        int32_t __stdcall get_Fonts(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Fonts());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ProgramData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ProgramData());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Public(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Public());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PublicDesktop(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PublicDesktop());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PublicDocuments(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PublicDocuments());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PublicDownloads(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PublicDownloads());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PublicMusic(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PublicMusic());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PublicPictures(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PublicPictures());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PublicVideos(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PublicVideos());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_System(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().System());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SystemHost(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().SystemHost());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SystemX86(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().SystemX86());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SystemX64(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().SystemX64());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SystemArm(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().SystemArm());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UserProfiles(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().UserProfiles());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Windows(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Windows());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISystemDataPathsStatics> : produce_base<D, winrt::Windows::Storage::ISystemDataPathsStatics>
    {
        int32_t __stdcall GetDefault(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Storage::SystemDataPaths>(this->shim().GetDefault());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISystemGPSProperties> : produce_base<D, winrt::Windows::Storage::ISystemGPSProperties>
    {
        int32_t __stdcall get_LatitudeDecimal(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().LatitudeDecimal());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LongitudeDecimal(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().LongitudeDecimal());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISystemImageProperties> : produce_base<D, winrt::Windows::Storage::ISystemImageProperties>
    {
        int32_t __stdcall get_HorizontalSize(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().HorizontalSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VerticalSize(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().VerticalSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISystemMediaProperties> : produce_base<D, winrt::Windows::Storage::ISystemMediaProperties>
    {
        int32_t __stdcall get_Duration(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Duration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Producer(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Producer());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Publisher(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Publisher());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SubTitle(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().SubTitle());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Writer(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Writer());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Year(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Year());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISystemMusicProperties> : produce_base<D, winrt::Windows::Storage::ISystemMusicProperties>
    {
        int32_t __stdcall get_AlbumArtist(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AlbumArtist());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AlbumTitle(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().AlbumTitle());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Artist(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Artist());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Composer(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Composer());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Conductor(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Conductor());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DisplayArtist(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DisplayArtist());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Genre(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Genre());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TrackNumber(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().TrackNumber());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISystemPhotoProperties> : produce_base<D, winrt::Windows::Storage::ISystemPhotoProperties>
    {
        int32_t __stdcall get_CameraManufacturer(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().CameraManufacturer());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CameraModel(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().CameraModel());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DateTaken(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DateTaken());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Orientation(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Orientation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PeopleNames(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().PeopleNames());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISystemProperties> : produce_base<D, winrt::Windows::Storage::ISystemProperties>
    {
        int32_t __stdcall get_Author(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Author());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Comment(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Comment());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ItemNameDisplay(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().ItemNameDisplay());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Keywords(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Keywords());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Rating(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Rating());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Title(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Title());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Audio(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::SystemAudioProperties>(this->shim().Audio());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_GPS(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::SystemGPSProperties>(this->shim().GPS());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Media(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::SystemMediaProperties>(this->shim().Media());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Music(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::SystemMusicProperties>(this->shim().Music());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Photo(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::SystemPhotoProperties>(this->shim().Photo());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Video(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::SystemVideoProperties>(this->shim().Video());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Image(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::SystemImageProperties>(this->shim().Image());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::ISystemVideoProperties> : produce_base<D, winrt::Windows::Storage::ISystemVideoProperties>
    {
        int32_t __stdcall get_Director(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Director());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FrameHeight(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FrameHeight());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FrameWidth(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FrameWidth());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Orientation(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Orientation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TotalBitrate(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().TotalBitrate());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IUserDataPaths> : produce_base<D, winrt::Windows::Storage::IUserDataPaths>
    {
        int32_t __stdcall get_CameraRoll(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().CameraRoll());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Cookies(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Cookies());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Desktop(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Desktop());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Documents(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Documents());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Downloads(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Downloads());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Favorites(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Favorites());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_History(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().History());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_InternetCache(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().InternetCache());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LocalAppData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().LocalAppData());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LocalAppDataLow(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().LocalAppDataLow());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Music(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Music());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Pictures(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Pictures());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Profile(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Profile());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Recent(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Recent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RoamingAppData(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().RoamingAppData());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SavedPictures(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().SavedPictures());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Screenshots(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Screenshots());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Templates(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Templates());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Videos(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Videos());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::IUserDataPathsStatics> : produce_base<D, winrt::Windows::Storage::IUserDataPathsStatics>
    {
        int32_t __stdcall GetForUser(void* user, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Storage::UserDataPaths>(this->shim().GetForUser(*reinterpret_cast<winrt::Windows::System::User const*>(&user)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDefault(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Storage::UserDataPaths>(this->shim().GetDefault());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Storage
{
    constexpr auto operator|(FileAttributes const left, FileAttributes const right) noexcept
    {
        return static_cast<FileAttributes>(impl::to_underlying_type(left) | impl::to_underlying_type(right));
    }
    constexpr auto operator|=(FileAttributes& left, FileAttributes const right) noexcept
    {
        left = left | right;
        return left;
    }
    constexpr auto operator&(FileAttributes const left, FileAttributes const right) noexcept
    {
        return static_cast<FileAttributes>(impl::to_underlying_type(left) & impl::to_underlying_type(right));
    }
    constexpr auto operator&=(FileAttributes& left, FileAttributes const right) noexcept
    {
        left = left & right;
        return left;
    }
    constexpr auto operator~(FileAttributes const value) noexcept
    {
        return static_cast<FileAttributes>(~impl::to_underlying_type(value));
    }
    constexpr auto operator^(FileAttributes const left, FileAttributes const right) noexcept
    {
        return static_cast<FileAttributes>(impl::to_underlying_type(left) ^ impl::to_underlying_type(right));
    }
    constexpr auto operator^=(FileAttributes& left, FileAttributes const right) noexcept
    {
        left = left ^ right;
        return left;
    }
    constexpr auto operator|(StorageItemTypes const left, StorageItemTypes const right) noexcept
    {
        return static_cast<StorageItemTypes>(impl::to_underlying_type(left) | impl::to_underlying_type(right));
    }
    constexpr auto operator|=(StorageItemTypes& left, StorageItemTypes const right) noexcept
    {
        left = left | right;
        return left;
    }
    constexpr auto operator&(StorageItemTypes const left, StorageItemTypes const right) noexcept
    {
        return static_cast<StorageItemTypes>(impl::to_underlying_type(left) & impl::to_underlying_type(right));
    }
    constexpr auto operator&=(StorageItemTypes& left, StorageItemTypes const right) noexcept
    {
        left = left & right;
        return left;
    }
    constexpr auto operator~(StorageItemTypes const value) noexcept
    {
        return static_cast<StorageItemTypes>(~impl::to_underlying_type(value));
    }
    constexpr auto operator^(StorageItemTypes const left, StorageItemTypes const right) noexcept
    {
        return static_cast<StorageItemTypes>(impl::to_underlying_type(left) ^ impl::to_underlying_type(right));
    }
    constexpr auto operator^=(StorageItemTypes& left, StorageItemTypes const right) noexcept
    {
        left = left ^ right;
        return left;
    }
    constexpr auto operator|(StorageOpenOptions const left, StorageOpenOptions const right) noexcept
    {
        return static_cast<StorageOpenOptions>(impl::to_underlying_type(left) | impl::to_underlying_type(right));
    }
    constexpr auto operator|=(StorageOpenOptions& left, StorageOpenOptions const right) noexcept
    {
        left = left | right;
        return left;
    }
    constexpr auto operator&(StorageOpenOptions const left, StorageOpenOptions const right) noexcept
    {
        return static_cast<StorageOpenOptions>(impl::to_underlying_type(left) & impl::to_underlying_type(right));
    }
    constexpr auto operator&=(StorageOpenOptions& left, StorageOpenOptions const right) noexcept
    {
        left = left & right;
        return left;
    }
    constexpr auto operator~(StorageOpenOptions const value) noexcept
    {
        return static_cast<StorageOpenOptions>(~impl::to_underlying_type(value));
    }
    constexpr auto operator^(StorageOpenOptions const left, StorageOpenOptions const right) noexcept
    {
        return static_cast<StorageOpenOptions>(impl::to_underlying_type(left) ^ impl::to_underlying_type(right));
    }
    constexpr auto operator^=(StorageOpenOptions& left, StorageOpenOptions const right) noexcept
    {
        left = left ^ right;
        return left;
    }
    inline auto AppDataPaths::GetForUser(winrt::Windows::System::User const& user)
    {
        return impl::call_factory<AppDataPaths, IAppDataPathsStatics>([&](IAppDataPathsStatics const& f) { return f.GetForUser(user); });
    }
    inline auto AppDataPaths::GetDefault()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::AppDataPaths(*)(IAppDataPathsStatics const&), AppDataPaths, IAppDataPathsStatics>([](IAppDataPathsStatics const& f) { return f.GetDefault(); });
    }
    inline auto ApplicationData::Current()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::ApplicationData(*)(IApplicationDataStatics const&), ApplicationData, IApplicationDataStatics>([](IApplicationDataStatics const& f) { return f.Current(); });
    }
    inline auto ApplicationData::GetForUserAsync(winrt::Windows::System::User const& user)
    {
        return impl::call_factory<ApplicationData, IApplicationDataStatics2>([&](IApplicationDataStatics2 const& f) { return f.GetForUserAsync(user); });
    }
    inline ApplicationDataCompositeValue::ApplicationDataCompositeValue() :
        ApplicationDataCompositeValue(impl::call_factory_cast<ApplicationDataCompositeValue(*)(winrt::Windows::Foundation::IActivationFactory const&), ApplicationDataCompositeValue>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<ApplicationDataCompositeValue>(); }))
    {
    }
    inline auto CachedFileManager::DeferUpdates(winrt::Windows::Storage::IStorageFile const& file)
    {
        impl::call_factory<CachedFileManager, ICachedFileManagerStatics>([&](ICachedFileManagerStatics const& f) { return f.DeferUpdates(file); });
    }
    inline auto CachedFileManager::CompleteUpdatesAsync(winrt::Windows::Storage::IStorageFile const& file)
    {
        return impl::call_factory<CachedFileManager, ICachedFileManagerStatics>([&](ICachedFileManagerStatics const& f) { return f.CompleteUpdatesAsync(file); });
    }
    inline auto DownloadsFolder::CreateFileAsync(param::hstring const& desiredName)
    {
        return impl::call_factory<DownloadsFolder, IDownloadsFolderStatics>([&](IDownloadsFolderStatics const& f) { return f.CreateFileAsync(desiredName); });
    }
    inline auto DownloadsFolder::CreateFolderAsync(param::hstring const& desiredName)
    {
        return impl::call_factory<DownloadsFolder, IDownloadsFolderStatics>([&](IDownloadsFolderStatics const& f) { return f.CreateFolderAsync(desiredName); });
    }
    inline auto DownloadsFolder::CreateFileAsync(param::hstring const& desiredName, winrt::Windows::Storage::CreationCollisionOption const& option)
    {
        return impl::call_factory<DownloadsFolder, IDownloadsFolderStatics>([&](IDownloadsFolderStatics const& f) { return f.CreateFileAsync(desiredName, option); });
    }
    inline auto DownloadsFolder::CreateFolderAsync(param::hstring const& desiredName, winrt::Windows::Storage::CreationCollisionOption const& option)
    {
        return impl::call_factory<DownloadsFolder, IDownloadsFolderStatics>([&](IDownloadsFolderStatics const& f) { return f.CreateFolderAsync(desiredName, option); });
    }
    inline auto DownloadsFolder::CreateFileForUserAsync(winrt::Windows::System::User const& user, param::hstring const& desiredName)
    {
        return impl::call_factory<DownloadsFolder, IDownloadsFolderStatics2>([&](IDownloadsFolderStatics2 const& f) { return f.CreateFileForUserAsync(user, desiredName); });
    }
    inline auto DownloadsFolder::CreateFolderForUserAsync(winrt::Windows::System::User const& user, param::hstring const& desiredName)
    {
        return impl::call_factory<DownloadsFolder, IDownloadsFolderStatics2>([&](IDownloadsFolderStatics2 const& f) { return f.CreateFolderForUserAsync(user, desiredName); });
    }
    inline auto DownloadsFolder::CreateFileForUserAsync(winrt::Windows::System::User const& user, param::hstring const& desiredName, winrt::Windows::Storage::CreationCollisionOption const& option)
    {
        return impl::call_factory<DownloadsFolder, IDownloadsFolderStatics2>([&](IDownloadsFolderStatics2 const& f) { return f.CreateFileForUserAsync(user, desiredName, option); });
    }
    inline auto DownloadsFolder::CreateFolderForUserAsync(winrt::Windows::System::User const& user, param::hstring const& desiredName, winrt::Windows::Storage::CreationCollisionOption const& option)
    {
        return impl::call_factory<DownloadsFolder, IDownloadsFolderStatics2>([&](IDownloadsFolderStatics2 const& f) { return f.CreateFolderForUserAsync(user, desiredName, option); });
    }
    inline auto FileIO::ReadTextAsync(winrt::Windows::Storage::IStorageFile const& file)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.ReadTextAsync(file); });
    }
    inline auto FileIO::ReadTextAsync(winrt::Windows::Storage::IStorageFile const& file, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.ReadTextAsync(file, encoding); });
    }
    inline auto FileIO::WriteTextAsync(winrt::Windows::Storage::IStorageFile const& file, param::hstring const& contents)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.WriteTextAsync(file, contents); });
    }
    inline auto FileIO::WriteTextAsync(winrt::Windows::Storage::IStorageFile const& file, param::hstring const& contents, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.WriteTextAsync(file, contents, encoding); });
    }
    inline auto FileIO::AppendTextAsync(winrt::Windows::Storage::IStorageFile const& file, param::hstring const& contents)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.AppendTextAsync(file, contents); });
    }
    inline auto FileIO::AppendTextAsync(winrt::Windows::Storage::IStorageFile const& file, param::hstring const& contents, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.AppendTextAsync(file, contents, encoding); });
    }
    inline auto FileIO::ReadLinesAsync(winrt::Windows::Storage::IStorageFile const& file)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.ReadLinesAsync(file); });
    }
    inline auto FileIO::ReadLinesAsync(winrt::Windows::Storage::IStorageFile const& file, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.ReadLinesAsync(file, encoding); });
    }
    inline auto FileIO::WriteLinesAsync(winrt::Windows::Storage::IStorageFile const& file, param::async_iterable<hstring> const& lines)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.WriteLinesAsync(file, lines); });
    }
    inline auto FileIO::WriteLinesAsync(winrt::Windows::Storage::IStorageFile const& file, param::async_iterable<hstring> const& lines, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.WriteLinesAsync(file, lines, encoding); });
    }
    inline auto FileIO::AppendLinesAsync(winrt::Windows::Storage::IStorageFile const& file, param::async_iterable<hstring> const& lines)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.AppendLinesAsync(file, lines); });
    }
    inline auto FileIO::AppendLinesAsync(winrt::Windows::Storage::IStorageFile const& file, param::async_iterable<hstring> const& lines, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.AppendLinesAsync(file, lines, encoding); });
    }
    inline auto FileIO::ReadBufferAsync(winrt::Windows::Storage::IStorageFile const& file)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.ReadBufferAsync(file); });
    }
    inline auto FileIO::WriteBufferAsync(winrt::Windows::Storage::IStorageFile const& file, winrt::Windows::Storage::Streams::IBuffer const& buffer)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.WriteBufferAsync(file, buffer); });
    }
    inline auto FileIO::WriteBytesAsync(winrt::Windows::Storage::IStorageFile const& file, array_view<uint8_t const> buffer)
    {
        return impl::call_factory<FileIO, IFileIOStatics>([&](IFileIOStatics const& f) { return f.WriteBytesAsync(file, buffer); });
    }
    inline auto KnownFolders::CameraRoll()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersCameraRollStatics const&), KnownFolders, IKnownFoldersCameraRollStatics>([](IKnownFoldersCameraRollStatics const& f) { return f.CameraRoll(); });
    }
    inline auto KnownFolders::Playlists()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersPlaylistsStatics const&), KnownFolders, IKnownFoldersPlaylistsStatics>([](IKnownFoldersPlaylistsStatics const& f) { return f.Playlists(); });
    }
    inline auto KnownFolders::SavedPictures()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersSavedPicturesStatics const&), KnownFolders, IKnownFoldersSavedPicturesStatics>([](IKnownFoldersSavedPicturesStatics const& f) { return f.SavedPictures(); });
    }
    inline auto KnownFolders::MusicLibrary()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersStatics const&), KnownFolders, IKnownFoldersStatics>([](IKnownFoldersStatics const& f) { return f.MusicLibrary(); });
    }
    inline auto KnownFolders::PicturesLibrary()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersStatics const&), KnownFolders, IKnownFoldersStatics>([](IKnownFoldersStatics const& f) { return f.PicturesLibrary(); });
    }
    inline auto KnownFolders::VideosLibrary()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersStatics const&), KnownFolders, IKnownFoldersStatics>([](IKnownFoldersStatics const& f) { return f.VideosLibrary(); });
    }
    inline auto KnownFolders::DocumentsLibrary()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersStatics const&), KnownFolders, IKnownFoldersStatics>([](IKnownFoldersStatics const& f) { return f.DocumentsLibrary(); });
    }
    inline auto KnownFolders::HomeGroup()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersStatics const&), KnownFolders, IKnownFoldersStatics>([](IKnownFoldersStatics const& f) { return f.HomeGroup(); });
    }
    inline auto KnownFolders::RemovableDevices()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersStatics const&), KnownFolders, IKnownFoldersStatics>([](IKnownFoldersStatics const& f) { return f.RemovableDevices(); });
    }
    inline auto KnownFolders::MediaServerDevices()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersStatics const&), KnownFolders, IKnownFoldersStatics>([](IKnownFoldersStatics const& f) { return f.MediaServerDevices(); });
    }
    inline auto KnownFolders::Objects3D()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersStatics2 const&), KnownFolders, IKnownFoldersStatics2>([](IKnownFoldersStatics2 const& f) { return f.Objects3D(); });
    }
    inline auto KnownFolders::AppCaptures()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersStatics2 const&), KnownFolders, IKnownFoldersStatics2>([](IKnownFoldersStatics2 const& f) { return f.AppCaptures(); });
    }
    inline auto KnownFolders::RecordedCalls()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::StorageFolder(*)(IKnownFoldersStatics2 const&), KnownFolders, IKnownFoldersStatics2>([](IKnownFoldersStatics2 const& f) { return f.RecordedCalls(); });
    }
    inline auto KnownFolders::GetFolderForUserAsync(winrt::Windows::System::User const& user, winrt::Windows::Storage::KnownFolderId const& folderId)
    {
        return impl::call_factory<KnownFolders, IKnownFoldersStatics3>([&](IKnownFoldersStatics3 const& f) { return f.GetFolderForUserAsync(user, folderId); });
    }
    inline auto KnownFolders::RequestAccessAsync(winrt::Windows::Storage::KnownFolderId const& folderId)
    {
        return impl::call_factory<KnownFolders, IKnownFoldersStatics4>([&](IKnownFoldersStatics4 const& f) { return f.RequestAccessAsync(folderId); });
    }
    inline auto KnownFolders::RequestAccessForUserAsync(winrt::Windows::System::User const& user, winrt::Windows::Storage::KnownFolderId const& folderId)
    {
        return impl::call_factory<KnownFolders, IKnownFoldersStatics4>([&](IKnownFoldersStatics4 const& f) { return f.RequestAccessForUserAsync(user, folderId); });
    }
    inline auto KnownFolders::GetFolderAsync(winrt::Windows::Storage::KnownFolderId const& folderId)
    {
        return impl::call_factory<KnownFolders, IKnownFoldersStatics4>([&](IKnownFoldersStatics4 const& f) { return f.GetFolderAsync(folderId); });
    }
    inline auto PathIO::ReadTextAsync(param::hstring const& absolutePath)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.ReadTextAsync(absolutePath); });
    }
    inline auto PathIO::ReadTextAsync(param::hstring const& absolutePath, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.ReadTextAsync(absolutePath, encoding); });
    }
    inline auto PathIO::WriteTextAsync(param::hstring const& absolutePath, param::hstring const& contents)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.WriteTextAsync(absolutePath, contents); });
    }
    inline auto PathIO::WriteTextAsync(param::hstring const& absolutePath, param::hstring const& contents, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.WriteTextAsync(absolutePath, contents, encoding); });
    }
    inline auto PathIO::AppendTextAsync(param::hstring const& absolutePath, param::hstring const& contents)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.AppendTextAsync(absolutePath, contents); });
    }
    inline auto PathIO::AppendTextAsync(param::hstring const& absolutePath, param::hstring const& contents, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.AppendTextAsync(absolutePath, contents, encoding); });
    }
    inline auto PathIO::ReadLinesAsync(param::hstring const& absolutePath)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.ReadLinesAsync(absolutePath); });
    }
    inline auto PathIO::ReadLinesAsync(param::hstring const& absolutePath, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.ReadLinesAsync(absolutePath, encoding); });
    }
    inline auto PathIO::WriteLinesAsync(param::hstring const& absolutePath, param::async_iterable<hstring> const& lines)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.WriteLinesAsync(absolutePath, lines); });
    }
    inline auto PathIO::WriteLinesAsync(param::hstring const& absolutePath, param::async_iterable<hstring> const& lines, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.WriteLinesAsync(absolutePath, lines, encoding); });
    }
    inline auto PathIO::AppendLinesAsync(param::hstring const& absolutePath, param::async_iterable<hstring> const& lines)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.AppendLinesAsync(absolutePath, lines); });
    }
    inline auto PathIO::AppendLinesAsync(param::hstring const& absolutePath, param::async_iterable<hstring> const& lines, winrt::Windows::Storage::Streams::UnicodeEncoding const& encoding)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.AppendLinesAsync(absolutePath, lines, encoding); });
    }
    inline auto PathIO::ReadBufferAsync(param::hstring const& absolutePath)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.ReadBufferAsync(absolutePath); });
    }
    inline auto PathIO::WriteBufferAsync(param::hstring const& absolutePath, winrt::Windows::Storage::Streams::IBuffer const& buffer)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.WriteBufferAsync(absolutePath, buffer); });
    }
    inline auto PathIO::WriteBytesAsync(param::hstring const& absolutePath, array_view<uint8_t const> buffer)
    {
        return impl::call_factory<PathIO, IPathIOStatics>([&](IPathIOStatics const& f) { return f.WriteBytesAsync(absolutePath, buffer); });
    }
    inline auto StorageFile::GetFileFromPathAsync(param::hstring const& path)
    {
        return impl::call_factory<StorageFile, IStorageFileStatics>([&](IStorageFileStatics const& f) { return f.GetFileFromPathAsync(path); });
    }
    inline auto StorageFile::GetFileFromApplicationUriAsync(winrt::Windows::Foundation::Uri const& uri)
    {
        return impl::call_factory<StorageFile, IStorageFileStatics>([&](IStorageFileStatics const& f) { return f.GetFileFromApplicationUriAsync(uri); });
    }
    inline auto StorageFile::CreateStreamedFileAsync(param::hstring const& displayNameWithExtension, winrt::Windows::Storage::StreamedFileDataRequestedHandler const& dataRequested, winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& thumbnail)
    {
        return impl::call_factory<StorageFile, IStorageFileStatics>([&](IStorageFileStatics const& f) { return f.CreateStreamedFileAsync(displayNameWithExtension, dataRequested, thumbnail); });
    }
    inline auto StorageFile::ReplaceWithStreamedFileAsync(winrt::Windows::Storage::IStorageFile const& fileToReplace, winrt::Windows::Storage::StreamedFileDataRequestedHandler const& dataRequested, winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& thumbnail)
    {
        return impl::call_factory<StorageFile, IStorageFileStatics>([&](IStorageFileStatics const& f) { return f.ReplaceWithStreamedFileAsync(fileToReplace, dataRequested, thumbnail); });
    }
    inline auto StorageFile::CreateStreamedFileFromUriAsync(param::hstring const& displayNameWithExtension, winrt::Windows::Foundation::Uri const& uri, winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& thumbnail)
    {
        return impl::call_factory<StorageFile, IStorageFileStatics>([&](IStorageFileStatics const& f) { return f.CreateStreamedFileFromUriAsync(displayNameWithExtension, uri, thumbnail); });
    }
    inline auto StorageFile::ReplaceWithStreamedFileFromUriAsync(winrt::Windows::Storage::IStorageFile const& fileToReplace, winrt::Windows::Foundation::Uri const& uri, winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& thumbnail)
    {
        return impl::call_factory<StorageFile, IStorageFileStatics>([&](IStorageFileStatics const& f) { return f.ReplaceWithStreamedFileFromUriAsync(fileToReplace, uri, thumbnail); });
    }
    inline auto StorageFile::GetFileFromPathForUserAsync(winrt::Windows::System::User const& user, param::hstring const& path)
    {
        return impl::call_factory<StorageFile, IStorageFileStatics2>([&](IStorageFileStatics2 const& f) { return f.GetFileFromPathForUserAsync(user, path); });
    }
    inline auto StorageFolder::GetFolderFromPathAsync(param::hstring const& path)
    {
        return impl::call_factory<StorageFolder, IStorageFolderStatics>([&](IStorageFolderStatics const& f) { return f.GetFolderFromPathAsync(path); });
    }
    inline auto StorageFolder::GetFolderFromPathForUserAsync(winrt::Windows::System::User const& user, param::hstring const& path)
    {
        return impl::call_factory<StorageFolder, IStorageFolderStatics2>([&](IStorageFolderStatics2 const& f) { return f.GetFolderFromPathForUserAsync(user, path); });
    }
    inline auto StorageLibrary::GetLibraryAsync(winrt::Windows::Storage::KnownLibraryId const& libraryId)
    {
        return impl::call_factory<StorageLibrary, IStorageLibraryStatics>([&](IStorageLibraryStatics const& f) { return f.GetLibraryAsync(libraryId); });
    }
    inline auto StorageLibrary::GetLibraryForUserAsync(winrt::Windows::System::User const& user, winrt::Windows::Storage::KnownLibraryId const& libraryId)
    {
        return impl::call_factory<StorageLibrary, IStorageLibraryStatics2>([&](IStorageLibraryStatics2 const& f) { return f.GetLibraryForUserAsync(user, libraryId); });
    }
    inline StorageLibraryChangeTrackerOptions::StorageLibraryChangeTrackerOptions() :
        StorageLibraryChangeTrackerOptions(impl::call_factory_cast<StorageLibraryChangeTrackerOptions(*)(winrt::Windows::Foundation::IActivationFactory const&), StorageLibraryChangeTrackerOptions>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<StorageLibraryChangeTrackerOptions>(); }))
    {
    }
    inline auto StorageLibraryLastChangeId::Unknown()
    {
        return impl::call_factory_cast<uint64_t(*)(IStorageLibraryLastChangeIdStatics const&), StorageLibraryLastChangeId, IStorageLibraryLastChangeIdStatics>([](IStorageLibraryLastChangeIdStatics const& f) { return f.Unknown(); });
    }
    inline auto SystemDataPaths::GetDefault()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::SystemDataPaths(*)(ISystemDataPathsStatics const&), SystemDataPaths, ISystemDataPathsStatics>([](ISystemDataPathsStatics const& f) { return f.GetDefault(); });
    }
    inline auto SystemProperties::Author()
    {
        return impl::call_factory_cast<hstring(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Author(); });
    }
    inline auto SystemProperties::Comment()
    {
        return impl::call_factory_cast<hstring(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Comment(); });
    }
    inline auto SystemProperties::ItemNameDisplay()
    {
        return impl::call_factory_cast<hstring(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.ItemNameDisplay(); });
    }
    inline auto SystemProperties::Keywords()
    {
        return impl::call_factory_cast<hstring(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Keywords(); });
    }
    inline auto SystemProperties::Rating()
    {
        return impl::call_factory_cast<hstring(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Rating(); });
    }
    inline auto SystemProperties::Title()
    {
        return impl::call_factory_cast<hstring(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Title(); });
    }
    inline auto SystemProperties::Audio()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::SystemAudioProperties(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Audio(); });
    }
    inline auto SystemProperties::GPS()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::SystemGPSProperties(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.GPS(); });
    }
    inline auto SystemProperties::Media()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::SystemMediaProperties(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Media(); });
    }
    inline auto SystemProperties::Music()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::SystemMusicProperties(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Music(); });
    }
    inline auto SystemProperties::Photo()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::SystemPhotoProperties(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Photo(); });
    }
    inline auto SystemProperties::Video()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::SystemVideoProperties(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Video(); });
    }
    inline auto SystemProperties::Image()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::SystemImageProperties(*)(ISystemProperties const&), SystemProperties, ISystemProperties>([](ISystemProperties const& f) { return f.Image(); });
    }
    inline auto UserDataPaths::GetForUser(winrt::Windows::System::User const& user)
    {
        return impl::call_factory<UserDataPaths, IUserDataPathsStatics>([&](IUserDataPathsStatics const& f) { return f.GetForUser(user); });
    }
    inline auto UserDataPaths::GetDefault()
    {
        return impl::call_factory_cast<winrt::Windows::Storage::UserDataPaths(*)(IUserDataPathsStatics const&), UserDataPaths, IUserDataPathsStatics>([](IUserDataPathsStatics const& f) { return f.GetDefault(); });
    }
    template <typename L> ApplicationDataSetVersionHandler::ApplicationDataSetVersionHandler(L handler) :
        ApplicationDataSetVersionHandler(impl::make_delegate<ApplicationDataSetVersionHandler>(std::forward<L>(handler)))
    {
    }
    template <typename F> ApplicationDataSetVersionHandler::ApplicationDataSetVersionHandler(F* handler) :
        ApplicationDataSetVersionHandler([=](auto&&... args) { return handler(args...); })
    {
    }
    template <typename O, typename M> ApplicationDataSetVersionHandler::ApplicationDataSetVersionHandler(O* object, M method) :
        ApplicationDataSetVersionHandler([=](auto&&... args) { return ((*object).*(method))(args...); })
    {
    }
    template <typename O, typename M> ApplicationDataSetVersionHandler::ApplicationDataSetVersionHandler(com_ptr<O>&& object, M method) :
        ApplicationDataSetVersionHandler([o = std::move(object), method](auto&&... args) { return ((*o).*(method))(args...); })
    {
    }
    template <typename O, typename LM> ApplicationDataSetVersionHandler::ApplicationDataSetVersionHandler(weak_ref<O>&& object, LM&& lambda_or_method) :
        ApplicationDataSetVersionHandler([o = std::move(object), lm = std::forward<LM>(lambda_or_method)](auto&&... args) { if (auto s = o.get()) {
            if constexpr (std::is_member_function_pointer_v<LM>) ((*s).*(lm))(args...);
            else lm(args...);
        } })
    {
    }
    template <typename O, typename M> ApplicationDataSetVersionHandler::ApplicationDataSetVersionHandler(std::shared_ptr<O>&& object, M method) :
        ApplicationDataSetVersionHandler([o = std::move(object), method](auto&&... args) { return ((*o).*(method))(args...); })
    {
    }
    template <typename O, typename LM> ApplicationDataSetVersionHandler::ApplicationDataSetVersionHandler(std::weak_ptr<O>&& object, LM&& lambda_or_method) :
        ApplicationDataSetVersionHandler([o = std::move(object), lm = std::forward<LM>(lambda_or_method)](auto&&... args) { if (auto s = o.lock()) {
            if constexpr (std::is_member_function_pointer_v<LM>) ((*s).*(lm))(args...);
            else lm(args...);
        } })
    {
    }
    inline auto ApplicationDataSetVersionHandler::operator()(winrt::Windows::Storage::SetVersionRequest const& setVersionRequest) const
    {
        check_hresult((*(impl::abi_t<ApplicationDataSetVersionHandler>**)this)->Invoke(*(void**)(&setVersionRequest)));
    }
    template <typename L> StreamedFileDataRequestedHandler::StreamedFileDataRequestedHandler(L handler) :
        StreamedFileDataRequestedHandler(impl::make_delegate<StreamedFileDataRequestedHandler>(std::forward<L>(handler)))
    {
    }
    template <typename F> StreamedFileDataRequestedHandler::StreamedFileDataRequestedHandler(F* handler) :
        StreamedFileDataRequestedHandler([=](auto&&... args) { return handler(args...); })
    {
    }
    template <typename O, typename M> StreamedFileDataRequestedHandler::StreamedFileDataRequestedHandler(O* object, M method) :
        StreamedFileDataRequestedHandler([=](auto&&... args) { return ((*object).*(method))(args...); })
    {
    }
    template <typename O, typename M> StreamedFileDataRequestedHandler::StreamedFileDataRequestedHandler(com_ptr<O>&& object, M method) :
        StreamedFileDataRequestedHandler([o = std::move(object), method](auto&&... args) { return ((*o).*(method))(args...); })
    {
    }
    template <typename O, typename LM> StreamedFileDataRequestedHandler::StreamedFileDataRequestedHandler(weak_ref<O>&& object, LM&& lambda_or_method) :
        StreamedFileDataRequestedHandler([o = std::move(object), lm = std::forward<LM>(lambda_or_method)](auto&&... args) { if (auto s = o.get()) {
            if constexpr (std::is_member_function_pointer_v<LM>) ((*s).*(lm))(args...);
            else lm(args...);
        } })
    {
    }
    template <typename O, typename M> StreamedFileDataRequestedHandler::StreamedFileDataRequestedHandler(std::shared_ptr<O>&& object, M method) :
        StreamedFileDataRequestedHandler([o = std::move(object), method](auto&&... args) { return ((*o).*(method))(args...); })
    {
    }
    template <typename O, typename LM> StreamedFileDataRequestedHandler::StreamedFileDataRequestedHandler(std::weak_ptr<O>&& object, LM&& lambda_or_method) :
        StreamedFileDataRequestedHandler([o = std::move(object), lm = std::forward<LM>(lambda_or_method)](auto&&... args) { if (auto s = o.lock()) {
            if constexpr (std::is_member_function_pointer_v<LM>) ((*s).*(lm))(args...);
            else lm(args...);
        } })
    {
    }
    inline auto StreamedFileDataRequestedHandler::operator()(winrt::Windows::Storage::StreamedFileDataRequest const& stream) const
    {
        check_hresult((*(impl::abi_t<StreamedFileDataRequestedHandler>**)this)->Invoke(*(void**)(&stream)));
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Storage::IAppDataPaths> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IAppDataPathsStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IApplicationData> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IApplicationData2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IApplicationData3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IApplicationDataContainer> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IApplicationDataStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IApplicationDataStatics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ICachedFileManagerStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IDownloadsFolderStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IDownloadsFolderStatics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IFileIOStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IKnownFoldersCameraRollStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IKnownFoldersPlaylistsStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IKnownFoldersSavedPicturesStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IKnownFoldersStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IKnownFoldersStatics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IKnownFoldersStatics3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IKnownFoldersStatics4> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IPathIOStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISetVersionDeferral> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISetVersionRequest> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageFile> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageFile2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageFilePropertiesWithAvailability> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageFileStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageFileStatics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageFolder> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageFolder2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageFolder3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageFolderStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageFolderStatics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageItem> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageItem2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageItemProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageItemProperties2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageItemPropertiesWithProvider> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibrary> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibrary2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibrary3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibraryChange> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibraryChangeReader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibraryChangeReader2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibraryChangeTracker> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibraryChangeTracker2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibraryChangeTrackerOptions> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibraryLastChangeId> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibraryLastChangeIdStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibraryStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageLibraryStatics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageProvider> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageProvider2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStorageStreamTransaction> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IStreamedFileDataRequest> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISystemAudioProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISystemDataPaths> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISystemDataPathsStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISystemGPSProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISystemImageProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISystemMediaProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISystemMusicProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISystemPhotoProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISystemProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ISystemVideoProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IUserDataPaths> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::IUserDataPathsStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::AppDataPaths> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ApplicationData> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ApplicationDataCompositeValue> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ApplicationDataContainer> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::ApplicationDataContainerSettings> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::CachedFileManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::DownloadsFolder> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::FileIO> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::KnownFolders> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::PathIO> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SetVersionDeferral> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SetVersionRequest> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StorageFile> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StorageFolder> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StorageLibrary> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StorageLibraryChange> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StorageLibraryChangeReader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StorageLibraryChangeTracker> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StorageLibraryChangeTrackerOptions> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StorageLibraryLastChangeId> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StorageProvider> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StorageStreamTransaction> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::StreamedFileDataRequest> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SystemAudioProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SystemDataPaths> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SystemGPSProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SystemImageProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SystemMediaProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SystemMusicProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SystemPhotoProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SystemProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::SystemVideoProperties> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::UserDataPaths> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
