/*
 * Copyright 2020-2021,2024 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */
#ifndef TFM_PARTITION_LOADER_SERVICE
#include "fsl_loader_utils.h"

//! @addtogroup sbloader
//! @{

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototype
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Codes
 ******************************************************************************/
////////////////////////////////////////////////////////////////////////////
//! @brief fw download
////////////////////////////////////////////////////////////////////////////
status_t sb3_fw_download(LOAD_Target_Type loadTarget, uint32_t flag, uint32_t sourceAddr)
{
    return sb3_fw_download_impl(loadTarget,flag,sourceAddr);
}

////////////////////////////////////////////////////////////////////////////
//! @brief fw reset
////////////////////////////////////////////////////////////////////////////
status_t sb3_fw_reset(LOAD_Target_Type loadTarget, uint32_t flag, uint32_t sourceAddr)
{
    return sb3_fw_reset_impl(loadTarget, flag, sourceAddr);
}

////////////////////////////////////////////////////////////////////////////
//! @brief power on device
////////////////////////////////////////////////////////////////////////////
void power_on_device(LOAD_Target_Type loadTarget)
{
    power_on_device_impl(loadTarget);
}

////////////////////////////////////////////////////////////////////////////
//! @brief power off device
////////////////////////////////////////////////////////////////////////////
void power_off_device(LOAD_Target_Type loadTarget)
{
    power_off_device_impl(loadTarget);
}
//! @}
////////////////////////////////////////////////////////////////////////////
// EOF
////////////////////////////////////////////////////////////////////////////
#endif /* TFM_PARTITION_LOADER_SERVICE */