' uBasic - The Fastest Horses - Copyright 2021 J.L. Bezemer
' You can redistribute this file and/or modify it under
' the terms of the GNU General Public License

' Pick the three FASTEST horses - no clocks allowed!
' Maximum 5 horses per race.

' We measure time - but we won't select them that way!
' It is there for you to check and for us to determine the position.

' See: https://www.youtube.com/watch?v=i-xqRDwpilM

                                       ' we will name our horses
Push Dup("Bella"), Dup("Alex"), Dup("Lilly"), Dup("Alexia"), Dup("Fancy")
Push Dup("Sugar"), Dup("Lady"), Dup("Tucker"), Dup("Dakota"), Dup("Cash")
Push Dup("Daisy"), Dup("Spirit"), Dup("Cisco"), Dup("Annie"), Dup("Buddy")
Push Dup("Whiskey"), Dup("Chance"), Dup("Blue"), Dup("Molly"), Dup("Ginger")
Push Dup("Gypsy"), Dup("Charlie"), Dup("Ranger"), Dup("Star"), Dup("Willow")

Dim @n(25)                             ' array with names
Dim @r(25)                             ' array with races
Dim @t(25)                             ' array with times
Dim @p(25)                             ' array with positions
Dim @w(25)                             ' array with winners

For x = 0 To 24
  @n(x) = Pop()                        ' set a name
  @r(x) = 0                            ' set a race
  @t(x) = 0                            ' set a time
  @p(x) = 0                            ' set a position
  @w(x) = 0                            ' only for winners
Next

For x = 1 To 5                         ' we got five races
  For r = 1 Until r > 5                ' we got five horses
    If @r(Set(z, Rnd(25))) = 0 Then @r(z) = r : r=r+1
  Next                                 ' assign them randomly
Next

For r = 1 To 5                         ' ok, let them run
  Print "This is race number ";r;"! Starting are:"
  For x = 0 To 24
    If @r(x) = r Then                  ' if horse is participating
       Print "* ";Show (@n(x))         ' show its name
       @t(x) = 4000 + Rnd(2000)        ' and decide its time
    EndIf
  Next

  Print: Proc _Race (r): Print
Next                                   ' next race
                                       ' ok, half final
Print "This is the half final! Starting are:"

For x = 0 To 24                        ' scan all horses
  If @p(x) = 1 Then                    ' if horse is a winner
     @w(x) = @r(x)                     ' save the old race for later
     @r(x) = 6                         ' this horse is participating
     @p(x) = 0                         ' but position is unknown
     Print "* ";Show (@n(x))           ' show its name
  EndIf
Next

Print: Proc _Race (6): Print

For x = 0 To 24                        ' first three from half final
   If (@r(x) = 6) * (@p(x) < 4) Then
      If @p(x) > 1 Then                ' position two or three?
        If @p(x) = 2 Then              ' if second position in half final
            For y = 0 To 24            ' get the second position from 1st race
              If (@w(x) = @r(y)) * (@p(y) = 2) Then
                @r(y) = 7
                @p(y) = 0
                Break
              EndIf
            Next
        EndIf
        @r(x) = 7                      ' second and third position from
        @p(x) = 0                      ' half final are in as well
      Else
        For y = 0 To 24                ' winner of the half final
          If (@w(x) = @r(y)) * ((@p(y) = 2) + (@p(y) = 3)) Then
             @r(y) = 7                 ' get second and third from 1st race
             @p(y) = 0
          EndIf
        Next
      EndIf
   EndIf
Next
                                       ' let's see what we got
Print "This is the final! Starting are:"
For x = 0 To 24
  If @r(x) = 7 Then Print "* ";Show (@n(x))
Next

Print: Proc _Race (7): Print           ' evaluate the winner

For x = 0 To 24                        ' which are the fastest horses
  If (@r(x) = 6) * (@p(x) = 1) Then
     Print Show (@n(x));Tab(8);"is the fastest horse"
  EndIf                                ' winner of the half final

  If (@r(x) = 7) * (@p(x) = 1) Then
     Print Show (@n(x));Tab(8);"is the second fastest horse"
  EndIf                                ' winner of the final

  If (@r(x) = 7) * (@p(x) = 2) Then
     Print Show (@n(x));Tab(8);"is the third fastest horse"
  EndIf                                ' 2nd place final
Next

End

_Race Param(1)                         ' input: the race
  Local(4)

  For b@ = 1 To 5                      ' determine all 5 positions
    c@ = 6000                          ' reset the time

    For d@ = 0 To 24                   ' test all horses
      If @r(d@) = a@ Then              ' is a horse participating?
         If (@t(d@) < c@) Then         ' is it faster than the time given?
            If @p(d@) = 0 Then         ' is its position still open?
               c@ = @t(d@)             ' then we found the fastest time
               e@ = d@                 ' and this is a candidate for that
            EndIf                      ' particular position
         EndIf
      EndIf
    Next

    @p(e@) = b@                        ' definitely set the position
    Print b@;": ";Show (@n(e@));Tab(10);Using " in ##.## secs";@t(e@)
  Next
Return

