;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-opt -all --closed-world --preserve-type-order \
;; RUN:     --type-refining -S -o - | filecheck %s

;; Reference fields accessed by RMW ops can be optimized.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $null (shared (struct (field (mut (ref null (shared none)))))))
    (type $null (shared (struct (field (mut (ref null (shared any)))))))

    ;; CHECK:       (type $i31 (shared (struct (field (mut (ref (shared i31)))))))
    (type $i31 (shared (struct (field (mut (ref null (shared any)))))))

    ;; CHECK:       (type $super (sub (shared (struct (field (mut (ref $sub)))))))
    (type $super (sub (shared (struct (field (mut (ref null $super)))))))

    ;; CHECK:       (type $sub (sub $super (shared (struct (field (mut (ref $sub)))))))
    (type $sub (sub $super (shared (struct (field (mut (ref null $super)))))))
  )

  ;; CHECK:       (type $4 (func (param (ref $null)) (result (ref null (shared any)))))

  ;; CHECK:       (type $5 (func (param (ref $i31)) (result (ref null (shared any)))))

  ;; CHECK:       (type $6 (func (param (ref $sub)) (result (ref null $super))))

  ;; CHECK:      (func $xchg-null (type $4) (param $0 (ref $null)) (result (ref null (shared any)))
  ;; CHECK-NEXT:  (struct.atomic.rmw.xchg $null 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (ref.null (shared none))
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $xchg-null (param (ref $null)) (result (ref null (shared any)))
    (struct.atomic.rmw.xchg $null 0
      (local.get 0)
      (ref.null (shared none))
    )
  )

  ;; CHECK:      (func $xchg-i31 (type $5) (param $0 (ref $i31)) (result (ref null (shared any)))
  ;; CHECK-NEXT:  (struct.atomic.rmw.xchg acqrel acqrel $i31 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (ref.i31_shared
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $xchg-i31 (param (ref $i31)) (result (ref null (shared any)))
    ;; Acqrel ordering shouldn't make a difference.
    (struct.atomic.rmw.xchg acqrel acqrel $i31 0
      (local.get 0)
      (ref.i31_shared
        (i32.const 1)
      )
    )
  )

  ;; CHECK:      (func $xchg-self (type $6) (param $0 (ref $sub)) (result (ref null $super))
  ;; CHECK-NEXT:  (struct.atomic.rmw.xchg $sub 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $xchg-self (param (ref $sub)) (result (ref null $super))
    (struct.atomic.rmw.xchg $sub 0
      (local.get 0)
      (local.get 0)
    )
  )
)

;; Cmpxchg works as well. Note that the field can be more refined than the
;; "expected" operand.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $null (shared (struct (field (mut (ref null (shared none)))))))
    (type $null (shared (struct (field (mut (ref null (shared eq)))))))

    ;; CHECK:       (type $i31 (shared (struct (field (mut (ref (shared i31)))))))
    (type $i31 (shared (struct (field (mut (ref null (shared eq)))))))

    ;; CHECK:       (type $super (sub (shared (struct (field (mut (ref $sub)))))))
    (type $super (sub (shared (struct (field (mut (ref null $super)))))))

    ;; CHECK:       (type $sub (sub $super (shared (struct (field (mut (ref $sub)))))))
    (type $sub (sub $super (shared (struct (field (mut (ref null $super)))))))
  )

  ;; CHECK:       (type $4 (func (param (ref $null) (ref (shared eq))) (result (ref null (shared any)))))

  ;; CHECK:       (type $5 (func (param (ref $i31) (ref (shared eq))) (result (ref null (shared any)))))

  ;; CHECK:       (type $6 (func (param (ref $sub) (ref (shared eq))) (result (ref null $super))))

  ;; CHECK:      (func $cmpxchg-null (type $4) (param $0 (ref $null)) (param $1 (ref (shared eq))) (result (ref null (shared any)))
  ;; CHECK-NEXT:  (struct.atomic.rmw.cmpxchg $null 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (ref.null (shared none))
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-null (param (ref $null) (ref (shared eq))) (result (ref null (shared any)))
    (struct.atomic.rmw.cmpxchg $null 0
      (local.get 0)
      (local.get 1)
      (ref.null (shared none))
    )
  )

  ;; CHECK:      (func $cmpxchg-i31 (type $5) (param $0 (ref $i31)) (param $1 (ref (shared eq))) (result (ref null (shared any)))
  ;; CHECK-NEXT:  (struct.atomic.rmw.cmpxchg acqrel acqrel $i31 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (ref.i31_shared
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-i31 (param (ref $i31) (ref (shared eq))) (result (ref null (shared any)))
    ;; Acqrel ordering shouldn't make a difference.
    (struct.atomic.rmw.cmpxchg acqrel acqrel $i31 0
      (local.get 0)
      (local.get 1)
      (ref.i31_shared
        (i32.const 1)
      )
    )
  )

  ;; CHECK:      (func $cmpxchg-self (type $6) (param $0 (ref $sub)) (param $1 (ref (shared eq))) (result (ref null $super))
  ;; CHECK-NEXT:  (struct.atomic.rmw.cmpxchg $sub 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-self (param (ref $sub) (ref (shared eq))) (result (ref null $super))
    (struct.atomic.rmw.cmpxchg $sub 0
      (local.get 0)
      (local.get 1)
      (local.get 0)
    )
  )
)

;; Non-reference fields should not cause problems.
(module
  ;; CHECK:      (type $A (shared (struct (field (mut i32)))))
  (type $A (shared (struct (field (mut i32)))))

  ;; CHECK:      (type $1 (func (param (ref $A)) (result i32)))

  ;; CHECK:      (type $2 (func (param (ref $A) i32) (result i32)))

  ;; CHECK:      (func $rmw (type $1) (param $0 (ref $A)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.add $A 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw (param (ref $A)) (result i32)
    (struct.atomic.rmw.add $A 0
      (local.get 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $cmpxchg (type $2) (param $0 (ref $A)) (param $1 i32) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.cmpxchg $A 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg (param (ref $A) i32) (result i32)
    (struct.atomic.rmw.cmpxchg $A 0
      (local.get 0)
      (local.get 1)
      (i32.const 1)
    )
  )
)
