;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt -all --closed-world --gto --preserve-type-order -S -o - | filecheck %s

(module
  (rec
    ;; We can optimize out the externref field on the struct because it is never
    ;; used.
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $struct (descriptor $desc) (struct))
    (type $struct (descriptor $desc) (struct (field externref)))
    ;; The externef field on the descriptor is visible from JS because it holds
    ;; the prototype, so we cannot remove it.
    ;; CHECK:       (type $desc (describes $struct) (struct (field externref)))
    (type $desc (describes $struct) (struct (field externref)))
  )
  ;; CHECK:       (type $2 (func))

  ;; CHECK:       (type $3 (func (result (ref $struct))))

  ;; CHECK:      (type $prototypes (array (mut externref)))
  (type $prototypes (array (mut externref)))
  ;; CHECK:      (type $funcs (array (mut funcref)))
  (type $funcs (array (mut funcref)))
  ;; CHECK:      (type $data (array (mut i8)))
  (type $data (array (mut i8)))
  ;; CHECK:      (type $configureAll (func (param (ref null $prototypes) (ref null $funcs) (ref null $data) externref)))
  (type $configureAll (func (param (ref null $prototypes)) (param (ref null $funcs)) (param (ref null $data)) (param externref)))

  ;; CHECK:      (import "wasm:js-prototypes" "configureAll" (func $configureAll (type $configureAll) (param (ref null $prototypes) (ref null $funcs) (ref null $data) externref)))
  (import "wasm:js-prototypes" "configureAll" (func $configureAll (type $configureAll)))

  ;; CHECK:      (data $data "12345678")
  (data $data "12345678")

  ;; CHECK:      (elem $prototypes externref (item (ref.null noextern)))
  (elem $prototypes externref (ref.null extern))

  ;; CHECK:      (elem $funcs func $return-struct)
  (elem $funcs funcref (ref.func $return-struct))

  ;; CHECK:      (start $start)
  (start $start)

  ;; CHECK:      (func $start (type $2)
  ;; CHECK-NEXT:  (call $configureAll
  ;; CHECK-NEXT:   (array.new_elem $prototypes $prototypes
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (array.new_elem $funcs $funcs
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (array.new_data $data $data
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (ref.null noextern)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $start
    (call $configureAll
      (array.new_elem $prototypes $prototypes (i32.const 0) (i32.const 1))
      (array.new_elem $funcs $funcs (i32.const 0) (i32.const 1))
      (array.new_data $data $data (i32.const 0) (i32.const 8))
      (ref.null extern)
    )
  )

  ;; CHECK:      (func $return-struct (type $3) (result (ref $struct))
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $return-struct (result (ref $struct))
    ;; It doesn't matter that the function does not actually return a struct; we
    ;; just look at the signature.
    (unreachable)
  )
)

(module
  (rec
    ;; We can optimize out the externref field on the field because it is never
    ;; used.
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $struct (descriptor $desc) (struct))
    (type $struct (descriptor $desc) (struct (field externref)))
    ;; The externef field on the descriptor is visible from JS because it holds
    ;; the prototype, so we cannot remove it.
    ;; CHECK:       (type $desc (describes $struct) (struct (field externref)))
    (type $desc (describes $struct) (struct (field externref)))
  )

  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (func $externalize (type $2)
  ;; CHECK-NEXT:  (local $struct (ref null $struct))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (extern.convert_any
  ;; CHECK-NEXT:    (local.get $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $externalize
    (local $struct (ref null $struct))
    ;; Externalizing a reference may in general make it available to JS and
    ;; and force us to keep fields holding exposed prototypes.
    (drop
      (extern.convert_any
        (local.get $struct)
      )
    )
  )
)

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $struct (descriptor $desc) (struct))
    (type $struct (descriptor $desc) (struct))
    ;; Non-nullable extern refs can also hold prototypes.
    ;; CHECK:       (type $desc (describes $struct) (struct (field (ref extern))))
    (type $desc (describes $struct) (struct (field (ref extern))))
  )

  ;; CHECK:      (type $2 (func))

  ;; CHECK:      (func $externalize (type $2)
  ;; CHECK-NEXT:  (local $struct (ref null $struct))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (extern.convert_any
  ;; CHECK-NEXT:    (local.get $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $externalize
    (local $struct (ref null $struct))
    (drop
      (extern.convert_any
        (local.get $struct)
      )
    )
  )
)


(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $struct (descriptor $desc) (struct))
    (type $struct (descriptor $desc) (struct))
    ;; Only externref fields can hold prototypes. We can optimize out e.g.
    ;; anyref fields.
    ;; CHECK:       (type $desc (describes $struct) (struct))
    (type $desc (describes $struct) (struct (field anyref)))
  )

  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (func $externalize (type $2)
  ;; CHECK-NEXT:  (local $struct (ref null $struct))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (extern.convert_any
  ;; CHECK-NEXT:    (local.get $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $externalize
    (local $struct (ref null $struct))
    (drop
      (extern.convert_any
        (local.get $struct)
      )
    )
  )
)

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $struct (descriptor $desc) (struct))
    (type $struct (descriptor $desc) (struct))
    ;; Bottom externrefs can only hold null prototypes, but that's the default
    ;; prototype value anyway, so we can still optimize them out.
    ;; CHECK:       (type $desc (describes $struct) (struct))
    (type $desc (describes $struct) (struct (field nullexternref)))
  )

  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (func $externalize (type $2)
  ;; CHECK-NEXT:  (local $struct (ref null $struct))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (extern.convert_any
  ;; CHECK-NEXT:    (local.get $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $externalize
    (local $struct (ref null $struct))
    (drop
      (extern.convert_any
        (local.get $struct)
      )
    )
  )
)

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $struct (descriptor $desc) (struct))
    (type $struct (descriptor $desc) (struct))
    ;; Mutable fields cannot hold exposed prototypes, so they can be optimized
    ;; normally.
    ;; CHECK:       (type $desc (describes $struct) (struct))
    (type $desc (describes $struct) (struct (field (mut externref))))
  )

  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (func $externalize (type $2)
  ;; CHECK-NEXT:  (local $struct (ref null $struct))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (extern.convert_any
  ;; CHECK-NEXT:    (local.get $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $externalize
    (local $struct (ref null $struct))
    (drop
      (extern.convert_any
        (local.get $struct)
      )
    )
  )
)
