/* SPDX-FileCopyrightText: 2011-2022 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

/** \defgroup intern Internal libraries
 *  \section internabout Internal libraries
 *  Blender comes with some of its dependencies
 *  directly included in the codebase. Libraries
 *  that are in the \c intern/ folder are maintained
 *  as part of the normal development process.
 */

/* TODO: other modules.
 * - `libmv`
 * - `cycles`
 * - `opencolorio`
 * - `opensubdiv`
 * - `openvdb`
 * - `quadriflow`
 */

/** \defgroup intern_atomic Atomic Operations
 *  \ingroup intern */

/** \defgroup intern_clog C-Logging (CLOG)
 *  \ingroup intern */

/** \defgroup intern_eigen Eigen
 *  \ingroup intern */

/** \defgroup intern_glew-mx GLEW with Multiple Rendering Context's
 *  \ingroup intern */

/** \defgroup intern_iksolver Inverse Kinematics (Solver)
 *  \ingroup intern */

/** \defgroup intern_itasc Inverse Kinematics (ITASC)
 *  \ingroup intern */

/** \defgroup intern_libc_compat libc Compatibility For Linux
 *  \ingroup intern */

/** \defgroup intern_locale Locale
 *  \ingroup intern */

/** \defgroup intern_mantaflow Manta-Flow Fluid Simulation
 *  \ingroup intern */

/** \defgroup intern_mem Guarded Memory (de)allocation
 *  \ingroup intern */

/** \defgroup intern_memutil Memory Utilities (memutil)
 *  \ingroup intern */

/** \defgroup intern_mikktspace MikktSpace
 *  \ingroup intern */

/** \defgroup intern_rigidbody Rigid-Body C-API
 *  \ingroup intern */

/** \defgroup intern_sky_model Sky Model
 *  \ingroup intern */

/** \defgroup intern_slim SLIM Solver for UV Unwrapping
 *  \ingroup intern */

/** \defgroup intern_utf_conv UTF8/UTF16 Conversion (utfconv)
 *  \ingroup intern */

/** \defgroup audaspace Audaspace
 *  \ingroup intern undoc
 *  \todo add to doxygen */
/** \defgroup audcoreaudio Audaspace CoreAudio
 *  \ingroup audaspace */
/** \defgroup audfx Audaspace FX
 *  \ingroup audaspace */
/** \defgroup audopenal Audaspace OpenAL
 *  \ingroup audaspace */
/** \defgroup audpulseaudio Audaspace PulseAudio
 *  \ingroup audaspace */
/** \defgroup audwasapi Audaspace WASAPI
 *  \ingroup audaspace */
/** \defgroup audpython Audaspace Python
 *  \ingroup audaspace */
/** \defgroup audsdl Audaspace SDL
 *  \ingroup audaspace */
/** \defgroup audsrc Audaspace SRC
 *  \ingroup audaspace */
/** \defgroup audffmpeg Audaspace FFMpeg
 *  \ingroup audaspace */
/** \defgroup audfftw Audaspace FFTW
 *  \ingroup audaspace */
/** \defgroup audjack Audaspace Jack
 *  \ingroup audaspace */
/** \defgroup audsndfile Audaspace sndfile
 *  \ingroup audaspace */

/** \defgroup GHOST GHOST API
 * \ingroup intern GUI
 * \ref GHOSTPage
 */
