// Code generated by generous; DO NOT EDIT.

package messages

import (
	"encoding/json"
	"github.com/pkg/errors"

	"github.com/itchio/butler/butlerd"
	"github.com/itchio/butler/butlerd/jsonrpc2"
)

type router interface {
  Register(method string, hf butlerd.RequestHandler)
  RegisterNotification(method string, nf butlerd.NotificationHandler)
}


//==============================
// Utilities
//==============================

// Meta.Authenticate (Request)

type MetaAuthenticateType struct {}

var _ RequestMessage = (*MetaAuthenticateType)(nil)

func (r *MetaAuthenticateType) Method() string {
  return "Meta.Authenticate"
}

func (r *MetaAuthenticateType) Register(router router, f func(*butlerd.RequestContext, butlerd.MetaAuthenticateParams) (*butlerd.MetaAuthenticateResult, error)) {
  router.Register("Meta.Authenticate", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.MetaAuthenticateParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Meta.Authenticate")
    }
    return res, nil
  })
}

func (r *MetaAuthenticateType) TestCall(rc *butlerd.RequestContext, params butlerd.MetaAuthenticateParams) (*butlerd.MetaAuthenticateResult, error) {
  var result butlerd.MetaAuthenticateResult
  err := rc.Call("Meta.Authenticate", params, &result)
  return &result, err
}

var MetaAuthenticate *MetaAuthenticateType

// Meta.Flow (Request)

type MetaFlowType struct {}

var _ RequestMessage = (*MetaFlowType)(nil)

func (r *MetaFlowType) Method() string {
  return "Meta.Flow"
}

func (r *MetaFlowType) Register(router router, f func(*butlerd.RequestContext, butlerd.MetaFlowParams) (*butlerd.MetaFlowResult, error)) {
  router.Register("Meta.Flow", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.MetaFlowParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Meta.Flow")
    }
    return res, nil
  })
}

func (r *MetaFlowType) TestCall(rc *butlerd.RequestContext, params butlerd.MetaFlowParams) (*butlerd.MetaFlowResult, error) {
  var result butlerd.MetaFlowResult
  err := rc.Call("Meta.Flow", params, &result)
  return &result, err
}

var MetaFlow *MetaFlowType

// Meta.Shutdown (Request)

type MetaShutdownType struct {}

var _ RequestMessage = (*MetaShutdownType)(nil)

func (r *MetaShutdownType) Method() string {
  return "Meta.Shutdown"
}

func (r *MetaShutdownType) Register(router router, f func(*butlerd.RequestContext, butlerd.MetaShutdownParams) (*butlerd.MetaShutdownResult, error)) {
  router.Register("Meta.Shutdown", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.MetaShutdownParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Meta.Shutdown")
    }
    return res, nil
  })
}

func (r *MetaShutdownType) TestCall(rc *butlerd.RequestContext, params butlerd.MetaShutdownParams) (*butlerd.MetaShutdownResult, error) {
  var result butlerd.MetaShutdownResult
  err := rc.Call("Meta.Shutdown", params, &result)
  return &result, err
}

var MetaShutdown *MetaShutdownType

// MetaFlowEstablished (Notification)

type MetaFlowEstablishedType struct {}

var _ NotificationMessage = (*MetaFlowEstablishedType)(nil)

func (r *MetaFlowEstablishedType) Method() string {
  return "MetaFlowEstablished"
}

func (r *MetaFlowEstablishedType) Notify(rc *butlerd.RequestContext, params butlerd.MetaFlowEstablishedNotification) (error) {
  return rc.Notify("MetaFlowEstablished", params)
}

func (r *MetaFlowEstablishedType) Register(router router, f func(butlerd.MetaFlowEstablishedNotification)) {
  router.RegisterNotification("MetaFlowEstablished", func (notif jsonrpc2.Notification) {
    var params butlerd.MetaFlowEstablishedNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var MetaFlowEstablished *MetaFlowEstablishedType

// Version.Get (Request)

type VersionGetType struct {}

var _ RequestMessage = (*VersionGetType)(nil)

func (r *VersionGetType) Method() string {
  return "Version.Get"
}

func (r *VersionGetType) Register(router router, f func(*butlerd.RequestContext, butlerd.VersionGetParams) (*butlerd.VersionGetResult, error)) {
  router.Register("Version.Get", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.VersionGetParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Version.Get")
    }
    return res, nil
  })
}

func (r *VersionGetType) TestCall(rc *butlerd.RequestContext, params butlerd.VersionGetParams) (*butlerd.VersionGetResult, error) {
  var result butlerd.VersionGetResult
  err := rc.Call("Version.Get", params, &result)
  return &result, err
}

var VersionGet *VersionGetType

// Network.SetSimulateOffline (Request)

type NetworkSetSimulateOfflineType struct {}

var _ RequestMessage = (*NetworkSetSimulateOfflineType)(nil)

func (r *NetworkSetSimulateOfflineType) Method() string {
  return "Network.SetSimulateOffline"
}

func (r *NetworkSetSimulateOfflineType) Register(router router, f func(*butlerd.RequestContext, butlerd.NetworkSetSimulateOfflineParams) (*butlerd.NetworkSetSimulateOfflineResult, error)) {
  router.Register("Network.SetSimulateOffline", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.NetworkSetSimulateOfflineParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Network.SetSimulateOffline")
    }
    return res, nil
  })
}

func (r *NetworkSetSimulateOfflineType) TestCall(rc *butlerd.RequestContext, params butlerd.NetworkSetSimulateOfflineParams) (*butlerd.NetworkSetSimulateOfflineResult, error) {
  var result butlerd.NetworkSetSimulateOfflineResult
  err := rc.Call("Network.SetSimulateOffline", params, &result)
  return &result, err
}

var NetworkSetSimulateOffline *NetworkSetSimulateOfflineType

// Network.SetBandwidthThrottle (Request)

type NetworkSetBandwidthThrottleType struct {}

var _ RequestMessage = (*NetworkSetBandwidthThrottleType)(nil)

func (r *NetworkSetBandwidthThrottleType) Method() string {
  return "Network.SetBandwidthThrottle"
}

func (r *NetworkSetBandwidthThrottleType) Register(router router, f func(*butlerd.RequestContext, butlerd.NetworkSetBandwidthThrottleParams) (*butlerd.NetworkSetBandwidthThrottleResult, error)) {
  router.Register("Network.SetBandwidthThrottle", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.NetworkSetBandwidthThrottleParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Network.SetBandwidthThrottle")
    }
    return res, nil
  })
}

func (r *NetworkSetBandwidthThrottleType) TestCall(rc *butlerd.RequestContext, params butlerd.NetworkSetBandwidthThrottleParams) (*butlerd.NetworkSetBandwidthThrottleResult, error) {
  var result butlerd.NetworkSetBandwidthThrottleResult
  err := rc.Call("Network.SetBandwidthThrottle", params, &result)
  return &result, err
}

var NetworkSetBandwidthThrottle *NetworkSetBandwidthThrottleType


//==============================
// Miscellaneous
//==============================

// Downloads.Drive.Progress (Notification)

type DownloadsDriveProgressType struct {}

var _ NotificationMessage = (*DownloadsDriveProgressType)(nil)

func (r *DownloadsDriveProgressType) Method() string {
  return "Downloads.Drive.Progress"
}

func (r *DownloadsDriveProgressType) Notify(rc *butlerd.RequestContext, params butlerd.DownloadsDriveProgressNotification) (error) {
  return rc.Notify("Downloads.Drive.Progress", params)
}

func (r *DownloadsDriveProgressType) Register(router router, f func(butlerd.DownloadsDriveProgressNotification)) {
  router.RegisterNotification("Downloads.Drive.Progress", func (notif jsonrpc2.Notification) {
    var params butlerd.DownloadsDriveProgressNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var DownloadsDriveProgress *DownloadsDriveProgressType

// Downloads.Drive.Started (Notification)

type DownloadsDriveStartedType struct {}

var _ NotificationMessage = (*DownloadsDriveStartedType)(nil)

func (r *DownloadsDriveStartedType) Method() string {
  return "Downloads.Drive.Started"
}

func (r *DownloadsDriveStartedType) Notify(rc *butlerd.RequestContext, params butlerd.DownloadsDriveStartedNotification) (error) {
  return rc.Notify("Downloads.Drive.Started", params)
}

func (r *DownloadsDriveStartedType) Register(router router, f func(butlerd.DownloadsDriveStartedNotification)) {
  router.RegisterNotification("Downloads.Drive.Started", func (notif jsonrpc2.Notification) {
    var params butlerd.DownloadsDriveStartedNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var DownloadsDriveStarted *DownloadsDriveStartedType

// Downloads.Drive.Errored (Notification)

type DownloadsDriveErroredType struct {}

var _ NotificationMessage = (*DownloadsDriveErroredType)(nil)

func (r *DownloadsDriveErroredType) Method() string {
  return "Downloads.Drive.Errored"
}

func (r *DownloadsDriveErroredType) Notify(rc *butlerd.RequestContext, params butlerd.DownloadsDriveErroredNotification) (error) {
  return rc.Notify("Downloads.Drive.Errored", params)
}

func (r *DownloadsDriveErroredType) Register(router router, f func(butlerd.DownloadsDriveErroredNotification)) {
  router.RegisterNotification("Downloads.Drive.Errored", func (notif jsonrpc2.Notification) {
    var params butlerd.DownloadsDriveErroredNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var DownloadsDriveErrored *DownloadsDriveErroredType

// Downloads.Drive.Finished (Notification)

type DownloadsDriveFinishedType struct {}

var _ NotificationMessage = (*DownloadsDriveFinishedType)(nil)

func (r *DownloadsDriveFinishedType) Method() string {
  return "Downloads.Drive.Finished"
}

func (r *DownloadsDriveFinishedType) Notify(rc *butlerd.RequestContext, params butlerd.DownloadsDriveFinishedNotification) (error) {
  return rc.Notify("Downloads.Drive.Finished", params)
}

func (r *DownloadsDriveFinishedType) Register(router router, f func(butlerd.DownloadsDriveFinishedNotification)) {
  router.RegisterNotification("Downloads.Drive.Finished", func (notif jsonrpc2.Notification) {
    var params butlerd.DownloadsDriveFinishedNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var DownloadsDriveFinished *DownloadsDriveFinishedType

// Downloads.Drive.Discarded (Notification)

type DownloadsDriveDiscardedType struct {}

var _ NotificationMessage = (*DownloadsDriveDiscardedType)(nil)

func (r *DownloadsDriveDiscardedType) Method() string {
  return "Downloads.Drive.Discarded"
}

func (r *DownloadsDriveDiscardedType) Notify(rc *butlerd.RequestContext, params butlerd.DownloadsDriveDiscardedNotification) (error) {
  return rc.Notify("Downloads.Drive.Discarded", params)
}

func (r *DownloadsDriveDiscardedType) Register(router router, f func(butlerd.DownloadsDriveDiscardedNotification)) {
  router.RegisterNotification("Downloads.Drive.Discarded", func (notif jsonrpc2.Notification) {
    var params butlerd.DownloadsDriveDiscardedNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var DownloadsDriveDiscarded *DownloadsDriveDiscardedType

// Downloads.Drive.NetworkStatus (Notification)

type DownloadsDriveNetworkStatusType struct {}

var _ NotificationMessage = (*DownloadsDriveNetworkStatusType)(nil)

func (r *DownloadsDriveNetworkStatusType) Method() string {
  return "Downloads.Drive.NetworkStatus"
}

func (r *DownloadsDriveNetworkStatusType) Notify(rc *butlerd.RequestContext, params butlerd.DownloadsDriveNetworkStatusNotification) (error) {
  return rc.Notify("Downloads.Drive.NetworkStatus", params)
}

func (r *DownloadsDriveNetworkStatusType) Register(router router, f func(butlerd.DownloadsDriveNetworkStatusNotification)) {
  router.RegisterNotification("Downloads.Drive.NetworkStatus", func (notif jsonrpc2.Notification) {
    var params butlerd.DownloadsDriveNetworkStatusNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var DownloadsDriveNetworkStatus *DownloadsDriveNetworkStatusType

// Log (Notification)

type LogType struct {}

var _ NotificationMessage = (*LogType)(nil)

func (r *LogType) Method() string {
  return "Log"
}

func (r *LogType) Notify(rc *butlerd.RequestContext, params butlerd.LogNotification) (error) {
  return rc.Notify("Log", params)
}

func (r *LogType) Register(router router, f func(butlerd.LogNotification)) {
  router.RegisterNotification("Log", func (notif jsonrpc2.Notification) {
    var params butlerd.LogNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var Log *LogType


//==============================
// Profile
//==============================

// Profile.List (Request)

type ProfileListType struct {}

var _ RequestMessage = (*ProfileListType)(nil)

func (r *ProfileListType) Method() string {
  return "Profile.List"
}

func (r *ProfileListType) Register(router router, f func(*butlerd.RequestContext, butlerd.ProfileListParams) (*butlerd.ProfileListResult, error)) {
  router.Register("Profile.List", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ProfileListParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Profile.List")
    }
    return res, nil
  })
}

func (r *ProfileListType) TestCall(rc *butlerd.RequestContext, params butlerd.ProfileListParams) (*butlerd.ProfileListResult, error) {
  var result butlerd.ProfileListResult
  err := rc.Call("Profile.List", params, &result)
  return &result, err
}

var ProfileList *ProfileListType

// Profile.LoginWithPassword (Request)

type ProfileLoginWithPasswordType struct {}

var _ RequestMessage = (*ProfileLoginWithPasswordType)(nil)

func (r *ProfileLoginWithPasswordType) Method() string {
  return "Profile.LoginWithPassword"
}

func (r *ProfileLoginWithPasswordType) Register(router router, f func(*butlerd.RequestContext, butlerd.ProfileLoginWithPasswordParams) (*butlerd.ProfileLoginWithPasswordResult, error)) {
  router.Register("Profile.LoginWithPassword", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ProfileLoginWithPasswordParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Profile.LoginWithPassword")
    }
    return res, nil
  })
}

func (r *ProfileLoginWithPasswordType) TestCall(rc *butlerd.RequestContext, params butlerd.ProfileLoginWithPasswordParams) (*butlerd.ProfileLoginWithPasswordResult, error) {
  var result butlerd.ProfileLoginWithPasswordResult
  err := rc.Call("Profile.LoginWithPassword", params, &result)
  return &result, err
}

var ProfileLoginWithPassword *ProfileLoginWithPasswordType

// Profile.LoginWithAPIKey (Request)

type ProfileLoginWithAPIKeyType struct {}

var _ RequestMessage = (*ProfileLoginWithAPIKeyType)(nil)

func (r *ProfileLoginWithAPIKeyType) Method() string {
  return "Profile.LoginWithAPIKey"
}

func (r *ProfileLoginWithAPIKeyType) Register(router router, f func(*butlerd.RequestContext, butlerd.ProfileLoginWithAPIKeyParams) (*butlerd.ProfileLoginWithAPIKeyResult, error)) {
  router.Register("Profile.LoginWithAPIKey", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ProfileLoginWithAPIKeyParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Profile.LoginWithAPIKey")
    }
    return res, nil
  })
}

func (r *ProfileLoginWithAPIKeyType) TestCall(rc *butlerd.RequestContext, params butlerd.ProfileLoginWithAPIKeyParams) (*butlerd.ProfileLoginWithAPIKeyResult, error) {
  var result butlerd.ProfileLoginWithAPIKeyResult
  err := rc.Call("Profile.LoginWithAPIKey", params, &result)
  return &result, err
}

var ProfileLoginWithAPIKey *ProfileLoginWithAPIKeyType

// Profile.LoginWithOAuthCode (Request)

type ProfileLoginWithOAuthCodeType struct {}

var _ RequestMessage = (*ProfileLoginWithOAuthCodeType)(nil)

func (r *ProfileLoginWithOAuthCodeType) Method() string {
  return "Profile.LoginWithOAuthCode"
}

func (r *ProfileLoginWithOAuthCodeType) Register(router router, f func(*butlerd.RequestContext, butlerd.ProfileLoginWithOAuthCodeParams) (*butlerd.ProfileLoginWithOAuthCodeResult, error)) {
  router.Register("Profile.LoginWithOAuthCode", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ProfileLoginWithOAuthCodeParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Profile.LoginWithOAuthCode")
    }
    return res, nil
  })
}

func (r *ProfileLoginWithOAuthCodeType) TestCall(rc *butlerd.RequestContext, params butlerd.ProfileLoginWithOAuthCodeParams) (*butlerd.ProfileLoginWithOAuthCodeResult, error) {
  var result butlerd.ProfileLoginWithOAuthCodeResult
  err := rc.Call("Profile.LoginWithOAuthCode", params, &result)
  return &result, err
}

var ProfileLoginWithOAuthCode *ProfileLoginWithOAuthCodeType

// Profile.RequestCaptcha (Request)

type ProfileRequestCaptchaType struct {}

var _ RequestMessage = (*ProfileRequestCaptchaType)(nil)

func (r *ProfileRequestCaptchaType) Method() string {
  return "Profile.RequestCaptcha"
}

func (r *ProfileRequestCaptchaType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.ProfileRequestCaptchaParams) (*butlerd.ProfileRequestCaptchaResult, error)) {
  router.Register("Profile.RequestCaptcha", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ProfileRequestCaptchaParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Profile.RequestCaptcha")
    }
    return res, nil
  })
}

func (r *ProfileRequestCaptchaType) Call(rc *butlerd.RequestContext, params butlerd.ProfileRequestCaptchaParams) (*butlerd.ProfileRequestCaptchaResult, error) {
  var result butlerd.ProfileRequestCaptchaResult
  err := rc.Call("Profile.RequestCaptcha", params, &result)
  return &result, err
}

var ProfileRequestCaptcha *ProfileRequestCaptchaType

// Profile.RequestTOTP (Request)

type ProfileRequestTOTPType struct {}

var _ RequestMessage = (*ProfileRequestTOTPType)(nil)

func (r *ProfileRequestTOTPType) Method() string {
  return "Profile.RequestTOTP"
}

func (r *ProfileRequestTOTPType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.ProfileRequestTOTPParams) (*butlerd.ProfileRequestTOTPResult, error)) {
  router.Register("Profile.RequestTOTP", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ProfileRequestTOTPParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Profile.RequestTOTP")
    }
    return res, nil
  })
}

func (r *ProfileRequestTOTPType) Call(rc *butlerd.RequestContext, params butlerd.ProfileRequestTOTPParams) (*butlerd.ProfileRequestTOTPResult, error) {
  var result butlerd.ProfileRequestTOTPResult
  err := rc.Call("Profile.RequestTOTP", params, &result)
  return &result, err
}

var ProfileRequestTOTP *ProfileRequestTOTPType

// Profile.UseSavedLogin (Request)

type ProfileUseSavedLoginType struct {}

var _ RequestMessage = (*ProfileUseSavedLoginType)(nil)

func (r *ProfileUseSavedLoginType) Method() string {
  return "Profile.UseSavedLogin"
}

func (r *ProfileUseSavedLoginType) Register(router router, f func(*butlerd.RequestContext, butlerd.ProfileUseSavedLoginParams) (*butlerd.ProfileUseSavedLoginResult, error)) {
  router.Register("Profile.UseSavedLogin", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ProfileUseSavedLoginParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Profile.UseSavedLogin")
    }
    return res, nil
  })
}

func (r *ProfileUseSavedLoginType) TestCall(rc *butlerd.RequestContext, params butlerd.ProfileUseSavedLoginParams) (*butlerd.ProfileUseSavedLoginResult, error) {
  var result butlerd.ProfileUseSavedLoginResult
  err := rc.Call("Profile.UseSavedLogin", params, &result)
  return &result, err
}

var ProfileUseSavedLogin *ProfileUseSavedLoginType

// Profile.Forget (Request)

type ProfileForgetType struct {}

var _ RequestMessage = (*ProfileForgetType)(nil)

func (r *ProfileForgetType) Method() string {
  return "Profile.Forget"
}

func (r *ProfileForgetType) Register(router router, f func(*butlerd.RequestContext, butlerd.ProfileForgetParams) (*butlerd.ProfileForgetResult, error)) {
  router.Register("Profile.Forget", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ProfileForgetParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Profile.Forget")
    }
    return res, nil
  })
}

func (r *ProfileForgetType) TestCall(rc *butlerd.RequestContext, params butlerd.ProfileForgetParams) (*butlerd.ProfileForgetResult, error) {
  var result butlerd.ProfileForgetResult
  err := rc.Call("Profile.Forget", params, &result)
  return &result, err
}

var ProfileForget *ProfileForgetType

// Profile.Data.Put (Request)

type ProfileDataPutType struct {}

var _ RequestMessage = (*ProfileDataPutType)(nil)

func (r *ProfileDataPutType) Method() string {
  return "Profile.Data.Put"
}

func (r *ProfileDataPutType) Register(router router, f func(*butlerd.RequestContext, butlerd.ProfileDataPutParams) (*butlerd.ProfileDataPutResult, error)) {
  router.Register("Profile.Data.Put", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ProfileDataPutParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Profile.Data.Put")
    }
    return res, nil
  })
}

func (r *ProfileDataPutType) TestCall(rc *butlerd.RequestContext, params butlerd.ProfileDataPutParams) (*butlerd.ProfileDataPutResult, error) {
  var result butlerd.ProfileDataPutResult
  err := rc.Call("Profile.Data.Put", params, &result)
  return &result, err
}

var ProfileDataPut *ProfileDataPutType

// Profile.Data.Get (Request)

type ProfileDataGetType struct {}

var _ RequestMessage = (*ProfileDataGetType)(nil)

func (r *ProfileDataGetType) Method() string {
  return "Profile.Data.Get"
}

func (r *ProfileDataGetType) Register(router router, f func(*butlerd.RequestContext, butlerd.ProfileDataGetParams) (*butlerd.ProfileDataGetResult, error)) {
  router.Register("Profile.Data.Get", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ProfileDataGetParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Profile.Data.Get")
    }
    return res, nil
  })
}

func (r *ProfileDataGetType) TestCall(rc *butlerd.RequestContext, params butlerd.ProfileDataGetParams) (*butlerd.ProfileDataGetResult, error) {
  var result butlerd.ProfileDataGetResult
  err := rc.Call("Profile.Data.Get", params, &result)
  return &result, err
}

var ProfileDataGet *ProfileDataGetType


//==============================
// Search
//==============================

// Search.Games (Request)

type SearchGamesType struct {}

var _ RequestMessage = (*SearchGamesType)(nil)

func (r *SearchGamesType) Method() string {
  return "Search.Games"
}

func (r *SearchGamesType) Register(router router, f func(*butlerd.RequestContext, butlerd.SearchGamesParams) (*butlerd.SearchGamesResult, error)) {
  router.Register("Search.Games", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.SearchGamesParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Search.Games")
    }
    return res, nil
  })
}

func (r *SearchGamesType) TestCall(rc *butlerd.RequestContext, params butlerd.SearchGamesParams) (*butlerd.SearchGamesResult, error) {
  var result butlerd.SearchGamesResult
  err := rc.Call("Search.Games", params, &result)
  return &result, err
}

var SearchGames *SearchGamesType

// Search.Users (Request)

type SearchUsersType struct {}

var _ RequestMessage = (*SearchUsersType)(nil)

func (r *SearchUsersType) Method() string {
  return "Search.Users"
}

func (r *SearchUsersType) Register(router router, f func(*butlerd.RequestContext, butlerd.SearchUsersParams) (*butlerd.SearchUsersResult, error)) {
  router.Register("Search.Users", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.SearchUsersParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Search.Users")
    }
    return res, nil
  })
}

func (r *SearchUsersType) TestCall(rc *butlerd.RequestContext, params butlerd.SearchUsersParams) (*butlerd.SearchUsersResult, error) {
  var result butlerd.SearchUsersResult
  err := rc.Call("Search.Users", params, &result)
  return &result, err
}

var SearchUsers *SearchUsersType


//==============================
// Fetch
//==============================

// Fetch.Game (Request)

type FetchGameType struct {}

var _ RequestMessage = (*FetchGameType)(nil)

func (r *FetchGameType) Method() string {
  return "Fetch.Game"
}

func (r *FetchGameType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchGameParams) (*butlerd.FetchGameResult, error)) {
  router.Register("Fetch.Game", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchGameParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.Game")
    }
    return res, nil
  })
}

func (r *FetchGameType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchGameParams) (*butlerd.FetchGameResult, error) {
  var result butlerd.FetchGameResult
  err := rc.Call("Fetch.Game", params, &result)
  return &result, err
}

var FetchGame *FetchGameType

// Fetch.GameRecords (Request)

type FetchGameRecordsType struct {}

var _ RequestMessage = (*FetchGameRecordsType)(nil)

func (r *FetchGameRecordsType) Method() string {
  return "Fetch.GameRecords"
}

func (r *FetchGameRecordsType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchGameRecordsParams) (*butlerd.FetchGameRecordsResult, error)) {
  router.Register("Fetch.GameRecords", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchGameRecordsParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.GameRecords")
    }
    return res, nil
  })
}

func (r *FetchGameRecordsType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchGameRecordsParams) (*butlerd.FetchGameRecordsResult, error) {
  var result butlerd.FetchGameRecordsResult
  err := rc.Call("Fetch.GameRecords", params, &result)
  return &result, err
}

var FetchGameRecords *FetchGameRecordsType

// Fetch.DownloadKey (Request)

type FetchDownloadKeyType struct {}

var _ RequestMessage = (*FetchDownloadKeyType)(nil)

func (r *FetchDownloadKeyType) Method() string {
  return "Fetch.DownloadKey"
}

func (r *FetchDownloadKeyType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchDownloadKeyParams) (*butlerd.FetchDownloadKeyResult, error)) {
  router.Register("Fetch.DownloadKey", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchDownloadKeyParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.DownloadKey")
    }
    return res, nil
  })
}

func (r *FetchDownloadKeyType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchDownloadKeyParams) (*butlerd.FetchDownloadKeyResult, error) {
  var result butlerd.FetchDownloadKeyResult
  err := rc.Call("Fetch.DownloadKey", params, &result)
  return &result, err
}

var FetchDownloadKey *FetchDownloadKeyType

// Fetch.DownloadKeys (Request)

type FetchDownloadKeysType struct {}

var _ RequestMessage = (*FetchDownloadKeysType)(nil)

func (r *FetchDownloadKeysType) Method() string {
  return "Fetch.DownloadKeys"
}

func (r *FetchDownloadKeysType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchDownloadKeysParams) (*butlerd.FetchDownloadKeysResult, error)) {
  router.Register("Fetch.DownloadKeys", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchDownloadKeysParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.DownloadKeys")
    }
    return res, nil
  })
}

func (r *FetchDownloadKeysType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchDownloadKeysParams) (*butlerd.FetchDownloadKeysResult, error) {
  var result butlerd.FetchDownloadKeysResult
  err := rc.Call("Fetch.DownloadKeys", params, &result)
  return &result, err
}

var FetchDownloadKeys *FetchDownloadKeysType

// Fetch.GameUploads (Request)

type FetchGameUploadsType struct {}

var _ RequestMessage = (*FetchGameUploadsType)(nil)

func (r *FetchGameUploadsType) Method() string {
  return "Fetch.GameUploads"
}

func (r *FetchGameUploadsType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchGameUploadsParams) (*butlerd.FetchGameUploadsResult, error)) {
  router.Register("Fetch.GameUploads", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchGameUploadsParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.GameUploads")
    }
    return res, nil
  })
}

func (r *FetchGameUploadsType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchGameUploadsParams) (*butlerd.FetchGameUploadsResult, error) {
  var result butlerd.FetchGameUploadsResult
  err := rc.Call("Fetch.GameUploads", params, &result)
  return &result, err
}

var FetchGameUploads *FetchGameUploadsType

// Fetch.User (Request)

type FetchUserType struct {}

var _ RequestMessage = (*FetchUserType)(nil)

func (r *FetchUserType) Method() string {
  return "Fetch.User"
}

func (r *FetchUserType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchUserParams) (*butlerd.FetchUserResult, error)) {
  router.Register("Fetch.User", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchUserParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.User")
    }
    return res, nil
  })
}

func (r *FetchUserType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchUserParams) (*butlerd.FetchUserResult, error) {
  var result butlerd.FetchUserResult
  err := rc.Call("Fetch.User", params, &result)
  return &result, err
}

var FetchUser *FetchUserType

// Fetch.Sale (Request)

type FetchSaleType struct {}

var _ RequestMessage = (*FetchSaleType)(nil)

func (r *FetchSaleType) Method() string {
  return "Fetch.Sale"
}

func (r *FetchSaleType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchSaleParams) (*butlerd.FetchSaleResult, error)) {
  router.Register("Fetch.Sale", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchSaleParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.Sale")
    }
    return res, nil
  })
}

func (r *FetchSaleType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchSaleParams) (*butlerd.FetchSaleResult, error) {
  var result butlerd.FetchSaleResult
  err := rc.Call("Fetch.Sale", params, &result)
  return &result, err
}

var FetchSale *FetchSaleType

// Fetch.Collection (Request)

type FetchCollectionType struct {}

var _ RequestMessage = (*FetchCollectionType)(nil)

func (r *FetchCollectionType) Method() string {
  return "Fetch.Collection"
}

func (r *FetchCollectionType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchCollectionParams) (*butlerd.FetchCollectionResult, error)) {
  router.Register("Fetch.Collection", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchCollectionParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.Collection")
    }
    return res, nil
  })
}

func (r *FetchCollectionType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchCollectionParams) (*butlerd.FetchCollectionResult, error) {
  var result butlerd.FetchCollectionResult
  err := rc.Call("Fetch.Collection", params, &result)
  return &result, err
}

var FetchCollection *FetchCollectionType

// Fetch.Collection.Games (Request)

type FetchCollectionGamesType struct {}

var _ RequestMessage = (*FetchCollectionGamesType)(nil)

func (r *FetchCollectionGamesType) Method() string {
  return "Fetch.Collection.Games"
}

func (r *FetchCollectionGamesType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchCollectionGamesParams) (*butlerd.FetchCollectionGamesResult, error)) {
  router.Register("Fetch.Collection.Games", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchCollectionGamesParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.Collection.Games")
    }
    return res, nil
  })
}

func (r *FetchCollectionGamesType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchCollectionGamesParams) (*butlerd.FetchCollectionGamesResult, error) {
  var result butlerd.FetchCollectionGamesResult
  err := rc.Call("Fetch.Collection.Games", params, &result)
  return &result, err
}

var FetchCollectionGames *FetchCollectionGamesType

// Fetch.ProfileCollections (Request)

type FetchProfileCollectionsType struct {}

var _ RequestMessage = (*FetchProfileCollectionsType)(nil)

func (r *FetchProfileCollectionsType) Method() string {
  return "Fetch.ProfileCollections"
}

func (r *FetchProfileCollectionsType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchProfileCollectionsParams) (*butlerd.FetchProfileCollectionsResult, error)) {
  router.Register("Fetch.ProfileCollections", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchProfileCollectionsParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.ProfileCollections")
    }
    return res, nil
  })
}

func (r *FetchProfileCollectionsType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchProfileCollectionsParams) (*butlerd.FetchProfileCollectionsResult, error) {
  var result butlerd.FetchProfileCollectionsResult
  err := rc.Call("Fetch.ProfileCollections", params, &result)
  return &result, err
}

var FetchProfileCollections *FetchProfileCollectionsType

// Fetch.ProfileGames (Request)

type FetchProfileGamesType struct {}

var _ RequestMessage = (*FetchProfileGamesType)(nil)

func (r *FetchProfileGamesType) Method() string {
  return "Fetch.ProfileGames"
}

func (r *FetchProfileGamesType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchProfileGamesParams) (*butlerd.FetchProfileGamesResult, error)) {
  router.Register("Fetch.ProfileGames", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchProfileGamesParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.ProfileGames")
    }
    return res, nil
  })
}

func (r *FetchProfileGamesType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchProfileGamesParams) (*butlerd.FetchProfileGamesResult, error) {
  var result butlerd.FetchProfileGamesResult
  err := rc.Call("Fetch.ProfileGames", params, &result)
  return &result, err
}

var FetchProfileGames *FetchProfileGamesType

// Fetch.ProfileOwnedKeys (Request)

type FetchProfileOwnedKeysType struct {}

var _ RequestMessage = (*FetchProfileOwnedKeysType)(nil)

func (r *FetchProfileOwnedKeysType) Method() string {
  return "Fetch.ProfileOwnedKeys"
}

func (r *FetchProfileOwnedKeysType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchProfileOwnedKeysParams) (*butlerd.FetchProfileOwnedKeysResult, error)) {
  router.Register("Fetch.ProfileOwnedKeys", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchProfileOwnedKeysParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.ProfileOwnedKeys")
    }
    return res, nil
  })
}

func (r *FetchProfileOwnedKeysType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchProfileOwnedKeysParams) (*butlerd.FetchProfileOwnedKeysResult, error) {
  var result butlerd.FetchProfileOwnedKeysResult
  err := rc.Call("Fetch.ProfileOwnedKeys", params, &result)
  return &result, err
}

var FetchProfileOwnedKeys *FetchProfileOwnedKeysType

// Fetch.Commons (Request)

type FetchCommonsType struct {}

var _ RequestMessage = (*FetchCommonsType)(nil)

func (r *FetchCommonsType) Method() string {
  return "Fetch.Commons"
}

func (r *FetchCommonsType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchCommonsParams) (*butlerd.FetchCommonsResult, error)) {
  router.Register("Fetch.Commons", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchCommonsParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.Commons")
    }
    return res, nil
  })
}

func (r *FetchCommonsType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchCommonsParams) (*butlerd.FetchCommonsResult, error) {
  var result butlerd.FetchCommonsResult
  err := rc.Call("Fetch.Commons", params, &result)
  return &result, err
}

var FetchCommons *FetchCommonsType

// Fetch.Caves (Request)

type FetchCavesType struct {}

var _ RequestMessage = (*FetchCavesType)(nil)

func (r *FetchCavesType) Method() string {
  return "Fetch.Caves"
}

func (r *FetchCavesType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchCavesParams) (*butlerd.FetchCavesResult, error)) {
  router.Register("Fetch.Caves", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchCavesParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.Caves")
    }
    return res, nil
  })
}

func (r *FetchCavesType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchCavesParams) (*butlerd.FetchCavesResult, error) {
  var result butlerd.FetchCavesResult
  err := rc.Call("Fetch.Caves", params, &result)
  return &result, err
}

var FetchCaves *FetchCavesType

// Fetch.Cave (Request)

type FetchCaveType struct {}

var _ RequestMessage = (*FetchCaveType)(nil)

func (r *FetchCaveType) Method() string {
  return "Fetch.Cave"
}

func (r *FetchCaveType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchCaveParams) (*butlerd.FetchCaveResult, error)) {
  router.Register("Fetch.Cave", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchCaveParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.Cave")
    }
    return res, nil
  })
}

func (r *FetchCaveType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchCaveParams) (*butlerd.FetchCaveResult, error) {
  var result butlerd.FetchCaveResult
  err := rc.Call("Fetch.Cave", params, &result)
  return &result, err
}

var FetchCave *FetchCaveType

// Fetch.ExpireAll (Request)

type FetchExpireAllType struct {}

var _ RequestMessage = (*FetchExpireAllType)(nil)

func (r *FetchExpireAllType) Method() string {
  return "Fetch.ExpireAll"
}

func (r *FetchExpireAllType) Register(router router, f func(*butlerd.RequestContext, butlerd.FetchExpireAllParams) (*butlerd.FetchExpireAllResult, error)) {
  router.Register("Fetch.ExpireAll", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.FetchExpireAllParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Fetch.ExpireAll")
    }
    return res, nil
  })
}

func (r *FetchExpireAllType) TestCall(rc *butlerd.RequestContext, params butlerd.FetchExpireAllParams) (*butlerd.FetchExpireAllResult, error) {
  var result butlerd.FetchExpireAllResult
  err := rc.Call("Fetch.ExpireAll", params, &result)
  return &result, err
}

var FetchExpireAll *FetchExpireAllType


//==============================
// Install
//==============================

// Game.FindUploads (Request)

type GameFindUploadsType struct {}

var _ RequestMessage = (*GameFindUploadsType)(nil)

func (r *GameFindUploadsType) Method() string {
  return "Game.FindUploads"
}

func (r *GameFindUploadsType) Register(router router, f func(*butlerd.RequestContext, butlerd.GameFindUploadsParams) (*butlerd.GameFindUploadsResult, error)) {
  router.Register("Game.FindUploads", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.GameFindUploadsParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Game.FindUploads")
    }
    return res, nil
  })
}

func (r *GameFindUploadsType) TestCall(rc *butlerd.RequestContext, params butlerd.GameFindUploadsParams) (*butlerd.GameFindUploadsResult, error) {
  var result butlerd.GameFindUploadsResult
  err := rc.Call("Game.FindUploads", params, &result)
  return &result, err
}

var GameFindUploads *GameFindUploadsType

// Install.Queue (Request)

type InstallQueueType struct {}

var _ RequestMessage = (*InstallQueueType)(nil)

func (r *InstallQueueType) Method() string {
  return "Install.Queue"
}

func (r *InstallQueueType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallQueueParams) (*butlerd.InstallQueueResult, error)) {
  router.Register("Install.Queue", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallQueueParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.Queue")
    }
    return res, nil
  })
}

func (r *InstallQueueType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallQueueParams) (*butlerd.InstallQueueResult, error) {
  var result butlerd.InstallQueueResult
  err := rc.Call("Install.Queue", params, &result)
  return &result, err
}

var InstallQueue *InstallQueueType

// Install.Plan (Request)

type InstallPlanType struct {}

var _ RequestMessage = (*InstallPlanType)(nil)

func (r *InstallPlanType) Method() string {
  return "Install.Plan"
}

func (r *InstallPlanType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallPlanParams) (*butlerd.InstallPlanResult, error)) {
  router.Register("Install.Plan", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallPlanParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.Plan")
    }
    return res, nil
  })
}

func (r *InstallPlanType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallPlanParams) (*butlerd.InstallPlanResult, error) {
  var result butlerd.InstallPlanResult
  err := rc.Call("Install.Plan", params, &result)
  return &result, err
}

var InstallPlan *InstallPlanType

// Caves.SetPinned (Request)

type CavesSetPinnedType struct {}

var _ RequestMessage = (*CavesSetPinnedType)(nil)

func (r *CavesSetPinnedType) Method() string {
  return "Caves.SetPinned"
}

func (r *CavesSetPinnedType) Register(router router, f func(*butlerd.RequestContext, butlerd.CavesSetPinnedParams) (*butlerd.CavesSetPinnedResult, error)) {
  router.Register("Caves.SetPinned", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.CavesSetPinnedParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Caves.SetPinned")
    }
    return res, nil
  })
}

func (r *CavesSetPinnedType) TestCall(rc *butlerd.RequestContext, params butlerd.CavesSetPinnedParams) (*butlerd.CavesSetPinnedResult, error) {
  var result butlerd.CavesSetPinnedResult
  err := rc.Call("Caves.SetPinned", params, &result)
  return &result, err
}

var CavesSetPinned *CavesSetPinnedType

// Install.CreateShortcut (Request)

type InstallCreateShortcutType struct {}

var _ RequestMessage = (*InstallCreateShortcutType)(nil)

func (r *InstallCreateShortcutType) Method() string {
  return "Install.CreateShortcut"
}

func (r *InstallCreateShortcutType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallCreateShortcutParams) (*butlerd.InstallCreateShortcutResult, error)) {
  router.Register("Install.CreateShortcut", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallCreateShortcutParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.CreateShortcut")
    }
    return res, nil
  })
}

func (r *InstallCreateShortcutType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallCreateShortcutParams) (*butlerd.InstallCreateShortcutResult, error) {
  var result butlerd.InstallCreateShortcutResult
  err := rc.Call("Install.CreateShortcut", params, &result)
  return &result, err
}

var InstallCreateShortcut *InstallCreateShortcutType

// Install.Perform (Request)

type InstallPerformType struct {}

var _ RequestMessage = (*InstallPerformType)(nil)

func (r *InstallPerformType) Method() string {
  return "Install.Perform"
}

func (r *InstallPerformType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallPerformParams) (*butlerd.InstallPerformResult, error)) {
  router.Register("Install.Perform", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallPerformParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.Perform")
    }
    return res, nil
  })
}

func (r *InstallPerformType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallPerformParams) (*butlerd.InstallPerformResult, error) {
  var result butlerd.InstallPerformResult
  err := rc.Call("Install.Perform", params, &result)
  return &result, err
}

var InstallPerform *InstallPerformType

// Install.Cancel (Request)

type InstallCancelType struct {}

var _ RequestMessage = (*InstallCancelType)(nil)

func (r *InstallCancelType) Method() string {
  return "Install.Cancel"
}

func (r *InstallCancelType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallCancelParams) (*butlerd.InstallCancelResult, error)) {
  router.Register("Install.Cancel", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallCancelParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.Cancel")
    }
    return res, nil
  })
}

func (r *InstallCancelType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallCancelParams) (*butlerd.InstallCancelResult, error) {
  var result butlerd.InstallCancelResult
  err := rc.Call("Install.Cancel", params, &result)
  return &result, err
}

var InstallCancel *InstallCancelType

// Uninstall.Perform (Request)

type UninstallPerformType struct {}

var _ RequestMessage = (*UninstallPerformType)(nil)

func (r *UninstallPerformType) Method() string {
  return "Uninstall.Perform"
}

func (r *UninstallPerformType) Register(router router, f func(*butlerd.RequestContext, butlerd.UninstallPerformParams) (*butlerd.UninstallPerformResult, error)) {
  router.Register("Uninstall.Perform", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.UninstallPerformParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Uninstall.Perform")
    }
    return res, nil
  })
}

func (r *UninstallPerformType) TestCall(rc *butlerd.RequestContext, params butlerd.UninstallPerformParams) (*butlerd.UninstallPerformResult, error) {
  var result butlerd.UninstallPerformResult
  err := rc.Call("Uninstall.Perform", params, &result)
  return &result, err
}

var UninstallPerform *UninstallPerformType

// Install.VersionSwitch.Queue (Request)

type InstallVersionSwitchQueueType struct {}

var _ RequestMessage = (*InstallVersionSwitchQueueType)(nil)

func (r *InstallVersionSwitchQueueType) Method() string {
  return "Install.VersionSwitch.Queue"
}

func (r *InstallVersionSwitchQueueType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallVersionSwitchQueueParams) (*butlerd.InstallVersionSwitchQueueResult, error)) {
  router.Register("Install.VersionSwitch.Queue", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallVersionSwitchQueueParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.VersionSwitch.Queue")
    }
    return res, nil
  })
}

func (r *InstallVersionSwitchQueueType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallVersionSwitchQueueParams) (*butlerd.InstallVersionSwitchQueueResult, error) {
  var result butlerd.InstallVersionSwitchQueueResult
  err := rc.Call("Install.VersionSwitch.Queue", params, &result)
  return &result, err
}

var InstallVersionSwitchQueue *InstallVersionSwitchQueueType

// InstallVersionSwitchPick (Request)

type InstallVersionSwitchPickType struct {}

var _ RequestMessage = (*InstallVersionSwitchPickType)(nil)

func (r *InstallVersionSwitchPickType) Method() string {
  return "InstallVersionSwitchPick"
}

func (r *InstallVersionSwitchPickType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.InstallVersionSwitchPickParams) (*butlerd.InstallVersionSwitchPickResult, error)) {
  router.Register("InstallVersionSwitchPick", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallVersionSwitchPickParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for InstallVersionSwitchPick")
    }
    return res, nil
  })
}

func (r *InstallVersionSwitchPickType) Call(rc *butlerd.RequestContext, params butlerd.InstallVersionSwitchPickParams) (*butlerd.InstallVersionSwitchPickResult, error) {
  var result butlerd.InstallVersionSwitchPickResult
  err := rc.Call("InstallVersionSwitchPick", params, &result)
  return &result, err
}

var InstallVersionSwitchPick *InstallVersionSwitchPickType

// PickUpload (Request)

type PickUploadType struct {}

var _ RequestMessage = (*PickUploadType)(nil)

func (r *PickUploadType) Method() string {
  return "PickUpload"
}

func (r *PickUploadType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.PickUploadParams) (*butlerd.PickUploadResult, error)) {
  router.Register("PickUpload", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.PickUploadParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for PickUpload")
    }
    return res, nil
  })
}

func (r *PickUploadType) Call(rc *butlerd.RequestContext, params butlerd.PickUploadParams) (*butlerd.PickUploadResult, error) {
  var result butlerd.PickUploadResult
  err := rc.Call("PickUpload", params, &result)
  return &result, err
}

var PickUpload *PickUploadType

// Progress (Notification)

type ProgressType struct {}

var _ NotificationMessage = (*ProgressType)(nil)

func (r *ProgressType) Method() string {
  return "Progress"
}

func (r *ProgressType) Notify(rc *butlerd.RequestContext, params butlerd.ProgressNotification) (error) {
  return rc.Notify("Progress", params)
}

func (r *ProgressType) Register(router router, f func(butlerd.ProgressNotification)) {
  router.RegisterNotification("Progress", func (notif jsonrpc2.Notification) {
    var params butlerd.ProgressNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var Progress *ProgressType

// TaskStarted (Notification)

type TaskStartedType struct {}

var _ NotificationMessage = (*TaskStartedType)(nil)

func (r *TaskStartedType) Method() string {
  return "TaskStarted"
}

func (r *TaskStartedType) Notify(rc *butlerd.RequestContext, params butlerd.TaskStartedNotification) (error) {
  return rc.Notify("TaskStarted", params)
}

func (r *TaskStartedType) Register(router router, f func(butlerd.TaskStartedNotification)) {
  router.RegisterNotification("TaskStarted", func (notif jsonrpc2.Notification) {
    var params butlerd.TaskStartedNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var TaskStarted *TaskStartedType

// TaskSucceeded (Notification)

type TaskSucceededType struct {}

var _ NotificationMessage = (*TaskSucceededType)(nil)

func (r *TaskSucceededType) Method() string {
  return "TaskSucceeded"
}

func (r *TaskSucceededType) Notify(rc *butlerd.RequestContext, params butlerd.TaskSucceededNotification) (error) {
  return rc.Notify("TaskSucceeded", params)
}

func (r *TaskSucceededType) Register(router router, f func(butlerd.TaskSucceededNotification)) {
  router.RegisterNotification("TaskSucceeded", func (notif jsonrpc2.Notification) {
    var params butlerd.TaskSucceededNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var TaskSucceeded *TaskSucceededType

// Install.Locations.List (Request)

type InstallLocationsListType struct {}

var _ RequestMessage = (*InstallLocationsListType)(nil)

func (r *InstallLocationsListType) Method() string {
  return "Install.Locations.List"
}

func (r *InstallLocationsListType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallLocationsListParams) (*butlerd.InstallLocationsListResult, error)) {
  router.Register("Install.Locations.List", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallLocationsListParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.Locations.List")
    }
    return res, nil
  })
}

func (r *InstallLocationsListType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallLocationsListParams) (*butlerd.InstallLocationsListResult, error) {
  var result butlerd.InstallLocationsListResult
  err := rc.Call("Install.Locations.List", params, &result)
  return &result, err
}

var InstallLocationsList *InstallLocationsListType

// Install.Locations.Add (Request)

type InstallLocationsAddType struct {}

var _ RequestMessage = (*InstallLocationsAddType)(nil)

func (r *InstallLocationsAddType) Method() string {
  return "Install.Locations.Add"
}

func (r *InstallLocationsAddType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallLocationsAddParams) (*butlerd.InstallLocationsAddResult, error)) {
  router.Register("Install.Locations.Add", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallLocationsAddParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.Locations.Add")
    }
    return res, nil
  })
}

func (r *InstallLocationsAddType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallLocationsAddParams) (*butlerd.InstallLocationsAddResult, error) {
  var result butlerd.InstallLocationsAddResult
  err := rc.Call("Install.Locations.Add", params, &result)
  return &result, err
}

var InstallLocationsAdd *InstallLocationsAddType

// Install.Locations.Remove (Request)

type InstallLocationsRemoveType struct {}

var _ RequestMessage = (*InstallLocationsRemoveType)(nil)

func (r *InstallLocationsRemoveType) Method() string {
  return "Install.Locations.Remove"
}

func (r *InstallLocationsRemoveType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallLocationsRemoveParams) (*butlerd.InstallLocationsRemoveResult, error)) {
  router.Register("Install.Locations.Remove", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallLocationsRemoveParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.Locations.Remove")
    }
    return res, nil
  })
}

func (r *InstallLocationsRemoveType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallLocationsRemoveParams) (*butlerd.InstallLocationsRemoveResult, error) {
  var result butlerd.InstallLocationsRemoveResult
  err := rc.Call("Install.Locations.Remove", params, &result)
  return &result, err
}

var InstallLocationsRemove *InstallLocationsRemoveType

// Install.Locations.GetByID (Request)

type InstallLocationsGetByIDType struct {}

var _ RequestMessage = (*InstallLocationsGetByIDType)(nil)

func (r *InstallLocationsGetByIDType) Method() string {
  return "Install.Locations.GetByID"
}

func (r *InstallLocationsGetByIDType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallLocationsGetByIDParams) (*butlerd.InstallLocationsGetByIDResult, error)) {
  router.Register("Install.Locations.GetByID", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallLocationsGetByIDParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.Locations.GetByID")
    }
    return res, nil
  })
}

func (r *InstallLocationsGetByIDType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallLocationsGetByIDParams) (*butlerd.InstallLocationsGetByIDResult, error) {
  var result butlerd.InstallLocationsGetByIDResult
  err := rc.Call("Install.Locations.GetByID", params, &result)
  return &result, err
}

var InstallLocationsGetByID *InstallLocationsGetByIDType

// Install.Locations.Scan (Request)

type InstallLocationsScanType struct {}

var _ RequestMessage = (*InstallLocationsScanType)(nil)

func (r *InstallLocationsScanType) Method() string {
  return "Install.Locations.Scan"
}

func (r *InstallLocationsScanType) Register(router router, f func(*butlerd.RequestContext, butlerd.InstallLocationsScanParams) (*butlerd.InstallLocationsScanResult, error)) {
  router.Register("Install.Locations.Scan", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallLocationsScanParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.Locations.Scan")
    }
    return res, nil
  })
}

func (r *InstallLocationsScanType) TestCall(rc *butlerd.RequestContext, params butlerd.InstallLocationsScanParams) (*butlerd.InstallLocationsScanResult, error) {
  var result butlerd.InstallLocationsScanResult
  err := rc.Call("Install.Locations.Scan", params, &result)
  return &result, err
}

var InstallLocationsScan *InstallLocationsScanType

// Install.Locations.Scan.Yield (Notification)

type InstallLocationsScanYieldType struct {}

var _ NotificationMessage = (*InstallLocationsScanYieldType)(nil)

func (r *InstallLocationsScanYieldType) Method() string {
  return "Install.Locations.Scan.Yield"
}

func (r *InstallLocationsScanYieldType) Notify(rc *butlerd.RequestContext, params butlerd.InstallLocationsScanYieldNotification) (error) {
  return rc.Notify("Install.Locations.Scan.Yield", params)
}

func (r *InstallLocationsScanYieldType) Register(router router, f func(butlerd.InstallLocationsScanYieldNotification)) {
  router.RegisterNotification("Install.Locations.Scan.Yield", func (notif jsonrpc2.Notification) {
    var params butlerd.InstallLocationsScanYieldNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var InstallLocationsScanYield *InstallLocationsScanYieldType

// Install.Locations.Scan.ConfirmImport (Request)

type InstallLocationsScanConfirmImportType struct {}

var _ RequestMessage = (*InstallLocationsScanConfirmImportType)(nil)

func (r *InstallLocationsScanConfirmImportType) Method() string {
  return "Install.Locations.Scan.ConfirmImport"
}

func (r *InstallLocationsScanConfirmImportType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.InstallLocationsScanConfirmImportParams) (*butlerd.InstallLocationsScanConfirmImportResult, error)) {
  router.Register("Install.Locations.Scan.ConfirmImport", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.InstallLocationsScanConfirmImportParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Install.Locations.Scan.ConfirmImport")
    }
    return res, nil
  })
}

func (r *InstallLocationsScanConfirmImportType) Call(rc *butlerd.RequestContext, params butlerd.InstallLocationsScanConfirmImportParams) (*butlerd.InstallLocationsScanConfirmImportResult, error) {
  var result butlerd.InstallLocationsScanConfirmImportResult
  err := rc.Call("Install.Locations.Scan.ConfirmImport", params, &result)
  return &result, err
}

var InstallLocationsScanConfirmImport *InstallLocationsScanConfirmImportType


//==============================
// Downloads
//==============================

// Downloads.Queue (Request)

type DownloadsQueueType struct {}

var _ RequestMessage = (*DownloadsQueueType)(nil)

func (r *DownloadsQueueType) Method() string {
  return "Downloads.Queue"
}

func (r *DownloadsQueueType) Register(router router, f func(*butlerd.RequestContext, butlerd.DownloadsQueueParams) (*butlerd.DownloadsQueueResult, error)) {
  router.Register("Downloads.Queue", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.DownloadsQueueParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Downloads.Queue")
    }
    return res, nil
  })
}

func (r *DownloadsQueueType) TestCall(rc *butlerd.RequestContext, params butlerd.DownloadsQueueParams) (*butlerd.DownloadsQueueResult, error) {
  var result butlerd.DownloadsQueueResult
  err := rc.Call("Downloads.Queue", params, &result)
  return &result, err
}

var DownloadsQueue *DownloadsQueueType

// Downloads.Prioritize (Request)

type DownloadsPrioritizeType struct {}

var _ RequestMessage = (*DownloadsPrioritizeType)(nil)

func (r *DownloadsPrioritizeType) Method() string {
  return "Downloads.Prioritize"
}

func (r *DownloadsPrioritizeType) Register(router router, f func(*butlerd.RequestContext, butlerd.DownloadsPrioritizeParams) (*butlerd.DownloadsPrioritizeResult, error)) {
  router.Register("Downloads.Prioritize", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.DownloadsPrioritizeParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Downloads.Prioritize")
    }
    return res, nil
  })
}

func (r *DownloadsPrioritizeType) TestCall(rc *butlerd.RequestContext, params butlerd.DownloadsPrioritizeParams) (*butlerd.DownloadsPrioritizeResult, error) {
  var result butlerd.DownloadsPrioritizeResult
  err := rc.Call("Downloads.Prioritize", params, &result)
  return &result, err
}

var DownloadsPrioritize *DownloadsPrioritizeType

// Downloads.List (Request)

type DownloadsListType struct {}

var _ RequestMessage = (*DownloadsListType)(nil)

func (r *DownloadsListType) Method() string {
  return "Downloads.List"
}

func (r *DownloadsListType) Register(router router, f func(*butlerd.RequestContext, butlerd.DownloadsListParams) (*butlerd.DownloadsListResult, error)) {
  router.Register("Downloads.List", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.DownloadsListParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Downloads.List")
    }
    return res, nil
  })
}

func (r *DownloadsListType) TestCall(rc *butlerd.RequestContext, params butlerd.DownloadsListParams) (*butlerd.DownloadsListResult, error) {
  var result butlerd.DownloadsListResult
  err := rc.Call("Downloads.List", params, &result)
  return &result, err
}

var DownloadsList *DownloadsListType

// Downloads.ClearFinished (Request)

type DownloadsClearFinishedType struct {}

var _ RequestMessage = (*DownloadsClearFinishedType)(nil)

func (r *DownloadsClearFinishedType) Method() string {
  return "Downloads.ClearFinished"
}

func (r *DownloadsClearFinishedType) Register(router router, f func(*butlerd.RequestContext, butlerd.DownloadsClearFinishedParams) (*butlerd.DownloadsClearFinishedResult, error)) {
  router.Register("Downloads.ClearFinished", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.DownloadsClearFinishedParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Downloads.ClearFinished")
    }
    return res, nil
  })
}

func (r *DownloadsClearFinishedType) TestCall(rc *butlerd.RequestContext, params butlerd.DownloadsClearFinishedParams) (*butlerd.DownloadsClearFinishedResult, error) {
  var result butlerd.DownloadsClearFinishedResult
  err := rc.Call("Downloads.ClearFinished", params, &result)
  return &result, err
}

var DownloadsClearFinished *DownloadsClearFinishedType

// Downloads.Drive (Request)

type DownloadsDriveType struct {}

var _ RequestMessage = (*DownloadsDriveType)(nil)

func (r *DownloadsDriveType) Method() string {
  return "Downloads.Drive"
}

func (r *DownloadsDriveType) Register(router router, f func(*butlerd.RequestContext, butlerd.DownloadsDriveParams) (*butlerd.DownloadsDriveResult, error)) {
  router.Register("Downloads.Drive", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.DownloadsDriveParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Downloads.Drive")
    }
    return res, nil
  })
}

func (r *DownloadsDriveType) TestCall(rc *butlerd.RequestContext, params butlerd.DownloadsDriveParams) (*butlerd.DownloadsDriveResult, error) {
  var result butlerd.DownloadsDriveResult
  err := rc.Call("Downloads.Drive", params, &result)
  return &result, err
}

var DownloadsDrive *DownloadsDriveType

// Downloads.Drive.Cancel (Request)

type DownloadsDriveCancelType struct {}

var _ RequestMessage = (*DownloadsDriveCancelType)(nil)

func (r *DownloadsDriveCancelType) Method() string {
  return "Downloads.Drive.Cancel"
}

func (r *DownloadsDriveCancelType) Register(router router, f func(*butlerd.RequestContext, butlerd.DownloadsDriveCancelParams) (*butlerd.DownloadsDriveCancelResult, error)) {
  router.Register("Downloads.Drive.Cancel", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.DownloadsDriveCancelParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Downloads.Drive.Cancel")
    }
    return res, nil
  })
}

func (r *DownloadsDriveCancelType) TestCall(rc *butlerd.RequestContext, params butlerd.DownloadsDriveCancelParams) (*butlerd.DownloadsDriveCancelResult, error) {
  var result butlerd.DownloadsDriveCancelResult
  err := rc.Call("Downloads.Drive.Cancel", params, &result)
  return &result, err
}

var DownloadsDriveCancel *DownloadsDriveCancelType

// Downloads.Retry (Request)

type DownloadsRetryType struct {}

var _ RequestMessage = (*DownloadsRetryType)(nil)

func (r *DownloadsRetryType) Method() string {
  return "Downloads.Retry"
}

func (r *DownloadsRetryType) Register(router router, f func(*butlerd.RequestContext, butlerd.DownloadsRetryParams) (*butlerd.DownloadsRetryResult, error)) {
  router.Register("Downloads.Retry", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.DownloadsRetryParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Downloads.Retry")
    }
    return res, nil
  })
}

func (r *DownloadsRetryType) TestCall(rc *butlerd.RequestContext, params butlerd.DownloadsRetryParams) (*butlerd.DownloadsRetryResult, error) {
  var result butlerd.DownloadsRetryResult
  err := rc.Call("Downloads.Retry", params, &result)
  return &result, err
}

var DownloadsRetry *DownloadsRetryType

// Downloads.Discard (Request)

type DownloadsDiscardType struct {}

var _ RequestMessage = (*DownloadsDiscardType)(nil)

func (r *DownloadsDiscardType) Method() string {
  return "Downloads.Discard"
}

func (r *DownloadsDiscardType) Register(router router, f func(*butlerd.RequestContext, butlerd.DownloadsDiscardParams) (*butlerd.DownloadsDiscardResult, error)) {
  router.Register("Downloads.Discard", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.DownloadsDiscardParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Downloads.Discard")
    }
    return res, nil
  })
}

func (r *DownloadsDiscardType) TestCall(rc *butlerd.RequestContext, params butlerd.DownloadsDiscardParams) (*butlerd.DownloadsDiscardResult, error) {
  var result butlerd.DownloadsDiscardResult
  err := rc.Call("Downloads.Discard", params, &result)
  return &result, err
}

var DownloadsDiscard *DownloadsDiscardType


//==============================
// Update
//==============================

// CheckUpdate (Request)

type CheckUpdateType struct {}

var _ RequestMessage = (*CheckUpdateType)(nil)

func (r *CheckUpdateType) Method() string {
  return "CheckUpdate"
}

func (r *CheckUpdateType) Register(router router, f func(*butlerd.RequestContext, butlerd.CheckUpdateParams) (*butlerd.CheckUpdateResult, error)) {
  router.Register("CheckUpdate", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.CheckUpdateParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for CheckUpdate")
    }
    return res, nil
  })
}

func (r *CheckUpdateType) TestCall(rc *butlerd.RequestContext, params butlerd.CheckUpdateParams) (*butlerd.CheckUpdateResult, error) {
  var result butlerd.CheckUpdateResult
  err := rc.Call("CheckUpdate", params, &result)
  return &result, err
}

var CheckUpdate *CheckUpdateType

// GameUpdateAvailable (Notification)

type GameUpdateAvailableType struct {}

var _ NotificationMessage = (*GameUpdateAvailableType)(nil)

func (r *GameUpdateAvailableType) Method() string {
  return "GameUpdateAvailable"
}

func (r *GameUpdateAvailableType) Notify(rc *butlerd.RequestContext, params butlerd.GameUpdateAvailableNotification) (error) {
  return rc.Notify("GameUpdateAvailable", params)
}

func (r *GameUpdateAvailableType) Register(router router, f func(butlerd.GameUpdateAvailableNotification)) {
  router.RegisterNotification("GameUpdateAvailable", func (notif jsonrpc2.Notification) {
    var params butlerd.GameUpdateAvailableNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var GameUpdateAvailable *GameUpdateAvailableType

// SnoozeCave (Request)

type SnoozeCaveType struct {}

var _ RequestMessage = (*SnoozeCaveType)(nil)

func (r *SnoozeCaveType) Method() string {
  return "SnoozeCave"
}

func (r *SnoozeCaveType) Register(router router, f func(*butlerd.RequestContext, butlerd.SnoozeCaveParams) (*butlerd.SnoozeCaveResult, error)) {
  router.Register("SnoozeCave", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.SnoozeCaveParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for SnoozeCave")
    }
    return res, nil
  })
}

func (r *SnoozeCaveType) TestCall(rc *butlerd.RequestContext, params butlerd.SnoozeCaveParams) (*butlerd.SnoozeCaveResult, error) {
  var result butlerd.SnoozeCaveResult
  err := rc.Call("SnoozeCave", params, &result)
  return &result, err
}

var SnoozeCave *SnoozeCaveType


//==============================
// update
//==============================


//==============================
// Launch
//==============================

// Launch (Request)

type LaunchType struct {}

var _ RequestMessage = (*LaunchType)(nil)

func (r *LaunchType) Method() string {
  return "Launch"
}

func (r *LaunchType) Register(router router, f func(*butlerd.RequestContext, butlerd.LaunchParams) (*butlerd.LaunchResult, error)) {
  router.Register("Launch", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.LaunchParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Launch")
    }
    return res, nil
  })
}

func (r *LaunchType) TestCall(rc *butlerd.RequestContext, params butlerd.LaunchParams) (*butlerd.LaunchResult, error) {
  var result butlerd.LaunchResult
  err := rc.Call("Launch", params, &result)
  return &result, err
}

var Launch *LaunchType

// LaunchRunning (Notification)

type LaunchRunningType struct {}

var _ NotificationMessage = (*LaunchRunningType)(nil)

func (r *LaunchRunningType) Method() string {
  return "LaunchRunning"
}

func (r *LaunchRunningType) Notify(rc *butlerd.RequestContext, params butlerd.LaunchRunningNotification) (error) {
  return rc.Notify("LaunchRunning", params)
}

func (r *LaunchRunningType) Register(router router, f func(butlerd.LaunchRunningNotification)) {
  router.RegisterNotification("LaunchRunning", func (notif jsonrpc2.Notification) {
    var params butlerd.LaunchRunningNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var LaunchRunning *LaunchRunningType

// LaunchExited (Notification)

type LaunchExitedType struct {}

var _ NotificationMessage = (*LaunchExitedType)(nil)

func (r *LaunchExitedType) Method() string {
  return "LaunchExited"
}

func (r *LaunchExitedType) Notify(rc *butlerd.RequestContext, params butlerd.LaunchExitedNotification) (error) {
  return rc.Notify("LaunchExited", params)
}

func (r *LaunchExitedType) Register(router router, f func(butlerd.LaunchExitedNotification)) {
  router.RegisterNotification("LaunchExited", func (notif jsonrpc2.Notification) {
    var params butlerd.LaunchExitedNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var LaunchExited *LaunchExitedType

// AcceptLicense (Request)

type AcceptLicenseType struct {}

var _ RequestMessage = (*AcceptLicenseType)(nil)

func (r *AcceptLicenseType) Method() string {
  return "AcceptLicense"
}

func (r *AcceptLicenseType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.AcceptLicenseParams) (*butlerd.AcceptLicenseResult, error)) {
  router.Register("AcceptLicense", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.AcceptLicenseParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for AcceptLicense")
    }
    return res, nil
  })
}

func (r *AcceptLicenseType) Call(rc *butlerd.RequestContext, params butlerd.AcceptLicenseParams) (*butlerd.AcceptLicenseResult, error) {
  var result butlerd.AcceptLicenseResult
  err := rc.Call("AcceptLicense", params, &result)
  return &result, err
}

var AcceptLicense *AcceptLicenseType

// PickManifestAction (Request)

type PickManifestActionType struct {}

var _ RequestMessage = (*PickManifestActionType)(nil)

func (r *PickManifestActionType) Method() string {
  return "PickManifestAction"
}

func (r *PickManifestActionType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.PickManifestActionParams) (*butlerd.PickManifestActionResult, error)) {
  router.Register("PickManifestAction", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.PickManifestActionParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for PickManifestAction")
    }
    return res, nil
  })
}

func (r *PickManifestActionType) Call(rc *butlerd.RequestContext, params butlerd.PickManifestActionParams) (*butlerd.PickManifestActionResult, error) {
  var result butlerd.PickManifestActionResult
  err := rc.Call("PickManifestAction", params, &result)
  return &result, err
}

var PickManifestAction *PickManifestActionType

// ShellLaunch (Request)

type ShellLaunchType struct {}

var _ RequestMessage = (*ShellLaunchType)(nil)

func (r *ShellLaunchType) Method() string {
  return "ShellLaunch"
}

func (r *ShellLaunchType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.ShellLaunchParams) (*butlerd.ShellLaunchResult, error)) {
  router.Register("ShellLaunch", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.ShellLaunchParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for ShellLaunch")
    }
    return res, nil
  })
}

func (r *ShellLaunchType) Call(rc *butlerd.RequestContext, params butlerd.ShellLaunchParams) (*butlerd.ShellLaunchResult, error) {
  var result butlerd.ShellLaunchResult
  err := rc.Call("ShellLaunch", params, &result)
  return &result, err
}

var ShellLaunch *ShellLaunchType

// HTMLLaunch (Request)

type HTMLLaunchType struct {}

var _ RequestMessage = (*HTMLLaunchType)(nil)

func (r *HTMLLaunchType) Method() string {
  return "HTMLLaunch"
}

func (r *HTMLLaunchType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.HTMLLaunchParams) (*butlerd.HTMLLaunchResult, error)) {
  router.Register("HTMLLaunch", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.HTMLLaunchParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for HTMLLaunch")
    }
    return res, nil
  })
}

func (r *HTMLLaunchType) Call(rc *butlerd.RequestContext, params butlerd.HTMLLaunchParams) (*butlerd.HTMLLaunchResult, error) {
  var result butlerd.HTMLLaunchResult
  err := rc.Call("HTMLLaunch", params, &result)
  return &result, err
}

var HTMLLaunch *HTMLLaunchType

// URLLaunch (Request)

type URLLaunchType struct {}

var _ RequestMessage = (*URLLaunchType)(nil)

func (r *URLLaunchType) Method() string {
  return "URLLaunch"
}

func (r *URLLaunchType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.URLLaunchParams) (*butlerd.URLLaunchResult, error)) {
  router.Register("URLLaunch", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.URLLaunchParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for URLLaunch")
    }
    return res, nil
  })
}

func (r *URLLaunchType) Call(rc *butlerd.RequestContext, params butlerd.URLLaunchParams) (*butlerd.URLLaunchResult, error) {
  var result butlerd.URLLaunchResult
  err := rc.Call("URLLaunch", params, &result)
  return &result, err
}

var URLLaunch *URLLaunchType

// AllowSandboxSetup (Request)

type AllowSandboxSetupType struct {}

var _ RequestMessage = (*AllowSandboxSetupType)(nil)

func (r *AllowSandboxSetupType) Method() string {
  return "AllowSandboxSetup"
}

func (r *AllowSandboxSetupType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.AllowSandboxSetupParams) (*butlerd.AllowSandboxSetupResult, error)) {
  router.Register("AllowSandboxSetup", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.AllowSandboxSetupParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for AllowSandboxSetup")
    }
    return res, nil
  })
}

func (r *AllowSandboxSetupType) Call(rc *butlerd.RequestContext, params butlerd.AllowSandboxSetupParams) (*butlerd.AllowSandboxSetupResult, error) {
  var result butlerd.AllowSandboxSetupResult
  err := rc.Call("AllowSandboxSetup", params, &result)
  return &result, err
}

var AllowSandboxSetup *AllowSandboxSetupType

// PrereqsStarted (Notification)

type PrereqsStartedType struct {}

var _ NotificationMessage = (*PrereqsStartedType)(nil)

func (r *PrereqsStartedType) Method() string {
  return "PrereqsStarted"
}

func (r *PrereqsStartedType) Notify(rc *butlerd.RequestContext, params butlerd.PrereqsStartedNotification) (error) {
  return rc.Notify("PrereqsStarted", params)
}

func (r *PrereqsStartedType) Register(router router, f func(butlerd.PrereqsStartedNotification)) {
  router.RegisterNotification("PrereqsStarted", func (notif jsonrpc2.Notification) {
    var params butlerd.PrereqsStartedNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var PrereqsStarted *PrereqsStartedType

// PrereqsTaskState (Notification)

type PrereqsTaskStateType struct {}

var _ NotificationMessage = (*PrereqsTaskStateType)(nil)

func (r *PrereqsTaskStateType) Method() string {
  return "PrereqsTaskState"
}

func (r *PrereqsTaskStateType) Notify(rc *butlerd.RequestContext, params butlerd.PrereqsTaskStateNotification) (error) {
  return rc.Notify("PrereqsTaskState", params)
}

func (r *PrereqsTaskStateType) Register(router router, f func(butlerd.PrereqsTaskStateNotification)) {
  router.RegisterNotification("PrereqsTaskState", func (notif jsonrpc2.Notification) {
    var params butlerd.PrereqsTaskStateNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var PrereqsTaskState *PrereqsTaskStateType

// PrereqsEnded (Notification)

type PrereqsEndedType struct {}

var _ NotificationMessage = (*PrereqsEndedType)(nil)

func (r *PrereqsEndedType) Method() string {
  return "PrereqsEnded"
}

func (r *PrereqsEndedType) Notify(rc *butlerd.RequestContext, params butlerd.PrereqsEndedNotification) (error) {
  return rc.Notify("PrereqsEnded", params)
}

func (r *PrereqsEndedType) Register(router router, f func(butlerd.PrereqsEndedNotification)) {
  router.RegisterNotification("PrereqsEnded", func (notif jsonrpc2.Notification) {
    var params butlerd.PrereqsEndedNotification
    if notif.Params != nil {
      err := json.Unmarshal(*notif.Params, &params)
      if err != nil {
        return
      }
    }
    f(params)
  })
}

var PrereqsEnded *PrereqsEndedType

// PrereqsFailed (Request)

type PrereqsFailedType struct {}

var _ RequestMessage = (*PrereqsFailedType)(nil)

func (r *PrereqsFailedType) Method() string {
  return "PrereqsFailed"
}

func (r *PrereqsFailedType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.PrereqsFailedParams) (*butlerd.PrereqsFailedResult, error)) {
  router.Register("PrereqsFailed", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.PrereqsFailedParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for PrereqsFailed")
    }
    return res, nil
  })
}

func (r *PrereqsFailedType) Call(rc *butlerd.RequestContext, params butlerd.PrereqsFailedParams) (*butlerd.PrereqsFailedResult, error) {
  var result butlerd.PrereqsFailedResult
  err := rc.Call("PrereqsFailed", params, &result)
  return &result, err
}

var PrereqsFailed *PrereqsFailedType


//==============================
// Clean Downloads
//==============================

// CleanDownloads.Search (Request)

type CleanDownloadsSearchType struct {}

var _ RequestMessage = (*CleanDownloadsSearchType)(nil)

func (r *CleanDownloadsSearchType) Method() string {
  return "CleanDownloads.Search"
}

func (r *CleanDownloadsSearchType) Register(router router, f func(*butlerd.RequestContext, butlerd.CleanDownloadsSearchParams) (*butlerd.CleanDownloadsSearchResult, error)) {
  router.Register("CleanDownloads.Search", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.CleanDownloadsSearchParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for CleanDownloads.Search")
    }
    return res, nil
  })
}

func (r *CleanDownloadsSearchType) TestCall(rc *butlerd.RequestContext, params butlerd.CleanDownloadsSearchParams) (*butlerd.CleanDownloadsSearchResult, error) {
  var result butlerd.CleanDownloadsSearchResult
  err := rc.Call("CleanDownloads.Search", params, &result)
  return &result, err
}

var CleanDownloadsSearch *CleanDownloadsSearchType

// CleanDownloads.Apply (Request)

type CleanDownloadsApplyType struct {}

var _ RequestMessage = (*CleanDownloadsApplyType)(nil)

func (r *CleanDownloadsApplyType) Method() string {
  return "CleanDownloads.Apply"
}

func (r *CleanDownloadsApplyType) Register(router router, f func(*butlerd.RequestContext, butlerd.CleanDownloadsApplyParams) (*butlerd.CleanDownloadsApplyResult, error)) {
  router.Register("CleanDownloads.Apply", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.CleanDownloadsApplyParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for CleanDownloads.Apply")
    }
    return res, nil
  })
}

func (r *CleanDownloadsApplyType) TestCall(rc *butlerd.RequestContext, params butlerd.CleanDownloadsApplyParams) (*butlerd.CleanDownloadsApplyResult, error) {
  var result butlerd.CleanDownloadsApplyResult
  err := rc.Call("CleanDownloads.Apply", params, &result)
  return &result, err
}

var CleanDownloadsApply *CleanDownloadsApplyType


//==============================
// System
//==============================

// System.StatFS (Request)

type SystemStatFSType struct {}

var _ RequestMessage = (*SystemStatFSType)(nil)

func (r *SystemStatFSType) Method() string {
  return "System.StatFS"
}

func (r *SystemStatFSType) Register(router router, f func(*butlerd.RequestContext, butlerd.SystemStatFSParams) (*butlerd.SystemStatFSResult, error)) {
  router.Register("System.StatFS", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.SystemStatFSParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for System.StatFS")
    }
    return res, nil
  })
}

func (r *SystemStatFSType) TestCall(rc *butlerd.RequestContext, params butlerd.SystemStatFSParams) (*butlerd.SystemStatFSResult, error) {
  var result butlerd.SystemStatFSResult
  err := rc.Call("System.StatFS", params, &result)
  return &result, err
}

var SystemStatFS *SystemStatFSType


//==============================
// Test
//==============================

// Test.DoubleTwice (Request)

type TestDoubleTwiceType struct {}

var _ RequestMessage = (*TestDoubleTwiceType)(nil)

func (r *TestDoubleTwiceType) Method() string {
  return "Test.DoubleTwice"
}

func (r *TestDoubleTwiceType) Register(router router, f func(*butlerd.RequestContext, butlerd.TestDoubleTwiceParams) (*butlerd.TestDoubleTwiceResult, error)) {
  router.Register("Test.DoubleTwice", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.TestDoubleTwiceParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Test.DoubleTwice")
    }
    return res, nil
  })
}

func (r *TestDoubleTwiceType) TestCall(rc *butlerd.RequestContext, params butlerd.TestDoubleTwiceParams) (*butlerd.TestDoubleTwiceResult, error) {
  var result butlerd.TestDoubleTwiceResult
  err := rc.Call("Test.DoubleTwice", params, &result)
  return &result, err
}

var TestDoubleTwice *TestDoubleTwiceType

// Test.Double (Request)

type TestDoubleType struct {}

var _ RequestMessage = (*TestDoubleType)(nil)

func (r *TestDoubleType) Method() string {
  return "Test.Double"
}

func (r *TestDoubleType) TestRegister(router router, f func(*butlerd.RequestContext, butlerd.TestDoubleParams) (*butlerd.TestDoubleResult, error)) {
  router.Register("Test.Double", func (rc *butlerd.RequestContext) (interface{}, error) {
    var params butlerd.TestDoubleParams
    err := json.Unmarshal(*rc.Params, &params)
    if err != nil {
    	return nil, &butlerd.RpcError{Code: jsonrpc2.CodeParseError, Message: err.Error()}
    }
    err = params.Validate()
    if err != nil {
    	return nil, err
    }
    res, err := f(rc, params)
    if err != nil {
    	return nil, err
    }
    if res == nil {
    	return nil, errors.New("internal error: nil result for Test.Double")
    }
    return res, nil
  })
}

func (r *TestDoubleType) Call(rc *butlerd.RequestContext, params butlerd.TestDoubleParams) (*butlerd.TestDoubleResult, error) {
  var result butlerd.TestDoubleResult
  err := rc.Call("Test.Double", params, &result)
  return &result, err
}

var TestDouble *TestDoubleType


func EnsureAllRequests(router *butlerd.Router) {
  if _, ok := router.Handlers["Meta.Authenticate"]; !ok { panic("missing request handler for (Meta.Authenticate)") }
  if _, ok := router.Handlers["Meta.Flow"]; !ok { panic("missing request handler for (Meta.Flow)") }
  if _, ok := router.Handlers["Meta.Shutdown"]; !ok { panic("missing request handler for (Meta.Shutdown)") }
  if _, ok := router.Handlers["Version.Get"]; !ok { panic("missing request handler for (Version.Get)") }
  if _, ok := router.Handlers["Network.SetSimulateOffline"]; !ok { panic("missing request handler for (Network.SetSimulateOffline)") }
  if _, ok := router.Handlers["Network.SetBandwidthThrottle"]; !ok { panic("missing request handler for (Network.SetBandwidthThrottle)") }
  if _, ok := router.Handlers["Profile.List"]; !ok { panic("missing request handler for (Profile.List)") }
  if _, ok := router.Handlers["Profile.LoginWithPassword"]; !ok { panic("missing request handler for (Profile.LoginWithPassword)") }
  if _, ok := router.Handlers["Profile.LoginWithAPIKey"]; !ok { panic("missing request handler for (Profile.LoginWithAPIKey)") }
  if _, ok := router.Handlers["Profile.LoginWithOAuthCode"]; !ok { panic("missing request handler for (Profile.LoginWithOAuthCode)") }
  if _, ok := router.Handlers["Profile.UseSavedLogin"]; !ok { panic("missing request handler for (Profile.UseSavedLogin)") }
  if _, ok := router.Handlers["Profile.Forget"]; !ok { panic("missing request handler for (Profile.Forget)") }
  if _, ok := router.Handlers["Profile.Data.Put"]; !ok { panic("missing request handler for (Profile.Data.Put)") }
  if _, ok := router.Handlers["Profile.Data.Get"]; !ok { panic("missing request handler for (Profile.Data.Get)") }
  if _, ok := router.Handlers["Search.Games"]; !ok { panic("missing request handler for (Search.Games)") }
  if _, ok := router.Handlers["Search.Users"]; !ok { panic("missing request handler for (Search.Users)") }
  if _, ok := router.Handlers["Fetch.Game"]; !ok { panic("missing request handler for (Fetch.Game)") }
  if _, ok := router.Handlers["Fetch.GameRecords"]; !ok { panic("missing request handler for (Fetch.GameRecords)") }
  if _, ok := router.Handlers["Fetch.DownloadKey"]; !ok { panic("missing request handler for (Fetch.DownloadKey)") }
  if _, ok := router.Handlers["Fetch.DownloadKeys"]; !ok { panic("missing request handler for (Fetch.DownloadKeys)") }
  if _, ok := router.Handlers["Fetch.GameUploads"]; !ok { panic("missing request handler for (Fetch.GameUploads)") }
  if _, ok := router.Handlers["Fetch.User"]; !ok { panic("missing request handler for (Fetch.User)") }
  if _, ok := router.Handlers["Fetch.Sale"]; !ok { panic("missing request handler for (Fetch.Sale)") }
  if _, ok := router.Handlers["Fetch.Collection"]; !ok { panic("missing request handler for (Fetch.Collection)") }
  if _, ok := router.Handlers["Fetch.Collection.Games"]; !ok { panic("missing request handler for (Fetch.Collection.Games)") }
  if _, ok := router.Handlers["Fetch.ProfileCollections"]; !ok { panic("missing request handler for (Fetch.ProfileCollections)") }
  if _, ok := router.Handlers["Fetch.ProfileGames"]; !ok { panic("missing request handler for (Fetch.ProfileGames)") }
  if _, ok := router.Handlers["Fetch.ProfileOwnedKeys"]; !ok { panic("missing request handler for (Fetch.ProfileOwnedKeys)") }
  if _, ok := router.Handlers["Fetch.Commons"]; !ok { panic("missing request handler for (Fetch.Commons)") }
  if _, ok := router.Handlers["Fetch.Caves"]; !ok { panic("missing request handler for (Fetch.Caves)") }
  if _, ok := router.Handlers["Fetch.Cave"]; !ok { panic("missing request handler for (Fetch.Cave)") }
  if _, ok := router.Handlers["Fetch.ExpireAll"]; !ok { panic("missing request handler for (Fetch.ExpireAll)") }
  if _, ok := router.Handlers["Game.FindUploads"]; !ok { panic("missing request handler for (Game.FindUploads)") }
  if _, ok := router.Handlers["Install.Queue"]; !ok { panic("missing request handler for (Install.Queue)") }
  if _, ok := router.Handlers["Install.Plan"]; !ok { panic("missing request handler for (Install.Plan)") }
  if _, ok := router.Handlers["Caves.SetPinned"]; !ok { panic("missing request handler for (Caves.SetPinned)") }
  if _, ok := router.Handlers["Install.CreateShortcut"]; !ok { panic("missing request handler for (Install.CreateShortcut)") }
  if _, ok := router.Handlers["Install.Perform"]; !ok { panic("missing request handler for (Install.Perform)") }
  if _, ok := router.Handlers["Install.Cancel"]; !ok { panic("missing request handler for (Install.Cancel)") }
  if _, ok := router.Handlers["Uninstall.Perform"]; !ok { panic("missing request handler for (Uninstall.Perform)") }
  if _, ok := router.Handlers["Install.VersionSwitch.Queue"]; !ok { panic("missing request handler for (Install.VersionSwitch.Queue)") }
  if _, ok := router.Handlers["Install.Locations.List"]; !ok { panic("missing request handler for (Install.Locations.List)") }
  if _, ok := router.Handlers["Install.Locations.Add"]; !ok { panic("missing request handler for (Install.Locations.Add)") }
  if _, ok := router.Handlers["Install.Locations.Remove"]; !ok { panic("missing request handler for (Install.Locations.Remove)") }
  if _, ok := router.Handlers["Install.Locations.GetByID"]; !ok { panic("missing request handler for (Install.Locations.GetByID)") }
  if _, ok := router.Handlers["Install.Locations.Scan"]; !ok { panic("missing request handler for (Install.Locations.Scan)") }
  if _, ok := router.Handlers["Downloads.Queue"]; !ok { panic("missing request handler for (Downloads.Queue)") }
  if _, ok := router.Handlers["Downloads.Prioritize"]; !ok { panic("missing request handler for (Downloads.Prioritize)") }
  if _, ok := router.Handlers["Downloads.List"]; !ok { panic("missing request handler for (Downloads.List)") }
  if _, ok := router.Handlers["Downloads.ClearFinished"]; !ok { panic("missing request handler for (Downloads.ClearFinished)") }
  if _, ok := router.Handlers["Downloads.Drive"]; !ok { panic("missing request handler for (Downloads.Drive)") }
  if _, ok := router.Handlers["Downloads.Drive.Cancel"]; !ok { panic("missing request handler for (Downloads.Drive.Cancel)") }
  if _, ok := router.Handlers["Downloads.Retry"]; !ok { panic("missing request handler for (Downloads.Retry)") }
  if _, ok := router.Handlers["Downloads.Discard"]; !ok { panic("missing request handler for (Downloads.Discard)") }
  if _, ok := router.Handlers["CheckUpdate"]; !ok { panic("missing request handler for (CheckUpdate)") }
  if _, ok := router.Handlers["SnoozeCave"]; !ok { panic("missing request handler for (SnoozeCave)") }
  if _, ok := router.Handlers["Launch"]; !ok { panic("missing request handler for (Launch)") }
  if _, ok := router.Handlers["CleanDownloads.Search"]; !ok { panic("missing request handler for (CleanDownloads.Search)") }
  if _, ok := router.Handlers["CleanDownloads.Apply"]; !ok { panic("missing request handler for (CleanDownloads.Apply)") }
  if _, ok := router.Handlers["System.StatFS"]; !ok { panic("missing request handler for (System.StatFS)") }
  if _, ok := router.Handlers["Test.DoubleTwice"]; !ok { panic("missing request handler for (Test.DoubleTwice)") }
}

