///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAttrAlias.cc
// -----------------
// Cego database table attribute alias description
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2019 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoAttrDesc
// 
// Description: Table attribute alias container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoAttrAlias.h"
#include "CegoXMLdef.h"
#include "CegoDatabaseFormater.h"

// POSIX INCLUDES
#include <stdlib.h>
#include <string.h>

CegoAttrAlias::CegoAttrAlias()
{
}

CegoAttrAlias::CegoAttrAlias(const Chain& aliasName)
{
    _aliasName = aliasName;
}

CegoAttrAlias::CegoAttrAlias(const Chain& attrName, const Chain& aliasName)
{
    _attrName = attrName;
    _aliasName = aliasName;
}
 
CegoAttrAlias::~CegoAttrAlias()
{
}

void CegoAttrAlias::setAttrName(const Chain& attrName)
{
    _attrName = attrName;
}

const Chain& CegoAttrAlias::getAttrName() const
{
    return _attrName;
}

void CegoAttrAlias::setAliasName(const Chain& aliasName)
{
    _aliasName = aliasName;
}

const Chain& CegoAttrAlias::getAliasName() const
{
    return _aliasName;
}

CegoAttrAlias* CegoAttrAlias::clone() const
{
    return ( new CegoAttrAlias(_attrName, _aliasName));
}

CegoAttrAlias& CegoAttrAlias::operator = ( const CegoAttrAlias& ad )
{
    _attrName = ad._attrName;
    _aliasName = ad._aliasName;
    return (*this);
}

bool CegoAttrAlias::operator == ( const CegoAttrAlias& ad) const
{    
    if ( _aliasName == ad._aliasName )
	return true;
    return false;
}

bool CegoAttrAlias::operator != ( const CegoAttrAlias& ad) const
{    
    if ( _aliasName ==  ad._aliasName)
	return false;
    return true;
}

Chain CegoAttrAlias::toChain() const
{
    Chain s;    
    s = _attrName + " as " + _aliasName;
    return s;
}

void CegoAttrAlias::encode(char *buf)
{   
    char* pE = (char*)buf;

    char len = _attrName.length();
    memcpy( pE, &len, sizeof(char));
    pE = pE + sizeof(char);
    memcpy( pE, (char*)_attrName, len);
    pE = pE + len;
    
    len = _aliasName.length();
    memcpy( pE, &len, sizeof(char));
    pE = pE + sizeof(char);    
    memcpy( pE, (char*)_aliasName, len);
    pE = pE + len;
}

void CegoAttrAlias::decode(char *buf)
{
    char* pE = (char*)buf;

    char len;
    
    memcpy( &len, pE, sizeof(char));
    pE = pE + sizeof(char);
    _attrName = Chain(pE, len-1);
    pE = pE + len;

    memcpy( &len, pE, sizeof(char));
    pE = pE + sizeof(char);
    _aliasName = Chain(pE, len-1);
    pE = pE + len;
}

int CegoAttrAlias::getEncodingLength() const
{
    int len = 0;
    
    len += sizeof(char);
    len += _attrName.length();

    len += sizeof(char);
    len += _aliasName.length();

    return len;
}


ostream& operator << (ostream& s, const CegoAttrAlias& a)
{
    s <<  a._attrName << " as " << a._aliasName;
    return s;
}
