# What APIs are included?

All Windows APIs provided by the Windows SDK are included, with a few exceptions. The definitions of these APIs are collected from [metadata and transformed into Rust bindings](how-are-crates-built.md). The process of generating the Rust bindings purposefully omits a few APIs. APIs are only excluded if they are (1) unsuitable for Rust developers and (2) impose a large hit on the overall size of the [windows](https://crates.io/crates/windows) and [windows-sys](https://crates.io/crates/windows-sys) crates. 

The Xaml API is excluded because it is all but unusable without direct language support that only the Xaml team can provide. Xaml is also focused and tailored for C# app development so this API isn't applicable to Rust developers. The MsHtml API is also excluded because it is only intended for Microsoft's older scripting languages like JScript and VBScript. It is also by far the single largest module as measured in lines of code. Beyond that, a few deprecrated and unusable APIs are excluded. You can see exactly what the [windows crate excludes](https://github.com/microsoft/windows-rs/blob/59950e2e2b7bd79f2de2020ee33745d7f642230f/crates/tools/windows/src/main.rs#L4-L5) and what the [windows-sys crate excludes](https://github.com/microsoft/windows-rs/blob/59950e2e2b7bd79f2de2020ee33745d7f642230f/crates/tools/sys/src/main.rs#L5-L35).

Beyond that, the `windows-sys` crate currently excludes all COM and WinRT APIs. The `windows-sys` crate only includes declarations and COM and WinRT calls are far too cumbersome without the abstractions provided by the windows crate. Here are some tips for [choosing between the windows and windows-sys crates](windows-or-windows-sys.md).
