# In Rust translations
rust_init_error_title = Critical Error During App Startup
rust_init_error_message =
    A critical error occurred while starting the application:

    { $error_message }

    This may be caused by missing or malfunctioning OpenGL/Vulkan drivers, running the application in a virtual machine or a bug in Krokiet or one of its libraries.

    You can try running different builds (skia_opengl, skia_vulkan, femtovg_opengl - the default) or with software renderer to see if that resolves the issue.

rust_loaded_preset = Loaded preset { $preset_idx }
rust_file_already_exists = File "{ $file }" already exists, and will not be overridden
rust_error_removing_file_after_copy = Error while removing file "{ $file }" (after copying into different partition), reason: { $reason }
rust_error_copying_file = Error while copying "{ $input }" to "{ $output }", reason: { $reason }
rust_loading_tags_cache = Loading tags cache
rust_loading_fingerprints_cache = Loading fingerprints cache
rust_saving_tags_cache = Saving tags cache
rust_saving_fingerprints_cache = Saving fingerprints cache
rust_loading_prehash_cache = Loading prehash cache
rust_saving_prehash_cache = Saving prehash cache
rust_loading_hash_cache = Loading hash cache
rust_saving_hash_cache = Saving hash cache
rust_loading_exif_cache = Loading EXIF cache
rust_saving_exif_cache = Saving EXIF cache
rust_scanning_name = Scanning name of { $entries_checked } file
rust_scanning_size_name = Scanning size and name of { $entries_checked } file
rust_scanning_size = Scanning size of { $entries_checked } file
rust_scanning_file = Scanning { $entries_checked } file
rust_scanning_folder = Scanning { $entries_checked } folder
rust_checked_tags = Checked tags of { $items_stats }
rust_checked_content = Checked content of { $items_stats } ({ $size_stats })
rust_compared_tags = Compared tags of { $items_stats }
rust_compared_content = Compared content of { $items_stats }
rust_hashed_images = Hashed { $items_stats } images ({ $size_stats })
rust_compared_image_hashes = Compared image hashes of { $items_stats }
rust_hashed_videos = Hashed { $items_stats } videos
rust_created_thumbnails = Created thumbnails for { $items_stats } videos
rust_checked_files = Checked { $items_stats } file ({ $size_stats })
rust_checked_files_bad_extensions = Checked { $items_stats } file
rust_checked_files_bad_names = Checked { $items_stats } file
rust_checked_videos = Checked { $items_stats } videos ({ $size_stats })
rust_analyzed_partial_hash = Analyzed partial hash of { $items_stats } files ({ $size_stats })
rust_analyzed_full_hash = Analyzed full hash of { $items_stats } files ({ $size_stats })
rust_failed_to_rename_file = Failed to rename file { $old_path } to { $new_path }, error: { $error }
rust_no_included_paths = Cannot start scan when no included paths are set.
rust_all_paths_referenced = Cannot start scan when all included paths are set as referenced paths, you need to disable reference checkbox next to input path.
rust_found_empty_folders = Found { $items_found } empty folders in { $time }
rust_found_empty_files = Found { $items_found } empty files in { $time }
rust_found_similar_images = Found { $items_found } similar image files in { $groups } groups in { $time }
rust_found_similar_videos = Found { $items_found } similar video files in { $groups } groups in { $time }
rust_found_similar_music_files = Found { $items_found } similar music files in { $groups } groups in { $time }
rust_found_invalid_symlinks = Found { $items_found } invalid symlinks in { $time }
rust_found_temporary_files = Found { $items_found } temporary files in { $time }
rust_no_file_type_selected = Cannot find broken files without any selected file type.
rust_found_broken_files = Found { $items_found } broken files taking { $size } in { $time }
rust_found_bad_extensions = Found { $items_found } files with bad extensions in { $time }
rust_found_bad_names = Found { $items_found } files with bad names in { $time }
rust_found_video_optimizer = Found { $items_found } files to optimize in { $time }
rust_found_duplicate_files = Found { $items_found } duplicate files in { $groups } groups taking { $size } in { $time }
rust_found_duplicate_files_no_lost_space = Found { $items_found } duplicate files in { $groups } groups in { $time }
rust_found_big_files = Found { $items_found } big files with size { $size } in { $time }
rust_found_exif_files = Found { $items_found } files with exif data in { $time }
rust_cannot_load_preset = Cannot change and load preset { $preset_idx } - reason { $reason }, using default settings instead
rust_saved_preset = Saved preset { $preset_idx }
rust_cannot_save_preset = Cannot save preset { $preset_idx } - reason { $reason }
rust_reset_preset = Reset preset { $preset_idx }
rust_cannot_create_output_folder = Cannot create output folder { $output_folder }, reason: { $error }

rust_delete_summary = Deleted { $deleted } items, failed to remove { $failed } items, out of { $total } items
rust_rename_summary = Renamed { $renamed } items, failed to rename { $failed } items, out of { $total } items
rust_move_summary = Moved { $moved } items, failed to move { $failed } items, out of { $total } items
rust_hardlink_summary = Hardlinked { $hardlinked } items, failed to hardlink { $failed } items, out of { $total } items
rust_symlink_summary = Symlinked { $symlinked } items, failed to symlink { $failed } items, out of { $total } items
rust_optimize_video_summary = Optimized { $optimized } videos, failed to optimize { $failed } videos, out of { $total } videos
rust_clean_exif_summary = Cleaned EXIF from { $cleaned } files, failed to clean { $failed } files, out of { $total } files
rust_deleting_files = Deleting { $items_stats } file ({ $size_stats })
rust_deleting_no_size_files = Deleting { $items_stats } file
rust_renaming_files = Renaming { $items_stats } file
rust_moving_files = Moving { $items_stats } file ({ $size_stats })
rust_moving_no_size_files = Moving { $items_stats } file
rust_hardlinking_files = Hardlinking { $items_stats } file ({ $size_stats })
rust_hardlinking_no_size_files = Hardlinking { $items_stats } file
rust_symlinking_files = Symlinking { $items_stats } file ({ $size_stats })
rust_symlinking_no_size_files = Symlinking { $items_stats } file
rust_optimizing_videos = Optimized { $items_stats } video ({ $size_stats })
rust_optimizing_no_size_videos = Optimized { $items_stats } video
rust_cleaning_exif = Cleaning EXIF from { $items_stats } file ({ $size_stats })
rust_cleaning_no_size_exif = Cleaning EXIF from { $items_stats } file
rust_no_files_deleted = No files or folders selected for deletion
rust_no_files_renamed = No files or folders selected for renaming
rust_no_files_moved = No files or folders selected for moving
rust_no_files_hardlinked = No files or folders selected for hardlinking
rust_no_files_symlinked = No files or folders selected for symlinking
rust_no_videos_optimized = No videos selected for optimization
rust_no_exif_cleaned = No files selected for EXIF cleaning
rust_extracted_exif_tags = Extracted EXIF tags from { $items_stats } files ({ $size_stats })

rust_delete_confirmation = Are you sure you want to delete the selected items?
rust_delete_confirmation_number_simple = { $items } items selected.
rust_delete_confirmation_number_groups = { $items } items selected in { $groups } groups.
rust_delete_confirmation_selected_all_in_group = All items selected in { $groups } groups.

rust_move_confirmation = Are you sure you want to move the selected items?
rust_move_confirmation_number_simple = { $items } items selected.

rust_clean_exif_confirmation = Are you sure you want to remove EXIF data from the selected items?
rust_clean_exif_confirmation_number_simple = { $items } items selected.

clean_exif_overwrite_files_text = Overwrite files

rust_optimize_video_confirmation = Are you sure you want to optimize the selected videos?
rust_optimize_video_confirmation_number_simple = { $items } items selected.

rust_hardlink_confirmation = Are you sure you want to create hardlinks for the selected items?
rust_hardlink_confirmation_number_simple = { $items } items selected.

rust_symlink_confirmation = Are you sure you want to create symlinks for the selected items?
rust_symlink_confirmation_number_simple = { $items } items selected.

rust_rename_confirmation = Are you sure you want to rename the selected items?
rust_rename_confirmation_number_simple = { $items } items selected.

rust_cache_processed_files = Processed { $files } cache files
rust_cache_entries_stats = Removed { $removed } entries out of all { $all }, { $left } left
rust_cache_size_reduced = Reduced cache files size by { $size }
rust_cache_time_elapsed = Time elapsed: { $time }

rust_symlink_failed = Failed to symlink {$name} to {$target}, reason {$reason}
rust_hardlink_failed = Failed to hardlink { $name } to { $target }, reason { $reason }

# Slint translations, but in arrays

column_selection = Selection
column_size = Size
column_file_name = File Name
column_path = Path
column_modification_date = Modification Date
column_similarity = Similarity
column_dimensions = Dimensions
column_new_dimensions = New Dimensions
column_title = Title
column_artist = Artist
column_year = Year
column_bitrate = Bitrate
column_length = Length
column_genre = Genre
column_type_of_error = Type of Error
column_symlink_name = Symlink Name
column_symlink_folder = Symlink Folder
column_destination_path = Destination Path
column_current_extension = Current Extension
column_proper_extension = Proper Extension
column_fps = FPS
column_codec = Codec
column_duration = Duration
column_exif_tags = EXIF Tags
column_new_name = New Name

# Slint translations
ok_button = Ok
cancel_button = Cancel
do_you_want_to_continue = Do you want to continue?
main_window_title = Krokiet - Data Cleaner
scan_button = Scan
stop_button = Stop
stop_text = Stop
select_button = Select
move_button = Move
delete_button = Delete
save_button = Save
sort_button = Sort
rename_button = Rename
motto = This program is free to use and will always be.\nSee the MIT/GPL License for details.
unicorn = You may not look at a unicorn, but the unicorn always looks at you.
repository = Repository
instruction = Instruction
donation = Donation
translation = Translation
included_paths = Included Paths
excluded_paths = Excluded Paths
ref = Ref
path = Path
tool_duplicate_files = Duplicate Files
tool_empty_folders = Empty Folders
tool_big_files = Big Files
tool_empty_files = Empty Files
tool_temporary_files = Temporary Files
tool_similar_images = Similar Images
tool_similar_videos = Similar Videos
tool_music_duplicates = Music Duplicates
tool_invalid_symlinks = Invalid Symlinks
tool_broken_files = Broken Files
tool_bad_extensions = Bad Extensions
tool_bad_names = Bad Names
tool_video_optimizer = Video Optimizer
tool_exif_remover = Exif Remover
sort_by_full_name = Sort by full name
sort_by_selection = Sort by selection
sort_reverse = Reverse order
selection_all = Select all
selection_deselect_all = Deselect all
selection_invert_selection = Invert selection
selection_the_biggest_size = Select the biggest size
selection_the_biggest_resolution = Select the biggest resolution
selection_the_smallest_size = Select the smallest size
selection_the_smallest_resolution = Select the smallest resolution
selection_newest = Select newest
selection_oldest = Select oldest
selection_shortest_path = Select the shortest path
selection_longest_path = Select the longest path
stage_current = Current Stage:
stage_all = All Stages:
subsettings = Subsettings
subsettings_images_hash_size = Hash Size
subsettings_images_resize_algorithm = Resize Algorithm
subsettings_images_ignore_same_size = Ignore images with same size
subsettings_images_max_difference = Max difference
subsettings_images_duplicates_hash_type = Hash Type
subsettings_duplicates_check_method = Check method
subsettings_duplicates_name_case_sensitive = Case Sensitive(only name modes)
subsettings_biggest_files_sub_method = Method
subsettings_biggest_files_sub_number_of_files = Number of files
subsettings_videos_max_difference = Max difference
subsettings_videos_ignore_same_size = Ignore videos with same size
subsettings_music_audio_check_type = Audio check type
subsettings_music_approximate_comparison = Approximate Tag Comparison
subsettings_music_compared_tags = Compared tags
subsettings_music_title = Title
subsettings_music_artist = Artist
subsettings_music_bitrate = Bitrate
subsettings_music_genre = Genre
subsettings_music_year = Year
subsettings_music_length = Length
subsettings_music_max_difference = Max difference
subsettings_music_minimal_fragment_duration = Minimal fragment duration
subsettings_music_compare_fingerprints_only_with_similar_titles = Compare within groups of similar titles
subsettings_broken_files_type = Type of files to check
subsettings_broken_files_audio = Audio
subsettings_broken_files_pdf = Pdf
subsettings_broken_files_archive = Archive
subsettings_broken_files_image = Image
subsettings_broken_files_video = Video
subsettings_broken_files_video_info = Uses ffmpeg/ffprobe. Quite slow and may detect pedantic errors even if file plays fine.
subsettings_bad_names_issues = Filename checks
subsettings_bad_names_uppercase_extension = Uppercase extension
subsettings_bad_names_uppercase_extension_hint = Finds files with uppercase letters in extension (e.g., .JPG, .Mp3) and suggests lowercase version
subsettings_bad_names_emoji_used = Emoji in name
subsettings_bad_names_emoji_used_hint = Finds files with emoji characters (😀, 🎉, etc.) in name and suggests removing them
subsettings_bad_names_space_at_start_end = Leading/trailing spaces
subsettings_bad_names_space_at_start_end_hint = Finds files with spaces at the start or end of the name and suggests trimming them
subsettings_bad_names_non_ascii = Non-ASCII chars
subsettings_bad_names_non_ascii_hint = Finds non-ASCII characters (ą, ć, ñ, etc.) and suggests replacing them with ASCII equivalents (a, c, n) or removing if no mapping exists
subsettings_bad_names_restricted_charset = Limited charset
subsettings_bad_names_restricted_charset_hint = Transliterates non-ASCII chars to ASCII, then finds files containing characters outside 0-9a-zA-Z and user-defined allowed chars
subsettings_bad_names_allowed_chars = Allowed chars
subsettings_bad_names_remove_duplicated = Duplicated chars
subsettings_bad_names_remove_duplicated_hint = Finds consecutive duplicated non-alphanumeric characters (e.g., "file---name..txt") and suggests removing duplicates
settings_global_settings = Global Settings
settings_dark_theme = Dark theme
settings_show_only_icons = Show only icons
settings_excluded_items = Excluded item:
settings_allowed_extensions = Allowed extensions:
settings_excluded_extensions = Excluded extensions:
settings_file_size = File Size(Kilobytes)
settings_minimum_file_size = Min:
settings_maximum_file_size = Max:
settings_recursive_search = Recursive search
settings_use_cache = Use cache
settings_save_as_json = Also save cache as JSON file
settings_move_to_trash = Move deleted files to trash
settings_ignore_other_filesystems = Ignore other filesystems (only Linux)
settings_delete_outdated_cache_entries = Delete automatically outdated cache entries
settings_delete_outdated_cache_entries_hint = When enabled, the app will verify during cache loading (at most once per week) whether the cached records still point to existing and unmodified files/data
settings_hide_hard_links = Hide hard links
settings_hide_hard_links_hint = Hide hard links to same files in results
settings_thread_number = Thread number
settings_restart_required = ---You need to restart app to apply changes in thread number---
settings_duplicate_image_preview = Image preview
settings_duplicate_minimal_hash_cache_size = Minimal size of cached files - Hash (KB)
settings_duplicate_use_prehash = Use prehash
settings_duplicate_minimal_prehash_cache_size = Minimal size of cached files - Prehash (KB)
settings_similar_images_show_image_preview = Image preview
settings_application_scale_text = Application scale
settings_application_scale_hint_text = When manual scale is enabled, this allows you to choose a custom scale factor, but completely disables automatic scaling based on the monitor’s DPI.
settings_restart_required_scale_text = ---You need to restart app to apply changes in scale---
settings_use_manual_application_scale_text = Use manual application scale

settings_video_thumbnails_preview = Image preview
settings_open_config_folder = Open config folder
settings_open_cache_folder = Open cache folder
settings_language = Language
settings_current_preset = Current Preset:
settings_edit_name = Edit name
settings_choose_name_for_prefix = Choose name for prefix
settings_save = Save
settings_load = Load
settings_reset = Reset
settings_similar_videos_tool = Similar Videos tool
settings_video_thumbnails_clear_unused_thumbnails = Delete unused video thumbnails older than 7 days at app startup
settings_video_thumbnails_header = Video Thumbnails
settings_video_thumbnails_generate = Generate thumbnails
settings_video_thumbnails_position = Thumbnail position in video (%)
settings_video_thumbnails_generate_grid = Generate thumbnail grid instead of single image
settings_video_thumbnails_generate_grid_hint = Generating multiple images in grid is a lot slower than generating single thumbnail
settings_video_thumbnails_grid_tiles_per_side = Number of tiles per side in thumbnail grid
settings_video_thumbnails_grid_tiles_per_side_hint = Number of thumbnail tiles per side in the grid. For example, selecting 2 creates a 2 x 2 grid, resulting in a single thumbnail composed of 4 images.
settings_similar_images_tool = Similar Images tool
settings_general_settings = General Settings
settings_cache_header_text = Cache Settings
settings_clean_cache_button_text = Clean outdated cache
settings_settings = Settings
settings_load_tabs_sizes_at_startup = Load tabs sizes at startup
settings_load_windows_size_at_startup = Load windows size at startup
settings_limit_lines_of_messages = Limit messages to 500 lines(workaround for slow TextEdit widget)
settings_play_audio_on_scan_completion_text = Play sound when scan completes successfully
settings_audio_feature_hint_text = Available only when compiling with audio feature
settings_audio_env_variable_hint_text = Sound can be changed, by setting KROKIET_AUDIO_STOP_FILE environment variable to a valid audio file path
popup_save_title = Saving results
popup_save_message = This will save results to 3 different files
popup_rename_title = Renaming files
popup_new_paths_title = Please add paths one per line
popup_move_title = Moving files
popup_move_copy_checkbox = Copy files instead of moving
popup_move_preserve_folder_checkbox = Preserve folder structure
move_confirmation_text = Are you sure you want to move the selected items?
rename_confirmation_text = Are you sure you want to rename the selected items?
delete = Delete items
stopping_scan = Stopping scan, please wait...
searching = Searching...
subsettings_videos_crop_detect = Crop detect method
subsettings_videos_skip_forward_amount = Skip duration [s]
subsettings_videos_vid_hash_duration = Video hash duration
settings_cache_number_size_text = Cache files size: { $size }, number of files: { $number }
settings_video_thumbnails_number_size_text = Video thumbnails size: { $size }, number of files: { $number }
settings_log_number_size_text = Log files size: { $size }, number of files: { $number }
popup_clean_cache_title_text = Clean Outdated Cache
popup_clean_cache_confirmation_text = Are you sure you want to clean outdated cache entries? This will remove cache entries for files that no longer exist or have been modified.
popup_clean_cache_progress_text = Processing cache file:
popup_clean_cache_current_file_text = Current file:
popup_clean_cache_file_progress_text = Current file progress:
popup_clean_cache_overall_progress_text = Overall progress:
popup_clean_cache_stopped_by_user_text = Cache cleaning was stopped by user
popup_clean_cache_finished_text = Cache cleaning completed successfully!
popup_clean_cache_error_details_text = Error details:
popup_clean_cache_files_with_errors = Files with errors:
subsettings_video_optimizer_mode = Mode
subsettings_video_optimizer_crop_type = Crop Type
subsettings_video_optimizer_black_pixel_threshold = Black Pixel Threshold
subsettings_video_optimizer_black_pixel_threshold_hint = Maximum RGB value for each pixel channel to be considered black (0-128). Default: 20
subsettings_video_optimizer_black_bar_min_percentage = Black Bar Min Percentage
subsettings_video_optimizer_black_bar_min_percentage_hint = Minimum percentage of black pixels in a row/column to be considered a black bar (50-100). Default: 90
subsettings_video_optimizer_max_samples = Max Samples
subsettings_video_optimizer_max_samples_hint = Maximum number of frames to analyze per video (5-1000). Default: 60
subsettings_video_optimizer_min_crop_size = Min Crop Size
subsettings_video_optimizer_min_crop_size_hint = Minimum pixels to crop on any side (1-1000). Smaller crops are ignored. Default: 5
subsettings_video_optimizer_video_codec = Video codec
subsettings_video_optimizer_excluded_codecs = Excluded codecs
subsettings_video_optimizer_video_quality = Video quality (CRF)
subsettings_reset = Reset
subsettings_exif_ignored_tags_text = Ignored tags:
subsettings_exif_ignored_tags_hint_text = Comma-separated list of tags to exclude from scanning (e.g. GPS, Thumbnail). Some tags, such as ImageWidth in TIFF files, are hidden to prevent breaking the image.
clean_button_text = Clean
clean_text = Clean EXIF data
clean_confirmation_text = Are you sure you want to remove EXIF data from the selected items?
crop_videos_text = Crop videos
crop_video_confirmation_text = Are you sure you want to crop the selected videos?
crop_reencode_video_text = Re-encode video
reencode_videos_text = Re-encode videos
optimize_button_text = Optimize
optimize_confirmation_text = Are you sure you want to re-encode the selected videos?
optimize_fail_if_bigger_text = Fail if optimized file is bigger
optimize_overwrite_files_text = Overwrite files
optimize_limit_video_size_text = Limit video size
optimize_max_width_text = Max width:
optimize_max_height_text = Max height:
hardlink_button_text = Hardlink
hardlink_text = Create hardlinks
hardlink_confirmation_text = Are you sure you want to create hardlinks for the selected items?
softlink_button_text = Softlink
softlink_text = Create softlinks
softlink_confirmation_text = Are you sure you want to create softlinks (symlinks) for the selected items?
