! This file is part of mstore.
! SPDX-Identifier: Apache-2.0
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.

module mstore_but14diol
   use mctc_env_accuracy, only : wp
   use mctc_io_structure, only : structure_type, new
   use mstore_data_record, only : record_type, new_record, select_record
   implicit none
   private

   public :: get_but14diol_records

contains

subroutine get_but14diol_records(records)
   type(record_type), allocatable, intent(out) :: records(:)

   records = [ &
      new_record("1", b1), &
      new_record("2", b2), &
      new_record("3", b3), &
      new_record("4", b4), &
      new_record("5", b5), &
      new_record("6", b6), &
      new_record("7", b7), &
      new_record("8", b8), &
      new_record("9", b9), &
      new_record("10", b10), &
      new_record("11", b11), &
      new_record("12", b12), &
      new_record("13", b13), &
      new_record("14", b14), &
      new_record("15", b15), &
      new_record("16", b16), &
      new_record("17", b17), &
      new_record("18", b18), &
      new_record("19", b19), &
      new_record("20", b20), &
      new_record("21", b21), &
      new_record("22", b22), &
      new_record("23", b23), &
      new_record("24", b24), &
      new_record("25", b25), &
      new_record("26", b26), &
      new_record("27", b27), &
      new_record("28", b28), &
      new_record("29", b29), &
      new_record("30", b30), &
      new_record("31", b31), &
      new_record("32", b32), &
      new_record("33", b33), &
      new_record("34", b34), &
      new_record("35", b35), &
      new_record("36", b36), &
      new_record("37", b37), &
      new_record("38", b38), &
      new_record("39", b39), &
      new_record("40", b40), &
      new_record("41", b41), &
      new_record("42", b42), &
      new_record("43", b43), &
      new_record("44", b44), &
      new_record("45", b45), &
      new_record("46", b46), &
      new_record("47", b47), &
      new_record("48", b48), &
      new_record("49", b49), &
      new_record("50", b50), &
      new_record("51", b51), &
      new_record("52", b52), &
      new_record("53", b53), &
      new_record("54", b54), &
      new_record("55", b55), &
      new_record("56", b56), &
      new_record("57", b57), &
      new_record("58", b58), &
      new_record("59", b59), &
      new_record("60", b60), &
      new_record("61", b61), &
      new_record("62", b62), &
      new_record("63", b63), &
      new_record("64", b64), &
      new_record("65", b65) &
      ]

end subroutine get_but14diol_records

subroutine b1(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.98271538225471_wp,  0.27909365256588_wp,  0.64970485202128_wp, &
      &  2.63569552384225_wp,  0.02450596849126_wp,  2.67121292650984_wp, &
      &  2.56989337016904_wp, -2.05262619471878_wp, -0.67988944754186_wp, &
      &  1.23558798335661_wp,  2.29620433434321_wp, -0.41823796718252_wp, &
      &  1.99900332597202_wp,  4.12013776218631_wp,  0.17749063730515_wp, &
      &  1.37891993108372_wp,  2.23906846471541_wp, -2.47825866025928_wp, &
      & -1.54453741909595_wp,  2.17720450030314_wp,  0.39335783291694_wp, &
      & -2.46330525736976_wp,  3.90367908229492_wp, -0.27557498250645_wp, &
      & -1.67007381582968_wp,  2.19163255932772_wp,  2.45524557541300_wp, &
      &  3.74944341478106_wp, -3.27762793227897_wp, -0.04041179335176_wp, &
      &  4.94406402530285_wp,  0.86728602923560_wp,  0.39031159439073_wp, &
      & -3.07595446965128_wp, -0.06434895427702_wp, -0.58827363489343_wp, &
      & -5.07245768794950_wp,  0.28537699195773_wp, -0.22405726867172_wp, &
      & -2.83811920774470_wp, -0.22326358369591_wp, -2.64090360906448_wp, &
      & -2.50249250818741_wp, -2.38134594526037_wp,  0.62999122900302_wp, &
      & -0.78924600912582_wp, -2.78793942001205_wp,  0.14482294164596_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b1

subroutine b2(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.96799441567953_wp,  0.14979292137545_wp, -0.69986952194486_wp, &
      & -2.56121385804070_wp, -0.13819567209793_wp, -2.69652769778597_wp, &
      & -2.52384641348902_wp, -2.25653520336168_wp,  0.46981615225350_wp, &
      & -1.34134839610969_wp,  2.27508664480822_wp,  0.36836998426180_wp, &
      & -2.15420086408752_wp,  4.05386884615827_wp, -0.29938175232854_wp, &
      & -1.54262690597561_wp,  2.29158395394831_wp,  2.42929396643008_wp, &
      &  1.46675440174025_wp,  2.23248087941618_wp, -0.34300796983234_wp, &
      &  2.32550264830747_wp,  3.96613642071293_wp,  0.38433061118015_wp, &
      &  1.66153414343517_wp,  2.28306128908899_wp, -2.39852355580831_wp, &
      & -2.98624161121867_wp, -2.11147982540137_wp,  2.22128992125723_wp, &
      & -4.96626452791199_wp,  0.63723454927037_wp, -0.52133575581436_wp, &
      &  3.01406215934701_wp,  0.00194452819074_wp,  0.64477833599285_wp, &
      &  5.01447711074030_wp,  0.43202540904805_wp,  0.41279555591981_wp, &
      &  2.67134898679140_wp, -0.23946231610700_wp,  2.67630762816410_wp, &
      &  2.60096802669821_wp, -2.28459007753050_wp, -0.68598381432042_wp, &
      &  0.89187136622444_wp, -2.80160025022668_wp, -0.30054960307866_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b2

subroutine b3(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.70007471373740_wp, -0.18342626708854_wp,  1.03812483055299_wp, &
      &  1.70779274944208_wp, -1.05953920709085_wp,  2.62468597939206_wp, &
      &  2.90536700190956_wp, -1.90909015656932_wp, -1.00687442949346_wp, &
      &  1.39895858699684_wp,  2.28648169338952_wp,  0.29406217326447_wp, &
      &  1.16252172242859_wp,  3.43228122926820_wp,  2.00015794863921_wp, &
      &  2.64477376818463_wp,  3.33699556846971_wp, -0.97100553776516_wp, &
      & -1.16339666562812_wp,  1.96683262828578_wp, -1.01918977470148_wp, &
      & -0.89841926727489_wp,  1.12289983460038_wp, -2.88211203211827_wp, &
      & -1.98624578484891_wp,  3.83439038390654_wp, -1.32428794858200_wp, &
      &  1.24684697165635_wp, -2.64356623318572_wp, -1.17721245338564_wp, &
      &  4.62141218537395_wp,  0.22430860224739_wp,  1.65814775420504_wp, &
      & -3.07804639648039_wp,  0.36869879660892_wp,  0.40666339461859_wp, &
      & -3.08418044750773_wp,  0.86562118051253_wp,  2.41498873960414_wp, &
      & -4.97158599670219_wp,  0.69901347600667_wp, -0.34803842079808_wp, &
      & -2.41222595999786_wp, -2.24019474149061_wp,  0.08141129153085_wp, &
      & -3.53359889588286_wp, -3.24966187523840_wp,  1.09040788347154_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b3

subroutine b4(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.71917984494087_wp, -0.20752027528284_wp,  1.00546847325060_wp, &
      & -4.67203605874783_wp,  0.14092254690768_wp,  1.55880485139924_wp, &
      & -2.78267275327970_wp, -2.04761653074050_wp, -0.94949478519452_wp, &
      & -1.50841530406585_wp,  2.27539278044174_wp,  0.16448554205863_wp, &
      & -2.75340278520743_wp,  3.20148519720661_wp, -1.19469808929323_wp, &
      & -1.38131232436796_wp,  3.51716961688356_wp,  1.81394055605240_wp, &
      &  1.11801489254687_wp,  1.99582102716424_wp, -1.02763874024161_wp, &
      &  1.91355179996907_wp,  3.87859674733313_wp, -1.32266467383385_wp, &
      &  0.95153568941804_wp,  1.12670574303201_wp, -2.89218238268042_wp, &
      & -1.10756281730588_wp, -2.76348258440024_wp, -0.95231803603706_wp, &
      & -1.73246123438077_wp, -0.95567985882746_wp,  2.66075707181658_wp, &
      &  2.98711088523980_wp,  0.44991355662195_wp,  0.53231317492029_wp, &
      &  4.92488708450632_wp,  0.89204144157640_wp, -0.02104399021581_wp, &
      &  2.79893006720091_wp,  0.88679745155764_wp,  2.53699890737390_wp, &
      &  2.57138247436175_wp, -2.22913417443484_wp,  0.31405169629813_wp, &
      &  3.48300525812712_wp, -2.79218752435878_wp, -1.15183910059939_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b4

subroutine b5(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "C", "O", "H", "H", "H", &
      & "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.63053846122561_wp, -0.01079789512331_wp,  1.08195891793141_wp, &
      &  1.64716277619458_wp, -1.00538154584848_wp,  2.59832807929057_wp, &
      &  2.81230743849561_wp, -1.60827410210592_wp, -1.10463563152604_wp, &
      &  1.18289863931950_wp,  2.35635998633136_wp,  0.33118962259727_wp, &
      &  0.83108832516018_wp,  3.44544884096215_wp,  2.05074024803816_wp, &
      &  2.38377046388887_wp,  3.51235081524470_wp, -0.88405734866496_wp, &
      & -1.32451282599181_wp,  1.86219282312950_wp, -1.03724610790120_wp, &
      &  3.87524248344726_wp, -3.01776413284134_wp, -0.67574716785858_wp, &
      &  4.51539476986680_wp,  0.50811712151482_wp,  1.74516586317216_wp, &
      & -3.16019090175079_wp,  0.12231441367716_wp,  0.34373551439350_wp, &
      & -2.40393384172676_wp, -2.46439940880070_wp,  0.35304619505023_wp, &
      & -0.88784435983526_wp, -2.59109987683228_wp, -0.64946296707627_wp, &
      & -5.01706414581622_wp,  0.25719361641187_wp, -0.54972889096097_wp, &
      & -3.37311012459529_wp,  0.73997328993696_wp,  2.30677735205671_wp, &
      & -2.26173195022711_wp,  3.67660959016738_wp, -1.33871978705885_wp, &
      & -0.95229724904959_wp,  1.07551873127053_wp, -2.90841324043578_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b5

subroutine b6(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.64351899003240_wp, -0.09808056574903_wp,  1.09391332544804_wp, &
      &  1.60151077227632_wp, -0.92267201246435_wp,  2.66451762682102_wp, &
      &  2.69355893803121_wp, -2.03968346043465_wp, -0.79299522577347_wp, &
      &  1.36436526040824_wp,  2.31957268770248_wp,  0.19016880993068_wp, &
      &  1.18370555237824_wp,  3.56874780195454_wp,  1.82628424715241_wp, &
      &  2.60364765835464_wp,  3.29092593507609_wp, -1.14964512855911_wp, &
      & -1.24294090773967_wp,  1.93592615738243_wp, -1.02589641274709_wp, &
      & -1.04963326270227_wp,  1.10469232331002_wp, -2.90458087583828_wp, &
      & -2.10362801331924_wp,  3.79275026856840_wp, -1.29059791108491_wp, &
      &  3.53199262866991_wp, -1.37734389948890_wp, -2.26309444276892_wp, &
      &  4.55687992766204_wp,  0.31033649472088_wp,  1.75356569583283_wp, &
      & -3.04784479342461_wp,  0.27754785658918_wp,  0.50141993209988_wp, &
      & -2.88670217689505_wp,  0.75232642966764_wp,  2.51398204307535_wp, &
      & -4.98961020455766_wp,  0.67310911017707_wp, -0.06266520829262_wp, &
      & -2.66916635310792_wp, -2.35840089055488_wp,  0.13728860355414_wp, &
      & -0.94588918773298_wp, -2.61799823860778_wp, -0.39974699697223_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b6

subroutine b7(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.23310149794371_wp,  3.33107694622151_wp, -0.34001842309011_wp, &
      & -1.52687414893187_wp,  4.14864995007929_wp, -1.03175456375904_wp, &
      & -0.23310149794371_wp,  2.68790676716775_wp,  2.23383770277959_wp, &
      &  0.97538781266732_wp,  1.07812088415552_wp, -1.97758705970803_wp, &
      &  1.25370289806646_wp,  1.78639968739172_wp, -3.89629403256761_wp, &
      &  2.80834468279495_wp,  0.35762122201794_wp, -1.34938729107899_wp, &
      & -0.97538781266732_wp, -1.07812088415552_wp, -1.97758705970803_wp, &
      & -1.25370289806646_wp, -1.78639968739172_wp, -3.89629403256761_wp, &
      & -2.80834468279495_wp, -0.35762122201794_wp, -1.34938729107899_wp, &
      &  1.16345902659050_wp,  1.65457617181389_wp,  2.77621744880976_wp, &
      &  1.69403365346854_wp,  4.78933135981604_wp, -0.46384839712584_wp, &
      & -0.23310149794371_wp, -3.33107694622151_wp, -0.34001842309011_wp, &
      & -1.69403365346854_wp, -4.78933135981604_wp, -0.46384839712584_wp, &
      &  1.52687414893187_wp, -4.14864995007929_wp, -1.03175456375904_wp, &
      &  0.23310149794371_wp, -2.68790676716775_wp,  2.23383770277959_wp, &
      & -1.16345902659050_wp, -1.65457617181389_wp,  2.77621744880976_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b7

subroutine b8(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.44710424105456_wp, -1.21292449784492_wp, -0.35140591276688_wp, &
      & -4.41597249856342_wp, -2.82473427754547_wp,  0.50711745639053_wp, &
      & -4.69689729575207_wp,  1.09314798636423_wp,  0.28798670374724_wp, &
      & -0.75586966616680_wp, -1.05920850501760_wp,  0.62342254096511_wp, &
      & -0.81602720788108_wp, -0.76166923566862_wp,  2.66664545844665_wp, &
      &  0.18054821418816_wp, -2.86443742359739_wp,  0.29050570868238_wp, &
      &  0.75585643808387_wp,  1.05926519680159_wp, -0.62328270123127_wp, &
      & -0.18050097103484_wp,  2.86451301264271_wp, -0.29029405935549_wp, &
      &  0.81593650102670_wp,  0.76178072951046_wp, -2.66651506734348_wp, &
      & -6.37802600945913_wp,  1.02051258299450_wp, -0.39151723966351_wp, &
      & -3.43346419782739_wp, -1.49009062975525_wp, -2.40251276767483_wp, &
      &  3.44713447667268_wp,  1.21288859304839_wp,  0.35144181756341_wp, &
      &  4.41598383692022_wp,  2.82473805699773_wp, -0.50702863926228_wp, &
      &  3.43359269920442_wp,  1.48992811330783_wp,  2.40256756973268_wp, &
      &  4.69686894986008_wp, -1.09316310417329_wp, -0.28814355101627_wp, &
      &  6.37805246562499_wp, -1.02055982614782_wp,  0.39122811156518_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b8

subroutine b9(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.35841301726762_wp,  3.46318392071928_wp,  1.20678099818690_wp, &
      &  0.37166755636368_wp,  4.39963770587076_wp,  2.89915736183690_wp, &
      &  0.28011977385604_wp,  4.86859781218606_wp, -1.00520958077039_wp, &
      &  0.55773377085987_wp,  0.73775475145695_wp,  1.10643843025681_wp, &
      &  2.62371277043362_wp,  0.72099099093213_wp,  0.97330533446888_wp, &
      &  0.07915306880205_wp, -0.20010498993739_wp,  2.88054355942798_wp, &
      & -0.55773377085987_wp, -0.73775475145695_wp, -1.10643843025681_wp, &
      & -0.07915306880205_wp,  0.20010498993739_wp, -2.88054355942798_wp, &
      & -2.62371277043362_wp, -0.72099099093213_wp, -0.97330533446888_wp, &
      &  2.09180966608417_wp,  4.98514478170565_wp, -1.06381754705571_wp, &
      & -2.41547439922029_wp,  3.51411015027441_wp,  1.30502597010950_wp, &
      &  0.35841301726762_wp, -3.46318392071928_wp, -1.20678099818690_wp, &
      & -0.37166755636368_wp, -4.39963770587076_wp, -2.89915736183690_wp, &
      &  2.41547439922029_wp, -3.51411015027441_wp, -1.30502597010950_wp, &
      & -0.28011977385604_wp, -4.86859781218606_wp,  1.00520958077039_wp, &
      & -2.09180966608417_wp, -4.98514478170565_wp,  1.06381754705571_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b9

subroutine b10(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.46513600781455_wp,  1.20126677733114_wp, -0.37818333206987_wp, &
      &  4.43851126215035_wp,  2.82402751997177_wp,  0.45473235826080_wp, &
      &  4.85792841843979_wp, -1.06728141505729_wp,  0.06392943507552_wp, &
      &  0.75918235607774_wp,  1.06222261819955_wp,  0.58892559040928_wp, &
      &  0.78842208853188_wp,  0.75690712581375_wp,  2.63722242255762_wp, &
      & -0.16276967072997_wp,  2.87991239089959_wp,  0.27532364893077_wp, &
      & -0.76658819279252_wp, -1.03197377199045_wp, -0.67957386327767_wp, &
      &  0.18436168152432_wp, -2.84163598807800_wp, -0.41182801613977_wp, &
      & -0.85618577793103_wp, -0.68437376765520_wp, -2.71322342817002_wp, &
      &  5.00002259554986_wp, -1.26673633920497_wp,  1.86363468416889_wp, &
      &  3.47190689654868_wp,  1.45182934474272_wp, -2.42249851125623_wp, &
      & -3.44168450650544_wp, -1.22660233559474_wp,  0.33093073011707_wp, &
      & -4.42104263377796_wp, -2.80763792522125_wp, -0.57153822026060_wp, &
      & -3.39724192731224_wp, -1.57973545804708_wp,  2.37071434603676_wp, &
      & -4.70188995219515_wp,  1.09945778192193_wp, -0.20220069621876_wp, &
      & -6.39055867317243_wp,  0.98055810336690_wp,  0.45103983339715_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b10

subroutine b11(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.56028411278332_wp, -0.85543555665627_wp,  1.10623811928672_wp, &
      &  1.38172428466493_wp, -2.53850312937568_wp,  1.18778736082527_wp, &
      &  3.85377897402994_wp, -0.99585165696034_wp, -1.25937585591738_wp, &
      &  0.93810918524389_wp,  1.50810160952779_wp,  1.36891383121009_wp, &
      & -0.10064492411136_wp,  1.37468694454606_wp,  3.14506175433091_wp, &
      &  2.16485514002473_wp,  3.16653093292663_wp,  1.51262561388991_wp, &
      & -0.91741857381492_wp,  1.90010828825972_wp, -0.81720639698800_wp, &
      &  0.11671893459768_wp,  2.31235960305325_wp, -2.55274410551310_wp, &
      & -2.10909499102167_wp,  3.53233466909996_wp, -0.40408202872107_wp, &
      &  4.98551894747996_wp,  0.42260701400175_wp, -1.34192854203249_wp, &
      &  3.89996954989607_wp, -0.96465605795867_wp,  2.67702950354686_wp, &
      & -2.59405162905185_wp, -0.37449269693235_wp, -1.31715612215649_wp, &
      & -3.96900691470878_wp,  0.09270240517484_wp, -2.78800933987897_wp, &
      & -1.45277798726143_wp, -1.95792067984309_wp, -1.99391051404389_wp, &
      & -3.84620117223707_wp, -1.01116788726738_wp,  0.98998405731773_wp, &
      & -4.89940790705663_wp, -2.45368088217497_wp,  0.66856620855361_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b11

subroutine b12(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.57810423021643_wp, -0.60999414706482_wp, -1.23137389408028_wp, &
      & -1.41517432694313_wp, -2.27071192881058_wp, -1.63188245068406_wp, &
      & -3.84071340754717_wp, -0.87507548035535_wp,  1.14267581858103_wp, &
      & -0.92942778338941_wp,  1.73467788313464_wp, -1.10912940027004_wp, &
      &  0.10848917728896_wp,  1.87520925673282_wp, -2.88391861030131_wp, &
      & -2.14487695534786_wp,  3.39497236622664_wp, -0.96380001202047_wp, &
      &  0.92939565804515_wp,  1.73457016874507_wp,  1.10919743041082_wp, &
      & -0.10847028002764_wp,  1.87500516631046_wp,  2.88402821441702_wp, &
      &  2.14489396288306_wp,  3.39484386484960_wp,  0.96400977162122_wp, &
      & -4.91235631051916_wp, -2.33598684889272_wp,  1.03946464638121_wp, &
      & -3.94804985189508_wp, -0.41025954344947_wp, -2.76629449688598_wp, &
      &  2.57805131788471_wp, -0.61012642789412_wp,  1.23132287147469_wp, &
      &  3.94770403201276_wp, -0.41063748867605_wp,  2.76655149964005_wp, &
      &  1.41504771529223_wp, -2.27090279115001_wp,  1.63129285613060_wp, &
      &  3.84115749318840_wp, -0.87471643239011_wp, -1.14252841994266_wp, &
      &  4.90975037818191_wp, -2.33796350242772_wp, -1.04073265261638_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b12

subroutine b13(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.64638908985028_wp, -0.70750401552172_wp,  0.58906354041698_wp, &
      &  4.17008700333074_wp, -2.34552429668539_wp, -0.54565653114460_wp, &
      &  4.32541871200168_wp,  1.43313617383621_wp, -0.90107811194386_wp, &
      &  0.83891179135032_wp, -0.78393398896628_wp,  1.21926452902075_wp, &
      &  0.48266628995712_wp, -2.41391348543453_wp,  2.44170001849248_wp, &
      &  0.33608023382918_wp,  0.89617994180742_wp,  2.30841196516165_wp, &
      & -0.83169303752270_wp, -0.93430705626452_wp, -1.12814571434527_wp, &
      & -0.47459337991743_wp, -2.70899611081075_wp, -2.12474381312810_wp, &
      & -0.34888879755788_wp,  0.59728951827343_wp, -2.41848473294998_wp, &
      &  3.86133409910922_wp,  2.91374037840438_wp,  0.04438588740922_wp, &
      &  4.76411674402495_wp, -0.76767856477120_wp,  2.32815015461964_wp, &
      & -3.62847637583665_wp, -0.77915298185008_wp, -0.51214790735627_wp, &
      & -4.74222426677547_wp, -1.03030514381511_wp, -2.23533436587683_wp, &
      & -4.14698510135622_wp, -2.28370568570031_wp,  0.81240649261047_wp, &
      & -4.09892180689240_wp,  1.64601004325351_wp,  0.57562947733830_wp, &
      & -5.86435687256589_wp,  1.73914519571278_wp,  0.98455487413795_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b13

subroutine b14(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.49929847684486_wp, -1.14339580423765_wp, -0.74775896160445_wp, &
      & -3.39913165344512_wp, -2.55351322404919_wp, -2.24621918840225_wp, &
      & -3.49929847684486_wp, -2.55112649994335_wp,  1.55343991890798_wp, &
      & -1.27507759035552_wp,  0.67403696570832_wp, -0.93503460082568_wp, &
      & -1.47462889053598_wp,  1.79265468089157_wp, -2.66254475273829_wp, &
      & -1.34490675041792_wp,  2.00469140163201_wp,  0.64269018861601_wp, &
      &  1.27507759035552_wp, -0.67403696570832_wp, -0.93503460082568_wp, &
      &  1.47462889053598_wp, -1.79265468089157_wp, -2.66254475273829_wp, &
      &  1.34490675041792_wp, -2.00469140163201_wp,  0.64269018861601_wp, &
      & -3.73112440964887_wp, -1.36195396986268_wp,  2.90693736432599_wp, &
      & -5.28022173790348_wp, -0.11770348191292_wp, -0.97163292684128_wp, &
      &  3.49929847684486_wp,  1.14339580423765_wp, -0.74775896160445_wp, &
      &  5.28022173790348_wp,  0.11770348191292_wp, -0.97163292684128_wp, &
      &  3.39913165344512_wp,  2.55351322404919_wp, -2.24621918840225_wp, &
      &  3.49929847684486_wp,  2.55112649994335_wp,  1.55343991890798_wp, &
      &  3.73112440964887_wp,  1.36195396986268_wp,  2.90693736432599_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b14

subroutine b15(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.58910621576209_wp, -0.64418874143939_wp,  1.23547837924091_wp, &
      &  1.44401343745710_wp, -2.31644330122642_wp,  1.58106015606624_wp, &
      &  3.89334228034804_wp, -1.12748997937716_wp, -1.07730830191838_wp, &
      &  0.92064244659763_wp,  1.70031699286038_wp,  1.11609871024812_wp, &
      & -0.12552694810306_wp,  1.82318698602061_wp,  2.88984857090631_wp, &
      &  2.11294814260663_wp,  3.38599427736930_wp,  1.00684608360147_wp, &
      & -0.92064244659763_wp,  1.70029431614679_wp, -1.11613272531851_wp, &
      &  0.12552505837693_wp,  1.82313407368889_wp, -2.88988258597670_wp, &
      & -2.11294814260663_wp,  3.38597349038184_wp, -1.00691033428999_wp, &
      &  5.02296953998149_wp,  0.26564825113040_wp, -1.36504745154221_wp, &
      &  3.92353065532089_wp, -0.47512061350851_wp,  2.80510947165545_wp, &
      & -2.58910810548822_wp, -0.64421141815298_wp, -1.23546704088411_wp, &
      & -3.92353065532089_wp, -0.47517352584023_wp, -2.80510380247705_wp, &
      & -1.44401721690937_wp, -2.31647353684454_wp, -1.58101480263905_wp, &
      & -3.89334794952644_wp, -1.12747297184196_wp,  1.07732719917971_wp, &
      & -5.02291851737590_wp,  0.26570872236665_wp,  1.36507957688647_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b15

subroutine b16(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.41280193229042_wp,  0.68671135888158_wp, -0.51086667303817_wp, &
      & -3.35087371718962_wp,  0.77921534281246_wp, -2.57810045076416_wp, &
      & -5.44875507333875_wp, -0.86955936977346_wp,  0.31619464573282_wp, &
      & -0.86450435236799_wp, -0.17482990291005_wp,  0.50498962476490_wp, &
      & -0.96316317431369_wp, -0.25020351944632_wp,  2.56593817337291_wp, &
      & -0.46834972477438_wp, -2.08810958231598_wp, -0.15890896024049_wp, &
      &  1.27920097277748_wp,  1.57296078986069_wp, -0.31955835824936_wp, &
      &  0.95329880390002_wp,  3.47892344968008_wp,  0.40836414813819_wp, &
      &  1.33042388933548_wp,  1.70696504939587_wp, -2.37944110131843_wp, &
      & -5.10978166880012_wp, -2.55311449183515_wp, -0.27457531738215_wp, &
      & -3.85383755554006_wp,  2.57677008356661_wp,  0.17923674425194_wp, &
      &  3.85052864508138_wp,  0.68222136958984_wp,  0.58853819655204_wp, &
      &  5.29653574360868_wp,  2.06690307565274_wp,  0.07354625136578_wp, &
      &  3.84025420409688_wp,  0.49786913669618_wp,  2.64983067531624_wp, &
      &  4.35597180411817_wp, -1.69596873302861_wp, -0.57936546590301_wp, &
      &  5.95321368506031_wp, -2.29337730404842_wp,  0.04086721734978_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b16

subroutine b17(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.44437925597093_wp, -1.23329196610516_wp, -0.34249963350259_wp, &
      & -4.43032496854269_wp, -2.80885301912470_wp,  0.53985696164277_wp, &
      & -4.94618429802395_wp,  0.94235728959062_wp,  0.19607609382208_wp, &
      & -0.76775037436425_wp, -1.04338771783308_wp,  0.69486741687111_wp, &
      & -0.86667942714694_wp, -0.78092365523659_wp,  2.74099295369277_wp, &
      &  0.20843490273115_wp, -2.82552796252128_wp,  0.34224452047465_wp, &
      &  0.74988679323008_wp,  1.11194320248191_wp, -0.48108836863616_wp, &
      & -0.11324561796544_wp,  2.92867488403258_wp, -0.01103978006832_wp, &
      &  0.75052930011526_wp,  0.93285007741607_wp, -2.54029270002352_wp, &
      & -4.33593125847892_wp,  2.29869877283862_wp, -0.84270447169902_wp, &
      & -3.38867768847800_wp, -1.59223977586839_wp, -2.38022722738971_wp, &
      &  3.47422559051373_wp,  1.16992377969110_wp,  0.41670539928875_wp, &
      &  4.43479039139470_wp,  2.83131808339244_wp, -0.35197472033288_wp, &
      &  3.52546929405919_wp,  1.29418272155900_wp,  2.48188882416056_wp, &
      &  4.66817912771061_wp, -1.09342577610576_wp, -0.43454441398319_wp, &
      &  6.36777424518823_wp, -1.10075413404909_wp,  0.20108764752649_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b17

subroutine b18(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.85710489202382_wp,  0.66409700624934_wp, -0.61338053629495_wp, &
      &  5.31678037967028_wp,  2.04379550449981_wp, -0.12418902200098_wp, &
      &  4.50740500777696_wp, -1.77888424656124_wp,  0.32151233507076_wp, &
      &  1.28509124913369_wp,  1.56606328947565_wp,  0.31754957937010_wp, &
      &  1.32384197321464_wp,  1.68434502758523_wp,  2.38370054402195_wp, &
      &  0.97249653168401_wp,  3.48865553926445_wp, -0.37533551478761_wp, &
      & -0.87390573987910_wp, -0.15045810497422_wp, -0.52963354326386_wp, &
      & -0.46564930613048_wp, -2.08816627409996_wp,  0.05431828796366_wp, &
      & -1.00166823399736_wp, -0.15339851883699_wp, -2.58979218634833_wp, &
      &  4.73030765378149_wp, -1.62870771078081_wp,  2.11782174630334_wp, &
      &  3.83682624089183_wp,  0.47524533543328_wp, -2.66391480418463_wp, &
      & -3.40836674505653_wp,  0.66834133114380_wp,  0.55445320629318_wp, &
      & -3.32056251001813_wp,  0.67258943549053_wp,  2.62353702590327_wp, &
      & -3.85450462886497_wp,  2.58702751701591_wp, -0.04726771976187_wp, &
      & -5.45679585803418_wp, -0.84722658633502_wp, -0.31235472223080_wp, &
      & -5.10226622796964_wp, -2.56076599294720_wp,  0.17394173162759_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b18

subroutine b19(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.48907505846595_wp,  1.16228928611425_wp,  0.43348616734877_wp, &
      &  3.54111622643948_wp,  1.29183190224969_wp,  2.48807389779349_wp, &
      &  4.83672758095494_wp, -1.09038331703181_wp, -0.17417038848967_wp, &
      &  0.75587722507133_wp,  1.10970387701444_wp, -0.47546454366469_wp, &
      & -0.09868905756382_wp,  2.93854681335077_wp, -0.03098205994866_wp, &
      &  0.73817238093232_wp,  0.92006230067483_wp, -2.53864296910951_wp, &
      & -0.77618611182145_wp, -1.02517264763820_wp,  0.71690918248509_wp, &
      & -0.89025187092856_wp, -0.73030356131499_wp,  2.75717656829480_wp, &
      &  0.20534709023002_wp, -2.81330521389377_wp,  0.40784069399938_wp, &
      &  4.98271837335102_wp, -1.16350060056542_wp, -1.98312395727738_wp, &
      &  4.46224433265326_wp,  2.82103419377728_wp, -0.32506124074832_wp, &
      & -3.44438681487547_wp, -1.23586010391975_wp, -0.33873907849815_wp, &
      & -3.37303642527610_wp, -1.62130376379217_wp, -2.37189920432208_wp, &
      & -4.43228650426863_wp, -2.80312714894205_wp,  0.55575144814647_wp, &
      & -4.95634724516660_wp,  0.94027859084444_wp,  0.16057002951129_wp, &
      & -4.32464581401333_wp,  2.29514419798266_wp, -0.86749011965795_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b19

subroutine b20(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.33755988939123_wp,  3.50209716124766_wp,  1.13119384259761_wp, &
      &  0.52983763368621_wp,  4.49955697514709_wp,  2.70788306211848_wp, &
      &  0.34321772943309_wp,  4.90371648263961_wp, -1.06632710336018_wp, &
      &  0.59479130032576_wp,  0.77750514066220_wp,  1.06004943314673_wp, &
      &  2.65016326711562_wp,  0.78962395435240_wp,  0.85011030841380_wp, &
      &  0.15392008324967_wp, -0.08359770466660_wp,  2.88680233238010_wp, &
      & -0.59479130032576_wp, -0.77750514066220_wp, -1.06004943314673_wp, &
      & -0.15392008324967_wp,  0.08359770466660_wp, -2.88680233238010_wp, &
      & -2.65016326711562_wp, -0.78962395435240_wp, -0.85011030841380_wp, &
      & -0.69676848136080_wp,  4.32254632827969_wp, -2.43452850781818_wp, &
      & -2.38678268734469_wp,  3.53780353652853_wp,  1.41740042432767_wp, &
      &  0.33755988939123_wp, -3.50209716124766_wp, -1.13119384259761_wp, &
      & -0.52983763368621_wp, -4.49955697514709_wp, -2.70788306211848_wp, &
      &  2.38678268734469_wp, -3.53780353652853_wp, -1.41740042432767_wp, &
      & -0.34321772943309_wp, -4.90371648263961_wp,  1.06632710336018_wp, &
      &  0.69676848136080_wp, -4.32254632827969_wp,  2.43452850781818_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b20

subroutine b21(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.86708453573159_wp,  0.67015546823137_wp,  0.60733908184812_wp, &
      &  3.86332209100102_wp,  0.45355316915388_wp,  2.66601051046600_wp, &
      &  4.65352808100234_wp, -1.61083090156372_wp, -0.58860622669282_wp, &
      &  1.28393095728809_wp,  1.57698401679760_wp, -0.28699081807521_wp, &
      &  0.91867146224103_wp,  3.42650622620610_wp,  0.56270375058936_wp, &
      &  1.35340295911137_wp,  1.84331067960971_wp, -2.33284990351213_wp, &
      & -0.84863254257789_wp, -0.24257091559560_wp,  0.39832214346803_wp, &
      & -0.88752499611881_wp, -0.55753534961592_wp,  2.43926605123332_wp, &
      & -0.55214396095879_wp, -2.07401411509078_wp, -0.50462112816898_wp, &
      &  3.58610304675896_wp, -2.94617563774923_wp,  0.02019550318215_wp, &
      &  5.30495069407842_wp,  2.06170821851343_wp,  0.12873381335057_wp, &
      & -3.41514897214746_wp,  0.73454410675718_wp, -0.42260134482335_wp, &
      & -3.80116521903814_wp,  2.54690863121475_wp,  0.49878943332290_wp, &
      & -3.41973722719811_wp,  1.04684591665626_wp, -2.46802579324971_wp, &
      & -5.25478980360710_wp, -1.10603024941211_wp,  0.27329219333792_wp, &
      & -6.87920027716173_wp, -0.50089458823493_wp, -0.26411001405823_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b21

subroutine b22(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.85593515154757_wp,  0.65770973192018_wp,  0.63886538292305_wp, &
      &  3.82825822260532_wp,  0.41832300485850_wp,  2.68438242792992_wp, &
      &  4.53587562169502_wp, -1.75384159584824_wp, -0.34933477292524_wp, &
      &  1.28082235779950_wp,  1.56250493516743_wp, -0.28042024031117_wp, &
      &  0.93891798802876_wp,  3.45007111108319_wp,  0.49160091511340_wp, &
      &  1.33636707802340_wp,  1.77202643042499_wp, -2.33884222507951_wp, &
      & -0.86681548742851_wp, -0.21764353817671_wp,  0.45806205570695_wp, &
      & -0.94498967809373_wp, -0.36829439521648_wp,  2.52076615989241_wp, &
      & -0.49532178586905_wp, -2.10784966150010_wp, -0.26931998900660_wp, &
      &  4.70510248662106_wp, -1.57540798520277_wp, -2.14906647818447_wp, &
      &  5.30359765016727_wp,  2.06479603101457_wp,  0.19207743332490_wp, &
      & -3.41365041932408_wp,  0.69092166870565_wp, -0.52156063322417_wp, &
      & -3.81969209404495_wp,  2.58617147107772_wp,  0.20769601981320_wp, &
      & -3.37349373900026_wp,  0.81765615180762_wp, -2.57695527672763_wp, &
      & -5.42502956174037_wp, -1.00359953410517_wp,  0.05056151241149_wp, &
      & -5.50324721610664_wp, -1.15892746332384_wp,  1.85817148591872_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b22

subroutine b23(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.41355215356517_wp,  0.68661309312267_wp, -0.51362567319218_wp, &
      & -3.38630608218123_wp,  0.82674951395907_wp, -2.56785813512392_wp, &
      & -5.42667173374985_wp, -1.00607885479152_wp,  0.06227214525698_wp, &
      & -0.86259761869991_wp, -0.23539751519517_wp,  0.44186143356972_wp, &
      & -0.93747612698937_wp, -0.42085712760270_wp,  2.50265313490870_wp, &
      & -0.48685770251986_wp, -2.10809343617124_wp, -0.32541272980904_wp, &
      &  1.27417430126401_wp,  1.56809663479464_wp, -0.27464901670133_wp, &
      &  0.92034575959476_wp,  3.43988170777467_wp,  0.52619613142814_wp, &
      &  1.34801157045425_wp,  1.78677763261830_wp, -2.32641538602965_wp, &
      & -5.48724690493950_wp, -1.17608050743204_wp,  1.86913000776332_wp, &
      & -3.80977670102570_wp,  2.57767337265813_wp,  0.23249489585505_wp, &
      &  3.84405066389785_wp,  0.66901029419484_wp,  0.62933738376104_wp, &
      &  5.27994016870968_wp,  2.08865760289451_wp,  0.18524985280678_wp, &
      &  3.81208216690782_wp,  0.40828666936674_wp,  2.68280072715669_wp, &
      &  4.38911949021512_wp, -1.65675313631897_wp, -0.61947301334738_wp, &
      &  5.99524686343408_wp, -2.25028398931409_wp, -0.01876875995182_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b23

subroutine b24(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.79688050270268_wp,  3.58724633106935_wp,  0.75263634475343_wp, &
      &  2.03631785819198_wp,  3.58900566609907_wp,  2.41196895724379_wp, &
      &  2.25211513393686_wp,  3.63866199969291_wp, -1.51775622034070_wp, &
      & -0.79688050270268_wp,  1.20284091919984_wp,  0.72889760507212_wp, &
      & -2.02295560470635_wp,  1.22613935269219_wp,  2.39366884937292_wp, &
      & -2.01444049875156_wp,  1.22451985739630_wp, -0.93172002118860_wp, &
      &  0.79688050270268_wp, -1.20284091919984_wp,  0.72889760507212_wp, &
      &  2.02295560470635_wp, -1.22613935269219_wp,  2.39366884937292_wp, &
      &  2.01444049875156_wp, -1.22451985739630_wp, -0.93172002118860_wp, &
      &  3.27197009223711_wp,  5.13915557180970_wp, -1.48988087015450_wp, &
      & -0.42912845888634_wp,  5.24824757173505_wp,  0.86881103822484_wp, &
      & -0.79688050270268_wp, -3.58724633106935_wp,  0.75263634475343_wp, &
      &  0.42912845888634_wp, -5.24824757173505_wp,  0.86881103822484_wp, &
      & -2.03631785819198_wp, -3.58900566609907_wp,  2.41196895724379_wp, &
      & -2.25211513393686_wp, -3.63866199969291_wp, -1.51775622034070_wp, &
      & -3.27197009223711_wp, -5.13915557180970_wp, -1.48988087015450_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b24

subroutine b25(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.88200510608465_wp,  3.56644611552468_wp, -0.04442368193188_wp, &
      & -2.08332290602138_wp,  3.60131723185482_wp,  1.62764757442026_wp, &
      &  0.53616065732685_wp,  5.85183932666166_wp,  0.04459564700997_wp, &
      &  0.77769600300162_wp,  1.21610301720043_wp, -0.01189582600652_wp, &
      &  2.00631656610629_wp,  1.23270615100396_wp, -1.67636282439992_wp, &
      &  2.00657356886036_wp,  1.30160556580897_wp,  1.64392189587668_wp, &
      & -0.77769600300162_wp, -1.21610301720043_wp,  0.01189582600652_wp, &
      & -2.00657356886036_wp, -1.30160556580897_wp, -1.64392189587668_wp, &
      & -2.00631656610629_wp, -1.23270615100396_wp,  1.67636282439992_wp, &
      &  1.55028785571833_wp,  5.92044016473767_wp, -1.46016681644101_wp, &
      & -2.12274259315337_wp,  3.53074162996994_wp, -1.70048706821234_wp, &
      &  0.88200510608465_wp, -3.56644611552468_wp,  0.04442368193188_wp, &
      &  2.08332290602138_wp, -3.60131723185482_wp, -1.62764757442026_wp, &
      &  2.12274259315337_wp, -3.53074162996994_wp,  1.70048706821234_wp, &
      & -0.53616065732685_wp, -5.85183932666166_wp, -0.04459564700997_wp, &
      & -1.55028785571833_wp, -5.92044016473767_wp,  1.46016681644101_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b25

subroutine b26(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.87191467572725_wp,  0.68901682476370_wp,  0.57768927882314_wp, &
      & -5.30849771002984_wp,  2.05827080667771_wp,  0.03499394852878_wp, &
      & -4.63702510268385_wp, -1.63881018668722_wp, -0.54317721045825_wp, &
      & -1.28335837026983_wp,  1.57158506923595_wp, -0.32490250375316_wp, &
      & -1.34272978591283_wp,  1.79940667236437_wp, -2.37567298740945_wp, &
      & -0.91581419632810_wp,  3.43648398018774_wp,  0.48944851704805_wp, &
      &  0.84929394672440_wp, -0.23358715755986_wp,  0.40051989496058_wp, &
      &  0.53891020885019_wp, -2.07294453009957_wp, -0.49212058979995_wp, &
      &  0.87087083970968_wp, -0.53521390453427_wp,  2.44398469738714_wp, &
      & -3.65202992235694_wp, -2.96200965301668_wp,  0.21212175841641_wp, &
      & -3.88902236640826_wp,  0.54641431132388_wp,  2.64210925433727_wp, &
      &  3.42885515578928_wp,  0.75240768789135_wp, -0.40872508582957_wp, &
      &  3.44239693325754_wp,  1.09548368786447_wp, -2.44953293331329_wp, &
      &  3.81860928097081_wp,  2.54671209969693_wp,  0.52309887029634_wp, &
      &  5.44598284510181_wp, -0.87987160528062_wp,  0.30591642529606_wp, &
      &  5.22840544733975_wp, -2.43968746016095_wp, -0.59784131830423_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b26

subroutine b27(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.84518568211150_wp,  3.56231895365046_wp,  0.00000000000000_wp, &
      & -2.06457682278315_wp,  3.56420112087881_wp,  1.67154402276107_wp, &
      &  0.78957293174681_wp,  5.70231663612321_wp,  0.00000000000000_wp, &
      &  0.78957293174681_wp,  1.20727043725532_wp,  0.00000000000000_wp, &
      &  2.01500552686530_wp,  1.26274901706458_wp, -1.65920222138719_wp, &
      &  2.01500552686530_wp,  1.26274901706458_wp,  1.65920222138719_wp, &
      & -0.78957293174681_wp, -1.20727043725532_wp,  0.00000000000000_wp, &
      & -2.01500552686530_wp, -1.26274901706458_wp, -1.65920222138719_wp, &
      & -2.01500552686530_wp, -1.26274901706458_wp,  1.65920222138719_wp, &
      & -0.24597242263479_wp,  7.19319339194975_wp,  0.00000000000000_wp, &
      & -2.06457682278315_wp,  3.56420112087881_wp, -1.67154402276107_wp, &
      &  0.84518568211150_wp, -3.56231895365046_wp,  0.00000000000000_wp, &
      &  2.06457682278315_wp, -3.56420112087881_wp, -1.67154402276107_wp, &
      &  2.06457682278315_wp, -3.56420112087881_wp,  1.67154402276107_wp, &
      & -0.78957293174681_wp, -5.70231663612321_wp,  0.00000000000000_wp, &
      &  0.24597242263479_wp, -7.19319339194975_wp,  0.00000000000000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b27

subroutine b28(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.64315954788918_wp,  0.77875235990991_wp, -0.58090559270131_wp, &
      &  4.11958596215551_wp,  2.38476257010863_wp,  0.63785059998969_wp, &
      &  4.50365390140318_wp, -1.52844262162217_wp,  0.51194381693392_wp, &
      &  0.82199307328260_wp,  0.78035295794446_wp, -1.15559209669930_wp, &
      &  0.37497079764397_wp,  2.51100194496379_wp, -2.19680662947956_wp, &
      &  0.37919622527710_wp, -0.81184902340127_wp, -2.38362306525050_wp, &
      & -0.81748418672953_wp,  0.65755288465115_wp,  1.21750330426490_wp, &
      & -0.36567145534404_wp,  2.24298964644115_wp,  2.46583371093556_wp, &
      & -0.44112633010403_wp, -1.08376171666218_wp,  2.26157321323195_wp, &
      &  3.72314409618969_wp, -1.68888792920869_wp,  2.14204236614853_wp, &
      &  4.71446230015724_wp,  0.98408622205700_wp, -2.32530044761125_wp, &
      & -3.62749560797369_wp,  0.73362003067820_wp,  0.63907892197606_wp, &
      & -4.70700544083688_wp,  0.79279302507725_wp,  2.40153766899026_wp, &
      & -4.07079701285666_wp,  2.44146191299973_wp, -0.44341289872482_wp, &
      & -4.23440761171577_wp, -1.47896959146322_wp, -0.77434173911575_wp, &
      & -6.00176641859254_wp, -1.41496834679465_wp, -1.18103158990020_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b28

subroutine b29(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.79331647921606_wp,  3.61026319536790_wp,  0.75447126882846_wp, &
      &  1.99657313816513_wp,  3.61112302075836_wp,  2.43936431699223_wp, &
      &  2.26576462579469_wp,  3.96153682730548_wp, -1.47115179445147_wp, &
      & -0.79331647921606_wp,  1.20631423583208_wp,  0.68564366361650_wp, &
      & -2.04245568867159_wp,  1.20428278023923_wp,  2.33522339953503_wp, &
      & -1.98160839691881_wp,  1.27972442691629_wp, -1.00071392230026_wp, &
      &  0.79331647921606_wp, -1.20631423583208_wp,  0.68564366361650_wp, &
      &  2.04245568867159_wp, -1.20428278023923_wp,  2.33522339953503_wp, &
      &  1.98160839691881_wp, -1.27972442691629_wp, -1.00071392230026_wp, &
      &  3.52975708265471_wp,  2.65998039437596_wp, -1.50806381500513_wp, &
      & -0.43218414604321_wp,  5.25924577782845_wp,  0.86271478172015_wp, &
      & -0.79331647921606_wp, -3.61026319536790_wp,  0.75447126882846_wp, &
      &  0.43218414604321_wp, -5.25924577782845_wp,  0.86271478172015_wp, &
      & -1.99657313816513_wp, -3.61112302075836_wp,  2.43936431699223_wp, &
      & -2.26576462579469_wp, -3.96153682730548_wp, -1.47115179445147_wp, &
      & -3.52975708265471_wp, -2.65998039437596_wp, -1.50806381500513_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b29

subroutine b30(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.63873947846436_wp, -0.65018862191130_wp,  0.71910315452537_wp, &
      &  4.10366312975981_wp, -2.46590929998087_wp, -0.13471857601342_wp, &
      &  4.43733018331730_wp,  1.19977389368616_wp, -1.06730409177088_wp, &
      &  0.81584390444619_wp, -0.52136788115862_wp,  1.28067306943500_wp, &
      &  0.36973814598201_wp, -1.94793347723079_wp,  2.71215384317880_wp, &
      &  0.40023076686225_wp,  1.32338843894275_wp,  2.12061665125388_wp, &
      & -0.81788291894357_wp, -0.92758907986211_wp, -1.06236434765952_wp, &
      & -0.37823435467546_wp, -2.77416520622945_wp, -1.88358263322763_wp, &
      & -0.35584865890530_wp,  0.49403299264643_wp, -2.47910714729295_wp, &
      &  4.13155548748120_wp,  2.83325316295251_wp, -0.33370484808014_wp, &
      &  4.72031667171692_wp, -0.48688415868572_wp,  2.47411260112373_wp, &
      & -3.64187453411881_wp, -0.83014157236760_wp, -0.51220459914025_wp, &
      & -4.70323165774950_wp, -1.18168732486832_wp, -2.23936515171828_wp, &
      & -4.15655656421928_wp, -2.30359694297506_wp,  0.84807507336868_wp, &
      & -4.46473310197027_wp,  1.58757971122469_wp,  0.35519481366332_wp, &
      & -3.88135763721328_wp,  1.78639590793946_wp,  2.06115074930423_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b30

subroutine b31(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.64187642384495_wp, -0.83021716141292_wp, -0.51214601763014_wp, &
      & -4.15649987243529_wp, -2.30358749434440_wp,  0.84824703844678_wp, &
      & -4.46484648553824_wp,  1.58753246807137_wp,  0.35504930475109_wp, &
      & -0.81787347031291_wp, -0.92760608739731_wp, -1.06228308943580_wp, &
      & -0.37815120672561_wp, -2.77424835417929_wp, -1.88331051266450_wp, &
      & -0.35587700479729_wp,  0.49388559400806_wp, -2.47916572880307_wp, &
      &  0.81581555855419_wp, -0.52109009141708_wp,  1.28073165094512_wp, &
      &  0.36963799049696_wp, -1.94743458953170_wp,  2.71241084593288_wp, &
      &  0.40024777439744_wp,  1.32380228896585_wp,  2.12038988411793_wp, &
      & -3.88125559200210_wp,  1.78662267507540_wp,  2.06090319518082_wp, &
      & -4.70321276048817_wp, -1.18194810707465_wp, -2.23928200376843_wp, &
      &  3.63872436065529_wp, -0.65009791505692_wp,  0.71924299425921_wp, &
      &  4.72026186965907_wp, -0.48650810318528_wp,  2.47424866140530_wp, &
      &  4.10360265852356_wp, -2.46599433765685_wp, -0.13422535749273_wp, &
      &  4.43740577236261_wp,  1.19951122175369_wp, -1.06748361575351_wp, &
      &  4.13203169846669_wp,  2.83313222048001_wp, -0.33402799124887_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b31

subroutine b32(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.84508434409254_wp,  0.67051640592275_wp,  0.61990576063181_wp, &
      &  3.81154359495995_wp,  0.40223576628924_wp,  2.67181763887236_wp, &
      &  4.39510236315183_wp, -1.65007673389148_wp, -0.63786382807262_wp, &
      &  1.27381903275102_wp,  1.56805317109358_wp, -0.28214744999662_wp, &
      &  0.93473224464442_wp,  3.45395827773853_wp,  0.49130044865827_wp, &
      &  1.34109139335562_wp,  1.75432725546439_wp, -2.33773484556564_wp, &
      & -0.86152992343483_wp, -0.21494500925894_wp,  0.48424043182581_wp, &
      & -0.97581489077336_wp, -0.33055845406889_wp,  2.54249801042060_wp, &
      & -0.47323277710175_wp, -2.11082786988553_wp, -0.21684229429636_wp, &
      &  5.96833905302792_wp, -2.27806485319364_wp,  0.01258368631889_wp, &
      &  5.28013858995363_wp,  2.09282444901753_wp,  0.18082411420356_wp, &
      & -3.39847591847701_wp,  0.65722974148243_wp, -0.52252817300421_wp, &
      & -3.80458751306480_wp,  2.57200797371174_wp,  0.15320576677144_wp, &
      & -3.34580358197509_wp,  0.71326012132249_wp, -2.59063878365586_wp, &
      & -5.27245874294958_wp, -1.07584187443926_wp,  0.34178909647663_wp, &
      & -6.87093461505649_wp, -0.54693209628429_wp, -0.33523552624778_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b32

subroutine b33(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.54037167434313_wp, -0.97620228463060_wp,  0.01422207887610_wp, &
      &  3.51840738750060_wp, -2.23583514330205_wp, -1.61413414284400_wp, &
      &  5.86309453550912_wp,  0.37407317773085_wp, -0.15333048869621_wp, &
      &  1.23670292177502_wp,  0.74665536154285_wp, -0.04680095740705_wp, &
      &  1.31950694146580_wp,  2.04016534059854_wp,  1.56607084838019_wp, &
      &  1.32849447895380_wp,  1.90437340014164_wp, -1.75287972524660_wp, &
      & -1.23263245168478_wp, -0.74527775119197_wp,  0.02882588243104_wp, &
      & -1.32463376846432_wp, -1.89199380424511_wp,  1.74223489794005_wp, &
      & -1.32733796656048_wp, -2.04290166403895_wp, -1.57298913575268_wp, &
      &  5.97585827331068_wp,  1.44149443252197_wp,  1.31128474306161_wp, &
      &  3.49348567926010_wp, -2.15636837996194_wp,  1.71373026895160_wp, &
      & -3.53274284994467_wp,  0.96333513939178_wp, -0.04666111767321_wp, &
      & -3.48939253245627_wp,  2.26613312239060_wp,  1.56102338987925_wp, &
      & -3.50722965742458_wp,  2.09277531613807_wp, -1.78020894458039_wp, &
      & -5.72264064068240_wp, -0.60215367333948_wp,  0.04733197045039_wp, &
      & -7.18098009195291_wp,  0.47573477450169_wp, -0.02366126090986_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b33

subroutine b34(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.63999654052070_wp, -1.37047285526972_wp,  0.21100493027188_wp, &
      &  1.54204864977894_wp, -2.63880223360471_wp, -0.98395961040609_wp, &
      &  4.00730788397011_wp,  0.19189790934227_wp, -1.50521410799674_wp, &
      &  0.92180084871709_wp,  0.12722392217039_wp,  1.97579370960792_wp, &
      & -0.12880184349135_wp, -1.20473064533272_wp,  3.15628861728639_wp, &
      &  2.09389214428261_wp,  1.23085988857213_wp,  3.27205135046083_wp, &
      & -0.91186277898424_wp,  1.90422978095554_wp,  0.61527215215397_wp, &
      &  0.15631814571230_wp,  3.33117710170655_wp, -0.42338747089463_wp, &
      & -2.05877536355519_wp,  2.88559668710731_wp,  2.02068982307302_wp, &
      &  5.08178915559369_wp,  1.27415918345494_wp, -0.51769992273469_wp, &
      &  3.92889180835988_wp, -2.54582770786674_wp,  1.32099415593238_wp, &
      & -2.66985988259869_wp,  0.58059000843712_wp, -1.24372325435869_wp, &
      & -3.97379926018178_wp,  1.95307353231224_wp, -2.04906217123216_wp, &
      & -1.59217741490600_wp, -0.23304669588586_wp, -2.80705777929845_wp, &
      & -4.22557692149680_wp, -1.28849086644675_wp, -0.07307759928482_wp, &
      & -3.18368775648709_wp, -2.72916137837478_wp,  0.28738766056312_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b34

subroutine b35(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.86569180757166_wp,  0.66231121505376_wp,  0.62691853431095_wp, &
      &  3.85224451641004_wp,  0.42264480852441_wp,  2.68344512376801_wp, &
      &  4.66986854287341_wp, -1.60009347767666_wp, -0.59096838435893_wp, &
      &  1.28421441620803_wp,  1.56941566363539_wp, -0.27183143503720_wp, &
      &  0.91045115356297_wp,  3.41381860494991_wp,  0.58508944635952_wp, &
      &  1.35942362657074_wp,  1.84656289828440_wp, -2.31587638338655_wp, &
      & -0.85511430321368_wp, -0.25373730731482_wp,  0.38743165176421_wp, &
      & -0.88877221536651_wp, -0.57092027981514_wp,  2.43335498788965_wp, &
      & -0.55318897951028_wp, -2.08509357940789_wp, -0.51421337801951_wp, &
      &  3.59213316284900_wp, -2.94501723562977_wp, -0.02305465882120_wp, &
      &  5.29999394243186_wp,  2.06550467831440_wp,  0.17268128429696_wp, &
      & -3.42332203767219_wp,  0.73407167522396_wp, -0.45567155214885_wp, &
      & -3.80196646291849_wp,  2.56418639724773_wp,  0.43382631805269_wp, &
      & -3.42611694262273_wp,  1.02401802497100_wp, -2.49397929195876_wp, &
      & -5.42365573084176_wp, -1.00024338049317_wp,  0.02723662275328_wp, &
      & -5.54271225666582_wp, -1.20537693167017_wp,  1.82750312050812_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b35

subroutine b36(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.63234503940864_wp,  0.47585571697420_wp, -1.29502742914040_wp, &
      &  1.50865340955859_wp,  2.11899337650573_wp, -1.85113792525212_wp, &
      &  4.18735343100692_wp,  1.05356389305867_wp,  0.83418180683971_wp, &
      &  0.93066744373258_wp, -1.80747958240406_wp, -0.87033415748794_wp, &
      & -0.13130762034356_wp, -2.14896443297329_wp, -2.60425048099103_wp, &
      &  2.11771781136603_wp, -3.45889235267150_wp, -0.52752082944729_wp, &
      & -0.92086354455517_wp, -1.51431313932658_wp,  1.33540898687403_wp, &
      &  0.11200784734840_wp, -1.38913390083197_wp,  3.12042728446261_wp, &
      & -2.09742215269884_wp, -3.20327854730672_wp,  1.45532911754082_wp, &
      &  3.10302857595714_wp,  1.65091577229449_wp,  2.16055601307241_wp, &
      &  3.94147171522650_wp,  0.08232780870530_wp, -2.83233853550420_wp, &
      & -2.63956568296240_wp,  0.77733884476251_wp,  1.11943407687266_wp, &
      & -3.97681715281600_wp,  0.78739974669399_wp,  2.69557527581500_wp, &
      & -1.53785156803780_wp,  2.52758429177986_wp,  1.22421372176277_wp, &
      & -3.93616536424536_wp,  0.62209595321982_wp, -1.23767235128119_wp, &
      & -5.06449249229938_wp,  2.03935842753979_wp, -1.34980870000662_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b36

subroutine b37(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.69472946686341_wp,  3.60784056646554_wp, -0.01706611670609_wp, &
      &  1.89244544879087_wp,  3.68609790508060_wp, -1.68981389501380_wp, &
      & -0.84011743662310_wp,  5.81529391297778_wp, -0.12943490174587_wp, &
      & -0.84011743662310_wp,  1.17392432991442_wp, -0.02256333002665_wp, &
      & -2.07303712668008_wp,  1.14821271615038_wp,  1.63893679833812_wp, &
      & -2.06668386742132_wp,  1.17312497576021_wp, -1.68208113567804_wp, &
      &  0.84011743662310_wp, -1.17392432991442_wp, -0.02256333002665_wp, &
      &  2.07303712668008_wp, -1.14821271615038_wp,  1.63893679833812_wp, &
      &  2.06668386742132_wp, -1.17312497576021_wp, -1.68208113567804_wp, &
      & -1.86817380634008_wp,  5.83911958006120_wp,  1.36721496741663_wp, &
      &  1.93589214231204_wp,  3.65542387049160_wp,  1.63901238738344_wp, &
      & -0.69472946686341_wp, -3.60784056646554_wp, -0.01706611670609_wp, &
      & -1.93589214231204_wp, -3.65542387049160_wp,  1.63901238738344_wp, &
      & -1.89244544879087_wp, -3.68609790508060_wp, -1.68981389501380_wp, &
      &  0.84011743662310_wp, -5.81529391297778_wp, -0.12943490174587_wp, &
      &  1.86817380634008_wp, -5.83911958006120_wp,  1.36721496741663_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b37

subroutine b38(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.85691213995827_wp,  0.66092226634609_wp, -0.62943564951995_wp, &
      &  5.30238255626383_wp,  2.06958837648757_wp, -0.17983956688833_wp, &
      &  4.54096276444475_wp, -1.75021521139923_wp,  0.35825805972473_wp, &
      &  1.27980946459227_wp,  1.56047914875298_wp,  0.28944935177409_wp, &
      &  1.32991366327960_wp,  1.74009572795763_wp,  2.35131063810429_wp, &
      &  0.94951368245585_wp,  3.46042114111300_wp, -0.45690176386136_wp, &
      & -0.86570621818851_wp, -0.20130685575791_wp, -0.49397252141017_wp, &
      & -0.48515127982186_wp, -2.11031197465125_wp,  0.17744150442570_wp, &
      & -0.97846995599006_wp, -0.29315510472068_wp, -2.55287071716401_wp, &
      &  4.69836939240959_wp, -1.57319322617503_wp,  2.15909903422396_wp, &
      &  3.83006669051450_wp,  0.42280165579344_wp, -2.67483742123271_wp, &
      & -3.39991211033800_wp,  0.66506076657711_wp,  0.52541567453526_wp, &
      & -3.33762862672422_wp,  0.72532413295483_wp,  2.59395714274521_wp, &
      & -3.81433472045822_wp,  2.57776218978638_wp, -0.15017275632816_wp, &
      & -5.27161403536818_wp, -1.07530519221752_wp, -0.32535036884666_wp, &
      & -6.87607655986407_wp, -0.52609219649083_wp,  0.32079990831867_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b38

subroutine b39(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.63996252545031_wp, -0.09250209420475_wp,  0.91799116083319_wp, &
      & -2.99776894062927_wp,  1.33037286672989_wp,  2.36509052106529_wp, &
      & -5.06901082748311_wp, -0.80130057212750_wp, -0.00813338127594_wp, &
      & -0.96116006461283_wp,  1.00044747091552_wp, -1.14929174977226_wp, &
      & -0.58606643477022_wp, -0.46546222324333_wp, -2.55312394046581_wp, &
      & -2.01004499576647_wp,  2.50255675887593_wp, -2.09560045670674_wp, &
      &  1.55038234202497_wp,  2.04439832713620_wp, -0.16545308183867_wp, &
      &  1.20026522248071_wp,  3.54675516922001_wp,  1.21155066694631_wp, &
      &  2.57702330686842_wp,  2.91955695544140_wp, -1.73176770489000_wp, &
      & -4.81482754480093_wp, -2.14516419372006_wp, -1.20302044318246_wp, &
      & -1.71926527679483_wp, -1.70110878811006_wp,  1.82994842612407_wp, &
      &  3.24973746428371_wp,  0.06626891602803_wp,  1.06742692396952_wp, &
      &  5.02828156014103_wp,  0.94287696427716_wp,  1.65244078128372_wp, &
      &  2.36626971017221_wp, -0.70766086279075_wp,  2.75584431137112_wp, &
      &  3.71168857637214_wp, -2.05809317242122_wp, -0.52620180060654_wp, &
      &  4.62073188396611_wp, -1.45924840954043_wp, -1.98072400508862_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b39

subroutine b40(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.54434009922219_wp,  0.24705523570894_wp, -0.60577060915782_wp, &
      &  5.45649539157905_wp,  0.86368610095245_wp, -0.11867858059748_wp, &
      &  3.12412925795694_wp, -2.26837244785807_wp,  0.28329073430702_wp, &
      &  1.63289156443902_wp,  1.99473443463783_wp,  0.63218331131716_wp, &
      &  1.71643635677390_wp,  1.70186278883708_wp,  2.67466734588075_wp, &
      &  2.25027832013569_wp,  3.93327219353591_wp,  0.28134809584241_wp, &
      & -1.08724826137736_wp,  1.71676327939489_wp, -0.31093931735727_wp, &
      & -1.14516458789804_wp,  1.94005142953052_wp, -2.36291355656021_wp, &
      & -2.23089350946455_wp,  3.23951026645254_wp,  0.48295541805545_wp, &
      &  4.33950473059621_wp, -3.35090962198614_wp, -0.52052506330335_wp, &
      &  3.34630624912644_wp,  0.33817216065828_wp, -2.66438156653946_wp, &
      & -2.36210664350147_wp, -0.75868346837866_wp,  0.39052513344375_wp, &
      & -1.47249350000582_wp, -2.34094737999155_wp, -0.58104354270901_wp, &
      & -2.17858022092788_wp, -1.08333652828228_wp,  2.42584143678530_wp, &
      & -4.96091660295592_wp, -0.52098804620591_wp, -0.31271565992218_wp, &
      & -5.75485102261743_wp, -2.12568300701614_wp, -0.01787491949097_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b40

subroutine b41(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.51970940880615_wp,  0.22178392813386_wp, -0.65693305447957_wp, &
      &  5.45395559965645_wp,  0.82826696404378_wp, -0.24968573448591_wp, &
      &  3.19666828529389_wp, -2.37301981191888_wp,  0.01224920479336_wp, &
      &  1.64951548523002_wp,  1.98997421450909_wp,  0.63756525134362_wp, &
      &  1.75728656658849_wp,  1.69772239887993_wp,  2.68395912927615_wp, &
      &  2.28180462121062_wp,  3.92740270416717_wp,  0.29825925500561_wp, &
      & -1.08966522110132_wp,  1.74731259205912_wp, -0.25554766495013_wp, &
      & -1.18889663006527_wp,  2.07185415812090_wp, -2.29186552314211_wp, &
      & -2.22539062696559_wp,  3.22098906062412_wp,  0.63644275402069_wp, &
      &  3.56023458572589_wp, -2.52044679617595_wp,  1.78563434830790_wp, &
      &  3.26218698004716_wp,  0.29434941163667_wp, -2.69956448768152_wp, &
      & -2.33688824825811_wp, -0.77014843682688_wp,  0.34000708473332_wp, &
      & -1.47363489459009_wp, -2.29128159776704_wp, -0.74660622866339_wp, &
      & -2.09465937309256_wp, -1.20978377301206_wp,  2.34979129829345_wp, &
      & -4.95538348483883_wp, -0.50312446507174_wp, -0.26551219084883_wp, &
      & -5.71918811103762_wp, -2.14345210184367_wp, -0.13081062237061_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b41

subroutine b42(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.47119258007045_wp,  0.43175517821105_wp, -0.19875194602625_wp, &
      & -4.88440159183538_wp,  0.70886083888513_wp, -1.68259703091231_wp, &
      & -2.96555288951584_wp, -2.20126260370090_wp,  0.13353749718036_wp, &
      & -1.04435525761312_wp,  1.77773151362018_wp, -0.92913298611268_wp, &
      & -0.30846188639706_wp,  0.97179733301484_wp, -2.67691800970502_wp, &
      & -1.54700162197324_wp,  3.73951101422662_wp, -1.33140654692458_wp, &
      &  1.02029526448922_wp,  1.71693902392524_wp,  1.10235473208364_wp, &
      &  0.17280411649559_wp,  1.92923274741975_wp,  2.97533222225352_wp, &
      &  2.29523301511091_wp,  3.31628039060101_wp,  0.83081431487091_wp, &
      & -4.52709595408163_wp, -3.00837597341316_wp,  0.58604753750889_wp, &
      & -4.21586939835216_wp,  1.24774648129560_wp,  1.55263489557537_wp, &
      &  2.62119943467688_wp, -0.66932209900677_wp,  1.07424883530924_wp, &
      &  3.93141081329502_wp, -0.63721754173517_wp,  2.67479962671005_wp, &
      &  1.41862685658792_wp, -2.33225652950640_wp,  1.22967880973908_wp, &
      &  3.99609235937143_wp, -0.68863321035872_wp, -1.25440965564015_wp, &
      &  4.66474171587489_wp, -2.35903772826166_wp, -1.48371847323516_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b42

subroutine b43(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.37198613172419_wp, -0.77944966885294_wp,  0.42924751163271_wp, &
      &  1.44714282393316_wp, -2.38592475168036_wp, -0.44595269064742_wp, &
      &  4.94136171693282_wp, -0.87037951091513_wp, -0.38721055380667_wp, &
      &  1.09560652006311_wp,  1.68846652028106_wp, -0.33988425253468_wp, &
      &  2.23166640745290_wp,  3.25041587596542_wp,  0.40172554023336_wp, &
      &  1.14562001189606_wp,  1.85105477730227_wp, -2.39774876809382_wp, &
      & -1.61914569654841_wp,  2.01001853960061_wp,  0.61187253484091_wp, &
      & -2.22050946436435_wp,  3.95041578901345_wp,  0.24394663622034_wp, &
      & -1.69776208312872_wp,  1.73599313252313_wp,  2.65726296819687_wp, &
      &  5.81301679298765_wp,  0.50447750898289_wp,  0.41760868838027_wp, &
      &  2.23739983654008_wp, -1.03010861229729_wp,  2.47904667605670_wp, &
      & -3.54837277478976_wp,  0.26595816621619_wp, -0.60477094403353_wp, &
      & -5.45357387497761_wp,  0.90234989763129_wp, -0.11558698864408_wp, &
      & -3.35706068054869_wp,  0.33957811690115_wp, -2.66458376723567_wp, &
      & -3.14060578010957_wp, -2.24191439227154_wp,  0.30504148209653_wp, &
      & -4.35243990597581_wp, -3.32986185231806_wp, -0.49715670994409_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b43

subroutine b44(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.39962904559604_wp, -0.72924531468057_wp,  0.48685581279373_wp, &
      & -2.31984480826561_wp, -0.90811734178886_wp,  2.53870155061963_wp, &
      & -5.02791117381898_wp, -0.68242923946446_wp, -0.12391690143784_wp, &
      & -1.07238367561608_wp,  1.69925118732143_wp, -0.32367985094518_wp, &
      & -1.08067201443491_wp,  1.82665841292672_wp, -2.38898043883723_wp, &
      & -2.20623258343039_wp,  3.27593473766391_wp,  0.37225148173874_wp, &
      &  1.64401638218332_wp,  1.98198067296699_wp,  0.63616685400529_wp, &
      &  1.69601975563420_wp,  1.70138468812546_wp,  2.68649703147262_wp, &
      &  2.26597816484771_wp,  3.92456244578944_wp,  0.30611673626615_wp, &
      & -5.16141087647669_wp, -0.77843677564572_wp, -1.93183490030473_wp, &
      & -1.47642224063609_wp, -2.38154058705206_wp, -0.32319986050743_wp, &
      &  3.57472500571285_wp,  0.24140495457161_wp, -0.60527361118487_wp, &
      &  3.43592273152627_wp,  0.38960861626930_wp, -2.65538269069465_wp, &
      &  5.48407783421465_wp,  0.82511868030639_wp, -0.06710606470490_wp, &
      &  3.20589203854850_wp, -2.37295178177810_wp, -0.05506661951229_wp, &
      &  3.45837267798495_wp, -2.59248126663542_wp,  1.73039576371752_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b44

subroutine b45(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.23888287737642_wp, -0.03309288403909_wp,  1.06795415756059_wp, &
      &  2.35425861087159_wp, -0.93041988960918_wp,  2.69485717988450_wp, &
      &  3.65681848837767_wp, -2.02614168296639_wp, -0.69586141281701_wp, &
      &  1.55977995008381_wp,  2.06613395711665_wp,  0.02426030409399_wp, &
      &  1.22215581000406_wp,  3.42993607913729_wp,  1.54128142096899_wp, &
      &  2.59443524345683_wp,  3.08156884599209_wp, -1.44928766309399_wp, &
      & -0.95698943903755_wp,  1.14469026663868_wp, -1.05957889133964_wp, &
      & -0.62448267732566_wp, -0.06937373606436_wp, -2.68936941519460_wp, &
      & -2.05471056264336_wp,  2.76302716040222_wp, -1.71420081075869_wp, &
      &  4.48629109769423_wp, -1.30806276000504_wp, -2.14394154091208_wp, &
      &  5.03468962145764_wp,  0.76555262287170_wp,  1.71082764961149_wp, &
      & -2.55104713144577_wp, -0.29759596113296_wp,  0.83943146603687_wp, &
      & -1.64934352015192_wp, -2.09603131426503_wp,  1.30638279347291_wp, &
      & -2.73997250158101_wp,  0.80456034970673_wp,  2.58397560931130_wp, &
      & -4.96412535792956_wp, -0.71346043229258_wp, -0.28956273534207_wp, &
      & -5.90862748668100_wp, -1.80474514868978_wp,  0.81046763359813_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b45

subroutine b46(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.23888665682868_wp, -0.03308721486069_wp,  1.06794659865606_wp, &
      &  2.35427372868065_wp, -0.93038965399105_wp,  2.69487040796743_wp, &
      &  3.65679392193795_wp, -2.02616058022772_wp, -0.69585007446021_wp, &
      &  1.55978561926221_wp,  2.06613773656892_wp,  0.02424707601106_wp, &
      &  1.22217848671766_wp,  3.42995119694635_wp,  1.54126063398153_wp, &
      &  2.59443713318296_wp,  3.08155750763529_wp, -1.44931411925985_wp, &
      & -0.95699132876368_wp,  1.14470160499548_wp, -1.05957700161351_wp, &
      & -0.62449779513472_wp, -0.06937184633823_wp, -2.68936374601620_wp, &
      & -2.05470678319109_wp,  2.76304227821128_wp, -1.71419703130643_wp, &
      &  4.48630054632490_wp, -1.30811567233676_wp, -2.14392642310302_wp, &
      &  5.03470473926671_wp,  0.76555451259783_wp,  1.71079363454110_wp, &
      & -2.55104713144577_wp, -0.29757706387164_wp,  0.83944091466753_wp, &
      & -1.64932273316446_wp, -2.09599351974238_wp,  1.30642814690010_wp, &
      & -2.74000651665141_wp,  0.80460570313392_wp,  2.58396616068064_wp, &
      & -4.96410835039437_wp, -0.71349255763684_wp, -0.28957596342500_wp, &
      & -5.90865961202526_wp, -1.80465633156153_wp,  0.81053188428665_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b46

subroutine b47(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.64574130796467_wp, -0.12120325471102_wp,  0.93055028071235_wp, &
      &  1.73469678039597_wp, -1.73072457606465_wp,  1.83393952771673_wp, &
      &  4.95832578842774_wp, -1.09025292592864_wp, -0.04760598073966_wp, &
      &  0.96527966758252_wp,  1.00239577855853_wp, -1.12031468925059_wp, &
      &  2.00192295284733_wp,  2.52861797197455_wp, -2.05184384809977_wp, &
      &  0.62403103277990_wp, -0.42677008067250_wp, -2.56920928930894_wp, &
      & -1.54219982786957_wp,  2.04838564927659_wp, -0.12532285768071_wp, &
      & -2.55395919941655_wp,  2.95861381515588_wp, -1.67420097770390_wp, &
      & -1.17423613472635_wp,  3.50169087012909_wp,  1.29915270128849_wp, &
      &  5.82606913138749_wp,  0.28759553043773_wp, -0.85206428523521_wp, &
      &  2.99740233375949_wp,  1.29155411250815_wp,  2.40309858277602_wp, &
      & -3.27760336583924_wp,  0.05924291426596_wp,  1.03844608399558_wp, &
      & -2.42104342213390_wp, -0.76760864490428_wp,  2.72863603450983_wp, &
      & -5.04019250395661_wp,  0.94638051652753_wp,  1.62096739254051_wp, &
      & -3.98588783825385_wp, -1.86427152187567_wp, -0.70805203610026_wp, &
      & -2.52152016061943_wp, -2.88607856727120_wp, -1.03337027960265_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b47

subroutine b48(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.43131298229595_wp,  2.90023261600651_wp, -0.64392984895918_wp, &
      & -0.19436211221955_wp,  4.85083060708467_wp, -0.45416733014707_wp, &
      &  3.11080101954170_wp,  3.02740740529745_wp, -0.87701055991543_wp, &
      & -0.43131298229595_wp,  1.38194727234861_wp,  1.64969122976038_wp, &
      &  0.28258019728105_wp,  2.30686616918495_wp,  3.34828479238757_wp, &
      & -2.49422873580830_wp,  1.46739879835156_wp,  1.75560471033022_wp, &
      &  0.43131298229595_wp, -1.38194727234861_wp,  1.64969122976038_wp, &
      & -0.28258019728105_wp, -2.30686616918495_wp,  3.34828479238757_wp, &
      &  2.49422873580830_wp, -1.46739879835156_wp,  1.75560471033022_wp, &
      &  3.71129929278877_wp,  1.36435770150371_wp, -1.28593217726282_wp, &
      & -0.41284090934699_wp,  2.15709592452310_wp, -2.38226813161322_wp, &
      & -0.43131298229595_wp, -2.90023261600651_wp, -0.64392984895918_wp, &
      &  0.41284090934699_wp, -2.15709592452310_wp, -2.38226813161322_wp, &
      &  0.19436211221955_wp, -4.85083060708467_wp, -0.45416733014707_wp, &
      & -3.11080101954170_wp, -3.02740740529745_wp, -0.87701055991543_wp, &
      & -3.71129929278877_wp, -1.36435770150371_wp, -1.28593217726282_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b48

subroutine b49(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.27242362650901_wp,  0.03490891085280_wp,  1.05327665468647_wp, &
      &  2.40000510109649_wp, -0.78789296521468_wp,  2.73841914669978_wp, &
      &  3.97055082095935_wp, -1.89265709811775_wp, -0.69255250235833_wp, &
      &  1.55899193428640_wp,  2.04254261607371_wp, -0.10924317801599_wp, &
      &  1.20112693759731_wp,  3.49379937379816_wp,  1.31956552297592_wp, &
      &  2.58280397910891_wp,  2.95025744619626_wp, -1.65157339698873_wp, &
      & -0.95670220066535_wp,  1.03416018512620_wp, -1.11982713990830_wp, &
      & -0.63029736463654_wp, -0.36309386889878_wp, -2.60345490628909_wp, &
      & -2.00817983607331_wp,  2.57140704080148_wp, -2.00308324469292_wp, &
      &  2.46480192046700_wp, -2.80032090563472_wp, -1.14411201044202_wp, &
      &  5.04235057120036_wp,  0.90075307904901_wp,  1.64534863910700_wp, &
      & -2.63092018590445_wp, -0.12715967148187_wp,  0.90111401674039_wp, &
      & -1.72435808872295_wp, -1.78379753450674_wp,  1.74544176318756_wp, &
      & -2.95617417871833_wp,  1.25018611773316_wp,  2.41209934834696_wp, &
      & -4.94858991939111_wp, -0.82633188448370_wp, -0.28120447665631_wp, &
      & -6.01052529921846_wp, -1.58608871730584_wp,  0.97949796700635_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b49

subroutine b50(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.27240472924768_wp,  0.03485032934268_wp,  1.05327287523421_wp, &
      &  2.39997864493063_wp, -0.78802335631784_wp,  2.73837946245099_wp, &
      &  3.97047523191403_wp, -1.89264575976095_wp, -0.69266399620017_wp, &
      &  1.55900327264319_wp,  2.04257474141797_wp, -0.10912034581735_wp, &
      &  1.20114961431091_wp,  3.49374457174031_wp,  1.31978095175507_wp, &
      &  2.58281720719184_wp,  2.95038027839490_wp, -1.65139765245837_wp, &
      & -0.95670409039148_wp,  1.03427734814644_wp, -1.11975910976752_wp, &
      & -0.63032760025467_wp, -0.36271403394607_wp, -2.60364198917624_wp, &
      & -2.00827621210609_wp,  2.57164325656809_wp, -2.00270152001408_wp, &
      &  2.46466586018544_wp, -2.80010358712943_wp, -1.14443515361074_wp, &
      &  5.04236190955716_wp,  0.90061701876744_wp,  1.64537320554673_wp, &
      & -2.63079735370581_wp, -0.12742045368821_wp,  0.90106866331320_wp, &
      & -1.72427872022537_wp, -1.78434366535914_wp,  1.74488618370449_wp, &
      & -2.95579434376562_wp,  1.24957384646610_wp,  2.41243194014634_wp, &
      & -4.94864283172283_wp, -0.82611456597842_wp, -0.28118746912112_wp, &
      & -6.01038923893689_wp, -1.58638162485644_wp,  0.97936568617705_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b50

subroutine b51(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.59861153821050_wp, -0.26573706825864_wp,  0.88453922882885_wp, &
      &  1.69516370969600_wp, -1.99943796298259_wp,  1.52166606370964_wp, &
      &  4.98160910411102_wp, -1.03647887909125_wp, -0.10316581877263_wp, &
      &  0.96776843689953_wp,  1.05598463223490_wp, -1.08539444004100_wp, &
      &  2.03720602947444_wp,  2.64240216188786_wp, -1.86995959753566_wp, &
      &  0.60538888447898_wp, -0.25799108083995_wp, -2.62917974813606_wp, &
      & -1.52882245657488_wp,  2.05642076479362_wp, -0.02146539914345_wp, &
      & -2.54872276830232_wp,  3.05689091242273_wp, -1.51551122569483_wp, &
      & -1.16058097369012_wp,  3.44724974996679_wp,  1.46390280500572_wp, &
      &  5.82411893401836_wp,  0.45541076994251_wp, -0.70515886539081_wp, &
      &  2.84855238572436_wp,  0.96130746325119_wp,  2.53575924703073_wp, &
      & -3.24516243731600_wp,  0.01084891772890_wp,  1.06867792266949_wp, &
      & -2.36028116805710_wp, -0.89524074791938_wp,  2.68994200221287_wp, &
      & -5.00893832344481_wp,  0.86356893793221_wp,  1.72996679588536_wp, &
      & -3.74027824303657_wp, -1.98294632302089_wp, -0.67275384166409_wp, &
      & -4.61691085772542_wp, -1.26384127876939_wp, -2.09220839829821_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b51

subroutine b52(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.36105028659318_wp, -0.78570844180506_wp,  0.39917818940623_wp, &
      &  1.45342994277727_wp, -2.36363732166910_wp, -0.54468143246003_wp, &
      &  4.94310026497508_wp, -0.85121012902314_wp, -0.37025404121628_wp, &
      &  1.09458606795135_wp,  1.70565357945965_wp, -0.30859416722636_wp, &
      &  2.22715185172144_wp,  3.24444245165937_wp,  0.48520797160585_wp, &
      &  1.15818858040588_wp,  1.92482779580399_wp, -2.36035108792402_wp, &
      & -1.62809354978763_wp,  1.99915450406265_wp,  0.62709427884130_wp, &
      & -2.24104322852428_wp,  3.94220681869220_wp,  0.28395402817966_wp, &
      & -1.70620348976432_wp,  1.72170680295851_wp,  2.67695769395381_wp, &
      &  5.79207295825688_wp,  0.52173070857613_wp,  0.46188497167378_wp, &
      &  2.19404573959941_wp, -1.09939353123341_wp,  2.44049248349356_wp, &
      & -3.54385443960603_wp,  0.25113515442984_wp, -0.62947344404261_wp, &
      & -5.46094947607426_wp,  0.87152468495166_wp, -0.16530757292644_wp, &
      & -3.33982448849064_wp,  0.34088769711124_wp, -2.67723170424308_wp, &
      & -3.22294303744553_wp, -2.34991224076595_wp,  0.00568618593385_wp, &
      & -3.54025262159675_wp, -2.51673537405097_wp,  1.78638456958266_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b52

subroutine b53(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.43173360286764_wp, -0.69434585245844_wp,  0.55985971275937_wp, &
      &  1.48471246918106_wp, -2.40750731384404_wp, -0.07566463436074_wp, &
      &  5.03532645916443_wp, -0.69099347829870_wp, -0.15733670809793_wp, &
      &  1.06317881962279_wp,  1.65780571377499_wp, -0.39395687610107_wp, &
      &  2.19897414535398_wp,  3.28932155758927_wp,  0.15724600124355_wp, &
      &  1.02184106046592_wp,  1.63579985295753_wp, -2.46332982380949_wp, &
      & -1.63080719651445_wp,  1.99074522277131_wp,  0.61550458846832_wp, &
      & -2.23833714070199_wp,  3.93074373997011_wp,  0.25468972928580_wp, &
      & -1.65608228354180_wp,  1.72898791774852_wp,  2.66389779664944_wp, &
      &  5.09563328924321_wp, -0.90228186749051_wp, -1.95926049567130_wp, &
      &  2.42947349041271_wp, -0.70814841213303_wp,  2.61923222977255_wp, &
      & -3.59936136530728_wp,  0.25869216923525_wp, -0.55177357463675_wp, &
      & -5.48082561553995_wp,  0.84030451951026_wp,  0.07760349337308_wp, &
      & -3.53595727409671_wp,  0.42449485040850_wp, -2.61462318773444_wp, &
      & -3.09987651276748_wp, -2.28016811837954_wp,  0.21456706403237_wp, &
      & -4.39149298623802_wp, -3.33978669396798_wp, -0.49544650779383_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b53

subroutine b54(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.24137920559796_wp, -0.00143430213486_wp,  1.04225955133175_wp, &
      &  2.36451037514250_wp, -0.88804467080535_wp,  2.69268966401008_wp, &
      &  3.62281097689026_wp, -1.81214720595229_wp, -0.91814611837608_wp, &
      &  1.55355708192822_wp,  2.08119318466962_wp,  0.00801999770797_wp, &
      &  1.21382778693644_wp,  3.44050720712465_wp,  1.52707823935422_wp, &
      &  2.58312145309924_wp,  3.07732641082376_wp, -1.47514289604413_wp, &
      & -0.96311971061263_wp,  1.14056877394286_wp, -1.06100941402224_wp, &
      & -0.62260806900183_wp, -0.07169809920781_wp, -2.68882706379446_wp, &
      & -2.07026300871701_wp,  2.75375994344655_wp, -1.71252840313109_wp, &
      &  4.72122751971297_wp, -3.10614095489800_wp, -0.27586411060478_wp, &
      &  5.04249608011260_wp,  0.81151643160188_wp,  1.64999358594164_wp, &
      & -2.54496977220241_wp, -0.30061952294558_wp,  0.84869301381414_wp, &
      & -1.62972249371417_wp, -2.09027898791653_wp,  1.32683907886140_wp, &
      & -2.74039391050865_wp,  0.80947363765223_wp,  2.58761522184324_wp, &
      & -4.95733935138637_wp, -0.74484311418141_wp, -0.27178230215775_wp, &
      & -5.90703444755098_wp, -1.79875282712240_wp,  0.85980649320164_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b54

subroutine b55(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.91055241041820_wp, -0.79498321766526_wp, -0.56218407590281_wp, &
      &  2.77980792846224_wp, -0.80293896468471_wp, -2.62906069538969_wp, &
      &  5.47961241136264_wp, -0.74370171959714_wp,  0.23975900310987_wp, &
      &  1.37884434203841_wp,  1.40112799259740_wp,  0.49987791557544_wp, &
      &  1.45134368512657_wp,  1.32796346591046_wp,  2.56141794846305_wp, &
      &  2.29667487615030_wp,  3.16505883626911_wp, -0.06451336045058_wp, &
      & -1.36462982206684_wp,  1.44775509520022_wp, -0.41272752577902_wp, &
      & -1.43165084909576_wp,  1.49120367844752_wp, -2.47533336420558_wp, &
      & -2.28680105710597_wp,  3.16754193640772_wp,  0.25186269899100_wp, &
      &  6.19423880467921_wp,  0.82317226238952_wp, -0.33711580375000_wp, &
      &  2.17730276606205_wp, -2.59505885308068_wp,  0.11113101442274_wp, &
      & -2.91299393658189_wp, -0.78462562873092_wp,  0.51382031498387_wp, &
      & -2.19310465598524_wp, -2.55254001509075_wp, -0.27844925595457_wp, &
      & -2.78216252722382_wp, -0.91059099329681_wp,  2.57625607805847_wp, &
      & -5.45931864242158_wp, -0.37124614743605_wp, -0.26466937299356_wp, &
      & -6.43864086489757_wp, -1.80987953459283_wp,  0.25037737425055_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b55

subroutine b56(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.48804445053131_wp,  2.92731239149076_wp, -0.79417252515425_wp, &
      & -2.55675032491482_wp,  2.85035707418126_wp, -0.84613243490408_wp, &
      &  0.38011463217768_wp,  5.47330828498333_wp, -0.71408782136869_wp, &
      &  0.48804445053131_wp,  1.36176121779712_wp,  1.41871945316843_wp, &
      &  2.55195042053729_wp,  1.38626529656225_wp,  1.39112567217603_wp, &
      & -0.09480000118234_wp,  2.28356395624034_wp,  3.17450368748127_wp, &
      & -0.48804445053131_wp, -1.36176121779712_wp,  1.41871945316843_wp, &
      & -2.55195042053729_wp, -1.38626529656225_wp,  1.39112567217603_wp, &
      &  0.09480000118234_wp, -2.28356395624034_wp,  3.17450368748127_wp, &
      & -0.23730613858938_wp,  6.20806971024580_wp,  0.82776429689243_wp, &
      &  0.20411309906524_wp,  2.18210456016571_wp, -2.58184588795954_wp, &
      &  0.48804445053131_wp, -2.92731239149076_wp, -0.79417252515425_wp, &
      & -0.20411309906524_wp, -2.18210456016571_wp, -2.58184588795954_wp, &
      &  2.55675032491482_wp, -2.85035707418126_wp, -0.84613243490408_wp, &
      & -0.38011463217768_wp, -5.47330828498333_wp, -0.71408782136869_wp, &
      &  0.23730613858938_wp, -6.20806971024580_wp,  0.82776429689243_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b56

subroutine b57(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.47813472669046_wp,  2.91784864301727_wp, -0.78370344237807_wp, &
      & -2.54485071945604_wp,  2.81768937852207_wp, -0.85958161579183_wp, &
      &  0.34793448586077_wp,  5.45486644765250_wp, -0.40304267934798_wp, &
      &  0.47813472669046_wp,  1.36376621722411_wp,  1.43172076896268_wp, &
      &  2.54186306243995_wp,  1.39929873770076_wp,  1.42580214671448_wp, &
      & -0.12974103737940_wp,  2.30435850260661_wp,  3.16236786625588_wp, &
      & -0.47813472669046_wp, -1.36376621722411_wp,  1.43172076896268_wp, &
      & -2.54186306243995_wp, -1.39929873770076_wp,  1.42580214671448_wp, &
      &  0.12974103737940_wp, -2.30435850260661_wp,  3.16236786625588_wp, &
      & -0.20459875868140_wp,  6.43859362174425_wp, -1.82460050116801_wp, &
      &  0.26005655150319_wp,  2.17921327918239_wp, -2.56775420018661_wp, &
      &  0.47813472669046_wp, -2.91784864301727_wp, -0.78370344237807_wp, &
      & -0.26005655150319_wp, -2.17921327918239_wp, -2.56775420018661_wp, &
      &  2.54485071945604_wp, -2.81768937852207_wp, -0.85958161579183_wp, &
      & -0.34793448586077_wp, -5.45486644765250_wp, -0.40304267934798_wp, &
      &  0.20459875868140_wp, -6.43859362174425_wp, -1.82460050116801_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b57

subroutine b58(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.93126380883463_wp, -0.76696424829297_wp, -0.58558455460634_wp, &
      &  2.85523634705637_wp, -0.78225402243414_wp, -2.64382512566592_wp, &
      &  5.54155574427250_wp, -0.54406916119297_wp,  0.03687800548326_wp, &
      &  1.36978121550509_wp,  1.43132770592704_wp,  0.42946294041186_wp, &
      &  1.42228725610732_wp,  1.40674425866433_wp,  2.49812913054657_wp, &
      &  2.28332963019986_wp,  3.17974389804776_wp, -0.16912859916713_wp, &
      & -1.37920150027752_wp,  1.40794234503258_wp, -0.47351056684329_wp, &
      & -1.45168950500888_wp,  1.36099209926104_wp, -2.53575546757846_wp, &
      & -2.29136663544302_wp,  3.16742855283975_wp,  0.11385599950636_wp, &
      &  5.67674486209300_wp, -0.62010796132803_wp,  1.84620196059302_wp, &
      &  2.18186078549457_wp, -2.57520728005471_wp,  0.07817797011748_wp, &
      & -2.91661654157863_wp, -0.79730947053484_wp,  0.56251288824994_wp, &
      & -2.18592180695414_wp, -2.59155341110418_wp, -0.12776627357053_wp, &
      & -2.78940395776504_wp, -0.82603330775471_wp,  2.62996587420734_wp, &
      & -5.48359028487236_wp, -0.73111236409986_wp, -0.24138416758415_wp, &
      & -6.19615876643022_wp,  0.83174217040215_wp,  0.34890202564081_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b58

subroutine b59(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.61279582256394_wp, -0.87034549584474_wp,  0.95929679464580_wp, &
      & -3.84447396255162_wp, -1.09835418186033_wp,  2.60539376530143_wp, &
      & -4.07430245483317_wp, -0.79808803770159_wp, -1.30919848541091_wp, &
      & -0.98253853635416_wp,  1.48748091796574_wp,  1.28024410160283_wp, &
      & -2.23510381928862_wp,  3.13274073994450_wp,  1.31259810272397_wp, &
      & -0.06176002947497_wp,  1.41774624420999_wp,  3.13017449185604_wp, &
      &  1.00439321908099_wp,  1.82118576604588_wp, -0.80410870516097_wp, &
      &  1.41906338332461_wp,  3.82684659718406_wp, -1.06385345185223_wp, &
      &  0.24371797935826_wp,  1.12291117295717_wp, -2.58829741297721_wp, &
      & -5.22136999694702_wp,  0.60292657132783_wp, -1.16673581170493_wp, &
      & -1.42629914468743_wp, -2.53608994910398_wp,  0.80038405495305_wp, &
      &  3.49845943844186_wp,  0.51637900416780_wp, -0.24536771027227_wp, &
      &  4.82875671612643_wp,  0.87675733661362_wp, -1.78677385316603_wp, &
      &  4.30866251038138_wp,  1.29428476677017_wp,  1.49433117519745_wp, &
      &  3.06047572289682_wp, -2.13235751971750_wp,  0.02675663231553_wp, &
      &  4.65429719953843_wp, -2.92440032351999_wp,  0.38192121036072_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b59

subroutine b60(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.91783730466048_wp, -0.77806638932367_wp, -0.58122306669164_wp, &
      &  2.81582232910278_wp, -0.78607315894871_wp, -2.63857546646877_wp, &
      &  5.53776306392380_wp, -0.57277788060377_wp,  0.00852266485931_wp, &
      &  1.37876497354083_wp,  1.42131404714888_wp,  0.46309250667269_wp, &
      &  1.44128278319508_wp,  1.37429766096269_wp,  2.53112374882676_wp, &
      &  2.30403346971176_wp,  3.16852081454455_wp, -0.12095759031374_wp, &
      & -1.37290682252888_wp,  1.44318951686316_wp, -0.42637890736299_wp, &
      & -1.45032134328867_wp,  1.48830105910741_wp, -2.48831200328623_wp, &
      & -2.30139352230412_wp,  3.15739032762186_wp,  0.24409781431097_wp, &
      &  5.68898272852957_wp, -0.59824194024441_wp,  1.81807338710502_wp, &
      &  2.16888970531844_wp, -2.58585777653966_wp,  0.08615450412439_wp, &
      & -2.90524605943706_wp, -0.79727356573832_wp,  0.50802074548205_wp, &
      & -2.19725260484692_wp, -2.55934680862141_wp, -0.30716931372216_wp, &
      & -2.74333621409755_wp, -0.93764053316293_wp,  2.56814159404386_wp, &
      & -5.46371981458507_wp, -0.37997668216998_wp, -0.22638541126743_wp, &
      & -6.42975348289461_wp, -1.83429290650358_wp,  0.26925384859195_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b60

subroutine b61(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.48584102986037_wp,  2.94204469642274_wp, -0.77849157770357_wp, &
      & -2.54576345717822_wp,  2.91233631188765_wp, -0.80139694816028_wp, &
      &  0.19132343259787_wp,  5.53881753110595_wp, -0.55879012776815_wp, &
      &  0.48584102986037_wp,  1.36299331923576_wp,  1.42673945087639_wp, &
      &  2.55493051864885_wp,  1.35615251063472_wp,  1.40211631936489_wp, &
      & -0.08616584248119_wp,  2.30193398397812_wp,  3.17070911740644_wp, &
      & -0.48584102986037_wp, -1.36299331923576_wp,  1.42673945087639_wp, &
      & -2.55493051864885_wp, -1.35615251063472_wp,  1.40211631936489_wp, &
      &  0.08616584248119_wp, -2.30193398397812_wp,  3.17070911740644_wp, &
      &  2.00428511051344_wp,  5.63278416306369_wp, -0.60764521748164_wp, &
      &  0.16800799157033_wp,  2.17518438306708_wp, -2.58296082637794_wp, &
      &  0.48584102986037_wp, -2.94204469642274_wp, -0.77849157770357_wp, &
      & -0.16800799157033_wp, -2.17518438306708_wp, -2.58296082637794_wp, &
      &  2.54576345717822_wp, -2.91233631188765_wp, -0.80139694816028_wp, &
      & -0.19132343259787_wp, -5.53881753110595_wp, -0.55879012776815_wp, &
      & -2.00428511051344_wp, -5.63278416306369_wp, -0.60764521748164_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b61

subroutine b62(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.62033205038189_wp, -0.13194067859808_wp,  0.92243957615000_wp, &
      & -2.91608741826142_wp,  1.24776159910466_wp,  2.42304086265636_wp, &
      & -5.08249591316739_wp, -0.77228760680931_wp,  0.04108075640280_wp, &
      & -0.96891739038832_wp,  1.00442912387751_wp, -1.14547261325770_wp, &
      & -0.62170100045805_wp, -0.41492527727157_wp, -2.60981950390465_wp, &
      & -2.03949637754750_wp,  2.51780495904218_wp, -2.04726315195365_wp, &
      &  1.55359487645088_wp,  2.04951381577792_wp, -0.18688824536399_wp, &
      &  1.19661805104425_wp,  3.54423616428488_wp,  1.19645175514455_wp, &
      &  2.56462292398442_wp,  2.91118357894659_wp, -1.76379289366401_wp, &
      & -4.88498551721044_wp, -1.98041409000283_wp, -1.30052086300870_wp, &
      & -1.71054419069156_wp, -1.78285078171416_wp,  1.77663547246310_wp, &
      &  3.28260925036526_wp,  0.08835036589080_wp,  1.03200589733471_wp, &
      &  5.06131397294387_wp,  0.97814681282134_wp,  1.55847792877825_wp, &
      &  2.43863299297880_wp, -0.66435211927728_wp,  2.76211064322777_wp, &
      &  3.95053295203369_wp, -1.91040162650555_wp, -0.64801165740621_wp, &
      &  2.48560969491621_wp, -2.95717384384262_wp, -0.87238262061599_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b62

subroutine b63(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.72084618921210_wp,  0.16549276608746_wp,  0.33783578940663_wp, &
      & -5.47429661175083_wp,  0.55561160841264_wp, -0.66696183106679_wp, &
      & -3.16237542516041_wp, -2.42772738346592_wp, -0.15206248246104_wp, &
      & -1.66233349758938_wp,  1.97924434952657_wp, -0.54465875574643_wp, &
      & -1.49763441647773_wp,  1.86481198354968_wp, -2.60019701843599_wp, &
      & -2.30433771561915_wp,  3.89195522136650_wp, -0.10649929567104_wp, &
      &  0.92429150776023_wp,  1.50343209625343_wp,  0.68209853739121_wp, &
      &  0.68940421862094_wp,  0.71042175267090_wp,  2.57661701574985_wp, &
      &  1.94935266155658_wp,  3.27506357391665_wp,  0.91915145267878_wp, &
      & -1.97815775700016_wp, -2.97838979913653_wp,  1.10832248721130_wp, &
      & -4.07742239267856_wp,  0.45355694860615_wp,  2.35500316296795_wp, &
      &  2.58063835296063_wp, -0.26406466063104_wp, -0.86168488097773_wp, &
      &  1.59439595338601_wp, -2.03751594456023_wp, -1.23927483904187_wp, &
      &  2.99629306451949_wp,  0.62109628809552_wp, -2.68562964717762_wp, &
      &  4.84388964299858_wp, -0.68518257044008_wp,  0.54079993498308_wp, &
      &  5.91978065031729_wp, -1.75796686799632_wp, -0.45197524783292_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b63

subroutine b64(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.56815671185292_wp, -0.33479899951108_wp, -0.85803959926739_wp, &
      & -1.58229792668328_wp, -2.11133431648914_wp, -1.16119513468330_wp, &
      & -4.86570653120275_wp, -0.97041594321170_wp,  0.39236950614944_wp, &
      & -0.94288074372942_wp,  1.49106572843982_wp,  0.67248550055322_wp, &
      & -1.98213374078375_wp,  3.26573210627246_wp,  0.86888095809176_wp, &
      & -0.71143275615199_wp,  0.73966904402957_wp,  2.58417592028139_wp, &
      &  1.64563209802694_wp,  1.99393130103136_wp, -0.54027648084427_wp, &
      &  2.26838189648874_wp,  3.91306724172310_wp, -0.10162947142659_wp, &
      &  1.49018511606190_wp,  1.87306063811972_wp, -2.59615489423775_wp, &
      & -5.82142040510060_wp,  0.56152267175630_wp,  0.58738357388484_wp, &
      & -2.94085605868516_wp,  0.48083514533435_wp, -2.72348464107159_wp, &
      &  3.71582518687703_wp,  0.19921681865494_wp,  0.35520993147238_wp, &
      &  5.47321379867669_wp,  0.61753604406117_wp, -0.63133860373576_wp, &
      &  4.05037663226470_wp,  0.48292140298506_wp,  2.37674257240067_wp, &
      &  3.19272442685455_wp, -2.39629556869763_wp, -0.15422243943093_wp, &
      &  2.03733075139921_wp, -2.98578807694678_wp,  1.11516896499074_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b64

subroutine b65(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "O", "C", "H", "H", "C", "H", "H", "H", "H", "C", "H", "H", &
      & "O", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.34722127075273_wp, -0.81577965375767_wp, -0.29034130250882_wp, &
      &  2.03043136128804_wp, -1.39290957364548_wp, -2.24061237096598_wp, &
      &  5.01859860343612_wp, -0.76204340144293_wp,  0.02894682490354_wp, &
      &  1.13655121618434_wp,  1.75258114851760_wp,  0.20461198676433_wp, &
      &  1.29109679878400_wp,  2.19225616895157_wp,  2.22132393632762_wp, &
      &  2.26753907863347_wp,  3.15615444673095_wp, -0.79834126100340_wp, &
      & -1.62732632097767_wp,  2.00170374461591_wp, -0.62189186279747_wp, &
      & -1.78729352785258_wp,  1.69878442496661_wp, -2.65762768534052_wp, &
      & -2.22568164479005_wp,  3.94477117705452_wp, -0.25664181638107_wp, &
      &  5.35301587826836_wp, -0.25178144076728_wp,  1.73999746219872_wp, &
      &  1.53059690941366_wp, -2.26848205197378_wp,  0.93998946274611_wp, &
      & -3.50083104473863_wp,  0.24149566142599_wp,  0.68815699937324_wp, &
      & -3.16194645732824_wp,  0.22559550574389_wp,  2.73094905929648_wp, &
      & -5.41228146924792_wp,  0.94085306758884_wp,  0.38721622298507_wp, &
      & -3.51884202451116_wp, -2.26496338191435_wp, -0.30491298071950_wp, &
      & -2.01722217561917_wp, -3.10918908315034_wp,  0.25828965756894_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine b65

end module mstore_but14diol
