;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
 (rec
   ;; CHECK-TEXT:      (rec
   ;; CHECK-TEXT-NEXT:  (type $ft (func (param i32 (ref null $ct)) (result i32)))
   ;; CHECK-BIN:      (rec
   ;; CHECK-BIN-NEXT:  (type $ft (func (param i32 (ref null $ct)) (result i32)))
   (type $ft (func (param i32) (param (ref null $ct)) (result i32)))
   ;; CHECK-TEXT:       (type $ct (cont $ft))
   ;; CHECK-BIN:       (type $ct (cont $ft))
   (type $ct (cont $ft)))

 ;; CHECK-TEXT:      (type $2 (func (param (ref null $ct)) (result i32)))

 ;; CHECK-TEXT:      (type $3 (func (result i32)))

 ;; CHECK-TEXT:      (type $4 (func (param (ref $ct)) (result i32)))

 ;; CHECK-TEXT:      (tag $t (type $3) (result i32))
 ;; CHECK-BIN:      (type $2 (func (param (ref null $ct)) (result i32)))

 ;; CHECK-BIN:      (type $3 (func (result i32)))

 ;; CHECK-BIN:      (type $4 (func (param (ref $ct)) (result i32)))

 ;; CHECK-BIN:      (tag $t (type $3) (result i32))
 (tag $t (result i32))

 ;; CHECK-TEXT:      (func $swap (type $2) (param $k (ref null $ct)) (result i32)
 ;; CHECK-TEXT-NEXT:  (local $scratch (tuple i32 (ref null $ct)))
 ;; CHECK-TEXT-NEXT:  (local $scratch_2 i32)
 ;; CHECK-TEXT-NEXT:  (return
 ;; CHECK-TEXT-NEXT:   (block (result i32)
 ;; CHECK-TEXT-NEXT:    (local.set $scratch_2
 ;; CHECK-TEXT-NEXT:     (tuple.extract 2 0
 ;; CHECK-TEXT-NEXT:      (local.tee $scratch
 ;; CHECK-TEXT-NEXT:       (switch $ct $t
 ;; CHECK-TEXT-NEXT:        (i32.const 42)
 ;; CHECK-TEXT-NEXT:        (local.get $k)
 ;; CHECK-TEXT-NEXT:       )
 ;; CHECK-TEXT-NEXT:      )
 ;; CHECK-TEXT-NEXT:     )
 ;; CHECK-TEXT-NEXT:    )
 ;; CHECK-TEXT-NEXT:    (local.set $k
 ;; CHECK-TEXT-NEXT:     (tuple.extract 2 1
 ;; CHECK-TEXT-NEXT:      (local.get $scratch)
 ;; CHECK-TEXT-NEXT:     )
 ;; CHECK-TEXT-NEXT:    )
 ;; CHECK-TEXT-NEXT:    (local.get $scratch_2)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $swap (type $2) (param $k (ref null $ct)) (result i32)
 ;; CHECK-BIN-NEXT:  (local $scratch i32)
 ;; CHECK-BIN-NEXT:  (local $scratch_2 i32)
 ;; CHECK-BIN-NEXT:  (local $3 (ref null $ct))
 ;; CHECK-BIN-NEXT:  (local $scratch_4 (tuple i32 (ref null $ct)))
 ;; CHECK-BIN-NEXT:  (local $scratch_5 i32)
 ;; CHECK-BIN-NEXT:  (local.set $scratch_2
 ;; CHECK-BIN-NEXT:   (local.tee $scratch
 ;; CHECK-BIN-NEXT:    (block (result i32)
 ;; CHECK-BIN-NEXT:     (local.set $scratch_5
 ;; CHECK-BIN-NEXT:      (tuple.extract 2 0
 ;; CHECK-BIN-NEXT:       (local.tee $scratch_4
 ;; CHECK-BIN-NEXT:        (switch $ct $t
 ;; CHECK-BIN-NEXT:         (i32.const 42)
 ;; CHECK-BIN-NEXT:         (local.get $k)
 ;; CHECK-BIN-NEXT:        )
 ;; CHECK-BIN-NEXT:       )
 ;; CHECK-BIN-NEXT:      )
 ;; CHECK-BIN-NEXT:     )
 ;; CHECK-BIN-NEXT:     (local.set $3
 ;; CHECK-BIN-NEXT:      (tuple.extract 2 1
 ;; CHECK-BIN-NEXT:       (local.get $scratch_4)
 ;; CHECK-BIN-NEXT:      )
 ;; CHECK-BIN-NEXT:     )
 ;; CHECK-BIN-NEXT:     (local.get $scratch_5)
 ;; CHECK-BIN-NEXT:    )
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (local.set $k
 ;; CHECK-BIN-NEXT:   (local.get $3)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (return
 ;; CHECK-BIN-NEXT:   (local.get $scratch_2)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $swap (param $k (ref null $ct)) (result i32)
   (switch $ct $t
     (i32.const 42)
     (local.get $k))
   (local.set $k)
   (return))

 ;; CHECK-TEXT:      (func $go (type $4) (param $x (ref $ct)) (result i32)
 ;; CHECK-TEXT-NEXT:  (resume $ct (on $t switch)
 ;; CHECK-TEXT-NEXT:   (i32.const 123)
 ;; CHECK-TEXT-NEXT:   (ref.null nocont)
 ;; CHECK-TEXT-NEXT:   (local.get $x)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $go (type $4) (param $x (ref $ct)) (result i32)
 ;; CHECK-BIN-NEXT:  (resume $ct (on $t switch)
 ;; CHECK-BIN-NEXT:   (i32.const 123)
 ;; CHECK-BIN-NEXT:   (ref.null nocont)
 ;; CHECK-BIN-NEXT:   (local.get $x)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $go (param $x (ref $ct)) (result i32)
   (resume $ct
     (on $t switch)
     (i32.const 123)
     (ref.null $ct)
     (local.get $x)
   )
 )

 ;; CHECK-TEXT:      (func $unreachable (type $2) (param $k (ref null $ct)) (result i32)
 ;; CHECK-TEXT-NEXT:  (return
 ;; CHECK-TEXT-NEXT:   (local.tee $k
 ;; CHECK-TEXT-NEXT:    (block ;; (replaces unreachable StackSwitch we can't emit)
 ;; CHECK-TEXT-NEXT:     (drop
 ;; CHECK-TEXT-NEXT:      (i32.const 42)
 ;; CHECK-TEXT-NEXT:     )
 ;; CHECK-TEXT-NEXT:     (drop
 ;; CHECK-TEXT-NEXT:      (unreachable)
 ;; CHECK-TEXT-NEXT:     )
 ;; CHECK-TEXT-NEXT:     (unreachable)
 ;; CHECK-TEXT-NEXT:    )
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $unreachable (type $2) (param $k (ref null $ct)) (result i32)
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.const 42)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (unreachable)
 ;; CHECK-BIN-NEXT: )
 (func $unreachable (param $k (ref null $ct)) (result i32)
   (switch $ct $t
   (i32.const 42)
   (unreachable))
   (local.set $k)
   (return)
 )
)
;; CHECK-BIN-NODEBUG:      (rec
;; CHECK-BIN-NODEBUG-NEXT:  (type $0 (func (param i32 (ref null $1)) (result i32)))

;; CHECK-BIN-NODEBUG:       (type $1 (cont $0))

;; CHECK-BIN-NODEBUG:      (type $2 (func (param (ref null $1)) (result i32)))

;; CHECK-BIN-NODEBUG:      (type $3 (func (result i32)))

;; CHECK-BIN-NODEBUG:      (type $4 (func (param (ref $1)) (result i32)))

;; CHECK-BIN-NODEBUG:      (tag $tag$0 (type $3) (result i32))

;; CHECK-BIN-NODEBUG:      (func $0 (type $2) (param $0 (ref null $1)) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $2 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $3 (ref null $1))
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch (tuple i32 (ref null $1)))
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_5 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $2
;; CHECK-BIN-NODEBUG-NEXT:   (local.tee $1
;; CHECK-BIN-NODEBUG-NEXT:    (block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:     (local.set $scratch_5
;; CHECK-BIN-NODEBUG-NEXT:      (tuple.extract 2 0
;; CHECK-BIN-NODEBUG-NEXT:       (local.tee $scratch
;; CHECK-BIN-NODEBUG-NEXT:        (switch $1 $tag$0
;; CHECK-BIN-NODEBUG-NEXT:         (i32.const 42)
;; CHECK-BIN-NODEBUG-NEXT:         (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (local.set $3
;; CHECK-BIN-NODEBUG-NEXT:      (tuple.extract 2 1
;; CHECK-BIN-NODEBUG-NEXT:       (local.get $scratch)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $scratch_5)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $3)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (return
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $4) (param $0 (ref $1)) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (resume $1 (on $tag$0 switch)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 123)
;; CHECK-BIN-NODEBUG-NEXT:   (ref.null nocont)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $2) (param $0 (ref null $1)) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 42)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )
