;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-ctor-eval --ctors=test --kept-exports=test --ignore-external-input --quiet -all -g -S -o - | filecheck %s

(module
  ;; Simplest possible return call.

  (func $test (export "test") (result i32)
    (return_call $test2)
  )

  (func $test2 (result i32)
    (i32.const 42)
  )
)

;; CHECK:      (type $0 (func (result i32)))

;; CHECK:      (export "test" (func $test_2))

;; CHECK:      (func $test_2 (type $0) (result i32)
;; CHECK-NEXT:  (i32.const 42)
;; CHECK-NEXT: )
(module
  ;; Basic return call (followed by unreachable import call, setting global as proof it was executed)

  (import "env" "import" (func $import))

  ;; CHECK:      (type $0 (func))

  ;; CHECK:      (global $g1 (mut i32) (i32.const 1))
  (global $g1 (export "g1") (mut i32) (i32.const 0))

  ;; CHECK:      (global $g2 (mut i32) (i32.const 2))
  (global $g2 (export "g2") (mut i32) (i32.const 0))

  (func $test (export "test")
    (global.set $g1
      (i32.const 1)
    )
    (return_call $test2)
    ;; This is never executed, so it should not impede eval.
    (call $import)
  )

  (func $test2
    (global.set $g2
      (i32.const 2)
    )
  )
)

;; CHECK:      (export "g1" (global $g1))

;; CHECK:      (export "g2" (global $g2))

;; CHECK:      (export "test" (func $test_3))

;; CHECK:      (func $test_3 (type $0)
;; CHECK-NEXT:  (nop)
;; CHECK-NEXT: )
(module
  ;; Basic return call indirect

  (import "env" "import" (func $import))

  ;; CHECK:      (type $0 (func))

  ;; CHECK:      (global $g1 (mut i32) (i32.const 1))
  (global $g1 (export "g1") (mut i32) (i32.const 0))

  ;; CHECK:      (global $g2 (mut i32) (i32.const 2))
  (global $g2 (export "g2") (mut i32) (i32.const 0))

  (table $t funcref (elem $test2))

  (func $test (export "test")
    (global.set $g1
      (i32.const 1)
    )
    (return_call_indirect $t
     (i32.const 0)
    )
    ;; This is never executed, so it should not impede eval.
    (call $import)
  )

  (func $test2
    (global.set $g2
      (i32.const 2)
    )
  )
)

;; CHECK:      (export "g1" (global $g1))

;; CHECK:      (export "g2" (global $g2))

;; CHECK:      (export "test" (func $test_3))

;; CHECK:      (func $test_3 (type $0)
;; CHECK-NEXT:  (nop)
;; CHECK-NEXT: )
(module
  ;; Basic return call ref
  ;; CHECK:      (type $f (func))
  (type $f (func))

  (import "env" "import" (func $import))

  ;; CHECK:      (global $g1 (mut i32) (i32.const 1))
  (global $g1 (export "g1") (mut i32) (i32.const 0))

  ;; CHECK:      (global $g2 (mut i32) (i32.const 2))
  (global $g2 (export "g2") (mut i32) (i32.const 0))

  (elem declare $test2)

  (func $test (export "test")
    (global.set $g1
      (i32.const 1)
    )
    (return_call_ref $f
      (ref.func $test2)
    )
    ;; This is never executed, so it should not impede eval.
    (call $import)
  )

  (func $test2 (type $f)
    (global.set $g2
      (i32.const 2)
    )
  )
)

;; CHECK:      (export "g1" (global $g1))

;; CHECK:      (export "g2" (global $g2))

;; CHECK:      (export "test" (func $test_3))

;; CHECK:      (func $test_3 (type $f)
;; CHECK-NEXT:  (nop)
;; CHECK-NEXT: )
(module
  ;; Return call to import

  ;; CHECK:      (type $0 (func))

  ;; CHECK:      (import "env" "import" (func $import (type $0)))
  (import "env" "import" (func $import))

  ;; CHECK:      (global $g1 (mut i32) (i32.const 1))
  (global $g1 (export "g1") (mut i32) (i32.const 0))

  (func $test (export "test")
    (global.set $g1
      (i32.const 1)
    )
    (return_call $import)
  )
)

;; CHECK:      (export "g1" (global $g1))

;; CHECK:      (export "test" (func $test_2))

;; CHECK:      (func $test_2 (type $0)
;; CHECK-NEXT:  (return_call $import)
;; CHECK-NEXT: )
(module
  ;; Return call to import with params

  ;; CHECK:      (type $0 (func (param i32)))

  ;; CHECK:      (type $1 (func))

  ;; CHECK:      (import "env" "import" (func $import (type $0) (param i32)))
  (import "env" "import" (func $import (param i32)))

  ;; CHECK:      (global $g1 (mut i32) (i32.const 1))
  (global $g1 (export "g1") (mut i32) (i32.const 0))

  (func $test (export "test")
    (global.set $g1
      (i32.const 1)
    )
    (return_call $import
      (i32.add
        (i32.const 40)
        (i32.const 2)
      )
    )
  )
)

;; CHECK:      (export "g1" (global $g1))

;; CHECK:      (export "test" (func $test_2))

;; CHECK:      (func $test_2 (type $1)
;; CHECK-NEXT:  (return_call $import
;; CHECK-NEXT:   (i32.const 42)
;; CHECK-NEXT:  )
;; CHECK-NEXT: )
(module
  ;; Chain of return calls ending in import

  ;; CHECK:      (type $0 (func (param i32)))

  ;; CHECK:      (type $1 (func))

  ;; CHECK:      (import "env" "import" (func $import (type $0) (param i32)))
  (import "env" "import" (func $import (param i32)))

  ;; CHECK:      (global $g1 (mut i32) (i32.const 1))
  (global $g1 (export "g1") (mut i32) (i32.const 0))

  ;; CHECK:      (global $g2 (mut i32) (i32.const 2))
  (global $g2 (export "g2") (mut i32) (i32.const 0))

  (func $test (export "test")
    (global.set $g1
      (i32.const 1)
    )
    (return_call $test2
      (i32.const 40)
    )
  )

  (func $test2 (param i32)
    (global.set $g2
      (i32.const 2)
    )
    (return_call $import
      (i32.add
        (i32.const 2)
        (local.get 0)
      )
    )
  )
)

;; CHECK:      (export "g1" (global $g1))

;; CHECK:      (export "g2" (global $g2))

;; CHECK:      (export "test" (func $test_3))

;; CHECK:      (func $test_3 (type $1)
;; CHECK-NEXT:  (return_call $import
;; CHECK-NEXT:   (i32.const 42)
;; CHECK-NEXT:  )
;; CHECK-NEXT: )
(module
  ;; Return call to a function that can only be partially evaluated.
  ;; CHECK:      (type $0 (func))

  ;; CHECK:      (import "env" "import" (func $import (type $0)))
  (import "env" "import" (func $import))

  ;; CHECK:      (global $g1 (mut i32) (i32.const 1))
  (global $g1 (export "g1") (mut i32) (i32.const 0))

  ;; CHECK:      (global $g2 (mut i32) (i32.const 2))
  (global $g2 (export "g2") (mut i32) (i32.const 0))

  (func $test (export "test")
    (global.set $g1
      (i32.const 1)
    )
    (return_call $test2)
  )

  (func $test2
    (global.set $g2
      (i32.const 2)
    )
    (call $import)
  )
)

;; CHECK:      (export "g1" (global $g1))

;; CHECK:      (export "g2" (global $g2))

;; CHECK:      (export "test" (func $test_3))

;; CHECK:      (func $test_3 (type $0)
;; CHECK-NEXT:  (call $import)
;; CHECK-NEXT: )
(module
  ;; Return call with parameters to a function that can only be partially evaluated.

  ;; CHECK:      (type $0 (func (param i32) (result i32)))

  ;; CHECK:      (type $1 (func (param i32)))

  ;; CHECK:      (import "env" "import" (func $import (type $0) (param i32) (result i32)))
  (import "env" "import" (func $import (param i32) (result i32)))

  ;; CHECK:      (global $g1 (mut i32) (i32.const 1))
  (global $g1 (export "g1") (mut i32) (i32.const 0))

  ;; CHECK:      (global $g2 (mut i32) (i32.const 2))
  (global $g2 (export "g2") (mut i32) (i32.const 0))

  (func $test (export "test") (param i32)
    (global.set $g1
      (i32.const 1)
    )
    (return_call $test2
      (local.get 0)
    )
  )

  (func $test2 (param i32)
    (local $x i32)
    (global.set $g2
      (i32.const 2)
    )
    (local.set $x
      (call $import
        (local.get 0)
      )
    )
    (drop
      (call $import
        (i32.const 0)
      )
    )
    (drop
      (call $import
        (local.get $x)
      )
    )
  )
)

;; CHECK:      (export "g1" (global $g1))

;; CHECK:      (export "g2" (global $g2))

;; CHECK:      (export "test" (func $test_3))

;; CHECK:      (func $test_3 (type $1) (param $0 i32)
;; CHECK-NEXT:  (local.set $0
;; CHECK-NEXT:   (call $import
;; CHECK-NEXT:    (i32.const 0)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (drop
;; CHECK-NEXT:   (call $import
;; CHECK-NEXT:    (i32.const 0)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (drop
;; CHECK-NEXT:   (call $import
;; CHECK-NEXT:    (local.get $0)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT: )
(module
  ;; Return call with parameters to a function that can only be partially
  ;; evaluated that takes different parameters from the original.
  ;; CHECK:      (type $0 (func (param i32) (result i32)))

  ;; CHECK:      (type $1 (func (param i32)))

  ;; CHECK:      (import "env" "import" (func $import (type $0) (param i32) (result i32)))
  (import "env" "import" (func $import (param i32) (result i32)))

  ;; CHECK:      (global $g1 (mut i32) (i32.const 1))
  (global $g1 (export "g1") (mut i32) (i32.const 0))

  ;; CHECK:      (global $g2 (mut i32) (i32.const 2))
  (global $g2 (export "g2") (mut i32) (i32.const 0))

  (func $test (export "test") (param i32)
    (global.set $g1
      (i32.const 1)
    )
    (return_call $test2
      (i64.const 1)
      (i64.const 2)
      (i64.const 3)
    )
  )

  (func $test2 (param i64 i64 i64)
    (local $x i32)
    (global.set $g2
      (i32.const 2)
    )
    (local.set $x
      (call $import
        (i32.wrap_i64
          (local.get 2)
        )
      )
    )
    (drop
      (call $import
        (i32.const 0)
      )
    )
    (drop
      (call $import
        (local.get $x)
      )
    )
  )
)

;; CHECK:      (export "g1" (global $g1))

;; CHECK:      (export "g2" (global $g2))

;; CHECK:      (export "test" (func $test_3))

;; CHECK:      (func $test_3 (type $1) (param $0 i32)
;; CHECK-NEXT:  (local.set $0
;; CHECK-NEXT:   (call $import
;; CHECK-NEXT:    (i32.const 3)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (drop
;; CHECK-NEXT:   (call $import
;; CHECK-NEXT:    (i32.const 0)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (drop
;; CHECK-NEXT:   (call $import
;; CHECK-NEXT:    (local.get $0)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT: )
(module
  ;; Return call to self with different params, then stop evaluating.
  ;; CHECK:      (type $0 (func (param i32)))

  ;; CHECK:      (type $1 (func))

  ;; CHECK:      (import "env" "import" (func $import (type $1)))
  (import "env" "import" (func $import))

  ;; CHECK:      (global $g (mut i32) (i32.const 42))
  (global $g (mut i32) (i32.const 0))

  ;; CHECK:      (export "test" (func $test_2))

  ;; CHECK:      (func $test (type $0) (param $0 i32)
  ;; CHECK-NEXT:  (global.set $g
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.eq
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:    (i32.const 42)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (call $import)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (else
  ;; CHECK-NEXT:    (return_call $test
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test (export "test") (param i32)
    (global.set $g
      (local.get 0)
    )
    (if
      (i32.eq
        (local.get 0)
        (i32.const 42)
      )
      (then
        (call $import)
      )
      (else
        (return_call $test
          (i32.add
            (local.get 0)
            (i32.const 1)
          )
        )
      )
    )
  )
)

;; CHECK:      (func $test_2 (type $0) (param $0 i32)
;; CHECK-NEXT:  (if
;; CHECK-NEXT:   (i32.eq
;; CHECK-NEXT:    (local.tee $0
;; CHECK-NEXT:     (i32.const 42)
;; CHECK-NEXT:    )
;; CHECK-NEXT:    (i32.const 42)
;; CHECK-NEXT:   )
;; CHECK-NEXT:   (then
;; CHECK-NEXT:    (call $import)
;; CHECK-NEXT:   )
;; CHECK-NEXT:   (else
;; CHECK-NEXT:    (return_call $test
;; CHECK-NEXT:     (i32.add
;; CHECK-NEXT:      (local.get $0)
;; CHECK-NEXT:      (i32.const 1)
;; CHECK-NEXT:     )
;; CHECK-NEXT:    )
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT: )
