//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_CLANG_TOOLS_EXTRA_CLANG_TIDY_READABILITY_IMPLICITBOOLCONVERSIONCHECK_H
#define LLVM_CLANG_TOOLS_EXTRA_CLANG_TIDY_READABILITY_IMPLICITBOOLCONVERSIONCHECK_H

#include "../ClangTidyCheck.h"

namespace clang::tidy::readability {

/// Checks for use of implicit bool conversions in expressions.
///
/// For the user-facing documentation see:
/// https://clang.llvm.org/extra/clang-tidy/checks/readability/implicit-bool-conversion.html
class ImplicitBoolConversionCheck : public ClangTidyCheck {
public:
  ImplicitBoolConversionCheck(StringRef Name, ClangTidyContext *Context);
  bool isLanguageVersionSupported(const LangOptions &LangOpts) const override {
    return LangOpts.Bool;
  }
  void storeOptions(ClangTidyOptions::OptionMap &Opts) override;
  void registerMatchers(ast_matchers::MatchFinder *Finder) override;
  void check(const ast_matchers::MatchFinder::MatchResult &Result) override;

private:
  void handleCastToBool(const ImplicitCastExpr *CastExpression,
                        const Stmt *ParentStatement, ASTContext &Context);
  void handleCastFromBool(const ImplicitCastExpr *Cast,
                          const ImplicitCastExpr *NextImplicitCast,
                          ASTContext &Context);

  const bool AllowIntegerConditions;
  const bool AllowPointerConditions;
  const bool UseUpperCaseLiteralSuffix;
};

} // namespace clang::tidy::readability

#endif // LLVM_CLANG_TOOLS_EXTRA_CLANG_TIDY_READABILITY_IMPLICITBOOLCONVERSIONCHECK_H
